/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;

public class LRUEvictionControllerTest
extends CacheTestCase {
    private static boolean usingMain = false;

    public LRUEvictionControllerTest(String name) {
        super(name);
    }

    private LRUStatistics getLRUStats(Region region) {
        LocalRegion l = (LocalRegion)region;
        return l.getEvictionController().getLRUHelper().getStats();
    }

    public void testRegionOperations() throws CacheException {
        String value;
        Integer key;
        int i;
        Region region;
        int threshold = 10;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)threshold));
        if (usingMain) {
            DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
            Cache cache = CacheFactory.create((DistributedSystem)system);
            region = cache.createRegion("Test", factory.create());
        } else {
            region = this.createRegion(name, factory.create());
        }
        LRUStatistics lruStats = this.getLRUStats(region);
        LRUEvictionControllerTest.assertNotNull((Object)lruStats);
        for (i = 1; i <= 10; ++i) {
            key = new Integer(i);
            value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            LRUEvictionControllerTest.assertEquals((long)i, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
        for (i = 11; i <= 20; ++i) {
            key = new Integer(i);
            value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            LRUEvictionControllerTest.assertEquals((long)10L, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)(i - 10), (long)lruStats.getEvictions());
        }
    }

    public void testCacheLoader() throws CacheException {
        Integer key;
        int i;
        Region region;
        int threshold = 10;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)threshold));
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                return "LOADED VALUE";
            }

            public void close() {
            }
        });
        if (usingMain) {
            DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
            Cache cache = CacheFactory.create((DistributedSystem)system);
            region = cache.createRegion("Test", factory.create());
        } else {
            region = this.createRegion(name, factory.create());
        }
        LRUStatistics lruStats = this.getLRUStats(region);
        LRUEvictionControllerTest.assertNotNull((Object)lruStats);
        for (i = 1; i <= 10; ++i) {
            key = new Integer(i);
            String value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            LRUEvictionControllerTest.assertEquals((long)i, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
        for (i = 11; i <= 20; ++i) {
            key = new Integer(i);
            region.get((Object)key);
            LRUEvictionControllerTest.assertEquals((long)10L, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)(i - 10), (long)lruStats.getEvictions());
        }
    }

    public void testSizeOne() throws CacheException {
        String value;
        Integer key;
        int i;
        Region region;
        int threshold = 1;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)threshold));
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                return "LOADED VALUE";
            }

            public void close() {
            }
        });
        if (usingMain) {
            DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
            Cache cache = CacheFactory.create((DistributedSystem)system);
            region = cache.createRegion("Test", factory.create());
        } else {
            region = this.createRegion(name, factory.create());
        }
        LRUStatistics lruStats = this.getLRUStats(region);
        LRUEvictionControllerTest.assertNotNull((Object)lruStats);
        for (i = 1; i <= 1; ++i) {
            key = new Integer(i);
            value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            LRUEvictionControllerTest.assertEquals((long)1L, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
        for (i = 2; i <= 10; ++i) {
            key = new Integer(i);
            value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            LRUEvictionControllerTest.assertEquals((long)1L, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)(i - 1), (long)lruStats.getEvictions());
        }
        for (i = 11; i <= 20; ++i) {
            key = new Integer(i);
            region.get((Object)key);
            LRUEvictionControllerTest.assertEquals((long)1L, (long)lruStats.getCounter());
            LRUEvictionControllerTest.assertEquals((long)(i - 1), (long)lruStats.getEvictions());
        }
    }

    public void testMultipleUsesOfEvictionAttributes() throws CacheException, CloneNotSupportedException {
        int threshold = 42;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)threshold));
        Region region = this.createRegion(name, factory.create());
        RegionAttributes ra = region.getAttributes();
        Region r2 = this.createRegion(name + 2, ra);
        factory = new AttributesFactory(ra);
        Region r3 = this.createRegion(name + 3, factory.create());
        LRUEvictionControllerTest.assertEquals((Object)region.getAttributes().getEvictionAttributes(), (Object)r2.getAttributes().getEvictionAttributes());
        LRUEvictionControllerTest.assertEquals((Object)r2.getAttributes().getEvictionAttributes(), (Object)r3.getAttributes().getEvictionAttributes());
        LocalRegion lRegion = (LocalRegion)region;
        LocalRegion lr2 = (LocalRegion)r2;
        LocalRegion lr3 = (LocalRegion)r3;
        LRUEvictionControllerTest.assertNotSame((Object)lRegion.getEvictionController(), (Object)lr2.getEvictionController());
        LRUEvictionControllerTest.assertEquals((Object)lRegion.getEvictionController(), (Object)lr2.getEvictionController());
        LRUEvictionControllerTest.assertNotSame((Object)lr2.getEvictionController(), (Object)lr3.getEvictionController());
        LRUEvictionControllerTest.assertEquals((Object)lr2.getEvictionController(), (Object)lr3.getEvictionController());
    }

    public void testBug31592() throws Exception {
        String name = this.getUniqueName();
        final String key = "KEY";
        String value = "VALUE";
        String key2 = "KEY2";
        final String value2 = "VALUE2";
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)10));
        final Region region = this.createRegion(name, factory.create());
        region.put((Object)key, (Object)value);
        final Throwable[] errors = new Throwable[1];
        region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                try {
                    DistributedTestCase.getLogWriter().info("AFTER CREATE");
                    region.put(key, value2);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable ex) {
                    region.getCache().getLogger().severe("failed to access cache from listener", ex);
                    errors[0] = ex;
                }
            }
        });
        region.put((Object)key2, (Object)value2);
        LRUEvictionControllerTest.assertNull((Object)errors[0]);
        LRUEvictionControllerTest.assertEquals((Object)value2, (Object)region.get((Object)key));
        LRUEvictionControllerTest.assertEquals((Object)value2, (Object)region.get((Object)key2));
    }

    public void testCCMirrored() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)10));
        factory.setDataPolicy(DataPolicy.REPLICATE);
        Region r = this.createRegion(name, factory.create());
        RegionAttributes ra = r.getAttributes();
        LRUEvictionControllerTest.assertEquals((Object)DataPolicy.PRELOADED, (Object)ra.getDataPolicy());
        LRUEvictionControllerTest.assertEquals((Object)new SubscriptionAttributes(InterestPolicy.ALL), (Object)ra.getSubscriptionAttributes());
        r.destroyRegion();
    }

    public void testReplicationAndTransactions() throws Exception {
        final String r1 = this.getUniqueName() + "-1";
        final String r2 = this.getUniqueName() + "-2";
        final String r3 = this.getUniqueName() + "-3";
        VM feeder = Host.getHost(0).getVM(3);
        VM repl = Host.getHost(0).getVM(2);
        boolean maxEntries = true;
        int numEntries = 10000;
        int txBatchSize = 10;
        LRUEvictionControllerTest.assertTrue((boolean)true);
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("Create Replicate Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                factory.setDataPolicy(DataPolicy.REPLICATE);
                File[] diskDirs = new File[]{new File("overflowDir/" + OSProcess.getId())};
                diskDirs[0].mkdirs();
                factory.setDiskStoreName(LRUEvictionControllerTest.this.getCache().createDiskStoreFactory().setDiskDirs(diskDirs).create("LRUEvictionControllerTest").getName());
                factory.setDiskSynchronous(true);
                factory.setScope(Scope.DISTRIBUTED_ACK);
                RegionAttributes a = factory.create();
                LRUEvictionControllerTest.this.createRegion(r1, a);
                LRUEvictionControllerTest.this.createRegion(r2, a);
                LRUEvictionControllerTest.this.createRegion(r3, a);
            }
        };
        feeder.invoke(createRegion);
        repl.invoke(createRegion);
        feeder.invoke(new CacheSerializableRunnable("put 10000 entries and assert 1 max entries"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache c = LRUEvictionControllerTest.this.getCache();
                CacheTransactionManager txm = c.getCacheTransactionManager();
                Region reg1 = LRUEvictionControllerTest.this.getRootRegion().getSubregion(r1);
                TestCase.assertNotNull((Object)reg1);
                Region reg2 = LRUEvictionControllerTest.this.getRootRegion().getSubregion(r2);
                TestCase.assertNotNull((Object)reg2);
                Region reg3 = LRUEvictionControllerTest.this.getRootRegion().getSubregion(r3);
                TestCase.assertNotNull((Object)reg3);
                boolean startTx = false;
                Region[] r = new Region[]{reg1, reg2, reg3};
                for (i = 0; i < 10000; ++i) {
                    if (i % 10 == 0) {
                        txm.begin();
                        startTx = true;
                    }
                    reg1.create((Object)("r1-key-" + i), (Object)("r1-value-" + i));
                    reg2.create((Object)("r2-key-" + i), (Object)("r2-value-" + i));
                    reg3.create((Object)("r3-key-" + i), (Object)("r3-value-" + i));
                    if (i % 10 != 9) continue;
                    txm.commit();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException ie) {
                        TestCase.fail((String)"interrupted");
                    }
                    startTx = false;
                }
                if (startTx) {
                    txm.commit();
                }
                for (i = 0; i < r.length; ++i) {
                    TestCase.assertEquals((int)10000, (int)r[i].size());
                    LocalRegion lr = (LocalRegion)r[i];
                    TestCase.assertEquals((long)1L, (long)lr.getEvictionController().getLRUHelper().getStats().getLimit());
                    TestCase.assertEquals((long)1L, (long)lr.getEvictionController().getLRUHelper().getStats().getCounter());
                }
            }
        });
        repl.invoke(new CacheSerializableRunnable("Replicate asserts 1 max entries"){

            @Override
            public void run2() throws CacheException {
                LRUEvictionControllerTest.this.getCache();
                Region reg1 = LRUEvictionControllerTest.this.getRootRegion().getSubregion(r1);
                Region reg2 = LRUEvictionControllerTest.this.getRootRegion().getSubregion(r2);
                Region reg3 = LRUEvictionControllerTest.this.getRootRegion().getSubregion(r3);
                Region[] r = new Region[]{reg1, reg2, reg3};
                for (int i = 0; i < r.length; ++i) {
                    TestCase.assertNotNull((Object)r[i]);
                    TestCase.assertEquals((int)10000, (int)r[i].size());
                    LocalRegion lr = (LocalRegion)r[i];
                    TestCase.assertEquals((long)1L, (long)lr.getEvictionController().getLRUHelper().getStats().getLimit());
                    TestCase.assertEquals((long)1L, (long)lr.getEvictionController().getLRUHelper().getStats().getCounter());
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        usingMain = true;
        new LRUEvictionControllerTest("test").testSizeOne();
    }
}

