/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class ClearMultiVmDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static Region paperWork;
    static Region mirroredRegion;
    static CacheTransactionManager cacheTxnMgr;

    public ClearMultiVmDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(ClearMultiVmDUnitTest.class, "createCache");
        vm1.invoke(ClearMultiVmDUnitTest.class, "createCache");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(ClearMultiVmDUnitTest.class, "closeCache");
        vm1.invoke(ClearMultiVmDUnitTest.class, "closeCache");
        cache = null;
        ClearMultiVmDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void createCache() {
        try {
            ds = new ClearMultiVmDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setConcurrencyChecksEnabled(true);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
            AttributesFactory factory1 = new AttributesFactory();
            factory1.setScope(Scope.DISTRIBUTED_ACK);
            factory.setConcurrencyChecksEnabled(true);
            factory1.setDataPolicy(DataPolicy.REPLICATE);
            paperWork = cache.createRegion("paperWork", factory1.create());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClearMultiVmDUnitTest.fail("failed in createCache", ex);
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testClearSimpleScenarios() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("temp1"){

            @Override
            public void run2() throws CacheException {
                region.put((Object)new Integer(1), (Object)new String("first"));
                region.put((Object)new Integer(2), (Object)new String("second"));
                region.put((Object)new Integer(3), (Object)new String("third"));
                region.clear();
                TestCase.assertEquals((int)0, (int)region.size());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("temp1vm1"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)region.size());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("temp2"){

            @Override
            public void run2() throws CacheException {
                try {
                    region.put((Object)new Integer(1), (Object)new String("first"));
                    region.put((Object)new Integer(2), (Object)new String("second"));
                    region.put((Object)new Integer(3), (Object)new String("third"));
                    cacheTxnMgr = cache.getCacheTransactionManager();
                    cacheTxnMgr.begin();
                    region.put((Object)new Integer(4), (Object)new String("forth"));
                    region.clear();
                    region.put((Object)new Integer(5), (Object)new String("fifth"));
                    cacheTxnMgr.commit();
                    TestCase.assertEquals((int)1, (int)region.size());
                    TestCase.assertEquals((String)"fifth", (String)region.get((Object)new Integer(5)).toString());
                }
                catch (CacheException ce) {
                    ce.printStackTrace();
                }
                finally {
                    if (cacheTxnMgr.exists()) {
                        try {
                            cacheTxnMgr.commit();
                        }
                        catch (Exception cce) {
                            cce.printStackTrace();
                        }
                    }
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("temp3"){

            @Override
            public void run2() throws CacheException {
                region.put((Object)new Integer(1), (Object)new String("first"));
                region.put((Object)new Integer(2), (Object)new String("second"));
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                RegionAttributes attr = factory.create();
                Region subRegion = region.createSubregion("subr", attr);
                subRegion.put((Object)new Integer(3), (Object)new String("third"));
                subRegion.put((Object)new Integer(4), (Object)new String("forth"));
                region.clear();
                TestCase.assertEquals((int)0, (int)region.size());
                TestCase.assertEquals((int)2, (int)subRegion.size());
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testClearMultiVM() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Object[] objArr = new Object[1];
        for (int i = 1; i < 4; ++i) {
            objArr[0] = "" + i;
            vm0.invoke(ClearMultiVmDUnitTest.class, "putMethod", objArr);
            vm1.invoke(ClearMultiVmDUnitTest.class, "getMethod", objArr);
        }
        AsyncInvocation as1 = vm0.invokeAsync(ClearMultiVmDUnitTest.class, "firstVM");
        AsyncInvocation as2 = vm1.invokeAsync(ClearMultiVmDUnitTest.class, "secondVM");
        DistributedTestCase.join(as1, 30000L, ClearMultiVmDUnitTest.getLogWriter());
        DistributedTestCase.join(as2, 30000L, ClearMultiVmDUnitTest.getLogWriter());
        if (as1.exceptionOccurred()) {
            ClearMultiVmDUnitTest.fail("as1 failed", as1.getException());
        }
        if (as2.exceptionOccurred()) {
            ClearMultiVmDUnitTest.fail("as2 failed", as2.getException());
        }
        int j = vm1.invokeInt(ClearMultiVmDUnitTest.class, "sizeMethod");
        ClearMultiVmDUnitTest.assertEquals((int)1, (int)j);
        j = vm0.invokeInt(ClearMultiVmDUnitTest.class, "sizeMethod");
        ClearMultiVmDUnitTest.assertEquals((int)0, (int)j);
        int i = 6;
        objArr[0] = "" + i;
        vm1.invoke(ClearMultiVmDUnitTest.class, "getMethod", objArr);
        Object[] ob = new Object[]{"secondVM"};
        boolean val = vm1.invokeBoolean(ClearMultiVmDUnitTest.class, "containsValueMethod", ob);
        ClearMultiVmDUnitTest.assertEquals((boolean)true, (boolean)val);
    }

    public void testClearExceptions() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(ClearMultiVmDUnitTest.class, "localDestroyRegionMethod");
        vm0.invoke(new CacheSerializableRunnable("exception in vm0"){

            @Override
            public void run2() throws CacheException {
                try {
                    region.clear();
                }
                catch (RegionDestroyedException rdex) {
                    TestCase.fail((String)"Should NOT have thrown RegionDestroyedException");
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("exception in vm1"){

            @Override
            public void run2() throws CacheException {
                try {
                    region.clear();
                    TestCase.fail((String)"Should have thrown RegionDestroyedException");
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
        });
    }

    public void testGiiandClear() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("create mirrored region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory1 = new AttributesFactory();
                factory1.setScope(Scope.DISTRIBUTED_ACK);
                factory1.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attr1 = factory1.create();
                mirroredRegion = cache.createRegion("mirrored", attr1);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("put initial data"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 1000; ++i) {
                    mirroredRegion.put((Object)new Integer(i), (Object)new Integer(i).toString());
                }
            }
        });
        vm1.invoke(new SerializableRunnable("set slow image processing"){

            @Override
            public void run() {
                int pause;
                InitialImageOperation.slowImageProcessing = pause = 50;
            }
        });
        AsyncInvocation async1 = vm1.invokeAsync(create);
        vm0.invoke(new SerializableRunnable("call clear when gii"){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    TestCase.fail((String)"interrupted");
                }
                mirroredRegion.clear();
                TestCase.assertEquals((int)0, (int)mirroredRegion.size());
            }
        });
        DistributedTestCase.join(async1, 30000L, ClearMultiVmDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            ClearMultiVmDUnitTest.fail("async1 failed", async1.getException());
        }
        CacheSerializableRunnable validate = new CacheSerializableRunnable("validate for region size"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)0, (int)mirroredRegion.size());
            }
        };
        vm0.invoke(validate);
        vm1.invoke(validate);
    }

    public static void firstVM() {
        try {
            cacheTxnMgr = cache.getCacheTransactionManager();
            cacheTxnMgr.begin();
            int i = 5;
            region.put((Object)("" + i), (Object)"firstVM");
            boolean val = false;
            while (!val) {
                val = paperWork.containsKey((Object)"TxnTwoStarted");
            }
            Object obj = paperWork.get((Object)"TxnTwoStarted");
            if (obj.toString().equals("true")) {
                region.clear();
                cacheTxnMgr.commit();
            }
            paperWork.put((Object)"TxnOneCommitted", (Object)"true");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (cacheTxnMgr.exists()) {
                try {
                    cacheTxnMgr.commit();
                }
                catch (Exception cce) {
                    cce.printStackTrace();
                }
            }
        }
    }

    public static void secondVM() {
        try {
            cacheTxnMgr = cache.getCacheTransactionManager();
            cacheTxnMgr.begin();
            region.put((Object)"6", (Object)"secondVM");
            TXStateInterface ts = ((TXManagerImpl)cacheTxnMgr).internalSuspend();
            try {
                paperWork.put((Object)"TxnTwoStarted", (Object)"true");
                boolean val = false;
                while (!val) {
                    val = paperWork.containsKey((Object)"TxnOneCommitted");
                }
            }
            finally {
                ((TXManagerImpl)cacheTxnMgr).resume(ts);
            }
            Object obj = paperWork.get((Object)"TxnOneCommitted");
            if (obj.toString().equals("true")) {
                cacheTxnMgr.commit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (cacheTxnMgr.exists()) {
                try {
                    cacheTxnMgr.commit();
                }
                catch (Exception cce) {
                    cce.printStackTrace();
                }
            }
        }
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClearMultiVmDUnitTest.fail((String)"Failed while region.put");
        }
        return obj;
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            ClearMultiVmDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static boolean containsValueMethod(Object ob) {
        boolean flag = false;
        try {
            flag = region.containsValue(ob);
        }
        catch (Exception ex) {
            ClearMultiVmDUnitTest.fail((String)"Failed while region.containsValueMethod");
        }
        return flag;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            ClearMultiVmDUnitTest.fail("Failed while region.size", ex);
        }
        return i;
    }

    public static void localDestroyRegionMethod() {
        try {
            region.localDestroyRegion();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void clearExceptions() {
        try {
            region.clear();
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
    }
}

