/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class ClearMultiVmCallBkDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static Region paperWork;
    static CacheTransactionManager cacheTxnMgr;
    static boolean afterClear;

    public ClearMultiVmCallBkDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(ClearMultiVmCallBkDUnitTest.class, "createCache");
        vm1.invoke(ClearMultiVmCallBkDUnitTest.class, "createCache");
        ClearMultiVmCallBkDUnitTest.getLogWriter().fine("Cache created in successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(ClearMultiVmCallBkDUnitTest.class, "closeCache");
        vm1.invoke(ClearMultiVmCallBkDUnitTest.class, "closeCache");
    }

    public static void createCache() {
        try {
            ListenerCallBk aListener = new ListenerCallBk();
            ds = new ClearMultiVmCallBkDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setCacheListener((CacheListener)aListener);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testClearSingleVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        Object[] objArr = new Object[1];
        for (int i = 1; i < 4; ++i) {
            objArr[0] = "" + i;
            vm0.invoke(ClearMultiVmCallBkDUnitTest.class, "putMethod", objArr);
        }
        ClearMultiVmCallBkDUnitTest.getLogWriter().fine("Did all puts successfully");
        vm0.invoke(ClearMultiVmCallBkDUnitTest.class, "clearMethod");
        ClearMultiVmCallBkDUnitTest.getLogWriter().fine("Did clear successfully");
        while (afterClear) {
        }
        int Regsize = vm0.invokeInt(ClearMultiVmCallBkDUnitTest.class, "sizeMethod");
        ClearMultiVmCallBkDUnitTest.assertEquals((int)1, (int)Regsize);
    }

    public void testClearMultiVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Object[] objArr = new Object[1];
        for (int i = 1; i < 4; ++i) {
            objArr[0] = "" + i;
            vm0.invoke(ClearMultiVmCallBkDUnitTest.class, "putMethod", objArr);
            vm1.invoke(ClearMultiVmCallBkDUnitTest.class, "getMethod", objArr);
        }
        ClearMultiVmCallBkDUnitTest.getLogWriter().fine("Did all puts successfully");
        vm1.invoke(ClearMultiVmCallBkDUnitTest.class, "clearMethod");
        ClearMultiVmCallBkDUnitTest.getLogWriter().fine("Did clear successfully");
        while (afterClear) {
        }
        int Regsize = vm0.invokeInt(ClearMultiVmCallBkDUnitTest.class, "sizeMethod");
        ClearMultiVmCallBkDUnitTest.assertEquals((int)1, (int)Regsize);
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClearMultiVmCallBkDUnitTest.fail((String)"Failed while region.put");
        }
        return obj;
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            ClearMultiVmCallBkDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static boolean containsValueMethod(Object ob) {
        boolean flag = false;
        try {
            flag = region.containsValue(ob);
        }
        catch (Exception ex) {
            ClearMultiVmCallBkDUnitTest.fail((String)"Failed while region.containsValueMethod");
        }
        return flag;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            ClearMultiVmCallBkDUnitTest.fail((String)"Failed while region.size");
        }
        return i;
    }

    public static void clearMethod() {
        try {
            region.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean getBoolean() {
        return afterClear;
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        afterClear = false;
    }

    static class ListenerCallBk
    extends CacheListenerAdapter {
        ListenerCallBk() {
        }

        public void afterRegionClear(RegionEvent event) {
            DistributedTestCase.getLogWriter().fine("In afterClear:: CacheListener Callback");
            try {
                int i = 7;
                region.put((Object)("" + i), (Object)"inAfterClear");
                afterClear = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

