/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import dunit.DistributedTestCase;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CertifiableTestCacheListener
extends TestCacheListener
implements Declarable2 {
    public final Set destroys = Collections.synchronizedSet(new HashSet());
    public final Set creates = Collections.synchronizedSet(new HashSet());
    public final Set invalidates = Collections.synchronizedSet(new HashSet());
    public final Set updates = Collections.synchronizedSet(new HashSet());
    final LogWriter logger;
    private static final String WAIT_PROPERTY = "CertifiableTestCacheListener.maxWaitTime";
    private static final int WAIT_DEFAULT = 30000;
    public static final long MAX_TIME = Integer.getInteger("CertifiableTestCacheListener.maxWaitTime", 30000).intValue();

    public CertifiableTestCacheListener(LogWriter l) {
        this.logger = l;
    }

    public void clearState() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
    }

    @Override
    public List getEventHistory() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
        return super.getEventHistory();
    }

    @Override
    public void afterCreate2(EntryEvent event) {
        this.creates.add(event.getKey());
    }

    @Override
    public void afterDestroy2(EntryEvent event) {
        this.destroys.add(event.getKey());
    }

    @Override
    public void afterInvalidate2(EntryEvent event) {
        Object key = event.getKey();
        this.invalidates.add(key);
    }

    @Override
    public void afterUpdate2(EntryEvent event) {
        this.updates.add(event.getKey());
    }

    public boolean waitForCreated(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.creates.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key creation: " + key;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForDestroyed(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.destroys.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key destroy: " + key;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForInvalidated(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.invalidates.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key invalidate: " + key;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForUpdated(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.updates.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key update: " + key;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public Properties getConfig() {
        return null;
    }

    public void init(Properties props) {
    }
}

