/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.util.TransactionListenerAdapter;
import com.gemstone.gemfire.cache30.CacheXml65Test;
import com.gemstone.gemfire.cache30.TestPdxSerializer;
import com.gemstone.gemfire.cache30.TestTransactionWriter;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.QuarterPartitionResolver;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheTransactionManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientCacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CacheXml66Test
extends CacheXml65Test {
    public CacheXml66Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "6_6";
    }

    public void testFixedPartitioning() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation();
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q1");
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true);
        FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"Q3", (int)3);
        FixedPartitionAttributes fpa4 = FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpattrsList = new ArrayList<FixedPartitionAttributes>();
        fpattrsList.add(fpa1);
        fpattrsList.add(fpa2);
        fpattrsList.add(fpa3);
        fpattrsList.add(fpa4);
        QuarterPartitionResolver resolver = new QuarterPartitionResolver();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setPartitionResolver((PartitionResolver)resolver).addFixedPartitionAttributes(fpa1).addFixedPartitionAttributes(fpa2).addFixedPartitionAttributes(fpa3).addFixedPartitionAttributes(fpa4);
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("Quarter", (RegionAttributes)attrs);
        Region r = cache.getRegion("Quarter");
        this.validateAttributes(r, fpattrsList, resolver, false);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml66Test.assertNotNull((Object)c);
        Region region = c.getRegion("Quarter");
        CacheXml66Test.assertNotNull((Object)region);
        this.validateAttributes(region, fpattrsList, resolver, false);
    }

    public void testFixedPartitioning_colocation_WithAttributes() throws CacheException {
        CacheCreation cache = new CacheCreation();
        FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q1");
        FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true);
        FixedPartitionAttributes fpa3 = FixedPartitionAttributes.createFixedPartition((String)"Q3", (int)3);
        FixedPartitionAttributes fpa4 = FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)false, (int)3);
        ArrayList<FixedPartitionAttributes> fpattrsList = new ArrayList<FixedPartitionAttributes>();
        fpattrsList.add(fpa1);
        fpattrsList.add(fpa2);
        fpattrsList.add(fpa3);
        fpattrsList.add(fpa4);
        QuarterPartitionResolver resolver = new QuarterPartitionResolver();
        Region customerRegion = null;
        Region orderRegion = null;
        RegionAttributesCreation attrs = new RegionAttributesCreation();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setPartitionResolver((PartitionResolver)resolver).addFixedPartitionAttributes(fpa1).addFixedPartitionAttributes(fpa2).addFixedPartitionAttributes(fpa3).addFixedPartitionAttributes(fpa4);
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("Customer", (RegionAttributes)attrs);
        customerRegion = cache.getRegion("Customer");
        this.validateAttributes(customerRegion, fpattrsList, resolver, false);
        try {
            attrs = new RegionAttributesCreation();
            paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(1).setPartitionResolver((PartitionResolver)resolver).addFixedPartitionAttributes(fpa1).addFixedPartitionAttributes(fpa2).addFixedPartitionAttributes(fpa3).addFixedPartitionAttributes(fpa4).setColocatedWith("Customer");
            attrs.setPartitionAttributes(paf.create());
            cache.createRegion("Order", (RegionAttributes)attrs);
            orderRegion = cache.getRegion("Order");
            this.validateAttributes(orderRegion, fpattrsList, resolver, true);
        }
        catch (Exception illegal) {
            if (!(illegal instanceof IllegalStateException) || !illegal.getMessage().contains("can not be specified in PartitionAttributesFactory")) {
                CacheXml66Test.fail("Expected IllegalStateException ", illegal);
            }
            RegionAttributesCreation attrs2 = new RegionAttributesCreation();
            PartitionAttributesFactory paf2 = new PartitionAttributesFactory();
            paf2.setRedundantCopies(1).setPartitionResolver((PartitionResolver)resolver).setColocatedWith("Customer");
            attrs2.setPartitionAttributes(paf2.create());
            cache.createRegion("Order", (RegionAttributes)attrs2);
            orderRegion = cache.getRegion("Order");
            this.validateAttributes(orderRegion, fpattrsList, resolver, true);
        }
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml66Test.assertNotNull((Object)c);
        customerRegion = c.getRegion("Customer");
        CacheXml66Test.assertNotNull((Object)customerRegion);
        this.validateAttributes(customerRegion, fpattrsList, resolver, false);
        orderRegion = c.getRegion("Order");
        CacheXml66Test.assertNotNull((Object)orderRegion);
        this.validateAttributes(orderRegion, fpattrsList, resolver, true);
    }

    private void validateAttributes(Region region, List<FixedPartitionAttributes> fpattrsList, QuarterPartitionResolver resolver, boolean isColocated) {
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        CacheXml66Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml66Test.assertNotNull(pa.getPartitionResolver().getClass());
        CacheXml66Test.assertEquals((Object)pa.getPartitionResolver(), (Object)resolver);
        List fixedPartitionsList = pa.getFixedPartitionAttributes();
        if (isColocated) {
            CacheXml66Test.assertNull((Object)fixedPartitionsList);
            CacheXml66Test.assertNotNull((Object)pa.getColocatedWith());
        } else {
            CacheXml66Test.assertNull((Object)pa.getColocatedWith());
            CacheXml66Test.assertEquals((int)fixedPartitionsList.size(), (int)4);
            CacheXml66Test.assertEquals((boolean)fixedPartitionsList.containsAll(fpattrsList), (boolean)true);
            for (FixedPartitionAttributes fpa : fixedPartitionsList) {
                if (fpa.getPartitionName().equals("Q1")) {
                    CacheXml66Test.assertEquals((int)fpa.getNumBuckets(), (int)1);
                    CacheXml66Test.assertEquals((boolean)fpa.isPrimary(), (boolean)false);
                }
                if (fpa.getPartitionName().equals("Q2")) {
                    CacheXml66Test.assertEquals((int)fpa.getNumBuckets(), (int)1);
                    CacheXml66Test.assertEquals((boolean)fpa.isPrimary(), (boolean)true);
                }
                if (fpa.getPartitionName().equals("Q3")) {
                    CacheXml66Test.assertEquals((int)fpa.getNumBuckets(), (int)3);
                    CacheXml66Test.assertEquals((boolean)fpa.isPrimary(), (boolean)false);
                }
                if (!fpa.getPartitionName().equals("Q4")) continue;
                CacheXml66Test.assertEquals((int)fpa.getNumBuckets(), (int)3);
                CacheXml66Test.assertEquals((boolean)fpa.isPrimary(), (boolean)false);
            }
        }
    }

    public void testPdxDefaults() {
        CacheCreation creation = new CacheCreation();
        this.testXml(creation);
        Cache c = this.getCache();
        CacheXml66Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        CacheXml66Test.assertEquals(null, (String)c.getPdxDiskStore());
        CacheXml66Test.assertEquals(null, (Object)c.getPdxSerializer());
        CacheXml66Test.assertEquals((boolean)false, (boolean)c.getPdxPersistent());
        CacheXml66Test.assertEquals((boolean)false, (boolean)c.getPdxReadSerialized());
        CacheXml66Test.assertEquals((boolean)false, (boolean)c.getPdxIgnoreUnreadFields());
    }

    public void testPdxAttributes() {
        CacheCreation creation = new CacheCreation();
        creation.setPdxPersistent(true);
        creation.setPdxReadSerialized(true);
        creation.setPdxIgnoreUnreadFields(true);
        creation.setPdxDiskStore("my_disk_store");
        TestPdxSerializer serializer = new TestPdxSerializer();
        Properties props = new Properties();
        props.setProperty("hello", "there");
        serializer.init(props);
        creation.setPdxSerializer((PdxSerializer)serializer);
        this.testXml(creation);
        Cache c = this.getCache();
        CacheXml66Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        CacheXml66Test.assertEquals((String)"my_disk_store", (String)c.getPdxDiskStore());
        CacheXml66Test.assertEquals((Object)serializer, (Object)c.getPdxSerializer());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxPersistent());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxReadSerialized());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxIgnoreUnreadFields());
        CacheXml66Test.closeCache();
        CacheFactory cf = new CacheFactory();
        cf.setPdxDiskStore("new disk store");
        c = this.getCache(cf);
        CacheXml66Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        CacheXml66Test.assertEquals((String)"new disk store", (String)c.getPdxDiskStore());
        CacheXml66Test.assertEquals((Object)serializer, (Object)c.getPdxSerializer());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxPersistent());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxReadSerialized());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxIgnoreUnreadFields());
        CacheXml66Test.closeCache();
        cf = new CacheFactory();
        cf.setPdxPersistent(false);
        cf.setPdxIgnoreUnreadFields(false);
        c = this.getCache(cf);
        CacheXml66Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        CacheXml66Test.assertEquals((String)"my_disk_store", (String)c.getPdxDiskStore());
        CacheXml66Test.assertEquals((Object)serializer, (Object)c.getPdxSerializer());
        CacheXml66Test.assertEquals((boolean)false, (boolean)c.getPdxPersistent());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxReadSerialized());
        CacheXml66Test.assertEquals((boolean)false, (boolean)c.getPdxIgnoreUnreadFields());
        CacheXml66Test.closeCache();
        cf = new CacheFactory();
        cf.setPdxSerializer(null);
        c = this.getCache(cf);
        CacheXml66Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        CacheXml66Test.assertEquals((String)"my_disk_store", (String)c.getPdxDiskStore());
        CacheXml66Test.assertEquals(null, (Object)c.getPdxSerializer());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxPersistent());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxReadSerialized());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxIgnoreUnreadFields());
        CacheXml66Test.closeCache();
        cf = new CacheFactory();
        cf.setPdxReadSerialized(false);
        c = this.getCache(cf);
        CacheXml66Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        CacheXml66Test.assertEquals((String)"my_disk_store", (String)c.getPdxDiskStore());
        CacheXml66Test.assertEquals((Object)serializer, (Object)c.getPdxSerializer());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxPersistent());
        CacheXml66Test.assertEquals((boolean)false, (boolean)c.getPdxReadSerialized());
        CacheXml66Test.assertEquals((boolean)true, (boolean)c.getPdxIgnoreUnreadFields());
    }

    public void testTXManagerOnClientCache() {
        ClientCacheCreation cc = new ClientCacheCreation();
        CacheTransactionManagerCreation txMgrCreation = new CacheTransactionManagerCreation();
        txMgrCreation.addListener((TransactionListener)new TestTXListener());
        cc.addCacheTransactionManagerCreation(txMgrCreation);
        this.testXml((CacheCreation)cc);
        Cache c = this.getCache();
        CacheXml66Test.assertTrue((boolean)(c instanceof ClientCache));
        c.loadCacheXml(this.generate((CacheCreation)cc));
        ClientCache clientC = (ClientCache)c;
        CacheTransactionManager mgr = clientC.getCacheTransactionManager();
        CacheXml66Test.assertNotNull((Object)mgr);
        CacheXml66Test.assertTrue((boolean)(mgr.getListeners()[0] instanceof TestTXListener));
    }

    public void testNoTXWriterOnClient() {
        ClientCacheCreation cc = new ClientCacheCreation();
        CacheTransactionManagerCreation txMgrCreation = new CacheTransactionManagerCreation();
        txMgrCreation.setWriter((TransactionWriter)new TestTransactionWriter());
        cc.addCacheTransactionManagerCreation(txMgrCreation);
        try {
            this.testXml((CacheCreation)cc);
            CacheXml66Test.fail((String)"expected exception not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static class TestTXListener
    extends TransactionListenerAdapter
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object other) {
            return other instanceof TestTXListener;
        }
    }
}

