/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.company.app.DBLoader;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheXml30Test;
import com.gemstone.gemfire.cache30.CacheXml41Test;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestTransactionListener;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheTransactionManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class CacheXml45Test
extends CacheXml41Test {
    protected Properties xmlProps = null;

    public CacheXml45Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "5_0";
    }

    @Override
    public void setBridgeAttributes(BridgeServer bridge1) {
        super.setBridgeAttributes(bridge1);
        bridge1.setMaxConnections(100);
    }

    public void testDataPolicy() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createRegion("rootNORMAL", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        attrs.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        cache.createRegion("rootNORMAL_ALL", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        cache.createRegion("rootREPLICATE", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        cache.createRegion("rootPERSISTENT_REPLICATE", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.EMPTY);
        cache.createRegion("rootEMPTY", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.EMPTY);
        attrs.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        cache.createRegion("rootEMPTY_ALL", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = super.getDistributedSystemProperties();
        if (this.xmlProps != null) {
            for (Map.Entry<Object, Object> entry : this.xmlProps.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                props.setProperty(key, value);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMembershipAttributes() throws Exception {
        String MY_ROLES = "Foo, Bip, BAM";
        String[][] roles = new String[][]{{"Foo"}, {"Bip", "BAM"}};
        LossAction[] policies = LossAction.VALUES.toArray(new LossAction[LossAction.VALUES.size()]);
        ResumptionAction[] actions = ResumptionAction.VALUES.toArray(new ResumptionAction[ResumptionAction.VALUES.size()]);
        CacheCreation cache = new CacheCreation();
        for (int policy = 0; policy < policies.length; ++policy) {
            for (int action = 0; action < actions.length; ++action) {
                for (int role = 0; role < roles.length; ++role) {
                    String[] theRoles = roles[role];
                    LossAction thePolicy = policies[policy];
                    ResumptionAction theAction = actions[action];
                    RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
                    MembershipAttributes ra = new MembershipAttributes(theRoles, thePolicy, theAction);
                    attrs.setMembershipAttributes(ra);
                    String region = "rootMEMBERSHIP_ATTRIBUTES_" + policy + "_" + action + "_" + role;
                    cache.createRegion(region, (RegionAttributes)attrs);
                }
            }
        }
        Properties config = new Properties();
        config.setProperty("roles", "Foo, Bip, BAM");
        this.xmlProps = config;
        DistributedRegion.ignoreReconnect = true;
        try {
            this.testXml(cache);
        }
        finally {
            this.xmlProps = null;
            try {
                this.tearDown2();
            }
            finally {
                DistributedRegion.ignoreReconnect = false;
            }
        }
    }

    public void testMultipleCacheListener() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        CacheXml30Test.MyTestCacheListener l1 = new CacheXml30Test.MyTestCacheListener();
        MySecondTestCacheListener l2 = new MySecondTestCacheListener();
        attrs.addCacheListener((CacheListener)l1);
        attrs.addCacheListener((CacheListener)l2);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        Region r = c.getRegion("root");
        CacheXml45Test.assertEquals(Arrays.asList(l1, l2), Arrays.asList(r.getAttributes().getCacheListeners()));
        AttributesMutator am = r.getAttributesMutator();
        am.removeCacheListener((CacheListener)l2);
        CacheXml45Test.assertEquals(Arrays.asList(l1), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.removeCacheListener((CacheListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(new CacheListener[0]), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.addCacheListener((CacheListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l1), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.addCacheListener((CacheListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l1), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.addCacheListener((CacheListener)l2);
        CacheXml45Test.assertEquals(Arrays.asList(l1, l2), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.removeCacheListener((CacheListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l2), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.removeCacheListener((CacheListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l2), Arrays.asList(r.getAttributes().getCacheListeners()));
        am.initCacheListeners(new CacheListener[]{l1, l2});
        CacheXml45Test.assertEquals(Arrays.asList(l1, l2), Arrays.asList(r.getAttributes().getCacheListeners()));
    }

    public void testHeapLRUEviction() throws Exception {
        String name = this.getUniqueName();
        CacheXml45Test.beginCacheXml();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        EvictionAttributes ev = EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        factory.setEvictionAttributes(ev);
        this.createRegion(name, factory.create());
        this.finishCacheXml(this.getUniqueName(), this.getGemFireVersion());
        Region r = this.getRootRegion().getSubregion(name);
        EvictionAttributes hlea = r.getAttributes().getEvictionAttributes();
        CacheXml45Test.assertEquals((Object)EvictionAction.OVERFLOW_TO_DISK, (Object)hlea.getAction());
    }

    public void testMultipleTXListener() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheTransactionManagerCreation txMgrCreation = new CacheTransactionManagerCreation();
        CacheXml30Test.MyTestTransactionListener l1 = new CacheXml30Test.MyTestTransactionListener();
        MySecondTestTransactionListener l2 = new MySecondTestTransactionListener();
        txMgrCreation.addListener((TransactionListener)l1);
        txMgrCreation.addListener((TransactionListener)l2);
        cache.addCacheTransactionManagerCreation(txMgrCreation);
        this.testXml(cache);
        CacheTransactionManager tm = this.getCache().getCacheTransactionManager();
        CacheXml45Test.assertEquals(Arrays.asList(l1, l2), Arrays.asList(tm.getListeners()));
        tm.removeListener((TransactionListener)l2);
        CacheXml45Test.assertEquals(Arrays.asList(l1), Arrays.asList(tm.getListeners()));
        tm.removeListener((TransactionListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(new TransactionListener[0]), Arrays.asList(tm.getListeners()));
        tm.addListener((TransactionListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l1), Arrays.asList(tm.getListeners()));
        tm.addListener((TransactionListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l1), Arrays.asList(tm.getListeners()));
        tm.addListener((TransactionListener)l2);
        CacheXml45Test.assertEquals(Arrays.asList(l1, l2), Arrays.asList(tm.getListeners()));
        tm.removeListener((TransactionListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l2), Arrays.asList(tm.getListeners()));
        tm.removeListener((TransactionListener)l1);
        CacheXml45Test.assertEquals(Arrays.asList(l2), Arrays.asList(tm.getListeners()));
        tm.initListeners(new TransactionListener[]{l1, l2});
        CacheXml45Test.assertEquals(Arrays.asList(l1, l2), Arrays.asList(tm.getListeners()));
    }

    public void testGatewayHub() throws CacheException {
        CacheCreation cache = new CacheCreation();
        int HUB_PORT = AvailablePort.getRandomAvailablePort((int)0);
        int PORT1 = AvailablePort.getRandomAvailablePort((int)0);
        int PORT2 = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub = cache.setGatewayHub("US", HUB_PORT);
        hub.setSocketBufferSize(65536);
        hub.setMaximumTimeBetweenPings(30000);
        Gateway gateway = hub.addGateway("EU");
        gateway.setSocketBufferSize(65536);
        gateway.addEndpoint("EU-1", DistributedTestCase.getIPLiteral(), PORT1);
        gateway.addEndpoint("EU-2", DistributedTestCase.getIPLiteral(), PORT2);
        GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
        File overflowDirectory = new File(this.getName());
        overflowDirectory.mkdir();
        queueAttributes.setOverflowDirectory(overflowDirectory.getAbsolutePath());
        queueAttributes.setMaximumQueueMemory(200);
        queueAttributes.setBatchSize(500);
        queueAttributes.setBatchTimeInterval(100);
        queueAttributes.setBatchConflation(true);
        queueAttributes.setEnablePersistence(true);
        this.testXml(cache);
        Cache c = this.getCache();
        List hubs = c.getGatewayHubs();
        GatewayHub createdHub = (GatewayHub)hubs.get(0);
        CacheXml45Test.assertTrue((createdHub != null ? 1 : 0) != 0);
        CacheXml45Test.assertEquals((String)"US", (String)createdHub.getId());
        CacheXml45Test.assertEquals((int)HUB_PORT, (int)createdHub.getPort());
        CacheXml45Test.assertEquals((int)65536, (int)createdHub.getSocketBufferSize());
        Gateway createdGateway = (Gateway)createdHub.getGateways().get(0);
        CacheXml45Test.assertNotNull((Object)createdGateway);
        CacheXml45Test.assertEquals((String)"EU", (String)createdGateway.getId());
        CacheXml45Test.assertEquals((int)65536, (int)createdGateway.getSocketBufferSize());
        List endpoints = createdGateway.getEndpoints();
        CacheXml45Test.assertEquals((int)2, (int)endpoints.size());
        for (Gateway.Endpoint endpoint : endpoints) {
            if (endpoint.getId().equals("EU-1")) {
                CacheXml45Test.assertEquals((String)DistributedTestCase.getIPLiteral(), (String)endpoint.getHost());
                CacheXml45Test.assertEquals((int)PORT1, (int)endpoint.getPort());
                continue;
            }
            if (endpoint.getId().equals("EU-2")) {
                CacheXml45Test.assertEquals((String)DistributedTestCase.getIPLiteral(), (String)endpoint.getHost());
                CacheXml45Test.assertEquals((int)PORT2, (int)endpoint.getPort());
                continue;
            }
            CacheXml45Test.fail((String)("Expected an endpoint with id EU-1 or EU-2 but got one with id " + endpoint.getId()));
        }
        GatewayQueueAttributes createdQueueAttributes = createdGateway.getQueueAttributes();
        CacheXml45Test.assertEquals((String)overflowDirectory.getAbsolutePath(), (String)createdQueueAttributes.getOverflowDirectory());
        CacheXml45Test.assertEquals((int)200, (int)createdQueueAttributes.getMaximumQueueMemory());
        CacheXml45Test.assertEquals((int)500, (int)createdQueueAttributes.getBatchSize());
        CacheXml45Test.assertEquals((int)100, (int)createdQueueAttributes.getBatchTimeInterval());
        CacheXml45Test.assertEquals((boolean)true, (boolean)createdQueueAttributes.getBatchConflation());
        CacheXml45Test.assertEquals((boolean)true, (boolean)createdQueueAttributes.getEnablePersistence());
        String rq = new StringBuffer(createdGateway.getGatewayHubId()).append('_').append(createdGateway.getId()).append("_EVENT_QUEUE").toString();
        Region wbcl = c.getRegion(rq);
        if (wbcl != null) {
            wbcl.localDestroyRegion();
        }
    }

    public void testPartitionedRegionXML() throws CacheException {
        this.setXmlFile(this.findFile("partitionedRegion.xml"));
        String regionName = "pRoot";
        Cache cache = this.getCache();
        Region region = cache.getRegion("pRoot");
        CacheXml45Test.assertNotNull((Object)region);
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable init = new CacheSerializableRunnable("initUsingPartitionedRegionXML"){

            @Override
            public void run2() throws CacheException {
                Cache cache;
                try {
                    CacheXml30Test.lonerDistributedSystem = false;
                    cache = CacheXml45Test.this.getCache();
                }
                finally {
                    CacheXml30Test.lonerDistributedSystem = true;
                }
                Region region = cache.getRegion("pRoot");
                TestCase.assertNotNull((Object)region);
                RegionAttributes attrs = region.getAttributes();
                TestCase.assertNotNull((Object)attrs.getPartitionAttributes());
                PartitionAttributes pa = attrs.getPartitionAttributes();
                TestCase.assertEquals((int)pa.getRedundantCopies(), (int)1);
                TestCase.assertEquals((String)pa.getGlobalProperties().getProperty("GLOBAL_MAX_MEMORY"), (String)"96");
                TestCase.assertEquals((String)pa.getLocalProperties().getProperty("LOCAL_MAX_MEMORY"), (String)"32");
            }
        };
        init.run2();
        vm0.invoke(init);
        vm1.invoke(init);
        vm0.invoke(new CacheSerializableRunnable("putUsingPartitionedRegionXML1"){

            @Override
            public void run2() throws CacheException {
                String val = "prValue0";
                Integer key = new Integer(10);
                Cache cache = CacheXml45Test.this.getCache();
                Region region = cache.getRegion("pRoot");
                TestCase.assertNotNull((Object)region);
                region.put((Object)key, (Object)"prValue0");
                TestCase.assertEquals((Object)"prValue0", (Object)region.get((Object)key));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("putUsingPartitionedRegionXML2"){

            @Override
            public void run2() throws CacheException {
                String val = "prValue1";
                Integer key = new Integer(14);
                Cache cache = CacheXml45Test.this.getCache();
                Region region = cache.getRegion("pRoot");
                TestCase.assertNotNull((Object)region);
                region.put((Object)key, (Object)"prValue1");
                TestCase.assertEquals((Object)"prValue1", (Object)region.get((Object)key));
            }
        });
    }

    public void testPartitionedRegionInstantiation() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        Properties gp = new Properties();
        gp.setProperty("GLOBAL_MAX_MEMORY", "2");
        gp.setProperty("GLOBAL_MAX_BUCKETS", "17");
        Properties lp = new Properties();
        lp.setProperty("LOCAL_MAX_MEMORY", "4");
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setLocalProperties(lp).setGlobalProperties(gp);
        attrs.setCacheLoader((CacheLoader)new DBLoader());
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("pRoot", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public static class MySecondTestTransactionListener
    extends TestTransactionListener
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof MySecondTestTransactionListener;
        }
    }

    public static class MySecondTestCacheListener
    extends TestCacheListener
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof MySecondTestCacheListener;
        }
    }
}

