/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import dunit.RepeatableRunnable;
import dunit.SerializableRunnable;
import junit.framework.AssertionFailedError;
import util.TestException;

public abstract class CacheSerializableRunnable
extends SerializableRunnable
implements RepeatableRunnable {
    public CacheSerializableRunnable(String name) {
        super(name);
    }

    @Override
    public final void run() {
        try {
            this.run2();
        }
        catch (CacheException ex) {
            String s = "While invoking \"" + this + "\"";
            throw new CacheSerializableRunnableException(s, ex);
        }
    }

    @Override
    public final void runRepeatingIfNecessary(long repeatTimeoutMs) {
        long start = System.currentTimeMillis();
        AssertionFailedError lastErr = null;
        do {
            try {
                lastErr = null;
                this.run();
                CacheFactory.getAnyInstance().getLogger().fine("Completed " + this);
            }
            catch (AssertionFailedError err) {
                CacheFactory.getAnyInstance().getLogger().fine("Repeating " + this);
                lastErr = err;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    throw new TestException("interrupted", ex);
                }
            }
        } while (lastErr != null && System.currentTimeMillis() - start < repeatTimeoutMs);
        if (lastErr != null) {
            throw lastErr;
        }
    }

    public abstract void run2() throws CacheException;

    public static class CacheSerializableRunnableException
    extends CacheRuntimeException {
        public CacheSerializableRunnableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

