/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache30.CacheLoaderTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import junit.framework.TestCase;

public abstract class CacheListenerTestCase
extends CacheLoaderTestCase {
    public CacheListenerTestCase(String name) {
        super(name);
    }

    public void testCacheListenerAfterCreate() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        String arg = "ARG";
        TestCacheListener listener = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)value, (Object)event.getNewValue());
                TestCase.assertNull((Object)event.getOldValue());
                TestCase.assertFalse((boolean)event.isLoad());
                TestCase.assertFalse((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }

            @Override
            public void afterDestroy2(EntryEvent event) {
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheListener((CacheListener)listener);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)value);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)value);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.create((Object)key, (Object)value, (Object)arg);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)value, (Object)arg);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
    }

    public void testCacheListenerAfterUpdate() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer oldValue = new Integer(42);
        final Integer newValue = new Integer(43);
        String arg = "ARG";
        TestCacheListener listener = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
            }

            @Override
            public void afterDestroy2(EntryEvent event) {
            }

            @Override
            public void afterUpdate2(EntryEvent event) {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                TestCase.assertEquals((Object)oldValue, (Object)event.getOldValue());
                TestCase.assertFalse((boolean)event.isLoad());
                TestCase.assertFalse((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheListener((CacheListener)listener);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)oldValue);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)newValue);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)oldValue);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)newValue);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.create((Object)key, (Object)oldValue);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)newValue, (Object)arg);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)oldValue);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.put((Object)key, (Object)newValue, (Object)arg);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
    }

    public void testCacheListenerAfterDestroy() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        String arg = "ARG";
        TestCacheListener listener = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
            }

            @Override
            public void afterDestroy2(EntryEvent event) {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)value, (Object)event.getOldValue());
                TestCase.assertNull((Object)event.getNewValue());
                TestCase.assertFalse((boolean)event.isLoad());
                TestCase.assertFalse((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheListener((CacheListener)listener);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)value);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.create((Object)key, (Object)value);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.destroy((Object)key, (Object)arg);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
    }

    public void testCacheListenerAfterInvalidate() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        TestCacheListener listener = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
            }

            @Override
            public void afterInvalidate2(EntryEvent event) {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)value, (Object)event.getOldValue());
                TestCase.assertNull((Object)event.getNewValue());
                TestCase.assertFalse((boolean)event.isLoad());
                TestCase.assertFalse((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheListener((CacheListener)listener);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)value);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region.invalidate((Object)key);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
    }

    public void testCacheListenerAfterRegionDestroy() throws CacheException, InterruptedException {
        final String name = this.getUniqueName();
        String arg = "ARG";
        TestCacheListener listener = new TestCacheListener(){
            private boolean closed = false;
            private boolean destroyed = false;

            @Override
            public boolean wasInvoked() {
                boolean value = this.closed && this.destroyed;
                super.wasInvoked();
                return value;
            }

            @Override
            public void close2() {
                this.closed = true;
            }

            @Override
            public void afterRegionDestroy2(RegionEvent event) {
                TestCase.assertEquals((String)name, (String)event.getRegion().getName());
                TestCase.assertFalse((boolean)event.isExpiration());
                TestCase.assertFalse((boolean)event.isOriginRemote());
                this.destroyed = true;
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheListener((CacheListener)listener);
        RegionAttributes attrs = factory.create();
        Region region = this.createRegion(name, attrs);
        CacheListenerTestCase.assertTrue((region.getAttributes().getCacheListener() != null ? 1 : 0) != 0);
        region.destroyRegion();
        CacheListenerTestCase.pause(100);
        CacheListenerTestCase.assertTrue((boolean)region.isDestroyed());
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        region = this.createRegion(name, attrs);
        region.destroyRegion((Object)arg);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        CacheListenerTestCase.assertTrue((boolean)region.isDestroyed());
    }

    public void testCacheListenerAfterRegionInvalidate() throws CacheException, InterruptedException {
        final String name = this.getUniqueName();
        TestCacheListener listener = new TestCacheListener(){
            private boolean closed = false;
            private boolean invalidated = false;

            @Override
            public boolean wasInvoked() {
                boolean value = this.invalidated;
                super.wasInvoked();
                return value;
            }

            @Override
            public void close2() {
                this.closed = true;
            }

            @Override
            public void afterRegionInvalidate2(RegionEvent event) {
                TestCase.assertEquals((String)name, (String)event.getRegion().getName());
                TestCase.assertFalse((boolean)event.isExpiration());
                TestCase.assertFalse((boolean)event.isOriginRemote());
                this.invalidated = true;
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheListener((CacheListener)listener);
        RegionAttributes attrs = factory.create();
        Region region = this.createRegion(name, attrs);
        region.invalidateRegion();
        CacheListenerTestCase.pause(500);
        CacheListenerTestCase.assertTrue((boolean)listener.wasInvoked());
        CacheListenerTestCase.assertEquals((int)0, (int)region.values().size());
    }
}

