/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import dunit.Host;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Bug38013DUnitTest
extends CacheTestCase {
    protected static Object lastCallback = null;

    public Bug38013DUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void doCreateOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                Bug38013DUnitTest.this.getSystem();
                AttributesFactory af = new AttributesFactory();
                CacheListenerAdapter cl = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }

                    public void afterUpdate(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }

                    public void afterInvalidate(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }

                    public void afterDestroy(EntryEvent event) {
                        if (event.getCallbackArgument() != null) {
                            lastCallback = event.getCallbackArgument();
                        }
                    }
                };
                af.setCacheListener((CacheListener)cl);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                af.setPartitionAttributes(paf.create());
                Bug38013DUnitTest.this.createRootRegion("bug38013", af.create());
            }
        });
    }

    public void testBug38013() throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(0);
        paf.setLocalMaxMemory(0);
        factory.setPartitionAttributes(paf.create());
        Region r = this.createRootRegion("bug38013", factory.create());
        this.doCreateOtherVm();
        r.put((Object)"key1", (Object)new HomeBoy());
        Bug38013DUnitTest.assertTrue((boolean)(r.get((Object)"key1") instanceof HomeBoy));
    }

    public static class HomeBoy
    implements DataSerializable {
        public void toData(DataOutput out) throws IOException {
            InternalDistributedMember me = InternalDistributedSystem.getAnyInstance().getDistributedMember();
            DataSerializer.writeObject((Object)me, (DataOutput)out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            DistributedMember hb;
            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
            DistributedMember me = ds.getDistributedMember();
            if (me.equals(hb = (DistributedMember)DataSerializer.readObject((DataInput)in))) {
                ds.getLogWriter().info("HomeBoy was deserialized on his home");
            } else {
                String msg = "HomeBoy was deserialized on " + me + " instead of his home " + hb;
                if (CachedDeserializableFactory.preferObject()) {
                    ds.getLogWriter().info(msg);
                } else {
                    ds.getLogWriter().error(msg);
                    throw new IllegalStateException(msg);
                }
            }
        }
    }
}

