/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;

public class Bug35214DUnitTest
extends CacheTestCase {
    protected volatile int expirationCount = 0;
    private static final int ENTRY_COUNT = 100;
    protected static volatile boolean callbackFailure;
    protected boolean afterRegionCreateSeen = false;

    public Bug35214DUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("init"){

            @Override
            public void run2() throws CacheException {
                Bug35214DUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                Region r1 = Bug35214DUnitTest.this.createRootRegion("r1", af.create());
                for (int i = 1; i <= 100; ++i) {
                    r1.put((Object)("key" + i), (Object)("value" + i));
                }
            }
        });
    }

    private AsyncInvocation updateOtherVm() throws Throwable {
        VM vm = this.getOtherVm();
        AsyncInvocation otherUpdater = vm.invokeAsync(new CacheSerializableRunnable("update"){

            @Override
            public void run2() throws CacheException {
                int i;
                int numProfiles;
                Region r1 = Bug35214DUnitTest.this.getRootRegion("r1");
                CacheDistributionAdvisor adv = ((DistributedRegion)r1).getCacheDistributionAdvisor();
                int expectedProfiles = 1;
                while ((numProfiles = adv.adviseInitialImage(null).getReplicates().size()) < expectedProfiles) {
                }
                DistributedTestCase.getLogWriter().info("PROFILE CHECK: Found " + numProfiles + " getInitialImage Profiles (OK)");
                int updateCount = 1;
                do {
                    for (i = 1; i <= 100; ++i) {
                        String key = "key" + i;
                        if (r1.containsKey((Object)key)) {
                            r1.destroy((Object)key);
                            continue;
                        }
                        r1.put((Object)key, (Object)("value" + i + "uc" + updateCount));
                    }
                } while (updateCount++ < 20);
                for (i = 1; i <= 100; ++i) {
                    String key = "key" + i;
                    if (r1.containsKey((Object)key)) continue;
                    r1.put((Object)key, (Object)("value" + i + "uc" + updateCount));
                }
            }
        });
        return otherUpdater;
    }

    protected static void callbackAssertTrue(String msg, boolean cond) {
        if (cond) {
            return;
        }
        callbackFailure = true;
        Bug35214DUnitTest.assertTrue((String)msg, (boolean)cond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoEntryExpireDuringGII() throws Exception {
        this.initOtherVm();
        AsyncInvocation updater = null;
        try {
            updater = this.updateOtherVm();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e1) {
            Bug35214DUnitTest.fail("failed due to " + e1, e1);
        }
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        InitialImageOperation.slowImageProcessing = 30;
        callbackFailure = false;
        try {
            AttributesFactory af = new AttributesFactory();
            af.setDataPolicy(DataPolicy.REPLICATE);
            af.setScope(Scope.DISTRIBUTED_ACK);
            af.setStatisticsEnabled(true);
            af.setEntryIdleTimeout(new ExpirationAttributes(1, ExpirationAction.INVALIDATE));
            CacheListenerAdapter cl1 = new CacheListenerAdapter(){

                public void afterRegionCreate(RegionEvent re) {
                    Bug35214DUnitTest.this.afterRegionCreateSeen = true;
                }

                public void afterInvalidate(EntryEvent e) {
                    Bug35214DUnitTest.callbackAssertTrue("afterregionCreate not seen", Bug35214DUnitTest.this.afterRegionCreateSeen);
                    Bug35214DUnitTest.callbackAssertTrue("not initialized", ((LocalRegion)e.getRegion()).isInitialized());
                    ++Bug35214DUnitTest.this.expirationCount;
                    InitialImageOperation.slowImageProcessing = 0;
                }
            };
            af.addCacheListener((CacheListener)cl1);
            final Region r1 = this.createRootRegion("r1", af.create());
            DistributedTestCase.join(updater, 60000L, Bug35214DUnitTest.getLogWriter());
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return r1.values().size() == 0;
                }

                @Override
                public String description() {
                    return "region never became empty";
                }
            };
            DistributedTestCase.waitForCriterion(ev, 2000L, 200L, true);
            Bug35214DUnitTest.assertEquals((int)0, (int)r1.values().size());
            Bug35214DUnitTest.assertEquals((int)100, (int)r1.keys().size());
        }
        finally {
            InitialImageOperation.slowImageProcessing = 0;
            System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
            Bug35214DUnitTest.assertEquals(null, (String)System.getProperty("gemfire.EXPIRY_UNITS_MS"));
        }
        Bug35214DUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }
}

