/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class PRQueryRemoteNodeExceptionDUnitTest
extends PartitionedRegionDUnitTestCase {
    static Properties props = new Properties();
    int totalNumBuckets = 100;
    int threadSleepTime = 500;
    int querySleepTime = 2000;
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "Portfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 50;
    final int redundancy = 0;
    private int numOfBuckets = 10;

    public PRQueryRemoteNodeExceptionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        PRQueryRemoteNodeExceptionDUnitTest.invokeInEveryVM(QueryObserverHolder.class, "reset");
        super.tearDown2();
    }

    public void testPRWithLocalAndRemoteException() throws Exception {
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception test Started");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm0);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating PR's across all VM0 , VM1");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created PR on VM0 , VM1");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data through the accessor node");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Querying on VM0 First time");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        vm1.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        throw new RuntimeException("For testing purpose only from remote node");
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                boolean gotException = false;
                Cache cache = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache();
                class MyQueryObserver
                extends QueryObserverAdapter {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        throw new RuntimeException("For testing purpose only from local node");
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
                DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery("Select * from /Portfolios");
                try {
                    query.execute();
                }
                catch (Exception ex) {
                    gotException = true;
                    if (ex.getMessage().contains("local node")) {
                        DistributedTestCase.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest: Test received Exception from local node successfully.");
                    }
                    DistributedTestCase.fail("PRQueryRemoteNodeExceptionDUnitTest: Test did not receive Exception as expected from local node rather received", ex);
                }
                if (!gotException) {
                    TestCase.fail((String)"PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Test did not receive Exception as expected from local as well as remote node");
                }
            }
        });
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception Test ENDED");
    }

    public void testRemoteException() throws Exception {
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception test Started");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm0);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating PR's across all VM0 , VM1");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created PR on VM0 , VM1");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data through the accessor node");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                boolean gotException = false;
                Cache cache = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache();
                class MyQueryObserver
                extends QueryObserverAdapter {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        throw new RuntimeException("For testing purpose only from remote node");
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                boolean gotException = false;
                Cache cache = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache();
                DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery("Select * from /Portfolios");
                try {
                    query.execute();
                }
                catch (Exception ex) {
                    gotException = true;
                    if (ex.getMessage().contains("remote node")) {
                        ex.printStackTrace();
                        DistributedTestCase.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest: Test received Exception from remote node successfully.");
                    }
                    DistributedTestCase.fail("PRQueryRemoteNodeExceptionDUnitTest: Test did not receive Exception as expected from remote node rather received", ex);
                }
                if (!gotException) {
                    TestCase.fail((String)"PRQueryRemoteNodeExceptionDUnitTest#testRemoteException: Test did not receive Exception as expected from remote node");
                }
            }
        });
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception Test ENDED");
    }

    public void testCacheCloseExceptionFromLocalAndRemote() throws Exception {
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception test Started");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm0);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating PR's across all VM0 , VM1");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created PR on VM0 , VM1");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data through the accessor node");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        vm1.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    private int noOfAccess = 0;

                    MyQueryObserver() {
                    }

                    public void afterIterationEvaluation(Object result) {
                        DistributedTestCase.getLogWriter().info("Calling after IterationEvaluation :" + this.noOfAccess);
                        if (this.noOfAccess > 2) {
                            PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache().getRegion("Portfolios").destroyRegion();
                        }
                        ++this.noOfAccess;
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                boolean gotException = false;
                Cache cache = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache();
                class MyQueryObserver
                extends QueryObserverAdapter {
                    private int noOfAccess = 0;

                    MyQueryObserver() {
                    }

                    public void afterIterationEvaluation(Object result) {
                        DistributedTestCase.getLogWriter().info("Calling after IterationEvaluation :" + this.noOfAccess);
                        if (this.noOfAccess > 2) {
                            PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache().close();
                        }
                        ++this.noOfAccess;
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
                DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery("Select * from /Portfolios p where p.ID > 0");
                try {
                    query.execute();
                }
                catch (Exception ex) {
                    gotException = true;
                    if (ex instanceof CacheClosedException || ex instanceof QueryInvocationTargetException) {
                        DistributedTestCase.getLogWriter().info(ex.getMessage());
                        DistributedTestCase.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest: Test received Exception from local node successfully.");
                    }
                    DistributedTestCase.fail("PRQueryRemoteNodeExceptionDUnitTest: Test did not receive Exception as expected from local node rather received", ex);
                }
                if (!gotException) {
                    TestCase.fail((String)"PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Test did not receive Exception as expected from local as well as remote node");
                }
            }
        });
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception Test ENDED");
    }

    public void testCacheCloseExceptionFromLocalAndRemote2() throws Exception {
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception test Started");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm0);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating PR's across all VM0 , VM1");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 0, this.numOfBuckets));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created PR on VM0 , VM1");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data through the accessor node");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        vm1.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    private int noOfAccess = 0;

                    MyQueryObserver() {
                    }

                    public void afterIterationEvaluation(Object result) {
                        DistributedTestCase.getLogWriter().info("Calling after IterationEvaluation :" + this.noOfAccess);
                        if (this.noOfAccess > 1) {
                            PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache().getRegion("Portfolios").destroyRegion();
                        }
                        ++this.noOfAccess;
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                boolean gotException = false;
                Cache cache = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache();
                class MyQueryObserver
                extends QueryObserverAdapter {
                    private int noOfAccess = 0;

                    MyQueryObserver() {
                    }

                    public void afterIterationEvaluation(Object result) {
                        Region region;
                        for (int i = 0; i <= 10 && (region = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache().getRegion("Portfolios")) != null && !region.isDestroyed(); ++i) {
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
                DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery("Select * from /Portfolios p where p.ID > 0");
                try {
                    query.execute();
                }
                catch (Exception ex) {
                    gotException = true;
                    if (ex instanceof QueryInvocationTargetException) {
                        DistributedTestCase.getLogWriter().info(ex.getMessage());
                        DistributedTestCase.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest: Test received Exception from remote node successfully as region.destroy happened before cache.close().");
                    }
                    DistributedTestCase.fail("PRQueryRemoteNodeExceptionDUnitTest: Test did not receive Exception as expected from local node rather received", ex);
                }
                if (!gotException) {
                    TestCase.fail((String)"PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Test did not receive Exception as expected from local as well as remote node");
                }
            }
        });
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception Test ENDED");
    }

    public void testForceReattemptExceptionFromLocal() throws Exception {
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception test Started");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm0);
        vmList.add(vm2);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating PR's across all VM0 , VM1");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 1, this.numOfBuckets));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 1, this.numOfBuckets));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateLimitedBuckets("Portfolios", 1, this.numOfBuckets));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created PR on VM0 , VM1");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data through the accessor node");
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#testPRWithLocalAndRemoteException: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        vm1.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    private int noOfAccess = 0;

                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        Object region = ((DefaultQuery)query).getRegionsInQuery(null).iterator().next();
                        DistributedTestCase.getLogWriter().info("Region type on VM1:" + region);
                        if (this.noOfAccess == 1) {
                            PartitionedRegion pr = (PartitionedRegion)PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache().getRegion("Portfolios");
                            List buks = pr.getLocalPrimaryBucketsListTestOnly();
                            DistributedTestCase.getLogWriter().info("Available buckets:" + buks);
                            int bukId = (Integer)buks.get(0);
                            DistributedTestCase.getLogWriter().info("Destroying bucket id:" + bukId);
                            pr.getDataStore().getLocalBucketById(Integer.valueOf(bukId)).destroyRegion();
                        }
                        ++this.noOfAccess;
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Portfolios"){

            @Override
            public void run2() throws CacheException {
                boolean gotException = false;
                Cache cache = PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache();
                class MyQueryObserver
                extends QueryObserverAdapter {
                    private int noOfAccess = 0;

                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        Object region = ((DefaultQuery)query).getRegionsInQuery(null).iterator().next();
                        DistributedTestCase.getLogWriter().info("Region type on VM0:" + region);
                        if (this.noOfAccess == 2) {
                            PartitionedRegion pr = (PartitionedRegion)PRQueryRemoteNodeExceptionDUnitTest.this.PRQHelp.getCache().getRegion("Portfolios");
                            List buks = pr.getLocalPrimaryBucketsListTestOnly();
                            DistributedTestCase.getLogWriter().info("Available buckets:" + buks);
                            int bukId = (Integer)buks.get(0);
                            DistributedTestCase.getLogWriter().info("Destroying bucket id:" + bukId);
                            pr.getDataStore().getLocalBucketById(Integer.valueOf(bukId)).destroyRegion();
                        }
                        ++this.noOfAccess;
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
                DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery("Select * from /Portfolios");
                try {
                    query.execute();
                    DistributedTestCase.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest: Query executed successfully with ForceReattemptException on local and remote both.");
                }
                catch (Exception ex) {
                    gotException = true;
                    DistributedTestCase.fail("PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Test received Exception", ex);
                }
            }
        });
        PRQueryRemoteNodeExceptionDUnitTest.getLogWriter().info("PRQueryRemoteNodeExceptionDUnitTest#testPRWithLocalAndRemoteException: Querying with PR Local/Remote Exception Test ENDED");
    }
}

