/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;

public class PRQueryCacheCloseDUnitTest
extends PartitionedRegionDUnitTestCase {
    static Properties props = new Properties();
    int totalNumBuckets = 100;
    int threadSleepTime = 500;
    int querySleepTime = 2000;
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "Portfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 50;
    final int redundancy = 1;

    public PRQueryCacheCloseDUnitTest(String name) {
        super(name);
    }

    public void testPRWithCacheCloseInOneDatastoreWithDelay() throws Exception {
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Querying PR Test with cache Close PR operation*****");
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(datastore1);
        vmList.add(datastore2);
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Creating Accessor node on VM0");
        accessor.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 1));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Successfully Created Accessor node on VM0");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Creating PR's across all VM1 , VM2");
        datastore1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 1));
        datastore2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 1));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Successfully Created PR on VM1 , VM2");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Creating Local Region on VM0");
        accessor.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Inserting Portfolio data through the accessor node");
        accessor.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Successfully Inserted Portfolio data through the accessor node");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        accessor.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        Random random = new Random();
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Querying on VM0 both on PR Region & local ,also  Comparing the Results sets from both");
        AsyncInvocation async0 = accessor.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Calling for cache close on either of the Datastores VM1 , VM2 at random and then recreating the cache, with a predefined Delay ");
        for (int j = 0; j < this.queryTestCycle; ++j) {
            int k = random.nextInt(vmList.size());
            ((VM)vmList.get(k)).invoke(this.PRQHelp.getCacheSerializableRunnableForCacheClose("Portfolios", 1));
            PRQueryCacheCloseDUnitTest.pause(this.threadSleepTime);
        }
        DistributedTestCase.join(async0, 300000L, PRQueryCacheCloseDUnitTest.getLogWriter());
        if (async0.exceptionOccurred()) {
            boolean isForceReattempt = false;
            Throwable t = async0.getException();
            do {
                if (!(t instanceof ForceReattemptException)) continue;
                isForceReattempt = true;
                break;
            } while ((t = t.getCause()) != null);
            if (!isForceReattempt) {
                PRQueryCacheCloseDUnitTest.fail("Unexpected exception during query", async0.getException());
            }
        }
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithDelay: Querying with PR Operations ENDED*****");
    }

    public void testPRWithCacheCloseInOneDatastoreWithoutDelay() throws Exception {
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Querying PR Test with cache Close PR operation without delay*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm2);
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Creating Accessor node on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 1));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Successfully Created Accessor node on VM0");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Creating PR's across all VM1 , VM2");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 1));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 1));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Successfully Created PR on VM1 , VM2");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Successfully Created Local Region on VM0");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("Successfully Created PR's across all VM's");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Successfully Inserted Portfolio data through the accessor node");
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        Random random = new Random();
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Querying on VM0 both on PR Region & local ,also  Comparing the Results sets from both");
        AsyncInvocation async0 = vm0.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Calling for cache close on either of the Datastores VM1 , VM2 at random and then recreating the cache, with no delay ");
        for (int j = 0; j < this.queryTestCycle; ++j) {
            int k = random.nextInt(vmList.size());
            ((VM)vmList.get(k)).invoke(this.PRQHelp.getCacheSerializableRunnableForCacheClose("Portfolios", 1));
        }
        DistributedTestCase.join(async0, 300000L, PRQueryCacheCloseDUnitTest.getLogWriter());
        if (async0.exceptionOccurred()) {
            boolean isForceReattempt = false;
            Throwable t = async0.getException();
            do {
                if (!(t instanceof ForceReattemptException)) continue;
                isForceReattempt = true;
                break;
            } while ((t = t.getCause()) != null);
            if (!isForceReattempt) {
                PRQueryCacheCloseDUnitTest.fail("Unexpected exception during query", async0.getException());
            }
        }
        PRQueryCacheCloseDUnitTest.getLogWriter().info("PRQueryCacheCloseDUnitTest#testPRWithCacheCloseInOneDatastoreWithoutDelay: Querying with PR Operations  without delay ENDED*****");
    }
}

