/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.QueryTestUtils;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.Position;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class CopyOnReadIndexDUnitTest
extends CacheTestCase {
    VM vm0;
    VM vm1;
    VM vm2;

    public CopyOnReadIndexDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CopyOnReadIndexDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CopyOnReadIndexDUnitTest.this.getSystem();
            }
        });
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
    }

    @Override
    public void tearDown2() throws Exception {
        CopyOnReadIndexDUnitTest.invokeInEveryVM(new SerializableRunnable("resetCopyOnRead"){

            @Override
            public void run() {
                CopyOnReadIndexDUnitTest.this.getCache().setCopyOnRead(false);
            }
        });
        this.vm0.invoke(CacheServerTestUtil.class, "closeCache");
        this.vm1.invoke(CacheServerTestUtil.class, "closeCache");
        this.vm2.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testPRQueryOnLocalNode() throws Exception {
        QueryTestUtils utils = new QueryTestUtils();
        this.helpTestPRQueryOnLocalNode((String)utils.queries.get("545"), 100, 100);
        this.helpTestPRQueryOnLocalNode((String)utils.queries.get("546"), 100, 100);
        this.helpTestPRQueryOnLocalNode((String)utils.queries.get("543"), 100, 100);
        this.helpTestPRQueryOnLocalNode((String)utils.queries.get("544"), 100, 100);
    }

    public void helpTestPRQueryOnLocalNode(final String queryString, int numPortfolios, int numExpectedResults) throws Exception {
        int[] port = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        this.startCacheServer(this.vm0, port[0], mcastPort);
        this.startCacheServer(this.vm1, port[1], mcastPort);
        this.createPartitionRegion(this.vm0, "portfolios");
        this.vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                QueryTestUtils utils = new QueryTestUtils();
                utils.createIndex("idIndex", "p.ID", "/portfolios p");
                return null;
            }
        });
        this.createPartitionRegion(this.vm1, "portfolios");
        this.vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = CopyOnReadIndexDUnitTest.this.getCache().getRegion("/portfolios");
                for (int i = 0; i < 50; ++i) {
                    Portfolio p = new Portfolio(i);
                    p.status = "testStatus";
                    p.positions = new HashMap();
                    p.positions.put("" + i, new Position("" + i, 20.0));
                    region.put((Object)("key " + i), (Object)p);
                }
                return null;
            }
        });
        this.vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = CopyOnReadIndexDUnitTest.this.getCache().getRegion("/portfolios");
                for (int i = 50; i < 100; ++i) {
                    Portfolio p = new Portfolio(i);
                    p.status = "testStatus";
                    p.positions = new HashMap();
                    p.positions.put("" + i, new Position("" + i, 20.0));
                    region.put((Object)("key " + i), (Object)p);
                }
                return null;
            }
        });
        this.vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                QueryService qs = CopyOnReadIndexDUnitTest.this.getCache().getQueryService();
                Query query = qs.newQuery(queryString);
                SelectResults results = (SelectResults)query.execute();
                TestCase.assertEquals((int)100, (int)results.size());
                for (Object o : results) {
                    if (o instanceof Portfolio) {
                        Portfolio p = (Portfolio)o;
                        p.status = "discardStatus";
                        continue;
                    }
                    Struct struct = (Struct)o;
                    Portfolio p = (Portfolio)struct.getFieldValues()[0];
                    p.status = "discardStatus";
                }
                return null;
            }
        });
        this.vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                QueryService qs = CopyOnReadIndexDUnitTest.this.getCache().getQueryService();
                Query query = qs.newQuery(queryString);
                SelectResults results = (SelectResults)query.execute();
                TestCase.assertEquals((int)100, (int)results.size());
                for (Object o : results) {
                    if (o instanceof Portfolio) {
                        Portfolio p = (Portfolio)o;
                        TestCase.assertEquals((String)"status should not have been changed", (String)"testStatus", (String)p.status);
                        continue;
                    }
                    Struct struct = (Struct)o;
                    Portfolio p = (Portfolio)struct.getFieldValues()[0];
                    TestCase.assertEquals((String)"status should not have been changed", (String)"testStatus", (String)p.status);
                }
                return null;
            }
        });
    }

    private void createPartitionRegion(VM vm, String regionName) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                QueryTestUtils utils = new QueryTestUtils();
                utils.createPartitionRegion("portfolios", Portfolio.class);
                return null;
            }
        });
    }

    private void startCacheServer(VM server, final int port, final int mcastPort) throws Exception {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CopyOnReadIndexDUnitTest.this.getSystem(CopyOnReadIndexDUnitTest.this.getServerProperties(mcastPort));
                GemFireCacheImpl cache = (GemFireCacheImpl)CopyOnReadIndexDUnitTest.this.getCache();
                cache.setCopyOnRead(true);
                AttributesFactory factory = new AttributesFactory();
                CacheServer cacheServer = CopyOnReadIndexDUnitTest.this.getCache().addCacheServer();
                cacheServer.setPort(port);
                cacheServer.start();
                QueryTestUtils.setCache((Cache)cache);
                return null;
            }
        });
    }

    private void startClient(VM client, final VM server, final int port) {
        client.invoke(new CacheSerializableRunnable("Start client"){

            @Override
            public void run2() throws CacheException {
                Properties props = CopyOnReadIndexDUnitTest.this.getClientProps();
                CopyOnReadIndexDUnitTest.this.getSystem(props);
                ClientCacheFactory ccf = new ClientCacheFactory(props);
                ccf.addPoolServer(DistributedTestCase.getServerHostName(server.getHost()), port);
                ccf.setPoolSubscriptionEnabled(true);
                ClientCache cache = CopyOnReadIndexDUnitTest.this.getClientCache(ccf);
            }
        });
    }

    protected Properties getClientProps() {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("locators", "");
        return p;
    }

    protected Properties getServerProperties(int mcastPort) {
        Properties p = new Properties();
        p.setProperty("mcast-port", mcastPort + "");
        p.setProperty("locators", "");
        return p;
    }
}

