/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.Position;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.CompactRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexStore;
import com.gemstone.gemfire.cache.query.internal.index.MemoryIndexStore;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache.query.internal.index.RangeIndex;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Collection;
import junit.framework.TestCase;

public class ConcurrentIndexUpdateWithoutWLDUnitTest
extends DistributedTestCase {
    PRQueryDUnitHelper helper = new PRQueryDUnitHelper("ConcurrentIndexUpdateWithoutWLDUnitTest");
    private static String regionName = "Portfolios";
    private int redundancy = 1;
    private String indexName = "idIndex";
    private String indexedExpression = "ID";
    private String fromClause = "/" + regionName;
    private String alias = "p";
    private String rindexName = "secidIndex";
    private String rindexedExpression = "pos.secId";
    private String rfromClause = "/" + regionName + " p, p.positions.values pos";
    private String ralias = "pos";
    int stepSize = 10;
    private int totalDataSize = 50;

    public ConcurrentIndexUpdateWithoutWLDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            ConcurrentIndexUpdateWithoutWLDUnitTest.invokeInEveryVM(ConcurrentIndexUpdateWithoutWLDUnitTest.class, "destroyRegions");
            ConcurrentIndexUpdateWithoutWLDUnitTest.invokeInEveryVM(CacheTestCase.class, "closeCache");
        }
        finally {
            super.tearDown2();
        }
    }

    public static synchronized void destroyRegions() {
        Region region;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && (region = cache.getRegion(regionName)) != null) {
            region.destroyRegion();
        }
    }

    public void testCompactRangeIndex() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(this.helper.getCacheSerializableRunnableForReplicatedRegionCreation(regionName, Portfolio.class));
        vm0.invoke(this.helper.getCacheSerializableRunnableForPRIndexCreate(regionName, this.indexName, this.indexedExpression, this.fromClause, this.alias));
        AsyncInvocation[] asyncInvs = new AsyncInvocation[]{vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize))};
        for (AsyncInvocation inv : asyncInvs) {
            DistributedTestCase.join(inv, 0L, this.helper.getCache().getLogger());
        }
        for (AsyncInvocation inv : asyncInvs) {
            if (!inv.exceptionOccurred()) continue;
            ConcurrentIndexUpdateWithoutWLDUnitTest.fail("Random region operation failed on VM_" + inv.getId(), inv.getException());
        }
        vm0.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.indexName));
    }

    private Runnable getCacheSerializableRunnableForIndexValidation(final String regionName, String indexName) {
        return new CacheSerializableRunnable("Index Validate"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexUpdateWithoutWLDUnitTest.this.helper.getCache();
                Region region = cache.getRegion(regionName);
                IndexValidator validator = new IndexValidator();
                validator.validate(region);
            }
        };
    }

    public void testRangeIndex() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(this.helper.getCacheSerializableRunnableForReplicatedRegionCreation(regionName, Portfolio.class));
        vm0.invoke(this.helper.getCacheSerializableRunnableForPRIndexCreate(regionName, this.rindexName, this.rindexedExpression, this.rfromClause, this.ralias));
        AsyncInvocation[] asyncInvs = new AsyncInvocation[]{vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.totalDataSize)), vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.totalDataSize))};
        for (AsyncInvocation inv : asyncInvs) {
            DistributedTestCase.join(inv, 0L, this.helper.getCache().getLogger());
        }
        for (AsyncInvocation inv : asyncInvs) {
            if (!inv.exceptionOccurred()) continue;
            ConcurrentIndexUpdateWithoutWLDUnitTest.fail("Random region operation failed on VM_" + inv.getId(), inv.getException());
        }
        vm0.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.rindexName));
    }

    public void testCompactRangeIndexOnPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(this.helper.getCacheSerializableRunnableForPRAccessorCreate(regionName, this.redundancy, Portfolio.class));
        vm1.invoke(this.helper.getCacheSerializableRunnableForPRCreate(regionName, this.redundancy, Portfolio.class));
        vm2.invoke(this.helper.getCacheSerializableRunnableForPRCreate(regionName, this.redundancy, Portfolio.class));
        vm3.invoke(this.helper.getCacheSerializableRunnableForPRCreate(regionName, this.redundancy, Portfolio.class));
        vm0.invoke(this.helper.getCacheSerializableRunnableForPRIndexCreate(regionName, this.indexName, this.indexedExpression, this.fromClause, this.alias));
        AsyncInvocation[] asyncInvs = new AsyncInvocation[]{vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm1.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, this.stepSize, 2 * this.stepSize)), vm2.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 2 * this.stepSize, 3 * this.stepSize)), vm3.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 3 * this.stepSize, this.totalDataSize)), vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm1.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, this.stepSize, 2 * this.stepSize)), vm2.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 2 * this.stepSize, 3 * this.stepSize)), vm3.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 3 * this.stepSize, this.totalDataSize)), vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm1.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, this.stepSize, 2 * this.stepSize)), vm2.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 2 * this.stepSize, 3 * this.stepSize)), vm3.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 3 * this.stepSize, this.totalDataSize))};
        for (AsyncInvocation inv : asyncInvs) {
            DistributedTestCase.join(inv, 0L, this.helper.getCache().getLogger());
        }
        for (AsyncInvocation inv : asyncInvs) {
            if (!inv.exceptionOccurred()) continue;
            ConcurrentIndexUpdateWithoutWLDUnitTest.fail("Random region operation failed on VM_" + inv.getId(), inv.getException());
        }
        vm0.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.indexName));
        vm1.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.indexName));
        vm2.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.indexName));
        vm3.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.indexName));
    }

    public void testRangeIndexOnPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(this.helper.getCacheSerializableRunnableForPRAccessorCreate(regionName, this.redundancy, Portfolio.class));
        vm1.invoke(this.helper.getCacheSerializableRunnableForPRCreate(regionName, this.redundancy, Portfolio.class));
        vm2.invoke(this.helper.getCacheSerializableRunnableForPRCreate(regionName, this.redundancy, Portfolio.class));
        vm3.invoke(this.helper.getCacheSerializableRunnableForPRCreate(regionName, this.redundancy, Portfolio.class));
        vm0.invoke(this.helper.getCacheSerializableRunnableForPRIndexCreate(regionName, this.rindexName, this.rindexedExpression, this.rfromClause, this.ralias));
        AsyncInvocation[] asyncInvs = new AsyncInvocation[]{vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm1.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, this.stepSize, 2 * this.stepSize)), vm2.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 2 * this.stepSize, 3 * this.stepSize)), vm3.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 3 * this.stepSize, this.totalDataSize)), vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm1.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, this.stepSize, 2 * this.stepSize)), vm2.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 2 * this.stepSize, 3 * this.stepSize)), vm3.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 3 * this.stepSize, this.totalDataSize)), vm0.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 0, this.stepSize)), vm1.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, this.stepSize, 2 * this.stepSize)), vm2.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 2 * this.stepSize, 3 * this.stepSize)), vm3.invokeAsync(this.helper.getCacheSerializableRunnableForPRRandomOps(regionName, 3 * this.stepSize, this.totalDataSize))};
        for (AsyncInvocation inv : asyncInvs) {
            DistributedTestCase.join(inv, 0L, this.helper.getCache().getLogger());
        }
        for (AsyncInvocation inv : asyncInvs) {
            if (!inv.exceptionOccurred()) continue;
            ConcurrentIndexUpdateWithoutWLDUnitTest.fail("Random region operation failed on VM_" + inv.getId(), inv.getException());
        }
        vm0.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.rindexName));
        vm1.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.rindexName));
        vm2.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.rindexName));
        vm3.invoke(this.getCacheSerializableRunnableForIndexValidation(regionName, this.rindexName));
    }

    public class IndexValidator {
        private boolean isValidationInProgress;

        public void validate(Region region) {
            Collection indexes = ((LocalRegion)region).getIndexManager().getIndexes();
            for (Index index : indexes) {
                if (region instanceof PartitionedRegion) {
                    this.validateOnPR((PartitionedRegion)region, (PartitionedIndex)index);
                    continue;
                }
                this.validate(region, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validate(Region region, Index index) {
            Object value2;
            String indexExpr = index.getIndexedExpression();
            int expectedIndexSize = 0;
            int expectedNullEntries = 0;
            int expectedUndefinedEntries = 0;
            if (indexExpr.indexOf(".") != -1) {
                indexExpr = indexExpr.substring(indexExpr.indexOf(".") + 1);
            }
            Collection entries = ((LocalRegion)region).entries.regionEntries();
            for (RegionEntry internalEntry : entries) {
                value2 = internalEntry.getValueInVM((RegionEntryContext)((LocalRegion)region));
                if (value2 instanceof CachedDeserializable) {
                    value2 = ((CachedDeserializable)value2).getDeserializedValue(region, internalEntry);
                }
                if (indexExpr.equals("ID")) {
                    if (!(index instanceof CompactRangeIndex)) continue;
                    if (value2 != Token.INVALID && value2 != Token.TOMBSTONE) {
                        Integer ID = ((Portfolio)value2).getID();
                        TestCase.assertTrue((String)("Did not find index key for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value2 + " ] in index: " + index.getName()), (((CompactRangeIndex)index).getIndexStorage().get((Object)ID) != null ? 1 : 0) != 0);
                        try (CloseableIterator valuesForKeyIterator = null;){
                            valuesForKeyIterator = ((CompactRangeIndex)index).getIndexStorage().get((Object)ID);
                            while (valuesForKeyIterator.hasNext()) {
                                TestCase.assertTrue((String)("Did not find index value for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value2 + " ] in index: " + index.getName() + " For index key: " + ID), (((MemoryIndexStore.MemoryIndexStoreEntry)valuesForKeyIterator.next()).getRegionEntry() == internalEntry ? 1 : 0) != 0);
                            }
                        }
                        if (ID != IndexManager.NULL) {
                            ++expectedIndexSize;
                            continue;
                        }
                        ++expectedNullEntries;
                        continue;
                    }
                    ++expectedUndefinedEntries;
                    continue;
                }
                if (!indexExpr.equals("secId") || !(index instanceof RangeIndex) || value2 == Token.INVALID || value2 == Token.TOMBSTONE) continue;
                Collection positions = ((Portfolio)value2).positions.values();
                for (Position pos : positions) {
                    if (pos != null) {
                        String secId = pos.secId;
                        TestCase.assertTrue((String)("Did not find index key for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value2 + " ] in index: " + index.getName()), (boolean)((RangeIndex)index).valueToEntriesMap.containsKey(secId));
                        Object valuesForKey = ((RangeIndex)index).valueToEntriesMap.get(secId);
                        if (!(valuesForKey instanceof AbstractIndex.RegionEntryToValuesMap)) {
                            TestCase.assertTrue((String)("Did not find index value for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value2 + " ] in index: " + index.getName() + " For index key: " + secId), ((RegionEntry)valuesForKey == internalEntry ? 1 : 0) != 0);
                        } else {
                            TestCase.assertTrue((String)("Did not find index value for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value2 + " ] in index: " + index.getName() + " For index key: " + secId), (boolean)((AbstractIndex.RegionEntryToValuesMap)valuesForKey).containsEntry(internalEntry));
                        }
                        if (secId != null) {
                            ++expectedIndexSize;
                            continue;
                        }
                        ++expectedNullEntries;
                        continue;
                    }
                    ++expectedUndefinedEntries;
                }
            }
            int actualSize = 0;
            if (index instanceof CompactRangeIndex) {
                try (Object iter = null;){
                    iter = ((CompactRangeIndex)index).getIndexStorage().iterator(null);
                    while (iter.hasNext()) {
                        value2 = iter.next();
                        ++actualSize;
                    }
                }
            }
            if (index instanceof RangeIndex) {
                for (Object value2 : ((RangeIndex)index).valueToEntriesMap.values()) {
                    if (value2 instanceof RegionEntry) {
                        ++actualSize;
                        continue;
                    }
                    actualSize += ((AbstractIndex.RegionEntryToValuesMap)value2).getNumValues();
                }
            }
            IndexStatistics stats = index.getStatistics();
            if (index instanceof CompactRangeIndex) {
                DistributedTestCase.getLogWriter().info(" Actual Size of Index is: " + actualSize);
                DistributedTestCase.getLogWriter().info(" Expected Size of Index is: " + expectedIndexSize + " Undefined size is: " + expectedUndefinedEntries + " And NULL size is: " + expectedNullEntries);
                TestCase.assertEquals((String)("No of index keys NOT equals the no shown in statistics for index:" + index.getName()), (long)((CompactRangeIndex)index).getIndexStorage().size(), (long)stats.getNumberOfKeys());
            } else {
                DistributedTestCase.getLogWriter().info(" Actual Size of Index is: " + actualSize + " Undefined size is: " + ((RangeIndex)index).undefinedMappedEntries.getNumEntries() + " And NULL size is: " + ((RangeIndex)index).nullMappedEntries.getNumEntries());
                for (Object obj : ((RangeIndex)index).undefinedMappedEntries.map.keySet()) {
                    DistributedTestCase.getLogWriter().info(((RegionEntry)obj).getKey() + "");
                }
                DistributedTestCase.getLogWriter().info(" Expected Size of Index is: " + expectedIndexSize + " Undefined size is: " + expectedUndefinedEntries + " And NULL size is: " + expectedNullEntries);
                TestCase.assertEquals((String)("No of index keys NOT equals the no shown in statistics for index:" + index.getName()), (long)((RangeIndex)index).valueToEntriesMap.keySet().size(), (long)stats.getNumberOfKeys());
            }
            TestCase.assertEquals((String)("No of index entries NOT equal the No of RegionEntries Basec on statistics for index:" + index.getName()), (long)(expectedIndexSize + expectedNullEntries), (long)stats.getNumberOfValues());
            TestCase.assertEquals((String)("No of index entries NOT equals the No of RegionEntries for index:" + index.getName()), (int)expectedIndexSize, (int)actualSize);
            GemFireCacheImpl.getInstance().getLogger().fine("Finishing the validation for region: " + region.getFullPath() + " and Index: " + index.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateOnPR(PartitionedRegion pr, PartitionedIndex ind) {
            String indexExpr = ind.getIndexedExpression();
            int expectedIndexSize = 0;
            int expectedNullEntries = 0;
            int expectedUndefinedEntries = 0;
            if (indexExpr.indexOf(".") != -1) {
                indexExpr = indexExpr.substring(indexExpr.indexOf(".") + 1);
            }
            int actualValueSize = 0;
            int actualKeySize = 0;
            for (Object idx : ind.getBucketIndexes()) {
                Index index = (Index)idx;
                TestCase.assertTrue((String)("Bucket stats are different than PR stats for bucket: " + index.getRegion()), (index.getStatistics() == ind.getStatistics() ? 1 : 0) != 0);
                Region region = index.getRegion();
                Collection entries = ((LocalRegion)region).entries.regionEntries();
                for (RegionEntry internalEntry : entries) {
                    Object value = internalEntry.getValueInVM((RegionEntryContext)((LocalRegion)region));
                    if (value instanceof CachedDeserializable) {
                        value = ((CachedDeserializable)value).getDeserializedValue(region, internalEntry);
                    }
                    if (indexExpr.equals("ID")) {
                        if (!(index instanceof CompactRangeIndex)) continue;
                        if (value != Token.INVALID && value != Token.TOMBSTONE) {
                            Integer ID = ((Portfolio)value).getID();
                            TestCase.assertTrue((String)("Did not find index key for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value + " ] in index: " + index.getName()), (((CompactRangeIndex)index).getIndexStorage().get((Object)ID) != null ? 1 : 0) != 0);
                            try (CloseableIterator valuesForKeyIterator = null;){
                                valuesForKeyIterator = ((CompactRangeIndex)index).getIndexStorage().get((Object)ID);
                                while (valuesForKeyIterator.hasNext()) {
                                    TestCase.assertTrue((String)("Did not find index value for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value + " ] in index: " + index.getName() + " For index key: " + ID), (((MemoryIndexStore.MemoryIndexStoreEntry)valuesForKeyIterator.next()).getRegionEntry() == internalEntry ? 1 : 0) != 0);
                                }
                            }
                            if (ID != IndexManager.NULL) {
                                ++expectedIndexSize;
                                continue;
                            }
                            ++expectedNullEntries;
                            continue;
                        }
                        ++expectedUndefinedEntries;
                        continue;
                    }
                    if (!indexExpr.equals("secId") || !(index instanceof RangeIndex) || value == Token.INVALID || value == Token.TOMBSTONE) continue;
                    Collection positions = ((Portfolio)value).positions.values();
                    for (Position pos : positions) {
                        if (pos != null) {
                            String secId = pos.secId;
                            TestCase.assertTrue((String)("Did not find index key for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value + " ] in index: " + index.getName()), (boolean)((RangeIndex)index).valueToEntriesMap.containsKey(secId));
                            Object valuesForKey = ((RangeIndex)index).valueToEntriesMap.get(secId);
                            if (!(valuesForKey instanceof AbstractIndex.RegionEntryToValuesMap)) {
                                TestCase.assertTrue((String)("Did not find index value for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value + " ] in index: " + index.getName() + " For index key: " + secId), ((RegionEntry)valuesForKey == internalEntry ? 1 : 0) != 0);
                            } else {
                                TestCase.assertTrue((String)("Did not find index value for REgionEntry [key: " + internalEntry.getKey() + " , value: " + value + " ] in index: " + index.getName() + " For index key: " + secId), (boolean)((AbstractIndex.RegionEntryToValuesMap)valuesForKey).containsEntry(internalEntry));
                            }
                            if (secId != null) {
                                ++expectedIndexSize;
                                continue;
                            }
                            ++expectedNullEntries;
                            continue;
                        }
                        ++expectedUndefinedEntries;
                    }
                }
                if (index instanceof CompactRangeIndex) {
                    try (CloseableIterator iter = null;){
                        iter = ((CompactRangeIndex)index).getIndexStorage().iterator(null);
                        while (iter.hasNext()) {
                            DistributedTestCase.getLogWriter().info("Index Values : " + ((IndexStore.IndexStoreEntry)iter.next()).getDeserializedValue());
                            ++actualValueSize;
                        }
                    }
                }
                if (index instanceof RangeIndex) {
                    for (Object value : ((RangeIndex)index).valueToEntriesMap.values()) {
                        if (value instanceof RegionEntry) {
                            ++actualValueSize;
                            continue;
                        }
                        actualValueSize += ((AbstractIndex.RegionEntryToValuesMap)value).getNumValues();
                    }
                }
                if (index instanceof CompactRangeIndex) {
                    actualKeySize += ((CompactRangeIndex)index).getIndexStorage().size();
                    continue;
                }
                actualKeySize += ((RangeIndex)index).valueToEntriesMap.keySet().size();
            }
            TestCase.assertEquals((String)("No of index entries NOT equals the No of RegionENtries NOT based on stats for index:" + ind.getName()), (int)expectedIndexSize, (int)actualValueSize);
            IndexStatistics stats = ind.getStatistics();
            TestCase.assertEquals((String)("No of index entries NOT equals the No of RegionENtries based on statistics for index:" + ind.getName()), (long)(expectedIndexSize + expectedNullEntries), (long)stats.getNumberOfValues());
            GemFireCacheImpl.getInstance().getLogger().fine("Finishing the validation for region: " + pr.getFullPath() + " and Index: " + ind.getName());
        }
    }
}

