/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryUsingPoolDUnitTest;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class CqResultSetUsingPoolDUnitTest
extends CacheTestCase {
    protected CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("CqResultSetUsingPoolDUnitTest");
    private final String selStr = "SELECT * FROM /root/regionA";
    public final String[] condition = new String[]{" p WHERE p.ID > 3", " p WHERE p.ID < 3", "   WHERE   ID = 3", " p WHERE p.ID >= 3", " p WHERE p.ID <= 3", " p WHERE p.ID > 3 AND p.status = 'active'", "   WHERE   status = 'active' AND ID < 3", " p WHERE p.names[0] = 'aaa'", " p WHERE p.status LIKE 'active'", " p WHERE p.collectionHolderMap.get('1').arr[0] = '0'", " p WHERE p.position1.portfolioId > 3", " p where p.position3[1].portfolioId = 2", " p where NOT(SELECT DISTINCT * FROM positions.values pos  WHERE pos.secId in SET('YHOO', 'SUN', 'IBM', 'YHOO', 'GOOG',  'MSFT', 'AOL', 'APPL', 'ORCL', 'SAP', 'DELL', 'RHAT', 'NOVL', 'HP')).isEmpty", " p WHERE p.ID != 3 AND p.ID !=4", " p WHERE (p.ID = 2 OR p.ID = 4) AND p.status = 'active'"};
    public final int[] resultSize = new int[]{2, 2, 1, 3, 3, 1, 1, 5, 2, 5, 2, 5, 5, 3, 2};
    public final String[][] expectedKeys = new String[][]{{"key-4", "key-5"}, {"key-1", "key-2"}, {"key-3"}, {"key-3", "key-4", "key-5"}, {"key-1", "key-2", "key-3"}, {"key-4"}, {"key-2"}, {"key-1", "key-2", "key-3", "key-4", "key-5"}, {"key-2", "key-4"}, {"key-1", "key-2", "key-3", "key-4", "key-5"}, {"key-4", "key-5"}, {"key-1", "key-2", "key-3", "key-4", "key-5"}, {"key-1", "key-2", "key-3", "key-4", "key-5"}, {"key-1", "key-2", "key-5"}, {"key-2", "key-4"}};
    public final String[] condition2 = new String[]{" p1, /root/regionB p2 WHERE p1.status = p2.status", " p, p.positions.values p1 WHERE p1.secId = 'IBM'", " p, p.positions.values AS pos WHERE pos.secId != '1'", " p WHERE p.ID in (SELECT p1.ID FROM /root/regionA p1 WHERE p1.ID > 3)", ".entries entry WHERE entry.key = '1'", ".entries entry WHERE entry.value.ID > '3'", ".values p WHERE p.ID > '3' and p.status = 'active'", " p, p.position3 pos where pos.portfolioId  = 1"};

    public CqResultSetUsingPoolDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqResultSetUsingPoolDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqResultSetUsingPoolDUnitTest.this.getSystem();
            }
        });
    }

    public void testCqResults() throws Exception {
        int queryCnt;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCqResults";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createValues(server, "regionA", 5);
        String cqQuery = "";
        for (queryCnt = 0; queryCnt < this.condition.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition[queryCnt];
            this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_" + queryCnt, cqQuery);
            this.cqDUnitTest.executeCQ(client, "testCqResultsP_" + queryCnt, true, this.resultSize[queryCnt], this.expectedKeys[queryCnt], null);
        }
        for (queryCnt = 0; queryCnt < this.condition2.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition2[queryCnt];
            try {
                this.cqDUnitTest.createCQ(client, poolName, "testCqResultsF_" + queryCnt, cqQuery);
                CqResultSetUsingPoolDUnitTest.fail((String)("UnSupported CQ Query, Expected to fail.  CQ :testCqResultsF_" + queryCnt + " Query : " + cqQuery));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCqResultsWithCompactRangeIndex() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCqResults";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createFunctionalIndex(server, "IdIndex", "p.ID", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server, "statusIndex", "p.status", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server, "portfolioIdIndex", "p.position1.portfolioId", "/root/regionA p");
        this.cqDUnitTest.createValues(server, "regionA", 5);
        String cqQuery = "";
        for (int queryCnt = 0; queryCnt < this.condition.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition[queryCnt];
            this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_" + queryCnt, cqQuery);
            this.cqDUnitTest.executeCQ(client, "testCqResultsP_" + queryCnt, true, this.resultSize[queryCnt], this.expectedKeys[queryCnt], null);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCqResultsWithRangeIndex() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCqResults";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        server.invoke(new CacheSerializableRunnable("Set RangeIndex Falg"){

            @Override
            public void run2() throws CacheException {
                IndexManager.TEST_RANGEINDEX_ONLY = true;
            }
        });
        this.cqDUnitTest.createFunctionalIndex(server, "IdIndex", "p.ID", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server, "statusIndex", "p.status", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server, "portfolioIdIndex", "p.position1.portfolioId", "/root/regionA p");
        this.cqDUnitTest.createValues(server, "regionA", 5);
        String cqQuery = "";
        for (int queryCnt = 0; queryCnt < this.condition.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition[queryCnt];
            this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_" + queryCnt, cqQuery);
            this.cqDUnitTest.executeCQ(client, "testCqResultsP_" + queryCnt, true, this.resultSize[queryCnt], this.expectedKeys[queryCnt], null);
        }
        server.invoke(new CacheSerializableRunnable("Set RangeIndex Falg"){

            @Override
            public void run2() throws CacheException {
                IndexManager.TEST_RANGEINDEX_ONLY = false;
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCqResultsOnPR() throws Exception {
        int queryCnt;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServerWithPR(server1, 0, false, 0);
        this.cqDUnitTest.createServerWithPR(server2, 0, false, 0);
        int port = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCqResults";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createValues(server1, "regionA", 5);
        String cqQuery = "";
        for (queryCnt = 0; queryCnt < this.condition.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition[queryCnt];
            this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_" + queryCnt, cqQuery);
            this.cqDUnitTest.executeCQ(client, "testCqResultsP_" + queryCnt, true, this.resultSize[queryCnt], this.expectedKeys[queryCnt], null);
        }
        for (queryCnt = 0; queryCnt < this.condition2.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition2[queryCnt];
            try {
                this.cqDUnitTest.createCQ(client, poolName, "testCqResultsF_" + queryCnt, cqQuery);
                CqResultSetUsingPoolDUnitTest.fail((String)("UnSupported CQ Query, Expected to fail.  CQ :testCqResultsF_" + queryCnt + " Query : " + cqQuery));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCqResultsWithCompactRangeIndexOnPR() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServerWithPR(server1, 0, false, 0);
        this.cqDUnitTest.createServerWithPR(server2, 0, false, 0);
        int port = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCqResults";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createFunctionalIndex(server1, "IdIndex", "p.ID", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server1, "statusIndex", "p.status", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server1, "portfolioIdIndex", "p.position1.portfolioId", "/root/regionA p");
        this.cqDUnitTest.createValues(server1, "regionA", 5);
        String cqQuery = "";
        for (int queryCnt = 0; queryCnt < this.condition.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition[queryCnt];
            this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_" + queryCnt, cqQuery);
            this.cqDUnitTest.executeCQ(client, "testCqResultsP_" + queryCnt, true, this.resultSize[queryCnt], this.expectedKeys[queryCnt], null);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCqResultsWithRangeIndexOnPR() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServerWithPR(server1, 0, false, 0);
        this.cqDUnitTest.createServerWithPR(server2, 0, false, 0);
        int port = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCqResults";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        server1.invoke(new CacheSerializableRunnable("Set RangeIndex Falg"){

            @Override
            public void run2() throws CacheException {
                IndexManager.TEST_RANGEINDEX_ONLY = true;
            }
        });
        server2.invoke(new CacheSerializableRunnable("Set RangeIndex Falg"){

            @Override
            public void run2() throws CacheException {
                IndexManager.TEST_RANGEINDEX_ONLY = true;
            }
        });
        this.cqDUnitTest.createFunctionalIndex(server1, "IdIndex", "p.ID", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server1, "statusIndex", "p.status", "/root/regionA p");
        this.cqDUnitTest.createFunctionalIndex(server1, "portfolioIdIndex", "p.position1.portfolioId", "/root/regionA p");
        this.cqDUnitTest.createValues(server1, "regionA", 5);
        String cqQuery = "";
        for (int queryCnt = 0; queryCnt < this.condition.length; ++queryCnt) {
            cqQuery = "SELECT * FROM /root/regionA" + this.condition[queryCnt];
            this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_" + queryCnt, cqQuery);
            this.cqDUnitTest.executeCQ(client, "testCqResultsP_" + queryCnt, true, this.resultSize[queryCnt], this.expectedKeys[queryCnt], null);
        }
        server1.invoke(new CacheSerializableRunnable("Set RangeIndex Falg"){

            @Override
            public void run2() throws CacheException {
                IndexManager.TEST_RANGEINDEX_ONLY = false;
            }
        });
        server2.invoke(new CacheSerializableRunnable("Set RangeIndex Falg"){

            @Override
            public void run2() throws CacheException {
                IndexManager.TEST_RANGEINDEX_ONLY = false;
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCqResultsCaching() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCqResults";
        String cqName = "testCqResultsP_0";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_0", this.cqDUnitTest.cqs[0]);
        int numObjects = 300;
        int totalObjects = 500;
        server.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 300; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Portfolio p;
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i < 500; ++i) {
                    if (i > 25 && i < 201) {
                        region.destroy((Object)("" + i));
                        continue;
                    }
                    p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
                for (int j = 26; j < 201; ++j) {
                    p = new Portfolio(j);
                    region.put((Object)("" + j), (Object)p);
                }
                Portfolio p2 = new Portfolio(500);
                region.put((Object)"500", (Object)p2);
            }
        });
        this.cqDUnitTest.executeCQ(client, "testCqResultsP_0", true, null);
        server.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                while (region.get((Object)"500") == null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    if (!cqQuery.getName().equals("testCqResultsP_0")) continue;
                    int size = cqQuery.getCqResultKeysSize();
                    if (size != 500) {
                        DistributedTestCase.getLogWriter().info("The number of Cached events " + size + " is not equal to the expected size " + 500);
                        HashSet<String> expectedKeys = new HashSet<String>();
                        for (int i = 1; i < 500; ++i) {
                            expectedKeys.add("" + i);
                        }
                        Set cachedKeys = cqQuery.getCqResultKeyCache();
                        expectedKeys.removeAll(cachedKeys);
                        DistributedTestCase.getLogWriter().info("Missing keys from the Cache : " + expectedKeys);
                    }
                    TestCase.assertEquals((String)"The number of keys cached for cq testCqResultsP_0 is wrong.", (int)500, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCqResultsCachingForMultipleCQs() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCqResults";
        String cqName1 = "testCqResultsP_0";
        String cqName2 = "testCqResultsP_1";
        this.cqDUnitTest.createPool(client1, poolName, host0, port);
        this.cqDUnitTest.createPool(client2, poolName, host0, port);
        this.cqDUnitTest.createClient(client1, port, host0);
        this.cqDUnitTest.createClient(client2, port, host0);
        this.cqDUnitTest.createCQ(client1, poolName, "testCqResultsP_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.createCQ(client2, poolName, "testCqResultsP_1", this.cqDUnitTest.cqs[0]);
        int numObjects = 300;
        int totalObjects = 500;
        server.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 300; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Portfolio p;
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i < 500; ++i) {
                    if (i > 25 && i < 201) {
                        region.destroy((Object)("" + i));
                        continue;
                    }
                    p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
                for (int j = 26; j < 201; ++j) {
                    p = new Portfolio(j);
                    region.put((Object)("" + j), (Object)p);
                }
                Portfolio p2 = new Portfolio(500);
                region.put((Object)"500", (Object)p2);
            }
        });
        this.cqDUnitTest.executeCQ(client1, "testCqResultsP_0", true, null);
        this.cqDUnitTest.executeCQ(client2, "testCqResultsP_1", true, null);
        server.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                while (region.get((Object)"500") == null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    int size = cqQuery.getCqResultKeysSize();
                    if (size != 500) {
                        DistributedTestCase.getLogWriter().info("The number of Cached events " + size + " is not equal to the expected size " + 500);
                        HashSet<String> expectedKeys = new HashSet<String>();
                        for (int i = 1; i < 500; ++i) {
                            expectedKeys.add("" + i);
                        }
                        Set cachedKeys = cqQuery.getCqResultKeyCache();
                        expectedKeys.removeAll(cachedKeys);
                        DistributedTestCase.getLogWriter().info("Missing keys from the Cache : " + expectedKeys);
                    }
                    TestCase.assertEquals((String)("The number of keys cached for cq " + cqQuery.getName() + " is wrong."), (int)500, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.closeClient(client1);
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCqResultsCachingForPR() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServerWithPR(server1, 0, false, 0);
        this.cqDUnitTest.createServerWithPR(server2, 0, false, 0);
        int port = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCqResults";
        String cqName = "testCqResultsP_0";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, poolName, "testCqResultsP_0", this.cqDUnitTest.cqs[0]);
        int numObjects = 300;
        int totalObjects = 500;
        server1.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 300; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server2.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Portfolio p;
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i < 500; ++i) {
                    if (i > 25 && i < 201) {
                        region.destroy((Object)("" + i));
                        continue;
                    }
                    p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
                for (int j = 26; j < 201; ++j) {
                    p = new Portfolio(j);
                    region.put((Object)("" + j), (Object)p);
                }
                Portfolio p2 = new Portfolio(500);
                region.put((Object)"500", (Object)p2);
            }
        });
        this.cqDUnitTest.executeCQ(client, "testCqResultsP_0", true, null);
        server1.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                while (region.get((Object)"500") == null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    if (cqQuery.getCqResultKeysSize() > 0) continue;
                    TestCase.fail((String)"The Result Cache for CQ on PR is not working. CQ :testCqResultsP_0");
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCqResultsCachingForDestroyEventsOnPR() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServerWithPR(server1, 0, false, 0);
        this.cqDUnitTest.createServerWithPR(server2, 0, false, 0);
        int port = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCqResults";
        String cqName = "testCqResultsCachingForDestroyEventsOnPR_0";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, poolName, "testCqResultsCachingForDestroyEventsOnPR_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testCqResultsCachingForDestroyEventsOnPR_0", true, null);
        int numObjects = 50;
        server1.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 50; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 50; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 50; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.destroy((Object)("" + i));
                }
            }
        });
        this.cqDUnitTest.waitForDestroyed(client, "testCqResultsCachingForDestroyEventsOnPR_0", "50");
        server1.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    if (cqQuery.getCqResultKeysSize() <= 0) continue;
                    TestCase.fail((String)("The CQ Result Cache on PR should have been empty for CQ :testCqResultsCachingForDestroyEventsOnPR_0 keys=" + cqQuery.getCqResultKeyCache()));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    if (cqQuery.getCqResultKeysSize() <= 0) continue;
                    TestCase.fail((String)"The CQ Result Cache on PR should have been empty for CQ :testCqResultsCachingForDestroyEventsOnPR_0");
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCqResultsCachingWithFailOver() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServer(server1);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqResultSetUsingPoolDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        String poolName = "testCQFailOver";
        String cqName = "testCQFailOver_0";
        this.cqDUnitTest.createPool(client, poolName, new String[]{host0, host0}, new int[]{port1, ports[0]});
        this.cqDUnitTest.createCQ(client, poolName, "testCQFailOver_0", this.cqDUnitTest.cqs[0]);
        int numObjects = 300;
        int totalObjects = 500;
        server1.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 300; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server1.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Portfolio p;
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i < 500; ++i) {
                    if (i > 25 && i < 201) {
                        region.destroy((Object)("" + i));
                        continue;
                    }
                    p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
                for (int j = 26; j < 201; ++j) {
                    p = new Portfolio(j);
                    region.put((Object)("" + j), (Object)p);
                }
                Portfolio p2 = new Portfolio(500);
                region.put((Object)"500", (Object)p2);
            }
        });
        this.cqDUnitTest.executeCQ(client, "testCQFailOver_0", true, null);
        server1.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                while (region.get((Object)"500") == null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    if (!cqQuery.getName().equals("testCQFailOver_0")) continue;
                    int size = cqQuery.getCqResultKeysSize();
                    if (size != 500) {
                        DistributedTestCase.getLogWriter().info("The number of Cached events " + size + " is not equal to the expected size " + 500);
                        HashSet<String> expectedKeys = new HashSet<String>();
                        for (int i = 1; i < 500; ++i) {
                            expectedKeys.add("" + i);
                        }
                        Set cachedKeys = cqQuery.getCqResultKeyCache();
                        expectedKeys.removeAll(cachedKeys);
                        DistributedTestCase.getLogWriter().info("Missing keys from the Cache : " + expectedKeys);
                    }
                    TestCase.assertEquals((String)"The number of keys cached for cq testCQFailOver_0 is wrong.", (int)500, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        System.out.println("### Port on which server1 running : " + port1 + " Server2 running : " + thePort2);
        CqResultSetUsingPoolDUnitTest.pause(3000);
        this.cqDUnitTest.closeServer(server1);
        CqResultSetUsingPoolDUnitTest.pause(3000);
        server2.invoke(new CacheSerializableRunnable("Verify CQ Cache results"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqResultSetUsingPoolDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                Region region = CqResultSetUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqResultSetUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                while (region.get((Object)"500") == null) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    if (!cqQuery.getName().equals("testCQFailOver_0")) continue;
                    int size = cqQuery.getCqResultKeysSize();
                    if (size != 500) {
                        DistributedTestCase.getLogWriter().info("The number of Cached events " + size + " is not equal to the expected size " + 500);
                        HashSet<String> expectedKeys = new HashSet<String>();
                        for (int i = 1; i < 500; ++i) {
                            expectedKeys.add("" + i);
                        }
                        Set cachedKeys = cqQuery.getCqResultKeyCache();
                        expectedKeys.removeAll(cachedKeys);
                        DistributedTestCase.getLogWriter().info("Missing keys from the Cache : " + expectedKeys);
                    }
                    TestCase.assertEquals((String)"The number of keys cached for cq testCQFailOver_0 is wrong.", (int)500, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server2);
    }
}

