/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryUsingPoolDUnitTest;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import util.TestException;

public class CqDataUsingPoolDUnitTest
extends CacheTestCase {
    protected CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("CqDataUsingPoolDUnitTest");

    public CqDataUsingPoolDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqDataUsingPoolDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqDataUsingPoolDUnitTest.this.getSystem();
            }
        });
    }

    public void testClientWithFeederAndCQ() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testClientWithFeederAndCQ";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, poolName, "testClientWithFeederAndCQ_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testClientWithFeederAndCQ_0", false, null);
        int size = 10;
        this.cqDUnitTest.createValues(client, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.waitForCreated(client, "testClientWithFeederAndCQ_0", "key-10");
        this.cqDUnitTest.validateCQ(client, "testClientWithFeederAndCQ_0", CqQueryUsingPoolDUnitTest.noTest, 10, 0, 0, 10, 0, 0, 10);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQHAWithState() throws Exception {
        int i;
        int i2;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client = host.getVM(3);
        this.cqDUnitTest.createServer(server1);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        this.cqDUnitTest.createServer(server2, ports[0]);
        int port2 = server2.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String poolName = "testCQHAWithState";
        this.cqDUnitTest.createPool(client, poolName, new String[]{host0, host0, host0}, new int[]{port1, port2, ports[1]}, "1");
        int numCQs = 1;
        for (int i3 = 0; i3 < numCQs; ++i3) {
            this.cqDUnitTest.createCQ(client, poolName, "testCQHAWithState_" + i3, this.cqDUnitTest.cqs[i3]);
            this.cqDUnitTest.executeCQ(client, "testCQHAWithState_" + i3, false, null);
        }
        CqDataUsingPoolDUnitTest.pause(1000);
        int size = 10;
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[1], size);
        for (int i4 = 1; i4 <= size; ++i4) {
            this.cqDUnitTest.waitForCreated(client, "testCQHAWithState_0", "key-" + i4);
        }
        int[] resultsCnt = new int[]{10, 1, 2};
        for (i2 = 0; i2 < numCQs; ++i2) {
            this.cqDUnitTest.validateCQ(client, "testCQHAWithState_" + i2, CqQueryUsingPoolDUnitTest.noTest, resultsCnt[i2], 0, 0);
        }
        this.cqDUnitTest.closeServer(server1);
        CqDataUsingPoolDUnitTest.pause(3000);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], 10);
        for (i2 = 1; i2 <= size; ++i2) {
            this.cqDUnitTest.waitForUpdated(client, "testCQHAWithState_0", "key-" + size);
        }
        for (i2 = 0; i2 < numCQs; ++i2) {
            this.cqDUnitTest.validateCQ(client, "testCQHAWithState_" + i2, CqQueryUsingPoolDUnitTest.noTest, resultsCnt[i2], resultsCnt[i2], CqQueryUsingPoolDUnitTest.noTest);
        }
        this.cqDUnitTest.stopCQ(client, "testCQHAWithState_0");
        CqDataUsingPoolDUnitTest.pause(2000);
        this.cqDUnitTest.createServer(server3, ports[1]);
        server3.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        CqDataUsingPoolDUnitTest.pause(2000);
        this.cqDUnitTest.clearCQListenerEvents(client, "testCQHAWithState_0");
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], 10);
        try {
            this.cqDUnitTest.waitForUpdated(client, "testCQHAWithState_0", "key-1");
            CqDataUsingPoolDUnitTest.fail((String)"Events not expected since CQ is in stop state.");
        }
        catch (Exception i5) {
            // empty catch block
        }
        this.cqDUnitTest.executeCQ(client, "testCQHAWithState_0", false, null);
        this.cqDUnitTest.createValues(server3, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server3, this.cqDUnitTest.regions[1], 10);
        for (i = 1; i <= size; ++i) {
            this.cqDUnitTest.waitForUpdated(client, "testCQHAWithState_0", "key-" + size);
        }
        for (i = 0; i < numCQs; ++i) {
            this.cqDUnitTest.validateCQ(client, "testCQHAWithState_" + i, CqQueryUsingPoolDUnitTest.noTest, resultsCnt[i], resultsCnt[i] * 2, CqQueryUsingPoolDUnitTest.noTest);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server2);
        this.cqDUnitTest.closeServer(server3);
    }

    public void testCQWithDestroysAndInvalidates() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM producer = host.getVM(2);
        this.cqDUnitTest.createServer(server, 0, true);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQWithDestroysAndInvalidates";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createClient(producer, port, host0);
        int size = 10;
        String name = "testQuery_4";
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createCQ(client, poolName, "testQuery_4", this.cqDUnitTest.cqs[4]);
        this.cqDUnitTest.executeCQ(client, "testQuery_4", true, null);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region1.destroy((Object)("key-" + i));
                }
            }
        });
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForDestroyed(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 5);
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForCreated(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region1.invalidate((Object)("key-" + i));
                }
            }
        });
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForInvalidated(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQWithMultipleClients() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        VM client3 = host.getVM(3);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName1 = "testCQWithMultipleClients1";
        String poolName2 = "testCQWithMultipleClients2";
        this.cqDUnitTest.createPool(client1, poolName1, host0, port);
        this.cqDUnitTest.createPool(client2, poolName2, host0, port);
        this.cqDUnitTest.createCQ(client1, poolName1, "testCQWithMultipleClients_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client1, "testCQWithMultipleClients_0", false, null);
        this.cqDUnitTest.createCQ(client2, poolName2, "testCQWithMultipleClients_0", this.cqDUnitTest.cqs[1]);
        this.cqDUnitTest.executeCQ(client2, "testCQWithMultipleClients_0", false, null);
        int size = 10;
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForCreated(client1, "testCQWithMultipleClients_0", "key-10");
        this.cqDUnitTest.validateCQ(client1, "testCQWithMultipleClients_0", CqQueryUsingPoolDUnitTest.noTest, size, 0, 0, size, 0, 0, size);
        this.cqDUnitTest.waitForCreated(client2, "testCQWithMultipleClients_0", "key-2");
        this.cqDUnitTest.validateCQ(client2, "testCQWithMultipleClients_0", CqQueryUsingPoolDUnitTest.noTest, 1, 0, 0, 1, 0, 0, 1);
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeClient(client3);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQWithLoad() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        this.cqDUnitTest.createServer(server2, 0, false, MirrorType.KEYS);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCQWithLoad";
        this.cqDUnitTest.createPool(client, poolName, host0, port1);
        this.cqDUnitTest.createCQ(client, poolName, "testCQWithLoad_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testCQWithLoad_0", false, null);
        CqDataUsingPoolDUnitTest.pause(1000);
        int size = 10;
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        server1.invoke(new CacheSerializableRunnable("Load from second server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.get((Object)("key-" + i));
                }
            }
        });
        for (int i = 1; i <= 10; ++i) {
            this.cqDUnitTest.waitForCreated(client, "testCQWithLoad_0", "key-" + i);
        }
        this.cqDUnitTest.validateCQ(client, "testCQWithLoad_0", CqQueryUsingPoolDUnitTest.noTest, 10, 0, 0);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCQWithEviction() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        int evictionThreshold = 5;
        server1.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setMirrorType(MirrorType.NONE);
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)5));
                for (int i = 0; i < CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions.length; ++i) {
                    Region region = CqDataUsingPoolDUnitTest.this.createRegion(CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[i], factory.createRegionAttributes());
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                DistributedTestCase.pause(2000);
                try {
                    CqDataUsingPoolDUnitTest.this.cqDUnitTest.startBridgeServer(0, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(2000);
            }
        });
        this.cqDUnitTest.createServer(server2, 0, false, MirrorType.NONE);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCQWithEviction";
        this.cqDUnitTest.createPool(client, poolName, host0, port1);
        this.cqDUnitTest.createCQ(client, poolName, "testCQWithEviction_0", this.cqDUnitTest.cqs[0]);
        try {
            this.cqDUnitTest.executeCQ(client, "testCQWithEviction_0", false, "CqException");
            CqDataUsingPoolDUnitTest.fail((String)"Should have thrown exception, cq not supported on Non-replicated region.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CqDataUsingPoolDUnitTest.pause(1000);
        int size = 10;
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        server1.invoke(new CacheSerializableRunnable("Load from second server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.get((Object)("key-" + i));
                }
            }
        });
        CqDataUsingPoolDUnitTest.pause(2000);
        server1.invoke(new CacheSerializableRunnable("validate destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = CqDataUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                int keyCnt = 5;
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the expected size", (int)keyCnt, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= keyCnt; ++i) {
                    ctl.waitForDestroyed("key-" + i);
                    TestCase.assertNull((Object)region.getEntry((Object)("key-" + i)));
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCQWithEstablishCallBackConnection() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        final int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        final String serverHost = CqDataUsingPoolDUnitTest.getServerHostName(server1.getHost());
        String poolName = "testCQWithEstablishCallBackConnection";
        client.invoke(new CacheSerializableRunnable("createPool :testCQWithEstablishCallBackConnection"){

            @Override
            public void run2() throws CacheException {
                CqDataUsingPoolDUnitTest.this.getCache();
                PoolFactory cpf = PoolManager.createFactory();
                cpf.setSubscriptionEnabled(false);
                cpf.addServer(serverHost, port1);
                cpf.create("testCQWithEstablishCallBackConnection");
            }
        });
        this.cqDUnitTest.createCQ(client, "testCQWithEstablishCallBackConnection", "testCQWithEstablishCallBackConnection_0", this.cqDUnitTest.cqs[0]);
        try {
            this.cqDUnitTest.executeCQ(client, "testCQWithEstablishCallBackConnection_0", false, "CqException");
            CqDataUsingPoolDUnitTest.fail((String)"Test should have failed with connection with establishCallBackConnection not found.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
    }

    public void testRegionEvents() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testRegionEvents";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createCQ(client, poolName, "testRegionEvents_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testRegionEvents_0", false, null);
        this.cqDUnitTest.createCQ(client, poolName, "testRegionEvents_1", this.cqDUnitTest.cqs[2]);
        this.cqDUnitTest.executeCQ(client, "testRegionEvents_1", false, null);
        server.invoke(new CacheSerializableRunnable("testRegionEvents"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Clearing the region on the server ###");
                Region region = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                region.clear();
            }
        });
        this.cqDUnitTest.waitForRegionClear(client, "testRegionEvents_0");
        server.invoke(new CacheSerializableRunnable("testRegionEvents"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Invalidate the region on the server ###");
                Region region = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                region.invalidateRegion();
            }
        });
        this.cqDUnitTest.waitForRegionInvalidate(client, "testRegionEvents_0");
        server.invoke(new CacheSerializableRunnable("testRegionEvents"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Destroying the region on the server ###");
                Region region = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[1]);
                for (int i = 1; i <= 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                region.destroyRegion();
            }
        });
        CqDataUsingPoolDUnitTest.pause(1000);
        this.cqDUnitTest.validateCQCount(client, 1);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testEventsDuringQueryExecution() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        final VM client = host.getVM(1);
        String cqName = "testEventsDuringQueryExecution_0";
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testEventsDuringQueryExecution";
        this.cqDUnitTest.createPool(client, poolName, host0, port);
        this.cqDUnitTest.createCQ(client, poolName, "testEventsDuringQueryExecution_0", this.cqDUnitTest.cqs[0]);
        int numObjects = 200;
        int totalObjects = 500;
        server.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 200; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        client.invoke(this.setTestHook());
        AsyncInvocation executeCq = client.invokeAsync(new CacheSerializableRunnable("Execute CQ AsyncInvoke"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = CqDataUsingPoolDUnitTest.this.getCache().getQueryService();
                CqQuery cq1 = cqService.getCq("testEventsDuringQueryExecution_0");
                if (cq1 == null) {
                    TestCase.fail((String)"Failed to get CQ testEventsDuringQueryExecution_0");
                }
                CqResults cqResults = null;
                try {
                    cqResults = cq1.executeWithInitialResults();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("CQ execution failed", ex);
                }
                final CqQueryImpl.TestHook testHook = CqQueryImpl.testHook;
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return testHook.numQueuedEvents() > 0;
                    }

                    @Override
                    public String description() {
                        return "No queued events found.";
                    }
                }, 3000L, 5L, true);
                CqDataUsingPoolDUnitTest.this.getCache().getLogger().fine("Queued Events Size" + testHook.numQueuedEvents());
                CqQueryTestListener cqListener = (CqQueryTestListener)cq1.getCqAttributes().getCqListener();
                cqListener.waitForCreated("500");
                int oldId = 0;
                for (Object cqEvent : cqListener.events.toArray()) {
                    int newId = new Integer(cqEvent.toString());
                    if (oldId > newId) {
                        TestCase.fail((String)"Queued events for CQ Listener during execution with Initial results is not in the order in which they are created.");
                    }
                    oldId = newId;
                }
                HashSet<Object> ids = new HashSet<Object>(cqListener.events);
                for (Object o : cqResults.asList()) {
                    Struct s = (Struct)o;
                    ids.add(s.get("key"));
                }
                HashSet<String> missingIds = new HashSet<String>();
                String key = "";
                for (int i = 1; i <= 500; ++i) {
                    key = "" + i;
                    if (ids.contains(key)) continue;
                    missingIds.add(key);
                }
                if (!missingIds.isEmpty()) {
                    TestCase.fail((String)("Missing Keys in either ResultSet or the Cq Event list.  Missing keys : [size : " + missingIds.size() + "]" + missingIds + " Ids in ResultSet and CQ Events :" + ids));
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.pause(200);
                client.invoke(new CacheSerializableRunnable("Releasing the latch"){

                    @Override
                    public void run2() throws CacheException {
                        CqQueryImpl.TestHook testHook = CqQueryImpl.testHook;
                        testHook.ready();
                    }
                });
                Region region = CqDataUsingPoolDUnitTest.this.getCache().getRegion("/root/" + CqDataUsingPoolDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 201; i <= 500; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCqStatInitializationTimingIssue() {
        String regionName = "testCqStatInitializationTimingIssue";
        String cq1Name = "testCq1";
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM client2 = host.getVM(2);
        int server1Port = (Integer)server.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{"testCqStatInitializationTimingIssue", new Boolean(true)});
        client.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client.getHost()), server1Port), "testCqStatInitializationTimingIssue"});
        client2.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client2.getHost()), server1Port), "testCqStatInitializationTimingIssue"});
        client.invokeAsync(new CacheSerializableRunnable("Register cq"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 10000; ++i) {
                    CqQuery query = CqDataUsingPoolDUnitTest.this.createCq("testCqStatInitializationTimingIssue", "testCq1");
                    if (query == null) continue;
                    try {
                        query.close();
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("exception while closing cq:" + e);
                    }
                }
            }
        });
        client2.invokeAsync(new CacheSerializableRunnable("pub updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion("testCqStatInitializationTimingIssue");
                block0: while (true) {
                    int i = 0;
                    while (true) {
                        if (i >= 50000) continue block0;
                        region.put((Object)("" + i), (Object)("" + Math.random()));
                        ++i;
                    }
                    break;
                }
            }
        });
        server.invokeAsync(new CacheSerializableRunnable("pub updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion("testCqStatInitializationTimingIssue");
                block0: while (true) {
                    int i = 0;
                    while (true) {
                        if (i >= 50000) continue block0;
                        region.put((Object)("" + i), (Object)("" + Math.random()));
                        ++i;
                    }
                    break;
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("Check Stats"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 10000; ++i) {
                    CqDataUsingPoolDUnitTest.this.checkCqStats("testCq1");
                }
            }
        });
        client.invoke(CacheServerTestUtil.class, "closeCache");
        client2.invoke(CacheServerTestUtil.class, "closeCache");
        server.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testGetDurableCQsFromPoolOnly() throws Exception {
        String regionName = "regionA";
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName1 = "pool1";
        String poolName2 = "pool2";
        this.cqDUnitTest.createPool(client1, "pool1", host0, port);
        this.cqDUnitTest.createPool(client2, "pool2", host0, port);
        client1.invoke(new CacheSerializableRunnable("Register cq for client 1"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = null;
                try {
                    queryService = PoolManager.find((String)"pool1").getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    CqAttributesFactory cqAf = new CqAttributesFactory();
                    CqAttributes attributes = cqAf.create();
                    queryService.newCq("client1DCQ1", "Select * From /root/regionA where id = 1", attributes, true).execute();
                    queryService.newCq("client1DCQ2", "Select * From /root/regionA where id = 10", attributes, true).execute();
                    queryService.newCq("client1NoDC1", "Select * From /root/regionA", attributes, false).execute();
                    queryService.newCq("client1NoDC2", "Select * From /root/regionA where id = 3", attributes, false).execute();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("Register cq for client 2"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = null;
                try {
                    queryService = PoolManager.find((String)"pool2").getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    CqAttributesFactory cqAf = new CqAttributesFactory();
                    CqAttributes attributes = cqAf.create();
                    queryService.newCq("client2DCQ1", "Select * From /root/regionA where id = 1", attributes, true).execute();
                    queryService.newCq("client2DCQ2", "Select * From /root/regionA where id = 10", attributes, true).execute();
                    queryService.newCq("client2DCQ3", "Select * From /root/regionA", attributes, true).execute();
                    queryService.newCq("client2DCQ4", "Select * From /root/regionA where id = 3", attributes, true).execute();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("test getDurableCQsFromServer for client2"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = null;
                try {
                    queryService = PoolManager.find((String)"pool2").getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)4, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client2DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ2"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ3"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ4"));
            }
        });
        client1.invoke(new CacheSerializableRunnable("test getDurableCQsFromServer for client1"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = null;
                try {
                    queryService = PoolManager.find((String)"pool1").getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)2, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client1DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client1DCQ2"));
            }
        });
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeClient(client1);
        this.cqDUnitTest.closeServer(server);
    }

    public void testGetDurableCQsFromServerWithEmptyList() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName1 = "pool1";
        this.cqDUnitTest.createPool(client1, "pool1", host0, port);
        client1.invoke(new CacheSerializableRunnable("test getDurableCQsFromServer for client1"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = null;
                try {
                    queryService = PoolManager.find((String)"pool1").getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)0, (int)list.size());
                TestCase.assertFalse((boolean)list.contains("client1DCQ1"));
                TestCase.assertFalse((boolean)list.contains("client1DCQ2"));
            }
        });
        this.cqDUnitTest.closeClient(client1);
        this.cqDUnitTest.closeServer(server);
    }

    public void testGetDurableCqsFromServer() {
        String regionName = "testGetAllDurableCqsFromServer";
        String cq1Name = "testCq1";
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        int server1Port = (Integer)server.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{"testGetAllDurableCqsFromServer", new Boolean(true)});
        client1.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client1.getHost()), server1Port), "testGetAllDurableCqsFromServer"});
        client2.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client2.getHost()), server1Port), "testGetAllDurableCqsFromServer"});
        this.createClient1CqsAndDurableCqs(client1, "testGetAllDurableCqsFromServer");
        this.createClient2CqsAndDurableCqs(client2, "testGetAllDurableCqsFromServer");
        client2.invoke(new CacheSerializableRunnable("check durable cqs for client 2"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)4, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client2DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ2"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ3"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ4"));
            }
        });
        client1.invoke(new CacheSerializableRunnable("check durable cqs for client 1"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)2, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client1DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client1DCQ2"));
            }
        });
        client1.invoke(CacheServerTestUtil.class, "closeCache");
        client2.invoke(CacheServerTestUtil.class, "closeCache");
        server.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testGetDurableCqsFromServerCycleClients() {
        String regionName = "testGetAllDurableCqsFromServerCycleClients";
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        int timeout = 60000;
        int server1Port = (Integer)server.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{"testGetAllDurableCqsFromServerCycleClients", new Boolean(true)});
        client1.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client1.getHost()), server1Port), "testGetAllDurableCqsFromServerCycleClients", this.getDurableClientProperties("client1_dc", timeout)});
        client2.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client2.getHost()), server1Port), "testGetAllDurableCqsFromServerCycleClients", this.getDurableClientProperties("client2_dc", timeout)});
        this.createClient1CqsAndDurableCqs(client1, "testGetAllDurableCqsFromServerCycleClients");
        this.createClient2CqsAndDurableCqs(client2, "testGetAllDurableCqsFromServerCycleClients");
        this.cycleDurableClient(client1, "client1_dc", server1Port, "testGetAllDurableCqsFromServerCycleClients", timeout);
        this.cycleDurableClient(client2, "client2_dc", server1Port, "testGetAllDurableCqsFromServerCycleClients", timeout);
        client2.invoke(new CacheSerializableRunnable("check durable cqs for client 2"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)4, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client2DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ2"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ3"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ4"));
            }
        });
        client1.invoke(new CacheSerializableRunnable("check durable cqs for client 1"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)2, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client1DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client1DCQ2"));
            }
        });
        client1.invoke(CacheServerTestUtil.class, "closeCache");
        client2.invoke(CacheServerTestUtil.class, "closeCache");
        server.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testGetDurableCqsFromServerCycleClientsAndMoreCqs() {
        String regionName = "testGetAllDurableCqsFromServerCycleClients";
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        int timeout = 60000;
        int server1Port = (Integer)server.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{"testGetAllDurableCqsFromServerCycleClients", new Boolean(true)});
        client1.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client1.getHost()), server1Port), "testGetAllDurableCqsFromServerCycleClients", this.getDurableClientProperties("client1_dc", timeout)});
        client2.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client2.getHost()), server1Port), "testGetAllDurableCqsFromServerCycleClients", this.getDurableClientProperties("client2_dc", timeout)});
        this.createClient1CqsAndDurableCqs(client1, "testGetAllDurableCqsFromServerCycleClients");
        this.createClient2CqsAndDurableCqs(client2, "testGetAllDurableCqsFromServerCycleClients");
        this.cycleDurableClient(client1, "client1_dc", server1Port, "testGetAllDurableCqsFromServerCycleClients", timeout);
        this.cycleDurableClient(client2, "client2_dc", server1Port, "testGetAllDurableCqsFromServerCycleClients", timeout);
        client1.invoke(new CacheSerializableRunnable("Register more cq for client 1"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqAttributes attributes = cqAf.create();
                try {
                    queryService.newCq("client1MoreDCQ1", "Select * From /testGetAllDurableCqsFromServerCycleClients where id = 1", attributes, true).execute();
                    queryService.newCq("client1MoreDCQ2", "Select * From /testGetAllDurableCqsFromServerCycleClients where id = 10", attributes, true).execute();
                    queryService.newCq("client1MoreNoDC1", "Select * From /testGetAllDurableCqsFromServerCycleClients", attributes, false).execute();
                    queryService.newCq("client1MoreNoDC2", "Select * From /testGetAllDurableCqsFromServerCycleClients where id = 3", attributes, false).execute();
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
            }
        });
        client2.invoke(new CacheSerializableRunnable("Register more cq for client 2"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqAttributes attributes = cqAf.create();
                try {
                    queryService.newCq("client2MoreDCQ1", "Select * From /testGetAllDurableCqsFromServerCycleClients where id = 1", attributes, true).execute();
                    queryService.newCq("client2MoreDCQ2", "Select * From /testGetAllDurableCqsFromServerCycleClients where id = 10", attributes, true).execute();
                    queryService.newCq("client2MoreDCQ3", "Select * From /testGetAllDurableCqsFromServerCycleClients", attributes, true).execute();
                    queryService.newCq("client2MoreDCQ4", "Select * From /testGetAllDurableCqsFromServerCycleClients where id = 3", attributes, true).execute();
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
            }
        });
        this.cycleDurableClient(client1, "client1_dc", server1Port, "testGetAllDurableCqsFromServerCycleClients", timeout);
        this.cycleDurableClient(client2, "client2_dc", server1Port, "testGetAllDurableCqsFromServerCycleClients", timeout);
        client2.invoke(new CacheSerializableRunnable("check durable cqs for client 2"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)8, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client2DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ2"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ3"));
                TestCase.assertTrue((boolean)list.contains("client2DCQ4"));
                TestCase.assertTrue((boolean)list.contains("client2MoreDCQ1"));
                TestCase.assertTrue((boolean)list.contains("client2MoreDCQ2"));
                TestCase.assertTrue((boolean)list.contains("client2MoreDCQ3"));
                TestCase.assertTrue((boolean)list.contains("client2MoreDCQ4"));
            }
        });
        client1.invoke(new CacheSerializableRunnable("check durable cqs for client 1"){

            @Override
            public void run2() throws CacheException {
                List list;
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                try {
                    list = queryService.getAllDurableCqsFromServer();
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                TestCase.assertEquals((int)4, (int)list.size());
                TestCase.assertTrue((boolean)list.contains("client1DCQ1"));
                TestCase.assertTrue((boolean)list.contains("client1DCQ2"));
                TestCase.assertTrue((boolean)list.contains("client1MoreDCQ1"));
                TestCase.assertTrue((boolean)list.contains("client1MoreDCQ2"));
            }
        });
        client1.invoke(CacheServerTestUtil.class, "closeCache");
        client2.invoke(CacheServerTestUtil.class, "closeCache");
        server.invoke(CacheServerTestUtil.class, "closeCache");
    }

    private Properties getDurableClientProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    private void createClient1CqsAndDurableCqs(VM client, final String regionName) {
        client.invoke(new CacheSerializableRunnable("Register cq for client 1"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqAttributes attributes = cqAf.create();
                try {
                    queryService.newCq("client1DCQ1", "Select * From /" + regionName + " where id = 1", attributes, true).execute();
                    queryService.newCq("client1DCQ2", "Select * From /" + regionName + " where id = 10", attributes, true).execute();
                    queryService.newCq("client1NoDC1", "Select * From /" + regionName, attributes, false).execute();
                    queryService.newCq("client1NoDC2", "Select * From /" + regionName + " where id = 3", attributes, false).execute();
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    private void createClient2CqsAndDurableCqs(VM client, final String regionName) {
        client.invoke(new CacheSerializableRunnable("Register cq for client 2"){

            @Override
            public void run2() throws CacheException {
                QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqAttributes attributes = cqAf.create();
                try {
                    queryService.newCq("client2DCQ1", "Select * From /" + regionName + " where id = 1", attributes, true).execute();
                    queryService.newCq("client2DCQ2", "Select * From /" + regionName + " where id = 10", attributes, true).execute();
                    queryService.newCq("client2DCQ3", "Select * From /" + regionName, attributes, true).execute();
                    queryService.newCq("client2DCQ4", "Select * From /" + regionName + " where id = 3", attributes, true).execute();
                }
                catch (RegionNotFoundException e) {
                    throw new CacheException(e){};
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
                catch (CqExistsException e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    private void cycleDurableClient(VM client, String dcName, int serverPort, String regionName, int durableClientTimeout) {
        client.invoke(new CacheSerializableRunnable("cycle client"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.closeCache(true);
            }
        });
        client.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(CqDataUsingPoolDUnitTest.getServerHostName(client.getHost()), serverPort), regionName, this.getDurableClientProperties(dcName, durableClientTimeout)});
    }

    private CqQuery createCq(String regionName, String cqName) {
        CqAttributesFactory cqAf = new CqAttributesFactory();
        CqListener[] cqListeners = new CqListener[]{new CqListener(){

            public void close() {
            }

            public void onEvent(CqEvent aCqEvent) {
            }

            public void onError(CqEvent aCqEvent) {
            }
        }};
        cqAf.initCqListeners(cqListeners);
        CqAttributes cqa = cqAf.create();
        QueryService queryService = CacheServerTestUtil.getCache().getQueryService();
        CqQuery query = null;
        try {
            query = queryService.newCq(cqName, "Select * from /" + regionName, cqa);
            query.execute();
        }
        catch (CqExistsException e) {
            CqDataUsingPoolDUnitTest.fail((String)("Could not find specified region:" + regionName + ":" + (Object)((Object)e)));
        }
        catch (CqException e) {
            CqDataUsingPoolDUnitTest.fail((String)("Could not find specified region:" + regionName + ":" + (Object)((Object)e)));
        }
        catch (RegionNotFoundException e) {
            CqDataUsingPoolDUnitTest.fail((String)("Could not find specified region:" + regionName + ":" + (Object)((Object)e)));
        }
        return query;
    }

    private void checkCqStats(String cqName) {
        QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
        CqQueryImpl query = null;
        query = (CqQueryImpl)queryService.getCq(cqName);
        if (query != null) {
            query.getVsdStats();
            query.getVsdStats().getNumEvents();
        }
    }

    private Pool getClientPool(String host, int serverPort) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, serverPort).setSubscriptionAckInterval(1).setSubscriptionEnabled(true);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    public CacheSerializableRunnable setTestHook() {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("TestHook"){

            @Override
            public void run2() {
                class CqQueryTestHook
                implements CqQueryImpl.TestHook {
                    CountDownLatch latch = new CountDownLatch(1);
                    private int numEvents = 0;
                    Cache cache = GemFireCacheImpl.getInstance();

                    CqQueryTestHook() {
                    }

                    public void pauseUntilReady() {
                        try {
                            this.cache.getLogger().fine("CqQueryTestHook: Going to wait on latch until ready is called.");
                            if (!this.latch.await(10L, TimeUnit.SECONDS)) {
                                throw new TestException("query was never unlatched");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Thread.currentThread().interrupt();
                        }
                    }

                    public void ready() {
                        this.latch.countDown();
                        this.cache.getLogger().fine("CqQueryTestHook: The latch has been released.");
                    }

                    public int numQueuedEvents() {
                        return this.numEvents;
                    }

                    public void setEventCount(int count) {
                        this.cache.getLogger().fine("CqQueryTestHook: Setting numEVents to: " + count);
                        this.numEvents = count;
                    }
                }
                CqQueryImpl.testHook = new CqQueryTestHook();
            }
        };
        return sr;
    }
}

