/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

public class CqDataDUnitTest
extends CacheTestCase {
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqDataDUnitTest");

    public CqDataDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqDataDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqDataDUnitTest.this.getSystem();
            }
        });
    }

    public void testClientWithFeederAndCQ() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, "testClientWithFeederAndCQ_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testClientWithFeederAndCQ_0", false, null);
        int size = 10;
        this.cqDUnitTest.createValues(client, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.waitForCreated(client, "testClientWithFeederAndCQ_0", "key-10");
        this.cqDUnitTest.validateCQ(client, "testClientWithFeederAndCQ_0", CqQueryDUnitTest.noTest, 10, 0, 0, 10, 0, 0, 10);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQHAWithState() throws Exception {
        int i;
        int i2;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client = host.getVM(3);
        this.cqDUnitTest.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        this.cqDUnitTest.createServer(server2, ports[0]);
        int port2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        this.cqDUnitTest.createClient(client, new int[]{port1, port2, ports[1]}, host0, "1");
        int numCQs = 1;
        for (int i3 = 0; i3 < numCQs; ++i3) {
            this.cqDUnitTest.createCQ(client, "testCQHAWithState_" + i3, this.cqDUnitTest.cqs[i3]);
            this.cqDUnitTest.executeCQ(client, "testCQHAWithState_" + i3, false, null);
        }
        CqDataDUnitTest.pause(1000);
        int size = 10;
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[1], size);
        for (int i4 = 1; i4 <= size; ++i4) {
            this.cqDUnitTest.waitForCreated(client, "testCQHAWithState_0", "key-" + i4);
        }
        int[] resultsCnt = new int[]{10, 1, 2};
        for (i2 = 0; i2 < numCQs; ++i2) {
            this.cqDUnitTest.validateCQ(client, "testCQHAWithState_" + i2, CqQueryDUnitTest.noTest, resultsCnt[i2], 0, 0);
        }
        this.cqDUnitTest.closeServer(server1);
        CqDataDUnitTest.pause(3000);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], 10);
        for (i2 = 1; i2 <= size; ++i2) {
            this.cqDUnitTest.waitForUpdated(client, "testCQHAWithState_0", "key-" + size);
        }
        for (i2 = 0; i2 < numCQs; ++i2) {
            this.cqDUnitTest.validateCQ(client, "testCQHAWithState_" + i2, CqQueryDUnitTest.noTest, resultsCnt[i2], resultsCnt[i2], CqQueryDUnitTest.noTest);
        }
        this.cqDUnitTest.stopCQ(client, "testCQHAWithState_0");
        CqDataDUnitTest.pause(2000);
        this.cqDUnitTest.createServer(server3, ports[1]);
        server3.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CqDataDUnitTest.pause(2000);
        this.cqDUnitTest.clearCQListenerEvents(client, "testCQHAWithState_0");
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], 10);
        try {
            this.cqDUnitTest.waitForUpdated(client, "testCQHAWithState_0", "key-1");
            CqDataDUnitTest.fail((String)"Events not expected since CQ is in stop state.");
        }
        catch (Exception i5) {
            // empty catch block
        }
        this.cqDUnitTest.executeCQ(client, "testCQHAWithState_0", false, null);
        CqDataDUnitTest.pause(2000);
        this.cqDUnitTest.createValues(server3, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server3, this.cqDUnitTest.regions[1], 10);
        for (i = 1; i <= size; ++i) {
            this.cqDUnitTest.waitForUpdated(client, "testCQHAWithState_0", "key-" + size);
        }
        for (i = 0; i < numCQs; ++i) {
            this.cqDUnitTest.validateCQ(client, "testCQHAWithState_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i] * 2, CqQueryDUnitTest.noTest);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server2);
        this.cqDUnitTest.closeServer(server3);
    }

    public void testCQWithDestroysAndInvalidates() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM producer = host.getVM(2);
        this.cqDUnitTest.createServer(server, 0, true);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createClient(producer, port, host0);
        int size = 10;
        String name = "testQuery_4";
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createCQ(client, "testQuery_4", this.cqDUnitTest.cqs[4]);
        this.cqDUnitTest.executeCQ(client, "testQuery_4", true, null);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataDUnitTest.this.getRootRegion().getSubregion(CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region1.destroy((Object)("key-" + i));
                }
            }
        });
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForDestroyed(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 5);
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForCreated(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataDUnitTest.this.getRootRegion().getSubregion(CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region1.invalidate((Object)("key-" + i));
                }
            }
        });
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForInvalidated(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQWithMultipleClients() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        VM client3 = host.getVM(3);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client1, port, host0);
        this.cqDUnitTest.createClient(client2, port, host0);
        this.cqDUnitTest.createCQ(client1, "testCQWithMultipleClients_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client1, "testCQWithMultipleClients_0", false, null);
        this.cqDUnitTest.createCQ(client2, "testCQWithMultipleClients_0", this.cqDUnitTest.cqs[1]);
        this.cqDUnitTest.executeCQ(client2, "testCQWithMultipleClients_0", false, null);
        int size = 10;
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForCreated(client1, "testCQWithMultipleClients_0", "key-10");
        this.cqDUnitTest.validateCQ(client1, "testCQWithMultipleClients_0", CqQueryDUnitTest.noTest, size, 0, 0, size, 0, 0, size);
        this.cqDUnitTest.waitForCreated(client2, "testCQWithMultipleClients_0", "key-2");
        this.cqDUnitTest.validateCQ(client2, "testCQWithMultipleClients_0", CqQueryDUnitTest.noTest, 1, 0, 0, 1, 0, 0, 1);
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeClient(client3);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCQWithLoad() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        this.cqDUnitTest.createServer(server2, 0, false, MirrorType.KEYS);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server1.getHost());
        this.cqDUnitTest.createClient(client, port1, host0);
        this.cqDUnitTest.createCQ(client, "testCQWithLoad_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testCQWithLoad_0", false, null);
        CqDataDUnitTest.pause(2000);
        int size = 10;
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        server1.invoke(new CacheSerializableRunnable("Load from second server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.get((Object)("key-" + i));
                }
            }
        });
        for (int i = 1; i <= 10; ++i) {
            this.cqDUnitTest.waitForCreated(client, "testCQWithLoad_0", "key-" + i);
        }
        this.cqDUnitTest.validateCQ(client, "testCQWithLoad_0", CqQueryDUnitTest.noTest, 10, 0, 0);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
        this.cqDUnitTest.closeServer(server2);
    }

    public void testCQWithEviction() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(2);
        boolean evictionThreshold = true;
        server1.invoke(new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                EvictionAttributes evictAttrs = EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                factory.setEvictionAttributes(evictAttrs);
                for (int i = 0; i < CqDataDUnitTest.this.cqDUnitTest.regions.length; ++i) {
                    Region region = CqDataDUnitTest.this.createRegion(CqDataDUnitTest.this.cqDUnitTest.regions[i], factory.createRegionAttributes());
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                DistributedTestCase.pause(2000);
                try {
                    CqDataDUnitTest.this.cqDUnitTest.startBridgeServer(0, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(2000);
            }
        });
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server1.getHost());
        this.cqDUnitTest.createClient(client, port1, host0);
        this.cqDUnitTest.createCQ(client, "testCQWithEviction_0", this.cqDUnitTest.cqs[0]);
        int size = 10;
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.executeCQ(client, "testCQWithEviction_0", false, "CqException");
        CqDataDUnitTest.pause(1000);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], 10);
        for (int i = 1; i <= 10; ++i) {
            this.cqDUnitTest.waitForUpdated(client, "testCQWithEviction_0", "key-" + i);
        }
        this.cqDUnitTest.validateCQ(client, "testCQWithEviction_0", CqQueryDUnitTest.noTest, 0, 10, 0);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
    }

    public void testCQWithConnectionPool() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        final String serverHost = CqDataDUnitTest.getServerHostName(server1.getHost());
        final String[] regions = this.cqDUnitTest.regions;
        final int[] serverPorts = new int[]{port1};
        CacheSerializableRunnable createClientWithPool = new CacheSerializableRunnable("createClientWithPool"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqDataDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts[0], -1, false, -1, -1, null);
                for (int i = 0; i < regions.length; ++i) {
                    CqDataDUnitTest.this.createRegion(regions[i], regionFactory.create());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + regions[i]);
                }
            }
        };
        client.invoke(createClientWithPool);
        this.cqDUnitTest.createCQ(client, "testCQWithPool_0", this.cqDUnitTest.cqs[0]);
        try {
            this.cqDUnitTest.executeCQ(client, "testCQWithPool_0", false, "CqException");
            CqDataDUnitTest.fail((String)"CQ Execution should have failed with BridgeClient/Writer not found.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
    }

    public void testCQWithBridgeClient() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        final String serverHost = CqDataDUnitTest.getServerHostName(server1.getHost());
        final String[] regions = this.cqDUnitTest.regions;
        final int[] serverPorts = new int[]{port1};
        CacheSerializableRunnable createClientWithPool = new CacheSerializableRunnable("createClientWithPool"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqDataDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts[0], -1, true, -1, -1, null);
                for (int i = 0; i < regions.length; ++i) {
                    CqDataDUnitTest.this.createRegion(regions[i], regionFactory.createRegionAttributes());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + regions[i]);
                }
            }
        };
        client.invoke(createClientWithPool);
        this.cqDUnitTest.createCQ(client, "testCQWithPool_1", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testCQWithPool_1", false, null);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
    }

    public void testCQWithBridgeWriter() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        final String serverHost = CqDataDUnitTest.getServerHostName(server1.getHost());
        final String[] regions = this.cqDUnitTest.regions;
        final int[] serverPorts = new int[]{port1};
        CacheSerializableRunnable createClientWithConnectionPool = new CacheSerializableRunnable("createClientWithConnectionPool"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqDataDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts[0], -1, true, -1, -1, null);
                for (int i = 0; i < regions.length; ++i) {
                    CqDataDUnitTest.this.createRegion(regions[i], regionFactory.createRegionAttributes());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + regions[i]);
                }
            }
        };
        client.invoke(createClientWithConnectionPool);
        this.cqDUnitTest.createCQ(client, "testCQWithBridgeWriter_2", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testCQWithBridgeWriter_2", false, null);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
    }

    public void testCQWithEstablishCallBackConnection() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server1, 0, false, MirrorType.KEYS_VALUES);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        final String serverHost = CqDataDUnitTest.getServerHostName(server1.getHost());
        final String[] regions = this.cqDUnitTest.regions;
        final int[] serverPorts = new int[]{port1};
        CacheSerializableRunnable createClientWithPool = new CacheSerializableRunnable("createClientWithPool"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqDataDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts[0], -1, false, -1, -1, null);
                for (int i = 0; i < regions.length; ++i) {
                    CqDataDUnitTest.this.createRegion(regions[i], regionFactory.createRegionAttributes());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + regions[i]);
                }
            }
        };
        client.invoke(createClientWithPool);
        this.cqDUnitTest.createCQ(client, "testCQWithEstablishCallBackConnection_0", this.cqDUnitTest.cqs[0]);
        try {
            this.cqDUnitTest.executeCQ(client, "testCQWithEstablishCallBackConnection_0", false, "CqException");
            CqDataDUnitTest.fail((String)"Test should have failed with connection with establishCallBackConnection not found.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server1);
    }

    public void testRegionEvents() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, "testRegionEvents_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testRegionEvents_0", false, null);
        this.cqDUnitTest.createCQ(client, "testRegionEvents_1", this.cqDUnitTest.cqs[2]);
        this.cqDUnitTest.executeCQ(client, "testRegionEvents_1", false, null);
        server.invoke(new CacheSerializableRunnable("testRegionEvents"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Clearing the region on the server ###");
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                region.clear();
            }
        });
        this.cqDUnitTest.waitForRegionClear(client, "testRegionEvents_0");
        server.invoke(new CacheSerializableRunnable("testRegionEvents"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Invalidate the region on the server ###");
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                region.invalidateRegion();
            }
        });
        this.cqDUnitTest.waitForRegionInvalidate(client, "testRegionEvents_0");
        server.invoke(new CacheSerializableRunnable("testRegionEvents"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Destroying the region on the server ###");
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[1]);
                for (int i = 1; i <= 5; ++i) {
                    region.put((Object)("key-" + i), (Object)new Portfolio(i));
                }
                region.destroyRegion();
            }
        });
        CqDataDUnitTest.pause(1000);
        this.cqDUnitTest.validateCQCount(client, 1);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testEventsDuringQueryExecution() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        String cqName = "testEventsDuringQueryExecution_0";
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, "testEventsDuringQueryExecution_0", this.cqDUnitTest.cqs[0]);
        int numObjects = 200;
        int totalObjects = 500;
        server.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 200; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        AsyncInvocation processCqs = client.invokeAsync(new CacheSerializableRunnable("Execute CQ"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = CqDataDUnitTest.this.getCache().getQueryService();
                CqQuery cq1 = cqService.getCq("testEventsDuringQueryExecution_0");
                if (cq1 == null) {
                    TestCase.fail((String)"Failed to get CQ testEventsDuringQueryExecution_0");
                }
                CqResults cqResults = null;
                try {
                    cqResults = cq1.executeWithInitialResults();
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to execute  CQ testEventsDuringQueryExecution_0");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                CqQueryTestListener cqListener = (CqQueryTestListener)cq1.getCqAttributes().getCqListener();
                cqListener.waitForCreated("500");
                int oldId = 0;
                for (Object cqEvent : cqListener.events.toArray()) {
                    int newId = new Integer(cqEvent.toString());
                    if (oldId > newId) {
                        TestCase.fail((String)"Queued events for CQ Listener during execution with Initial results is not in the order in which they are created.");
                    }
                    oldId = newId;
                }
                HashSet<Object> ids = new HashSet<Object>(cqListener.events);
                for (Object o : cqResults.asList()) {
                    Struct s = (Struct)o;
                    ids.add(s.get("key"));
                }
                HashSet<String> missingIds = new HashSet<String>();
                String key = "";
                for (int i = 1; i <= 500; ++i) {
                    key = "" + i;
                    if (ids.contains(key)) continue;
                    missingIds.add(key);
                }
                if (!missingIds.isEmpty()) {
                    TestCase.fail((String)("Missing Keys in either ResultSet or the Cq Event list.  Missing keys : [size : " + missingIds.size() + "]" + missingIds + " Ids in ResultSet and CQ Events :" + ids));
                }
            }
        });
        server.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 201; i <= 500; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        DistributedTestCase.join(processCqs, 60000L, CqDataDUnitTest.getLogWriter());
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testMultipleExecuteWithInitialResults() throws Exception {
        int numObjects = 200;
        int totalObjects = 500;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        client.invoke(this.setTestHook());
        String cqName = "testMultiExecuteWithInitialResults";
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqDataDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createCQ(client, "testMultiExecuteWithInitialResults", this.cqDUnitTest.cqs[0]);
        server.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 200; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Region region = CqDataDUnitTest.this.getCache().getRegion("/root/" + CqDataDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 201; i <= 500; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        AsyncInvocation processCqs = client.invokeAsync(new CacheSerializableRunnable("Execute CQ first"){

            @Override
            public void run2() throws CacheException {
                CqResults cqResults = null;
                QueryService cqService = CqDataDUnitTest.this.getCache().getQueryService();
                CqQuery cq1 = cqService.getCq("testMultiExecuteWithInitialResults");
                if (cq1 == null) {
                    TestCase.fail((String)"Failed to get CQ testMultiExecuteWithInitialResults");
                }
                try {
                    cqResults = cq1.executeWithInitialResults();
                }
                catch (Exception e) {
                    AssertionError err = new AssertionError((Object)"Failed to execute  CQ testMultiExecuteWithInitialResults");
                    ((Throwable)((Object)err)).initCause(e);
                    throw err;
                }
                CqQueryTestListener cqListener = (CqQueryTestListener)cq1.getCqAttributes().getCqListener();
                cqListener.waitForCreated("500");
                int oldId = 0;
                for (Object cqEvent : cqListener.events.toArray()) {
                    int newId = new Integer(cqEvent.toString());
                    if (oldId > newId) {
                        TestCase.fail((String)"Queued events for CQ Listener during execution with Initial results is not in the order in which they are created.");
                    }
                    oldId = newId;
                }
                HashSet<Object> ids = new HashSet<Object>(cqListener.events);
                for (Object o : cqResults.asList()) {
                    Struct s = (Struct)o;
                    ids.add(s.get("key"));
                }
                HashSet<String> missingIds = new HashSet<String>();
                String key = "";
                for (int i = 1; i <= 500; ++i) {
                    key = "" + i;
                    if (ids.contains(key)) continue;
                    missingIds.add(key);
                }
                if (!missingIds.isEmpty()) {
                    TestCase.fail((String)("Missing Keys in either ResultSet or the Cq Event list.  Missing keys : [size : " + missingIds.size() + "]" + missingIds + " Ids in ResultSet and CQ Events :" + ids));
                }
            }
        });
        client.invokeAsync(new CacheSerializableRunnable("Execute CQ second"){

            @Override
            public void run2() throws CacheException {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                QueryService cqService = CqDataDUnitTest.this.getCache().getQueryService();
                CqQuery cq1 = cqService.getCq("testMultiExecuteWithInitialResults");
                if (cq1 == null) {
                    TestCase.fail((String)"Failed to get CQ testMultiExecuteWithInitialResults");
                }
                try {
                    cq1.executeWithInitialResults();
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e) {
                    AssertionError err = new AssertionError((Object)"test hook lock interruptedtestMultiExecuteWithInitialResults");
                    ((Throwable)((Object)err)).initCause(e);
                    throw err;
                }
            }
        });
        client.invokeAsync(new CacheSerializableRunnable("Release latch"){

            @Override
            public void run2() throws CacheException {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    AssertionError err = new AssertionError((Object)"test hook lock interruptedtestMultiExecuteWithInitialResults");
                    ((Throwable)((Object)err)).initCause(e);
                    throw err;
                }
                CqQueryImpl.testHook.ready();
            }
        });
        DistributedTestCase.join(processCqs, 60000L, CqDataDUnitTest.getLogWriter());
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public CacheSerializableRunnable setTestHook() {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("TestHook"){

            @Override
            public void run2() {
                class CqQueryTestHook
                implements CqQueryImpl.TestHook {
                    CountDownLatch latch = new CountDownLatch(1);

                    CqQueryTestHook() {
                    }

                    public void pauseUntilReady() {
                        try {
                            this.latch.await();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Thread.currentThread().interrupt();
                        }
                    }

                    public void ready() {
                        this.latch.countDown();
                    }

                    public int numQueuedEvents() {
                        return 0;
                    }

                    public void setEventCount(int count) {
                    }
                }
                CqQueryImpl.testHook = new CqQueryTestHook();
            }
        };
        return sr;
    }
}

