/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.partition;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.FixedPartitioningTestBase;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.QuarterPartitionResolver;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import junit.framework.TestCase;

public class PartitionRegionHelperDUnitTest
extends CacheTestCase {
    public PartitionRegionHelperDUnitTest(String name) {
        super(name);
    }

    public void testAssignBucketsToPartitions() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(12);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        vm2.invoke(createPrRegion);
        SerializableRunnable assignBuckets = new SerializableRunnable("assign partitions"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionHelper.assignBucketsToPartitions((Region)region);
            }
        };
        AsyncInvocation future1 = vm0.invokeAsync(assignBuckets);
        AsyncInvocation future2 = vm1.invokeAsync(assignBuckets);
        AsyncInvocation future3 = vm2.invokeAsync(assignBuckets);
        future1.join(60000L);
        future2.join(60000L);
        future3.join(60000L);
        if (future1.exceptionOccurred()) {
            throw future1.getException();
        }
        if (future2.exceptionOccurred()) {
            throw future2.getException();
        }
        if (future3.exceptionOccurred()) {
            throw future3.getException();
        }
        SerializableRunnable checkAssignment = new SerializableRunnable("check assignment"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo info = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)info.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)info.getLowRedundancyBucketCount());
                for (PartitionMemberInfo member : info.getPartitionMemberInfo()) {
                    TestCase.assertEquals((int)8, (int)member.getBucketCount());
                }
            }
        };
        vm0.invoke(checkAssignment);
    }

    public void testAssignBucketsToPartitions_FPR() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        SerializableRunnable createPrRegion1 = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)false, (int)3);
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.addFixedPartitionAttributes(fpa1);
                paf.addFixedPartitionAttributes(fpa2);
                paf.setPartitionResolver((PartitionResolver)new QuarterPartitionResolver());
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(12);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion1);
        SerializableRunnable createPrRegion2 = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)false, (int)3);
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.addFixedPartitionAttributes(fpa1);
                paf.addFixedPartitionAttributes(fpa2);
                paf.setPartitionResolver((PartitionResolver)new QuarterPartitionResolver());
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(12);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm1.invoke(createPrRegion2);
        SerializableRunnable createPrRegion3 = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                FixedPartitionAttributes fpa1 = FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)true, (int)3);
                FixedPartitionAttributes fpa2 = FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)false, (int)3);
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.addFixedPartitionAttributes(fpa1);
                paf.addFixedPartitionAttributes(fpa2);
                paf.setPartitionResolver((PartitionResolver)new QuarterPartitionResolver());
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(12);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm2.invoke(createPrRegion3);
        SerializableRunnable assignBuckets = new SerializableRunnable("assign partitions"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionHelper.assignBucketsToPartitions((Region)region);
            }
        };
        AsyncInvocation future1 = vm0.invokeAsync(assignBuckets);
        AsyncInvocation future2 = vm1.invokeAsync(assignBuckets);
        AsyncInvocation future3 = vm2.invokeAsync(assignBuckets);
        future1.join();
        future2.join();
        future3.join();
        if (future1.exceptionOccurred()) {
            throw future1.getException();
        }
        if (future2.exceptionOccurred()) {
            throw future2.getException();
        }
        if (future3.exceptionOccurred()) {
            throw future3.getException();
        }
        SerializableRunnable checkAssignment = new SerializableRunnable("check assignment"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo info = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)9, (int)info.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)info.getLowRedundancyBucketCount());
                for (PartitionMemberInfo member : info.getPartitionMemberInfo()) {
                    TestCase.assertEquals((int)6, (int)member.getBucketCount());
                }
            }
        };
        vm0.invoke(checkAssignment);
        SerializableRunnable createPrRegion4 = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setPartitionResolver((PartitionResolver)new QuarterPartitionResolver());
                paf.setLocalMaxMemory(0);
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(12);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                Region region = cache.createRegion("region1", attr.create());
                for (FixedPartitioningTestBase.Months_Accessor month : FixedPartitioningTestBase.Months_Accessor.values()) {
                    String dateString = "10-" + (Object)((Object)month) + "-2009";
                    String DATE_FORMAT = "dd-MMM-yyyy";
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.US);
                    Date date = null;
                    try {
                        date = sdf.parse(dateString);
                    }
                    catch (ParseException e) {
                        FixedPartitioningTestBase.fail("Exception Occured while parseing date", e);
                    }
                    String value = month.toString() + 10;
                    region.put((Object)date, (Object)value);
                }
            }
        };
        vm3.invoke(createPrRegion4);
        SerializableRunnable checkMembers = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                for (FixedPartitioningTestBase.Months_Accessor month : FixedPartitioningTestBase.Months_Accessor.values()) {
                    String dateString = "10-" + (Object)((Object)month) + "-2009";
                    String DATE_FORMAT = "dd-MMM-yyyy";
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.US);
                    Date date = null;
                    try {
                        date = sdf.parse(dateString);
                    }
                    catch (ParseException e) {
                        FixedPartitioningTestBase.fail("Exception Occured while parseing date", e);
                    }
                    DistributedMember key1Pri = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, (Object)date);
                    TestCase.assertNotNull((Object)key1Pri);
                    Set buk0AllMems = PartitionRegionHelper.getAllMembersForKey((Region)region, (Object)date);
                    TestCase.assertEquals((int)2, (int)buk0AllMems.size());
                    Set buk0RedundantMems = PartitionRegionHelper.getRedundantMembersForKey((Region)region, (Object)date);
                    TestCase.assertEquals((int)1, (int)buk0RedundantMems.size());
                }
            }
        };
        vm3.invoke(checkMembers);
    }

    public void testMembersForKey() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM ds1 = host.getVM(1);
        VM ds2 = host.getVM(2);
        VM ds3 = host.getVM(3);
        final String prName = this.getUniqueName();
        int tb = 11;
        boolean rc = true;
        accessor.invoke(new SerializableRunnable("createAccessor"){

            @Override
            public void run() {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).setRedundantCopies(1).setTotalNumBuckets(11).create());
                cache.createRegion(prName, attr.create());
            }
        });
        HashMap<DistributedMember, VM> d2v = new HashMap<DistributedMember, VM>();
        SerializableCallable createPrRegion = new SerializableCallable("createDataStore"){

            public Object call() throws Exception {
                Cache cache = PartitionRegionHelperDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(11).create());
                cache.createRegion(prName, attr.create());
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        DistributedMember dm = (DistributedMember)ds1.invoke(createPrRegion);
        d2v.put(dm, ds1);
        dm = (DistributedMember)ds2.invoke(createPrRegion);
        d2v.put(dm, ds2);
        dm = (DistributedMember)ds3.invoke(createPrRegion);
        d2v.put(dm, ds3);
        final Integer buk0Key1 = new Integer(0);
        final Integer buk0Key2 = new Integer(buk0Key1 + 11);
        final Integer buk1Key1 = new Integer(1);
        accessor.invoke(new CacheSerializableRunnable("nonPRcheck"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory attr = new AttributesFactory();
                attr.setScope(Scope.LOCAL);
                Region lr = PartitionRegionHelperDUnitTest.this.getCache().createRegion(prName + "lr", attr.create());
                try {
                    this.nonPRMemberForKey(lr, buk0Key1);
                }
                finally {
                    lr.destroyRegion();
                }
                attr = new AttributesFactory();
                attr.setScope(Scope.DISTRIBUTED_ACK);
                Region dr = PartitionRegionHelperDUnitTest.this.getCache().createRegion(prName + "dr", attr.create());
                try {
                    this.nonPRMemberForKey(dr, buk0Key1);
                }
                finally {
                    dr.destroyRegion();
                }
            }

            private void nonPRMemberForKey(Region lr, Object key) {
                try {
                    PartitionRegionHelper.getPrimaryMemberForKey((Region)lr, (Object)key);
                    TestCase.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    PartitionRegionHelper.getAllMembersForKey((Region)lr, (Object)key);
                    TestCase.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    PartitionRegionHelper.getRedundantMembersForKey((Region)lr, (Object)key);
                    TestCase.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        Object[] noKeyThenKeyStuff = (Object[])accessor.invoke(new SerializableCallable("noKeyThenKey"){

            public Object call() throws Exception {
                Region r = PartitionRegionHelperDUnitTest.this.getCache().getRegion(prName);
                try {
                    PartitionRegionHelper.getPrimaryMemberForKey((Region)r, null);
                    TestCase.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    PartitionRegionHelper.getAllMembersForKey((Region)r, null);
                    TestCase.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    PartitionRegionHelper.getRedundantMembersForKey((Region)r, null);
                    TestCase.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                TestCase.assertNull((Object)PartitionRegionHelper.getPrimaryMemberForKey((Region)r, (Object)buk0Key1));
                TestCase.assertTrue((boolean)PartitionRegionHelper.getAllMembersForKey((Region)r, (Object)buk0Key1).isEmpty());
                TestCase.assertTrue((boolean)PartitionRegionHelper.getRedundantMembersForKey((Region)r, (Object)buk0Key1).isEmpty());
                TestCase.assertNull((Object)PartitionRegionHelper.getPrimaryMemberForKey((Region)r, (Object)buk1Key1));
                TestCase.assertTrue((boolean)PartitionRegionHelper.getAllMembersForKey((Region)r, (Object)buk1Key1).isEmpty());
                TestCase.assertTrue((boolean)PartitionRegionHelper.getRedundantMembersForKey((Region)r, (Object)buk1Key1).isEmpty());
                r.put((Object)buk0Key1, (Object)"zero");
                DistributedMember key1Pri = PartitionRegionHelper.getPrimaryMemberForKey((Region)r, (Object)buk0Key1);
                TestCase.assertNotNull((Object)key1Pri);
                Set buk0AllMems = PartitionRegionHelper.getAllMembersForKey((Region)r, (Object)buk0Key1);
                TestCase.assertEquals((int)2, (int)buk0AllMems.size());
                Set buk0RedundantMems = PartitionRegionHelper.getRedundantMembersForKey((Region)r, (Object)buk0Key1);
                TestCase.assertEquals((int)1, (int)buk0RedundantMems.size());
                DistributedMember me = r.getCache().getDistributedSystem().getDistributedMember();
                try {
                    buk0AllMems.add(me);
                    TestCase.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    buk0AllMems.remove(me);
                    TestCase.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    buk0RedundantMems.add(me);
                    TestCase.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    buk0RedundantMems.remove(me);
                    TestCase.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                TestCase.assertTrue((boolean)buk0AllMems.containsAll(buk0RedundantMems));
                TestCase.assertTrue((boolean)buk0AllMems.contains(key1Pri));
                TestCase.assertTrue((!buk0RedundantMems.contains(key1Pri) ? 1 : 0) != 0);
                DistributedMember key2Pri = PartitionRegionHelper.getPrimaryMemberForKey((Region)r, (Object)buk0Key2);
                TestCase.assertNotNull((Object)key2Pri);
                buk0AllMems = PartitionRegionHelper.getAllMembersForKey((Region)r, (Object)buk0Key2);
                TestCase.assertEquals((int)2, (int)buk0AllMems.size());
                buk0RedundantMems = PartitionRegionHelper.getRedundantMembersForKey((Region)r, (Object)buk0Key2);
                TestCase.assertEquals((int)1, (int)buk0RedundantMems.size());
                TestCase.assertTrue((boolean)buk0AllMems.containsAll(buk0RedundantMems));
                TestCase.assertTrue((boolean)buk0AllMems.contains(key2Pri));
                TestCase.assertTrue((!buk0RedundantMems.contains(key2Pri) ? 1 : 0) != 0);
                TestCase.assertNull((Object)PartitionRegionHelper.getPrimaryMemberForKey((Region)r, (Object)buk1Key1));
                TestCase.assertTrue((boolean)PartitionRegionHelper.getAllMembersForKey((Region)r, (Object)buk1Key1).isEmpty());
                TestCase.assertTrue((boolean)PartitionRegionHelper.getRedundantMembersForKey((Region)r, (Object)buk1Key1).isEmpty());
                return new Object[]{key1Pri, buk0AllMems, buk0RedundantMems};
            }
        });
        DistributedMember buk0Key1Pri = (DistributedMember)noKeyThenKeyStuff[0];
        Set buk0AllMems = (Set)noKeyThenKeyStuff[1];
        Set buk0Redundants = (Set)noKeyThenKeyStuff[2];
        VM buk0Key1PriVM = (VM)d2v.get(buk0Key1Pri);
        buk0Key1PriVM.invoke(new CacheSerializableRunnable("assertPrimaryness"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)PartitionRegionHelperDUnitTest.this.getCache().getRegion(prName);
                Integer bucketId = new Integer(PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)buk0Key1, null, null));
                try {
                    BucketRegion buk0 = pr.getDataStore().getInitializedBucketForId((Object)buk0Key1, bucketId);
                    TestCase.assertNotNull((Object)buk0);
                    TestCase.assertTrue((boolean)buk0.getBucketAdvisor().isPrimary());
                }
                catch (ForceReattemptException e) {
                    DistributedTestCase.getLogWriter().severe((Throwable)e);
                    TestCase.fail();
                }
            }
        });
        CacheSerializableRunnable assertHasBucket = new CacheSerializableRunnable("assertHasBucketAndKey"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)PartitionRegionHelperDUnitTest.this.getCache().getRegion(prName);
                Integer bucketId = new Integer(PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)buk0Key1, null, null));
                try {
                    BucketRegion buk0 = pr.getDataStore().getInitializedBucketForId((Object)buk0Key1, bucketId);
                    TestCase.assertNotNull((Object)buk0);
                    Region.Entry k1e = buk0.getEntry((Object)buk0Key1);
                    TestCase.assertNotNull((Object)k1e);
                }
                catch (ForceReattemptException e) {
                    DistributedTestCase.getLogWriter().severe((Throwable)e);
                    TestCase.fail();
                }
            }
        };
        for (DistributedMember bom : buk0AllMems) {
            VM v = (VM)d2v.get(bom);
            PartitionRegionHelperDUnitTest.getLogWriter().info("Visiting bucket owner member " + bom + " for key " + buk0Key1);
            v.invoke(assertHasBucket);
        }
        CacheSerializableRunnable assertRed = new CacheSerializableRunnable("assertRedundant"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)PartitionRegionHelperDUnitTest.this.getCache().getRegion(prName);
                Integer bucketId = new Integer(PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)buk0Key1, null, null));
                try {
                    BucketRegion buk0 = pr.getDataStore().getInitializedBucketForId((Object)buk0Key1, bucketId);
                    TestCase.assertNotNull((Object)buk0);
                    TestCase.assertFalse((boolean)buk0.getBucketAdvisor().isPrimary());
                }
                catch (ForceReattemptException e) {
                    DistributedTestCase.getLogWriter().severe((Throwable)e);
                    TestCase.fail();
                }
            }
        };
        for (DistributedMember redm : buk0Redundants) {
            VM v = (VM)d2v.get(redm);
            PartitionRegionHelperDUnitTest.getLogWriter().info("Visiting redundant member " + redm + " for key " + buk0Key1);
            v.invoke(assertRed);
        }
    }
}

