/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.management;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.management.MemoryThresholdsDUnitTest;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.control.OffHeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.ResourceAdvisor;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.control.TestMemoryThresholdListener;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class MemoryThresholdsOffHeapDUnitTest
extends BridgeTestCase {
    private static final long serialVersionUID = -684231183212051910L;
    final String expectedEx = LocalizedStrings.MemoryMonitor_MEMBER_ABOVE_CRITICAL_THRESHOLD.getRawText().replaceAll("\\{[0-9]+\\}", ".*?");
    final String addExpectedExString = "<ExpectedException action=add>" + this.expectedEx + "</ExpectedException>";
    final String removeExpectedExString = "<ExpectedException action=remove>" + this.expectedEx + "</ExpectedException>";
    final String expectedBelow = LocalizedStrings.MemoryMonitor_MEMBER_BELOW_CRITICAL_THRESHOLD.getRawText().replaceAll("\\{[0-9]+\\}", ".*?");
    final String addExpectedBelow = "<ExpectedException action=add>" + this.expectedBelow + "</ExpectedException>";
    final String removeExpectedBelow = "<ExpectedException action=remove>" + this.expectedBelow + "</ExpectedException>";
    private SerializableCallable resetResourceManager = new SerializableCallable(){

        public Object call() throws Exception {
            InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsOffHeapDUnitTest.this.getCache()).getResourceManager();
            Set listeners = irm.getResourceListeners(InternalResourceManager.ResourceType.OFFHEAP_MEMORY);
            for (ResourceListener l : listeners) {
                if (!(l instanceof TestMemoryThresholdListener)) continue;
                ((TestMemoryThresholdListener)l).resetThresholdCalls();
            }
            return null;
        }
    };
    private SerializableRunnable addExpectedException = new SerializableRunnable("addExpectedEx"){

        @Override
        public void run() {
            MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedExString);
            MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedBelow);
        }
    };
    private SerializableRunnable removeExpectedException = new SerializableRunnable("removeExpectedException"){

        @Override
        public void run() {
            MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedExString);
            MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedBelow);
        }
    };

    public MemoryThresholdsOffHeapDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        MemoryThresholdsOffHeapDUnitTest.invokeInEveryVM(this.resetResourceManager);
    }

    public void testEventDelivery() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int port1 = ports[0];
        int port2 = ports[1];
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        String regionName = "offHeapEventDelivery";
        this.startCacheServer(server1, port1, mcastPort, 0.0f, 0.0f, "offHeapEventDelivery", false, false, 0);
        this.startCacheServer(server2, port2, mcastPort, 70.0f, 90.0f, "offHeapEventDelivery", false, false, 0);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.setUsageAboveEvictionThreshold(server2, "offHeapEventDelivery");
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 1, false);
        this.setUsageAboveCriticalThreshold(server2, "offHeapEventDelivery");
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 2, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 2, false);
        server2.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLogger().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedExString);
                MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapEventDelivery").destroy((Object)"oh3");
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLogger().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedExString);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 2, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 2, false);
        server2.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLogger().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedBelow);
                MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapEventDelivery").destroy((Object)"oh2");
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLogger().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedBelow);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 3, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 3, false);
        server2.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapEventDelivery").put((Object)"oh6", (Object)new byte[20480]);
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 3, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 3, false);
        server2.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapEventDelivery").destroy((Object)"oh4");
                return null;
            }
        });
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 3, true);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.NORMAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 3, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.NORMAL, 1, false);
    }

    public void testDisabledThresholds() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int port1 = ports[0];
        int port2 = ports[1];
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        String regionName = "offHeapDisabledThresholds";
        this.startCacheServer(server1, port1, mcastPort, 0.0f, 0.0f, "offHeapDisabledThresholds", false, false, 0);
        this.startCacheServer(server2, port2, mcastPort, 0.0f, 0.0f, "offHeapDisabledThresholds", false, false, 0);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.setUsageAboveEvictionThreshold(server1, "offHeapDisabledThresholds");
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 0, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 0, true);
        this.setThresholds(server1, 70.0f, 0.0f);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION, 1, true);
        this.setUsageAboveCriticalThreshold(server1, "offHeapDisabledThresholds");
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 0, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 0, true);
        this.setThresholds(server1, 0.0f, 0.0f);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.EVICTION_DISABLED, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.EVICTION_DISABLED, 1, true);
        this.setThresholds(server1, 0.0f, 90.0f);
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsOffHeapDUnitTest.this.getCache()).getResourceManager();
                TestCase.assertEquals((int)0, (int)irm.getStats().getOffHeapEvictionStartEvents());
                TestCase.assertEquals((int)0, (int)irm.getStats().getOffHeapCriticalEvents());
                TestCase.assertEquals((long)0L, (long)irm.getStats().getOffHeapCriticalThreshold());
                TestCase.assertEquals((long)0L, (long)irm.getStats().getOffHeapEvictionThreshold());
                return null;
            }
        });
    }

    private void setUsageAboveCriticalThreshold(VM vm, final String regionName) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedExString);
                Region region = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName);
                if (!region.containsKey((Object)"oh1")) {
                    region.put((Object)"oh5", (Object)new byte[954204]);
                } else {
                    region.put((Object)"oh5", (Object)new byte[122880]);
                }
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedExString);
                return null;
            }
        });
    }

    private void setUsageAboveEvictionThreshold(VM vm, final String regionName) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedBelow);
                Region region = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.put((Object)"oh1", (Object)new byte[245760]);
                region.put((Object)"oh2", (Object)new byte[184320]);
                region.put((Object)"oh3", (Object)new byte[63488]);
                region.put((Object)"oh4", (Object)new byte[378160]);
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedBelow);
                return null;
            }
        });
    }

    private void setUsageBelowEviction(VM vm, final String regionName) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedBelow);
                Region region = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName);
                region.remove((Object)"oh1");
                region.remove((Object)"oh2");
                region.remove((Object)"oh3");
                region.remove((Object)"oh4");
                region.remove((Object)"oh5");
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedBelow);
                return null;
            }
        });
    }

    private void setThresholds(VM server, final float evictionThreshold, final float criticalThreshold) {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ResourceManager irm = MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager();
                irm.setCriticalOffHeapPercentage(criticalThreshold);
                irm.setEvictionOffHeapPercentage(evictionThreshold);
                return null;
            }
        });
    }

    public void testDistributedRegionRemoteClientPutRejection() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int port1 = ports[0];
        int port2 = ports[1];
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        String regionName = "offHeapDRRemoteClientPutReject";
        this.startCacheServer(server1, port1, mcastPort, 0.0f, 0.0f, "offHeapDRRemoteClientPutReject", false, false, 0);
        this.startCacheServer(server2, port2, mcastPort, 0.0f, 90.0f, "offHeapDRRemoteClientPutReject", false, false, 0);
        this.startClient(client, server1, port1, "offHeapDRRemoteClientPutReject");
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.doPuts(client, "offHeapDRRemoteClientPutReject", false, false);
        this.doPutAlls(client, "offHeapDRRemoteClientPutReject", false, false, MemoryThresholdsDUnitTest.Range.DEFAULT);
        this.setUsageAboveCriticalThreshold(server2, "offHeapDRRemoteClientPutReject");
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.doPuts(client, "offHeapDRRemoteClientPutReject", true, false);
        this.doPutAlls(client, "offHeapDRRemoteClientPutReject", true, false, new MemoryThresholdsDUnitTest.Range(MemoryThresholdsDUnitTest.Range.DEFAULT, MemoryThresholdsDUnitTest.Range.DEFAULT.width() + 1));
        this.setUsageBelowEviction(server2, "offHeapDRRemoteClientPutReject");
    }

    public void testDistributedRegionRemotePutRejectionLocalDestroy() throws Exception {
        this.doDistributedRegionRemotePutRejection(true, false);
    }

    public void testDistributedRegionRemotePutRejectionCacheClose() throws Exception {
        this.doDistributedRegionRemotePutRejection(false, true);
    }

    public void testDistributedRegionRemotePutRejectionBelowThreshold() throws Exception {
        this.doDistributedRegionRemotePutRejection(false, false);
    }

    public void testGettersAndSetters() {
        this.getSystem(this.getServerProperties(0));
        ResourceManager rm = this.getCache().getResourceManager();
        MemoryThresholdsOffHeapDUnitTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(rm.getCriticalOffHeapPercentage()));
        MemoryThresholdsOffHeapDUnitTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(rm.getEvictionOffHeapPercentage()));
        rm.setEvictionOffHeapPercentage(50.0f);
        rm.setCriticalOffHeapPercentage(90.0f);
        MemoryThresholdsOffHeapDUnitTest.assertEquals((Object)Float.valueOf(50.0f), (Object)Float.valueOf(rm.getEvictionOffHeapPercentage()));
        MemoryThresholdsOffHeapDUnitTest.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(rm.getCriticalOffHeapPercentage()));
        this.getCache().createRegionFactory(RegionShortcut.REPLICATE_HEAP_LRU).create(this.getName());
        MemoryThresholdsOffHeapDUnitTest.assertEquals((Object)Float.valueOf(50.0f), (Object)Float.valueOf(rm.getEvictionOffHeapPercentage()));
        MemoryThresholdsOffHeapDUnitTest.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(rm.getCriticalOffHeapPercentage()));
    }

    private void doDistributedRegionRemotePutRejection(boolean localDestroy, boolean cacheClose) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int port1 = ports[0];
        int port2 = ports[1];
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        String regionName = "offHeapDRRemotePutRejection";
        this.startCacheServer(server1, port1, mcastPort, 0.0f, 0.0f, "offHeapDRRemotePutRejection", false, false, 0);
        this.startCacheServer(server2, port2, mcastPort, 0.0f, 90.0f, "offHeapDRRemotePutRejection", false, false, 0);
        this.registerTestMemoryThresholdListener(server1);
        this.registerTestMemoryThresholdListener(server2);
        this.doPuts(server1, "offHeapDRRemotePutRejection", false, false);
        this.doPutAlls(server1, "offHeapDRRemotePutRejection", false, false, MemoryThresholdsDUnitTest.Range.DEFAULT);
        this.setUsageAboveCriticalThreshold(server2, "offHeapDRRemotePutRejection");
        this.verifyListenerValue(server1, MemoryThresholds.MemoryState.CRITICAL, 1, true);
        this.verifyListenerValue(server2, MemoryThresholds.MemoryState.CRITICAL, 1, false);
        this.doPuts(server1, "offHeapDRRemotePutRejection", false, true);
        MemoryThresholdsDUnitTest.Range r1 = new MemoryThresholdsDUnitTest.Range(MemoryThresholdsDUnitTest.Range.DEFAULT, MemoryThresholdsDUnitTest.Range.DEFAULT.width() + 1);
        this.doPutAlls(server1, "offHeapDRRemotePutRejection", false, true, r1);
        if (localDestroy) {
            server2.invoke(new SerializableCallable("local destroy"){

                public Object call() throws Exception {
                    Region r = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapDRRemotePutRejection");
                    r.localDestroyRegion();
                    return null;
                }
            });
        } else if (cacheClose) {
            server2.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    MemoryThresholdsOffHeapDUnitTest.this.getCache().close();
                    return null;
                }
            });
        } else {
            this.setUsageBelowEviction(server2, "offHeapDRRemotePutRejection");
        }
        server1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "remote localRegionDestroyed message not received";
                    }

                    @Override
                    public boolean done() {
                        DistributedRegion dr = (DistributedRegion)MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapDRRemotePutRejection");
                        return dr.getMemoryThresholdReachedMembers().size() == 0;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
        this.doPuts(server1, "offHeapDRRemotePutRejection", false, false);
        MemoryThresholdsDUnitTest.Range r2 = new MemoryThresholdsDUnitTest.Range(r1, r1.width() + 1);
        this.doPutAlls(server1, "offHeapDRRemotePutRejection", false, false, r2);
    }

    public void testDRLoadRejection() throws Exception {
        Host host = Host.getHost(0);
        VM replicate1 = host.getVM(1);
        VM replicate2 = host.getVM(2);
        final String rName = this.getUniqueName();
        final int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        AsyncInvocation d1 = replicate1.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        AsyncInvocation d2 = replicate2.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        d1.join();
        MemoryThresholdsOffHeapDUnitTest.assertFalse((boolean)d1.exceptionOccurred());
        d2.join();
        MemoryThresholdsOffHeapDUnitTest.assertFalse((boolean)d2.exceptionOccurred());
        CacheSerializableRunnable establishConnectivity = new CacheSerializableRunnable("establishcConnectivity"){

            @Override
            public void run2() throws CacheException {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getServerProperties(mcastPort));
            }
        };
        replicate1.invoke(establishConnectivity);
        replicate2.invoke(establishConnectivity);
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("create DistributedRegion"){

            @Override
            public void run2() throws CacheException {
                InternalDistributedSystem ds = MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getServerProperties(mcastPort));
                TestCase.assertTrue((ds.getDistributionManager().getNormalDistributionManagerIds().size() >= 1 ? 1 : 0) != 0);
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager();
                irm.setCriticalOffHeapPercentage(90.0f);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                af.setEnableOffHeapMemory(true);
                Region region = MemoryThresholdsOffHeapDUnitTest.this.getCache().createRegion(rName, af.create());
            }
        };
        replicate1.invoke(createRegion);
        replicate2.invoke(createRegion);
        replicate1.invoke(this.addExpectedException);
        replicate2.invoke(this.addExpectedException);
        final Integer expected = (Integer)replicate1.invoke(new SerializableCallable("test Local DistributedRegion Load"){

            public Object call() throws Exception {
                final DistributedRegion r = (DistributedRegion)MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                AttributesMutator am = r.getAttributesMutator();
                am.setCacheLoader((CacheLoader)new CacheLoader<Integer, String>(){
                    final AtomicInteger numLoaderInvocations = new AtomicInteger();

                    public String load(LoaderHelper<Integer, String> helper) throws CacheLoaderException {
                        Integer expectedInvocations = (Integer)helper.getArgument();
                        int actualInvocations = this.numLoaderInvocations.getAndIncrement();
                        if (expectedInvocations != actualInvocations) {
                            throw new CacheLoaderException("Expected " + expectedInvocations + " invocations, actual is " + actualInvocations);
                        }
                        return ((Integer)helper.getKey()).toString();
                    }

                    public void close() {
                    }
                });
                int expectedInvocations = 0;
                OffHeapMemoryMonitor ohmm = ((InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager()).getOffHeapMonitor();
                TestCase.assertFalse((boolean)ohmm.getState().isCritical());
                Integer k = new Integer(1);
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)new Integer(expectedInvocations++)));
                r.put((Object)"oh1", (Object)new byte[838860]);
                r.put((Object)"oh3", (Object)new byte[157287]);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                Integer k2 = new Integer(2);
                TestCase.assertEquals((Object)k2.toString(), (Object)r.get((Object)k2, (Object)new Integer(expectedInvocations++)));
                r.destroy((Object)"oh3");
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return !r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                k2 = new Integer(3);
                TestCase.assertEquals((Object)k2.toString(), (Object)r.get((Object)k2, (Object)new Integer(expectedInvocations++)));
                return new Integer(expectedInvocations);
            }
        });
        CacheSerializableRunnable validateData1 = new CacheSerializableRunnable("Validate data 1"){

            @Override
            public void run2() throws CacheException {
                Region r = MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                Integer i1 = new Integer(1);
                TestCase.assertTrue((boolean)r.containsKey((Object)i1));
                TestCase.assertNotNull((Object)r.getEntry((Object)i1));
                Integer i2 = new Integer(2);
                TestCase.assertFalse((boolean)r.containsKey((Object)i2));
                TestCase.assertNull((Object)r.getEntry((Object)i2));
                Integer i3 = new Integer(3);
                TestCase.assertTrue((boolean)r.containsKey((Object)i3));
                TestCase.assertNotNull((Object)r.getEntry((Object)i3));
            }
        };
        replicate1.invoke(validateData1);
        replicate2.invoke(validateData1);
        replicate2.invoke(new SerializableCallable("test DistributedRegion netLoad"){

            public Object call() throws Exception {
                final DistributedRegion r = (DistributedRegion)MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                OffHeapMemoryMonitor ohmm = ((InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager()).getOffHeapMonitor();
                TestCase.assertFalse((boolean)ohmm.getState().isCritical());
                int expectedInvocations = expected;
                Integer k = new Integer(4);
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)new Integer(expectedInvocations++)));
                r.put((Object)"oh3", (Object)new byte[157287]);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                Integer k2 = new Integer(5);
                TestCase.assertEquals((Object)k2.toString(), (Object)r.get((Object)k2, (Object)new Integer(expectedInvocations++)));
                r.destroy((Object)"oh3");
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return !r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                k2 = new Integer(6);
                TestCase.assertEquals((Object)k2.toString(), (Object)r.get((Object)k2, (Object)new Integer(expectedInvocations++)));
                return new Integer(expectedInvocations);
            }
        });
        replicate1.invoke(this.removeExpectedException);
        replicate2.invoke(this.removeExpectedException);
        CacheSerializableRunnable validateData2 = new CacheSerializableRunnable("Validate data 2"){

            @Override
            public void run2() throws CacheException {
                Region r = MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                Integer i4 = new Integer(4);
                TestCase.assertTrue((boolean)r.containsKey((Object)i4));
                TestCase.assertNotNull((Object)r.getEntry((Object)i4));
                Integer i5 = new Integer(5);
                TestCase.assertFalse((boolean)r.containsKey((Object)i5));
                TestCase.assertNull((Object)r.getEntry((Object)i5));
                Integer i6 = new Integer(6);
                TestCase.assertTrue((boolean)r.containsKey((Object)i6));
                TestCase.assertNotNull((Object)r.getEntry((Object)i6));
            }
        };
        replicate1.invoke(validateData2);
        replicate2.invoke(validateData2);
    }

    public void testPR_RemotePutRejectionLocalDestroy() throws Exception {
        this.prRemotePutRejection(false, true, false);
    }

    public void testPR_RemotePutRejectionCacheClose() throws Exception {
        this.prRemotePutRejection(true, false, false);
    }

    public void testPR_RemotePutRejection() throws Exception {
        this.prRemotePutRejection(false, false, false);
    }

    public void testPR_RemotePutRejectionLocalDestroyWithTx() throws Exception {
        this.prRemotePutRejection(false, true, true);
    }

    public void testPR_RemotePutRejectionCacheCloseWithTx() throws Exception {
        this.prRemotePutRejection(true, false, true);
    }

    public void testPR_RemotePutRejectionWithTx() throws Exception {
        this.prRemotePutRejection(false, false, true);
    }

    private void prRemotePutRejection(boolean cacheClose, boolean localDestroy, final boolean useTx) throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM[] servers = new VM[]{host.getVM(1), host.getVM(2), host.getVM(3)};
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(3);
        final int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        String regionName = "offHeapPRRemotePutRejection";
        boolean redundancy = true;
        this.startCacheServer(servers[0], ports[0], mcastPort, 0.0f, 90.0f, "offHeapPRRemotePutRejection", true, false, 1);
        this.startCacheServer(servers[1], ports[1], mcastPort, 0.0f, 90.0f, "offHeapPRRemotePutRejection", true, false, 1);
        this.startCacheServer(servers[2], ports[2], mcastPort, 0.0f, 90.0f, "offHeapPRRemotePutRejection", true, false, 1);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getServerProperties(mcastPort));
                MemoryThresholdsOffHeapDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                paf.setTotalNumBuckets(11);
                factory.setPartitionAttributes(paf.create());
                factory.setEnableOffHeapMemory(true);
                MemoryThresholdsOffHeapDUnitTest.this.createRegion("offHeapPRRemotePutRejection", factory.create());
                return null;
            }
        });
        this.doPuts(accessor, "offHeapPRRemotePutRejection", false, false);
        MemoryThresholdsDUnitTest.Range r1 = MemoryThresholdsDUnitTest.Range.DEFAULT;
        this.doPutAlls(accessor, "offHeapPRRemotePutRejection", false, false, r1);
        servers[0].invoke(this.addExpectedException);
        servers[1].invoke(this.addExpectedException);
        servers[2].invoke(this.addExpectedException);
        this.setUsageAboveCriticalThreshold(servers[0], "offHeapPRRemotePutRejection");
        final Set criticalMembers = (Set)servers[0].invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapPRRemotePutRejection");
                int hashKey = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)"oh5", null, null);
                return pr.getRegionAdvisor().getBucketOwners(hashKey);
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                final PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapPRRemotePutRejection");
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "remote bucket not marked sick";
                    }

                    @Override
                    public boolean done() {
                        boolean keyFoundOnSickMember = false;
                        boolean caughtException = false;
                        for (int i = 0; i < 20; ++i) {
                            Integer key = i;
                            int hKey = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)key, null, null);
                            Set owners = pr.getRegionAdvisor().getBucketOwners(hKey);
                            boolean hasCriticalOwners = owners.removeAll(criticalMembers);
                            if (hasCriticalOwners) {
                                keyFoundOnSickMember = true;
                                try {
                                    if (useTx) {
                                        MemoryThresholdsOffHeapDUnitTest.this.getCache().getCacheTransactionManager().begin();
                                    }
                                    pr.getCache().getLogger().fine("SWAP:putting in tx:" + useTx);
                                    pr.put((Object)key, (Object)"value");
                                    if (!useTx) continue;
                                    MemoryThresholdsOffHeapDUnitTest.this.getCache().getCacheTransactionManager().commit();
                                }
                                catch (LowMemoryException ex) {
                                    caughtException = true;
                                    if (!useTx) continue;
                                    MemoryThresholdsOffHeapDUnitTest.this.getCache().getCacheTransactionManager().rollback();
                                }
                                continue;
                            }
                            pr.put((Object)key, (Object)"value");
                        }
                        return keyFoundOnSickMember && caughtException;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
        MemoryThresholdsDUnitTest.Range r2 = new MemoryThresholdsDUnitTest.Range(r1, r1.width() + 1);
        this.doPutAlls(accessor, "offHeapPRRemotePutRejection", false, true, r2);
        SerializableCallable getMyId = new SerializableCallable(){

            public Object call() throws Exception {
                return ((GemFireCacheImpl)MemoryThresholdsOffHeapDUnitTest.this.getCache()).getMyId();
            }
        };
        HashSet<VM> criticalServers = new HashSet<VM>();
        for (VM server : servers) {
            DistributedMember member = (DistributedMember)server.invoke(getMyId);
            if (!criticalMembers.contains(member)) continue;
            criticalServers.add(server);
        }
        if (localDestroy) {
            for (VM vm : criticalServers) {
                vm.invoke(new SerializableCallable("local destroy sick member"){

                    public Object call() throws Exception {
                        Region r = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapPRRemotePutRejection");
                        DistributedTestCase.getLogWriter().info("PRLocalDestroy");
                        r.localDestroyRegion();
                        return null;
                    }
                });
            }
        } else if (cacheClose) {
            for (VM vm : criticalServers) {
                vm.invoke(new SerializableCallable("close cache sick member"){

                    public Object call() throws Exception {
                        MemoryThresholdsOffHeapDUnitTest.this.getCache().close();
                        return null;
                    }
                });
            }
        } else {
            this.setUsageBelowEviction(servers[0], "offHeapPRRemotePutRejection");
            servers[0].invoke(this.removeExpectedException);
            servers[1].invoke(this.removeExpectedException);
            servers[2].invoke(this.removeExpectedException);
        }
        accessor.invoke(new SerializableCallable("Put in a loop"){

            public Object call() throws Exception {
                final Region r = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion("offHeapPRRemotePutRejection");
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "pr should have gone un-critical";
                    }

                    @Override
                    public boolean done() {
                        boolean done = true;
                        for (int i = 0; i < 20; ++i) {
                            try {
                                r.put((Object)i, (Object)"value");
                                continue;
                            }
                            catch (LowMemoryException e) {
                                done = false;
                            }
                        }
                        return done;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
        this.doPutAlls(accessor, "offHeapPRRemotePutRejection", false, false, r1);
    }

    public void testPRLoadRejection() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(1);
        VM ds1 = host.getVM(2);
        final String rName = this.getUniqueName();
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        AsyncInvocation d0 = accessor.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        AsyncInvocation d1 = ds1.invokeAsync(DistributedTestCase.class, "disconnectFromDS");
        d0.join();
        MemoryThresholdsOffHeapDUnitTest.assertFalse((boolean)d0.exceptionOccurred());
        d1.join();
        MemoryThresholdsOffHeapDUnitTest.assertFalse((boolean)d1.exceptionOccurred());
        CacheSerializableRunnable establishConnectivity = new CacheSerializableRunnable("establishcConnectivity"){

            @Override
            public void run2() throws CacheException {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem();
            }
        };
        ds1.invoke(establishConnectivity);
        accessor.invoke(establishConnectivity);
        ds1.invoke(this.createPR(rName, false, mcastPort));
        accessor.invoke(this.createPR(rName, true, mcastPort));
        final AtomicInteger expectedInvocations = new AtomicInteger(0);
        Integer ex = (Integer)accessor.invoke(new SerializableCallable("Invoke loader from accessor, non-critical"){

            public Object call() throws Exception {
                Region r = MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                Integer k = new Integer(1);
                Integer expectedInvocations0 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations0)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                Integer expectedInvocations1 = new Integer(expectedInvocations.get());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations1)));
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations1)));
                return expectedInvocations1;
            }
        });
        expectedInvocations.set(ex);
        ex = (Integer)ds1.invoke(new SerializableCallable("Invoke loader from datastore, non-critical"){

            public Object call() throws Exception {
                Region r = MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                Integer k = new Integer(2);
                Integer expectedInvocations1 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations1)));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                Integer expectedInvocations2 = new Integer(expectedInvocations.get());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations2)));
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations2)));
                String oldVal = (String)r.remove((Object)k);
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                TestCase.assertEquals((String)k.toString(), (String)oldVal);
                return expectedInvocations2;
            }
        });
        expectedInvocations.set(ex);
        accessor.invoke(this.addExpectedException);
        ds1.invoke(this.addExpectedException);
        ex = (Integer)ds1.invoke(new SerializableCallable("Set critical state, assert local load behavior"){

            public Object call() throws Exception {
                OffHeapMemoryMonitor ohmm = ((InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager()).getOffHeapMonitor();
                PartitionedRegion pr = (PartitionedRegion)MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                final RegionAdvisor advisor = pr.getRegionAdvisor();
                pr.put((Object)"oh1", (Object)new byte[838860]);
                pr.put((Object)"oh3", (Object)new byte[157287]);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        for (ProxyBucketRegion bucket : advisor.getProxyBucketArray()) {
                            if (!bucket.isBucketSick()) continue;
                            return true;
                        }
                        return false;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                Integer k = new Integer(2);
                Integer expectedInvocations3 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((Object)k.toString(), (Object)pr.get((Object)k, (Object)expectedInvocations3));
                TestCase.assertFalse((boolean)pr.containsKey((Object)k));
                Integer expectedInvocations4 = new Integer(expectedInvocations.getAndIncrement());
                TestCase.assertEquals((Object)k.toString(), (Object)pr.get((Object)k, (Object)expectedInvocations4));
                TestCase.assertFalse((boolean)pr.containsKey((Object)k));
                Integer expectedInvocations5 = new Integer(expectedInvocations.get());
                TestCase.assertEquals((Object)k.toString(), (Object)pr.get((Object)k, (Object)expectedInvocations5));
                TestCase.assertFalse((boolean)pr.containsKey((Object)k));
                return expectedInvocations5;
            }
        });
        expectedInvocations.set(ex);
        ex = (Integer)accessor.invoke(new SerializableCallable("During critical state on datastore, assert accesor load behavior"){

            public Object call() throws Exception {
                Integer k = new Integer(2);
                Integer expectedInvocations6 = new Integer(expectedInvocations.incrementAndGet());
                Region r = MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations6)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                Integer expectedInvocations7 = new Integer(expectedInvocations.incrementAndGet());
                TestCase.assertEquals((String)k.toString(), (String)((String)r.get((Object)k, (Object)expectedInvocations7)));
                TestCase.assertFalse((boolean)r.containsKey((Object)k));
                return expectedInvocations7;
            }
        });
        expectedInvocations.set(ex);
        ex = (Integer)ds1.invoke(new SerializableCallable("Set safe state on datastore, assert local load behavior"){

            public Object call() throws Exception {
                final PartitionedRegion r = (PartitionedRegion)MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                r.destroy((Object)"oh3");
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return !r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                Integer k = new Integer(3);
                Integer expectedInvocations8 = new Integer(expectedInvocations.incrementAndGet());
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)expectedInvocations8));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                return expectedInvocations8;
            }
        });
        expectedInvocations.set(ex);
        accessor.invoke(new SerializableCallable("Data store in safe state, assert load behavior, accessor sets critical state, assert load behavior"){

            public Object call() throws Exception {
                final OffHeapMemoryMonitor ohmm = ((InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager()).getOffHeapMonitor();
                TestCase.assertFalse((boolean)ohmm.getState().isCritical());
                Integer k = new Integer(4);
                Integer expectedInvocations9 = new Integer(expectedInvocations.incrementAndGet());
                final PartitionedRegion r = (PartitionedRegion)MemoryThresholdsOffHeapDUnitTest.this.getCache().getRegion(rName);
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)expectedInvocations9));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)expectedInvocations9));
                r.put((Object)"oh3", (Object)new byte[157287]);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return r.memoryThresholdReached.get();
                    }
                };
                k = new Integer(5);
                Integer expectedInvocations10 = new Integer(expectedInvocations.incrementAndGet());
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)expectedInvocations10));
                TestCase.assertTrue((boolean)r.containsKey((Object)k));
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k, (Object)expectedInvocations10));
                r.destroy((Object)"oh3");
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return !ohmm.getState().isCritical();
                    }
                };
                return expectedInvocations10;
            }
        });
        accessor.invoke(this.removeExpectedException);
        ds1.invoke(this.removeExpectedException);
    }

    private CacheSerializableRunnable createPR(final String rName, final boolean accessor, final int mcastPort) {
        return new CacheSerializableRunnable("create PR accessor"){

            @Override
            public void run2() throws CacheException {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getServerProperties(mcastPort));
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager();
                irm.setCriticalOffHeapPercentage(90.0f);
                AttributesFactory af = new AttributesFactory();
                if (!accessor) {
                    af.setCacheLoader((CacheLoader)new CacheLoader<Integer, String>(){
                        final AtomicInteger numLoaderInvocations = new AtomicInteger();

                        public String load(LoaderHelper<Integer, String> helper) throws CacheLoaderException {
                            Integer expectedInvocations = (Integer)helper.getArgument();
                            int actualInvocations = this.numLoaderInvocations.getAndIncrement();
                            if (expectedInvocations != actualInvocations) {
                                throw new CacheLoaderException("Expected " + expectedInvocations + " invocations, actual is " + actualInvocations);
                            }
                            return ((Integer)helper.getKey()).toString();
                        }

                        public void close() {
                        }
                    });
                    af.setPartitionAttributes(new PartitionAttributesFactory().create());
                } else {
                    af.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).create());
                }
                af.setEnableOffHeapMemory(true);
                MemoryThresholdsOffHeapDUnitTest.this.getCache().createRegion(rName, af.create());
            }
        };
    }

    public void testLRLoadRejection() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(2);
        final String rName = this.getUniqueName();
        final int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        vm.invoke(DistributedTestCase.class, "disconnectFromDS");
        vm.invoke(new CacheSerializableRunnable("test LocalRegion load passthrough when critical"){

            @Override
            public void run2() throws CacheException {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getServerProperties(mcastPort));
                InternalResourceManager irm = (InternalResourceManager)MemoryThresholdsOffHeapDUnitTest.this.getCache().getResourceManager();
                OffHeapMemoryMonitor ohmm = irm.getOffHeapMonitor();
                irm.setCriticalOffHeapPercentage(90.0f);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.LOCAL);
                af.setEnableOffHeapMemory(true);
                final AtomicInteger numLoaderInvocations = new AtomicInteger();
                af.setCacheLoader((CacheLoader)new CacheLoader<Integer, String>(){

                    public String load(LoaderHelper<Integer, String> helper) throws CacheLoaderException {
                        numLoaderInvocations.incrementAndGet();
                        return ((Integer)helper.getKey()).toString();
                    }

                    public void close() {
                    }
                });
                final LocalRegion r = (LocalRegion)MemoryThresholdsOffHeapDUnitTest.this.getCache().createRegion(rName, af.create());
                TestCase.assertFalse((boolean)ohmm.getState().isCritical());
                int expectedInvocations = 0;
                TestCase.assertEquals((int)expectedInvocations++, (int)numLoaderInvocations.get());
                Integer k = new Integer(1);
                TestCase.assertEquals((Object)k.toString(), (Object)r.get((Object)k));
                TestCase.assertEquals((int)expectedInvocations++, (int)numLoaderInvocations.get());
                ++expectedInvocations;
                r.getAll(MemoryThresholdsOffHeapDUnitTest.createRanges(10, 12));
                int n = ++expectedInvocations;
                TestCase.assertEquals((int)n, (int)numLoaderInvocations.get());
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedExString);
                r.put((Object)"oh1", (Object)new byte[838860]);
                r.put((Object)"oh3", (Object)new byte[157287]);
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedExString);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                Integer k2 = new Integer(2);
                TestCase.assertEquals((Object)k2.toString(), (Object)r.get((Object)k2));
                int n2 = ++expectedInvocations;
                ++expectedInvocations;
                TestCase.assertEquals((int)n2, (int)numLoaderInvocations.get());
                ++expectedInvocations;
                r.getAll(MemoryThresholdsOffHeapDUnitTest.createRanges(13, 15));
                int n3 = ++expectedInvocations;
                TestCase.assertEquals((int)n3, (int)numLoaderInvocations.get());
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedBelow);
                r.destroy((Object)"oh3");
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedBelow);
                wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify critical state";
                    }

                    @Override
                    public boolean done() {
                        return !r.memoryThresholdReached.get();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 100L, true);
                k2 = new Integer(3);
                TestCase.assertEquals((Object)k2.toString(), (Object)r.get((Object)k2));
                int n4 = ++expectedInvocations;
                ++expectedInvocations;
                TestCase.assertEquals((int)n4, (int)numLoaderInvocations.get());
                ++expectedInvocations;
                r.getAll(MemoryThresholdsOffHeapDUnitTest.createRanges(16, 18));
                TestCase.assertEquals((int)(++expectedInvocations), (int)numLoaderInvocations.get());
                for (Integer i : MemoryThresholdsOffHeapDUnitTest.createRanges(2, 2, 13, 15)) {
                    if (r.containsKey((Object)i)) {
                        TestCase.fail((String)("Expected containsKey return false for key" + i));
                    }
                    if (r.getEntry((Object)i) == null) continue;
                    TestCase.fail((String)("Expected getEntry to return null for key" + i));
                }
            }
        });
    }

    public static List<Integer> createRanges(int ... startEnds) {
        assert (startEnds.length % 2 == 0);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int si = 0; si < startEnds.length; ++si) {
            int start = startEnds[si++];
            int end = startEnds[si];
            assert (end >= start);
            ret.ensureCapacity(ret.size() + (end - start + 1));
            for (int i = start; i <= end; ++i) {
                ret.add(new Integer(i));
            }
        }
        return ret;
    }

    public void testCleanAdvisorClose() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(3);
        int port1 = ports[0];
        int port2 = ports[1];
        int port3 = ports[2];
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        String regionName = "testEventOrger";
        this.startCacheServer(server1, port1, mcastPort, 0.0f, 0.0f, "testEventOrger", false, false, 0);
        this.startCacheServer(server2, port2, mcastPort, 0.0f, 0.0f, "testEventOrger", false, false, 0);
        this.verifyProfiles(server1, 1);
        this.verifyProfiles(server2, 1);
        server2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        });
        this.verifyProfiles(server1, 0);
        this.startCacheServer(server3, port3, mcastPort, 0.0f, 0.0f, "testEventOrger", false, false, 0);
        this.verifyProfiles(server1, 1);
        this.verifyProfiles(server3, 1);
    }

    public void testPRClientPutRejection() throws Exception {
        this.doClientServerTest("parRegReject", true);
    }

    public void testDistributedRegionClientPutRejection() throws Exception {
        this.doClientServerTest("distrReject", false);
    }

    private void doPuts(VM vm, final String regionName, final boolean catchServerException, final boolean catchLowMemoryException) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                block6: {
                    Region r = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName);
                    try {
                        r.put((Object)0, (Object)"value-1");
                        if (catchServerException || catchLowMemoryException) {
                            TestCase.fail((String)"An expected ResourceException was not thrown");
                        }
                    }
                    catch (ServerOperationException ex) {
                        if (!catchServerException) {
                            DistributedTestCase.fail("Unexpected exception: ", ex);
                        }
                        if (!(ex.getCause() instanceof LowMemoryException)) {
                            DistributedTestCase.fail("Unexpected exception: ", ex);
                        }
                    }
                    catch (LowMemoryException low) {
                        if (catchLowMemoryException) break block6;
                        DistributedTestCase.fail("Unexpected exception: ", low);
                    }
                }
                return null;
            }
        });
    }

    private void doPutAlls(VM vm, final String regionName, final boolean catchServerException, final boolean catchLowMemoryException, final MemoryThresholdsDUnitTest.Range rng) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName);
                HashMap<Integer, String> temp = new HashMap<Integer, String>();
                for (int i = rng.start; i < rng.end; ++i) {
                    Integer k = i;
                    temp.put(k, "value-" + i);
                }
                try {
                    r.putAll(temp);
                    if (catchServerException || catchLowMemoryException) {
                        TestCase.fail((String)"An expected ResourceException was not thrown");
                    }
                    for (Map.Entry me : temp.entrySet()) {
                        TestCase.assertEquals(me.getValue(), (Object)r.get(me.getKey()));
                    }
                }
                catch (ServerOperationException ex) {
                    if (!catchServerException) {
                        DistributedTestCase.fail("Unexpected exception: ", ex);
                    }
                    if (!(ex.getCause() instanceof LowMemoryException)) {
                        DistributedTestCase.fail("Unexpected exception: ", ex);
                    }
                    for (Integer me : temp.keySet()) {
                        TestCase.assertFalse((String)("Key " + me + " should not exist"), (boolean)r.containsKey((Object)me));
                    }
                }
                catch (LowMemoryException low) {
                    DistributedTestCase.getLogWriter().info("Caught LowMemoryException", (Throwable)low);
                    if (!catchLowMemoryException) {
                        DistributedTestCase.fail("Unexpected exception: ", low);
                    }
                    for (Integer me : temp.keySet()) {
                        TestCase.assertFalse((String)("Key " + me + " should not exist"), (boolean)r.containsKey((Object)me));
                    }
                }
                return null;
            }
        });
    }

    private void doClientServerTest(final String regionName, boolean createPR) throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        int port = AvailablePortHelper.getRandomAvailableTCPPort();
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        this.startCacheServer(server, port, mcastPort, 0.0f, 90.0f, regionName, createPR, false, 0);
        this.startClient(client, server, port, regionName);
        this.doPuts(client, regionName, false, false);
        this.doPutAlls(client, regionName, false, false, MemoryThresholdsDUnitTest.Range.DEFAULT);
        server.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedExString);
                MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName).put((Object)1, (Object)new byte[943720]);
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLoggerI18n().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedExString);
            }
        });
        this.doPuts(client, regionName, true, false);
        this.doPutAlls(client, regionName, true, false, new MemoryThresholdsDUnitTest.Range(MemoryThresholdsDUnitTest.Range.DEFAULT, MemoryThresholdsDUnitTest.Range.DEFAULT.width() + 1));
        server.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLogger().fine(MemoryThresholdsOffHeapDUnitTest.this.addExpectedBelow);
                MemoryThresholdsOffHeapDUnitTest.this.getRootRegion().getSubregion(regionName).destroy((Object)1);
                MemoryThresholdsOffHeapDUnitTest.this.getCache().getLogger().fine(MemoryThresholdsOffHeapDUnitTest.this.removeExpectedBelow);
            }
        });
    }

    private void registerTestMemoryThresholdListener(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TestMemoryThresholdListener listener = new TestMemoryThresholdListener();
                InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsOffHeapDUnitTest.this.getCache()).getResourceManager();
                irm.addResourceListener(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, (ResourceListener)listener);
                TestCase.assertTrue((boolean)irm.getResourceListeners(InternalResourceManager.ResourceType.OFFHEAP_MEMORY).contains(listener));
                return null;
            }
        });
    }

    private void startCacheServer(VM server, final int port, final int mcastPort, final float evictionThreshold, final float criticalThreshold, final String regionName, final boolean createPR, final boolean notifyBySubscription, final int prRedundancy) throws Exception {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getServerProperties(mcastPort));
                GemFireCacheImpl cache = (GemFireCacheImpl)MemoryThresholdsOffHeapDUnitTest.this.getCache();
                InternalResourceManager irm = cache.getResourceManager();
                irm.setEvictionOffHeapPercentage(evictionThreshold);
                irm.setCriticalOffHeapPercentage(criticalThreshold);
                AttributesFactory factory = new AttributesFactory();
                if (createPR) {
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(prRedundancy);
                    paf.setTotalNumBuckets(11);
                    factory.setPartitionAttributes(paf.create());
                    factory.setEnableOffHeapMemory(true);
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    factory.setEnableOffHeapMemory(true);
                }
                Region region = MemoryThresholdsOffHeapDUnitTest.this.createRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
                CacheServer cacheServer = MemoryThresholdsOffHeapDUnitTest.this.getCache().addCacheServer();
                cacheServer.setPort(port);
                cacheServer.setNotifyBySubscription(notifyBySubscription);
                cacheServer.start();
                return null;
            }
        });
    }

    private void startClient(VM client, final VM server, final int serverPort, final String regionName) {
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                MemoryThresholdsOffHeapDUnitTest.this.getSystem(MemoryThresholdsOffHeapDUnitTest.this.getClientProps());
                MemoryThresholdsOffHeapDUnitTest.this.getCache();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(server.getHost()), serverPort);
                pf.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.LOCAL);
                af.setPoolName("pool1");
                MemoryThresholdsOffHeapDUnitTest.this.createRegion(regionName, af.create());
                return null;
            }
        });
    }

    private void verifyListenerValue(VM vm, final MemoryThresholds.MemoryState state, final int value, final boolean useWaitCriterion) {
        vm.invoke(new SerializableCallable(){
            private static final long serialVersionUID = 1L;

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = null;
                Set listeners = MemoryThresholdsOffHeapDUnitTest.this.getGemfireCache().getResourceManager().getResourceListeners(InternalResourceManager.ResourceType.OFFHEAP_MEMORY);
                TestMemoryThresholdListener tmp_listener = null;
                for (ResourceListener l : listeners) {
                    if (!(l instanceof TestMemoryThresholdListener)) continue;
                    tmp_listener = (TestMemoryThresholdListener)l;
                    break;
                }
                final TestMemoryThresholdListener listener = tmp_listener == null ? null : tmp_listener;
                switch (state) {
                    case CRITICAL: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote CRITICAL assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getCriticalThresholdCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getCriticalThresholdCalls());
                        break;
                    }
                    case CRITICAL_DISABLED: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote CRITICAL_DISABLED assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getCriticalDisabledCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getCriticalDisabledCalls());
                        break;
                    }
                    case EVICTION: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote EVICTION assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getEvictionThresholdCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getEvictionThresholdCalls());
                        break;
                    }
                    case EVICTION_DISABLED: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote EVICTION_DISABLED assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getEvictionDisabledCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getEvictionDisabledCalls());
                        break;
                    }
                    case NORMAL: {
                        if (useWaitCriterion) {
                            wc = new DistributedTestCase.WaitCriterion(){

                                @Override
                                public String description() {
                                    return "Remote NORMAL assert failed " + listener.toString();
                                }

                                @Override
                                public boolean done() {
                                    return value == listener.getNormalCalls();
                                }
                            };
                            break;
                        }
                        TestCase.assertEquals((int)value, (int)listener.getNormalCalls());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown memory state");
                    }
                }
                if (useWaitCriterion) {
                    DistributedTestCase.waitForCriterion(wc, 5000L, 100L, true);
                }
                return null;
            }
        });
    }

    private void verifyProfiles(VM vm, final int numberOfProfiles) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalResourceManager irm = ((GemFireCacheImpl)MemoryThresholdsOffHeapDUnitTest.this.getCache()).getResourceManager();
                final ResourceAdvisor ra = irm.getResourceAdvisor();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public String description() {
                        return "verify profiles failed. Current profiles: " + ra.adviseGeneric();
                    }

                    @Override
                    public boolean done() {
                        return numberOfProfiles == ra.adviseGeneric().size();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 10L, true);
                return null;
            }
        });
    }

    private Properties getServerProperties(int mcastPort) {
        Properties p = new Properties();
        p.setProperty("mcast-port", mcastPort + "");
        p.setProperty("locators", "");
        p.setProperty("off-heap-memory-size", "1m");
        return p;
    }

    protected Properties getClientProps() {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("locators", "");
        return p;
    }
}

