/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal.hoplog;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.BaseHoplogTestCase;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HdfsSortedOplogOrganizer;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.ShutdownHookManager;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class HdfsErrorHandlingJunitTest
extends BaseHoplogTestCase {
    MiniDFSCluster cluster;
    private String HDFS_DIR = "hdfs-test-cluster";
    private int CLUSTER_PORT = AvailablePortHelper.getRandomAvailableTCPPort();
    private File configFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache.getLogger().info("<ExpectedException action=add>java.io.IOException</ExpectedException>");
    }

    public void test000HoplogDeletionOnFailure() throws Exception {
        int i;
        Configuration hconf = this.getMiniClusterConf();
        hconf.setInt("dfs.datanode.max.transfer.threads", 1);
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        final AtomicInteger errorCount = new AtomicInteger(0);
        AtomicInteger hoplogCount = new AtomicInteger(0);
        Thread[] clients = new Thread[2];
        for (i = 0; i < clients.length; ++i) {
            class Client
            implements Runnable {
                private int num;

                public Client(int i) {
                    this.num = i;
                }

                @Override
                public void run() {
                    HdfsErrorHandlingJunitTest.this.cache.getLogger().info("<ExpectedException action=add>PriviledgedActionException</ExpectedException>");
                    HdfsErrorHandlingJunitTest.this.cache.getLogger().info("<ExpectedException action=add>java.io.FileNotFoundException</ExpectedException>");
                    try {
                        byte[] keyBytes1 = BlobHelper.serializeToBlob((Object)"key-1");
                        HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(HdfsErrorHandlingJunitTest.this.regionManager, this.num);
                        try {
                            int count = 50000;
                            ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
                            String value = this.getlongString();
                            for (int i = 0; i < count; ++i) {
                                items.add(new BaseHoplogTestCase.TestEvent("key-" + i, value + System.nanoTime()));
                            }
                            HdfsErrorHandlingJunitTest.this.cache.getLogger().info("<ExpectedException action=add>java.io.IOException</ExpectedException>");
                            organizer.flush(items.iterator(), count);
                        }
                        catch (Exception e) {
                            errorCount.incrementAndGet();
                            TestCase.assertNull((Object)organizer.read((Object)keyBytes1));
                        }
                        HdfsErrorHandlingJunitTest.this.cache.getLogger().info("<ExpectedException action=remove>java.io.IOException</ExpectedException>");
                        HdfsErrorHandlingJunitTest.this.cache.getLogger().info("<ExpectedException action=remove>PriviledgedActionException</ExpectedException>");
                        HdfsErrorHandlingJunitTest.this.cache.getLogger().info("<ExpectedException action=remove>java.io.FileNotFoundException</ExpectedException>");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                private String getlongString() {
                    String value = "v";
                    for (int i = 0; i < 2048; ++i) {
                        value = value + "v";
                    }
                    return value;
                }
            }
            clients[i] = new Thread(new Client(i));
        }
        for (i = 0; i < clients.length; ++i) {
            clients[i].start();
        }
        for (i = 0; i < clients.length; ++i) {
            clients[i].join();
        }
        HdfsErrorHandlingJunitTest.assertEquals((int)(clients.length - 1), (int)errorCount.get());
        for (int num = 0; num < clients.length; ++num) {
            HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, num);
            organizer.performMaintenance();
            FileStatus[] hoplogs = this.getBucketHoplogs(this.getName() + "/" + num, "");
            hoplogCount.addAndGet(hoplogs.length);
        }
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)hoplogCount.get());
    }

    public void test001DirectDirDeletion() throws Exception {
        Configuration hconf = this.getMiniClusterConf();
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        byte[] keyBytes1 = BlobHelper.serializeToBlob((Object)"key-1");
        HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, 1);
        int count = 10;
        ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
        for (int i = 0; i < count; ++i) {
            items.add(new BaseHoplogTestCase.TestEvent("key-" + i, "value-" + System.nanoTime()));
        }
        organizer.flush(items.iterator(), count);
        HdfsErrorHandlingJunitTest.assertTrue((boolean)((String)((SortedHoplogPersistedEvent)organizer.read((Object)keyBytes1)).getValue()).startsWith("value-"));
        FileStatus[] hoplogs = this.getBucketHoplogs(this.getName() + "/" + 1, "");
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)hoplogs.length);
        FileStatus[] testDir = this.cluster.getFileSystem().listStatus(this.testDataDir);
        HdfsErrorHandlingJunitTest.assertNotNull((Object)testDir);
        HdfsErrorHandlingJunitTest.assertEquals((int)2, (int)testDir.length);
        this.cluster.getFileSystem().delete(this.testDataDir, true);
        organizer.flush(items.iterator(), count);
        hoplogs = this.getBucketHoplogs(this.getName() + "/" + 1, "");
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)hoplogs.length);
    }

    public void test002MaxHdfsOpenFiles() throws Exception {
        Configuration hconf = this.getMiniClusterConf();
        hconf.setInt("dfs.datanode.max.transfer.threads", 5);
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        HdfsSortedOplogOrganizer bucket1 = new HdfsSortedOplogOrganizer(this.regionManager, 1);
        HdfsSortedOplogOrganizer bucket2 = new HdfsSortedOplogOrganizer(this.regionManager, 2);
        int count = 10;
        ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
        for (int j = 0; j < 3; ++j) {
            items.clear();
            for (int i = 0; i < count; ++i) {
                items.add(new BaseHoplogTestCase.TestEvent("key-" + j + "-" + i, "value"));
            }
            bucket1.flush(items.iterator(), count);
            bucket2.flush(items.iterator(), count);
        }
        byte[] keyBytes = BlobHelper.serializeToBlob((Object)"key-0-1");
        HdfsErrorHandlingJunitTest.assertTrue((boolean)((String)bucket1.read(keyBytes).getValue()).equals("value"));
        this.cache.getLogger().info("<ExpectedException action=add>java.io.EOFException</ExpectedException>");
        this.cache.getLogger().info("<ExpectedException action=add>org.apache.hadoop.hdfs.BlockMissingException</ExpectedException>");
        try {
            HdfsErrorHandlingJunitTest.assertTrue((boolean)((String)bucket2.read(keyBytes).getValue()).equals("value"));
            HdfsErrorHandlingJunitTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cache.getLogger().info("<ExpectedException action=remove>java.io.EOFException</ExpectedException>");
        this.cache.getLogger().info("<ExpectedException action=remove>org.apache.hadoop.hdfs.BlockMissingException</ExpectedException>");
        bucket1.close();
        bucket2.close();
        System.setProperty("hoplog.bucket.max.open.files", "1");
        bucket1 = new HdfsSortedOplogOrganizer(this.regionManager, 1);
        bucket2 = new HdfsSortedOplogOrganizer(this.regionManager, 2);
        HdfsErrorHandlingJunitTest.assertTrue((boolean)((String)bucket1.read(keyBytes).getValue()).equals("value"));
        HdfsErrorHandlingJunitTest.assertTrue((boolean)((String)bucket2.read(keyBytes).getValue()).equals("value"));
    }

    public void test003DataReadErrorByFSClose() throws Exception {
        Configuration hconf = this.getMiniClusterConf();
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        this.hdfsStore.getFileSystem().delete(this.testDataDir, true);
        HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, 0);
        ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
        items.add(new BaseHoplogTestCase.TestEvent("1", "1-1"));
        items.add(new BaseHoplogTestCase.TestEvent("4", "1-4"));
        organizer.flush(items.iterator(), items.size());
        byte[] keyBytes = BlobHelper.serializeToBlob((Object)"1");
        List list = organizer.getSortedOplogs();
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)list.size());
        Hoplog hoplog = (Hoplog)((TrackedReference)list.get(0)).get();
        Hoplog.HoplogReader reader = hoplog.getReader();
        reader.getBloomFilter().mightContain(keyBytes);
        ShutdownHookManager mgr = ShutdownHookManager.get();
        Field field = ShutdownHookManager.class.getDeclaredField("shutdownInProgress");
        field.setAccessible(true);
        field.set(mgr, new AtomicBoolean(true));
        this.hdfsStore.getFileSystem().close();
        this.hdfsStore = null;
        try {
            HdfsErrorHandlingJunitTest.assertTrue((boolean)reader.getBloomFilter().mightContain(keyBytes));
            organizer.read(keyBytes);
            HdfsErrorHandlingJunitTest.fail();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        field.set(mgr, new AtomicBoolean(false));
    }

    public void test004ScanReadErrorByFSClose() throws Exception {
        Configuration hconf = this.getMiniClusterConf();
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        this.hdfsStore.getFileSystem().delete(this.testDataDir, true);
        HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, 0);
        ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
        items.add(new BaseHoplogTestCase.TestEvent("1", "1-1"));
        items.add(new BaseHoplogTestCase.TestEvent("4", "1-4"));
        organizer.flush(items.iterator(), items.size());
        byte[] keyBytes = BlobHelper.serializeToBlob((Object)"1");
        List list = organizer.getSortedOplogs();
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)list.size());
        Hoplog hoplog = (Hoplog)((TrackedReference)list.get(0)).get();
        Hoplog.HoplogReader reader = hoplog.getReader();
        reader.getBloomFilter().mightContain(keyBytes);
        ShutdownHookManager mgr = ShutdownHookManager.get();
        Field field = ShutdownHookManager.class.getDeclaredField("shutdownInProgress");
        field.setAccessible(true);
        field.set(mgr, new AtomicBoolean(true));
        this.hdfsStore.getFileSystem().close();
        this.hdfsStore = null;
        try {
            HdfsErrorHandlingJunitTest.assertTrue((boolean)reader.getBloomFilter().mightContain(keyBytes));
            organizer.scan();
            HdfsErrorHandlingJunitTest.fail();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        field.set(mgr, new AtomicBoolean(false));
    }

    public void test005BloomReadErrorByFSClose() throws Exception {
        Configuration hconf = this.getMiniClusterConf();
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        this.hdfsStore.getFileSystem().delete(this.testDataDir, true);
        HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, 0);
        ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
        items.add(new BaseHoplogTestCase.TestEvent("1", "1-1"));
        items.add(new BaseHoplogTestCase.TestEvent("4", "1-4"));
        organizer.flush(items.iterator(), items.size());
        List list = organizer.getSortedOplogs();
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)list.size());
        Hoplog hoplog = (Hoplog)((TrackedReference)list.get(0)).get();
        Hoplog.HoplogReader reader = hoplog.getReader();
        ShutdownHookManager mgr = ShutdownHookManager.get();
        Field field = ShutdownHookManager.class.getDeclaredField("shutdownInProgress");
        field.setAccessible(true);
        field.set(mgr, new AtomicBoolean(true));
        this.hdfsStore.getFileSystem().close();
        this.hdfsStore = null;
        byte[] keyBytes = BlobHelper.serializeToBlob((Object)"1");
        try {
            organizer.read(keyBytes);
            HdfsErrorHandlingJunitTest.fail();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        field.set(mgr, new AtomicBoolean(false));
    }

    public void test006HopCloseErrorByFSClose() throws Exception {
        Configuration hconf = this.getMiniClusterConf();
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        this.hdfsStore.getFileSystem().delete(this.testDataDir, true);
        HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, 0);
        ArrayList<BaseHoplogTestCase.TestEvent> items = new ArrayList<BaseHoplogTestCase.TestEvent>();
        items.add(new BaseHoplogTestCase.TestEvent("1", "1-1"));
        items.add(new BaseHoplogTestCase.TestEvent("4", "1-4"));
        organizer.flush(items.iterator(), items.size());
        byte[] keyBytes = BlobHelper.serializeToBlob((Object)"1");
        HdfsErrorHandlingJunitTest.assertNotNull((Object)organizer.read(keyBytes));
        ShutdownHookManager mgr = ShutdownHookManager.get();
        Field field = ShutdownHookManager.class.getDeclaredField("shutdownInProgress");
        field.setAccessible(true);
        field.set(mgr, new AtomicBoolean(true));
        this.hdfsStore.getFileSystem().close();
        this.hdfsStore = null;
        organizer.close();
        field.set(mgr, new AtomicBoolean(false));
    }

    public void test007HopWriteErrByClusterDown() throws Exception {
        this.cache.getLogger().info("<ExpectedException action=add>java.io.IOException</ExpectedException>");
        this.cache.getLogger().info("<ExpectedException action=add>java.lang.InterruptedException</ExpectedException>");
        Configuration hconf = this.getMiniClusterConf();
        final AtomicInteger counter = new AtomicInteger(100);
        int numDataNodes = 1;
        this.initMiniCluster(hconf, numDataNodes);
        this.hdfsStore.getFileSystem().delete(this.testDataDir, true);
        final HdfsSortedOplogOrganizer organizer = new HdfsSortedOplogOrganizer(this.regionManager, 0);
        class MyIter
        implements Iterator<BaseHoplogTestCase.TestEvent> {
            MyIter() {
            }

            @Override
            public boolean hasNext() {
                return counter.get() >= 0;
            }

            @Override
            public BaseHoplogTestCase.TestEvent next() {
                try {
                    int i = counter.incrementAndGet();
                    i = i > 0 ? i : 1000;
                    BaseHoplogTestCase.TestEvent event = new BaseHoplogTestCase.TestEvent("" + i, "" + System.currentTimeMillis());
                    TimeUnit.MILLISECONDS.sleep(20L);
                    return event;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public void remove() {
            }
        }
        final MyIter iter = new MyIter();
        final AtomicInteger status = new AtomicInteger(0);
        Executors.newSingleThreadScheduledExecutor().execute(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    organizer.flush((Iterator)iter, 100);
                    status.set(-1);
                }
                catch (IOException e) {
                    status.set(1);
                    return;
                }
                catch (Exception e) {
                    status.set(-1);
                }
            }
        });
        while (counter.get() < 105) {
            TimeUnit.MILLISECONDS.sleep(20L);
        }
        this.cluster.shutdown();
        this.cluster = null;
        counter.set(-100);
        for (int wait = 0; status.get() == 0 && wait < 1000; wait += 20) {
            TimeUnit.MILLISECONDS.sleep(20L);
        }
        HdfsErrorHandlingJunitTest.assertEquals((int)1, (int)status.get());
        this.cache.getLogger().info("<ExpectedException action=remove>java.io.IOException</ExpectedException>");
        this.cache.getLogger().info("<ExpectedException action=remove>java.lang.InterruptedException</ExpectedException>");
        this.initMiniCluster(hconf, 1);
    }

    private Configuration getMiniClusterConf() {
        System.setProperty("test.build.data", this.HDFS_DIR);
        HdfsConfiguration hconf = new HdfsConfiguration();
        hconf.setInt("dfs.replication", 1);
        return hconf;
    }

    private void initMiniCluster(Configuration hconf, int numDataNodes) throws IOException {
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hconf);
        builder.numDataNodes(numDataNodes);
        builder.nameNodePort(this.CLUSTER_PORT);
        this.cluster = builder.build();
    }

    protected void configureHdfsStoreFactory() throws Exception {
        super.configureHdfsStoreFactory();
        this.configFile = new File("testMaxHdfsOpenFiles-config");
        String hadoopClientConf = "<configuration>\n  <property>\n    <name>dfs.client.max.block.acquire.failures</name>\n    <value>0</value>\n  </property>\n  <property>\n    <name>dfs.client.retry.window.base</name>\n    <value>10</value>\n  </property>\n</configuration>";
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.configFile));
        bw.write(hadoopClientConf);
        bw.close();
        this.hsf.setNameNodeURL("hdfs://127.0.0.1:" + this.CLUSTER_PORT);
        this.hsf.setHDFSClientConfigFile("testMaxHdfsOpenFiles-config");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = null;
        FileUtils.deleteDirectory((File)new File(this.HDFS_DIR));
        this.configFile.delete();
        this.cache.getLogger().info("<ExpectedException action=remove>java.io.IOException</ExpectedException>");
    }
}

