/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributesFactory;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.internal.RegionWithHDFSTestBase;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.AsyncInvocation;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ColocatedRegionWithHDFSDUnitTest
extends RegionWithHDFSTestBase {
    public ColocatedRegionWithHDFSDUnitTest(String name) {
        super(name);
    }

    @Override
    protected SerializableCallable getCreateRegionCallable(final int totalnumOfBuckets, final int batchSizeMB, final int maximumEntries, final String folderPath, final String uniqueName, final int batchInterval, final boolean queuePersistent, final boolean writeonly, long timeForRollover, long maxFileSize) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                HDFSEventQueueAttributesFactory hqf = new HDFSEventQueueAttributesFactory();
                hqf.setBatchSizeMB(batchSizeMB);
                hqf.setPersistent(queuePersistent);
                hqf.setMaximumQueueMemory(3);
                hqf.setBatchTimeInterval(batchInterval);
                HDFSStoreFactory hsf = ColocatedRegionWithHDFSDUnitTest.this.getCache().createHDFSStoreFactory();
                String homeDir = ColocatedRegionWithHDFSDUnitTest.this.tmpDir + "/" + folderPath;
                hsf.setHomeDir(homeDir);
                hsf.setHDFSEventQueueAttributes(hqf.create());
                hsf.create(uniqueName);
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.HDFS_PARTITION);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(totalnumOfBuckets);
                paf.setRedundantCopies(1);
                af.setHDFSStoreName(uniqueName);
                af.setPartitionAttributes(paf.create());
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                af.setHDFSWriteOnly(writeonly);
                Region r1 = ColocatedRegionWithHDFSDUnitTest.this.createRootRegion(uniqueName + "-r1", af.create());
                paf.setColocatedWith(uniqueName + "-r1");
                af.setPartitionAttributes(paf.create());
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maximumEntries, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                Region r2 = ColocatedRegionWithHDFSDUnitTest.this.createRootRegion(uniqueName + "-r2", af.create());
                ((LocalRegion)r1).setIsTest();
                ((LocalRegion)r2).setIsTest();
                return 0;
            }
        };
        return createRegion;
    }

    @Override
    protected void doPuts(String uniqueName, int start, int end) {
        Region r1 = this.getRootRegion(uniqueName + "-r1");
        Region r2 = this.getRootRegion(uniqueName + "-r2");
        for (int i = start; i < end; ++i) {
            r1.put((Object)("K" + i), (Object)("V" + i));
            r2.put((Object)("K" + i), (Object)("V" + i));
        }
    }

    @Override
    protected AsyncInvocation doAsyncPuts(VM vm, final String regionName, final int start, final int end, final String suffix) throws Exception {
        return vm.invokeAsync(new SerializableCallable(){

            public Object call() throws Exception {
                Region r1 = ColocatedRegionWithHDFSDUnitTest.this.getRootRegion(regionName + "-r1");
                Region r2 = ColocatedRegionWithHDFSDUnitTest.this.getRootRegion(regionName + "-r2");
                ColocatedRegionWithHDFSDUnitTest.this.getCache().getLogger().info("Putting entries ");
                for (int i = start; i < end; ++i) {
                    r1.put((Object)("K" + i), (Object)("V" + i + suffix));
                    r2.put((Object)("K" + i), (Object)("V" + i + suffix));
                }
                return null;
            }
        });
    }

    @Override
    protected void doPutAll(String uniqueName, Map map) {
        Region r1 = this.getRootRegion(uniqueName + "-r1");
        Region r2 = this.getRootRegion(uniqueName + "-r2");
        r1.putAll(map);
        r2.putAll(map);
    }

    @Override
    protected void doDestroys(String uniqueName, int start, int end) {
        Region r1 = this.getRootRegion(uniqueName + "-r1");
        Region r2 = this.getRootRegion(uniqueName + "-r2");
        for (int i = start; i < end; ++i) {
            r1.destroy((Object)("K" + i));
            r2.destroy((Object)("K" + i));
        }
    }

    @Override
    protected void checkWithGet(String uniqueName, int start, int end, boolean expectValue) {
        Region r1 = this.getRootRegion(uniqueName + "-r1");
        Region r2 = this.getRootRegion(uniqueName + "-r2");
        for (int i = start; i < end; ++i) {
            String expected = expectValue ? "V" + i : null;
            ColocatedRegionWithHDFSDUnitTest.assertEquals((String)("Mismatch on key " + i), (Object)expected, (Object)r1.get((Object)("K" + i)));
            ColocatedRegionWithHDFSDUnitTest.assertEquals((String)("Mismatch on key " + i), (Object)expected, (Object)r2.get((Object)("K" + i)));
        }
    }

    @Override
    protected void checkWithGetAll(String uniqueName, ArrayList arrayl) {
        Region r1 = this.getRootRegion(uniqueName + "-r1");
        Region r2 = this.getRootRegion(uniqueName + "-r2");
        Map map1 = r1.getAll((Collection)arrayl);
        Map map2 = r2.getAll((Collection)arrayl);
        for (Object e : map1.keySet()) {
            String v = e.toString().replaceFirst("K", "V");
            ColocatedRegionWithHDFSDUnitTest.assertTrue((String)("Reading entries failed for key " + e + " where value = " + map1.get(e)), (boolean)v.equals(map1.get(e)));
            ColocatedRegionWithHDFSDUnitTest.assertTrue((String)("Reading entries failed for key " + e + " where value = " + map2.get(e)), (boolean)v.equals(map2.get(e)));
        }
    }

    @Override
    protected void verifyHDFSData(VM vm, String uniqueName) throws Exception {
        HashMap<String, HashMap<String, String>> filesToEntriesMap = this.createFilesAndEntriesMap(vm, uniqueName, uniqueName + "-r1");
        HashMap<String, String> entriesMap = new HashMap<String, String>();
        for (Map.Entry<String, HashMap<String, String>> e : filesToEntriesMap.entrySet()) {
            entriesMap.putAll((Map<String, String>)e.getValue());
        }
        this.verifyInEntriesMap(entriesMap, 1, 50, "vm0");
        this.verifyInEntriesMap(entriesMap, 40, 100, "vm1");
        this.verifyInEntriesMap(entriesMap, 40, 100, "vm2");
        this.verifyInEntriesMap(entriesMap, 90, 150, "vm3");
        filesToEntriesMap = this.createFilesAndEntriesMap(vm, uniqueName, uniqueName + "-r2");
        entriesMap = new HashMap();
        for (Map.Entry<String, HashMap<String, String>> e : filesToEntriesMap.entrySet()) {
            entriesMap.putAll((Map<String, String>)e.getValue());
        }
        this.verifyInEntriesMap(entriesMap, 1, 50, "vm0");
        this.verifyInEntriesMap(entriesMap, 40, 100, "vm1");
        this.verifyInEntriesMap(entriesMap, 40, 100, "vm2");
        this.verifyInEntriesMap(entriesMap, 90, 150, "vm3");
    }
}

