/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallback;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class LocatorTestBase
extends DistributedTestCase {
    protected static final String CACHE_KEY = "CACHE";
    protected static final String LOCATOR_KEY = "LOCATOR";
    protected static final String REGION_NAME = "A_REGION";
    protected static final String POOL_NAME = "daPool";
    protected static final Object CALLBACK_KEY = "callback";
    protected static final HashMap remoteObjects = new HashMap();

    public LocatorTestBase(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        SerializableRunnable tearDown = new SerializableRunnable("tearDown"){

            @Override
            public void run() {
                Cache cache;
                Locator locator = (Locator)remoteObjects.get(LocatorTestBase.LOCATOR_KEY);
                if (locator != null) {
                    try {
                        locator.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((cache = (Cache)remoteObjects.get(LocatorTestBase.CACHE_KEY)) != null) {
                    try {
                        cache.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                remoteObjects.clear();
            }
        };
        LocatorTestBase.invokeInEveryVM(tearDown);
        tearDown.run();
        super.tearDown2();
    }

    protected void startLocatorInVM(final VM vm, final int locatorPort, final String otherLocators) {
        vm.invoke(new SerializableRunnable("Create Locator"){
            final String testName;
            {
                super(name);
                this.testName = LocatorTestBase.this.getUniqueName();
            }

            @Override
            public void run() {
                DistributedTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(0));
                props.setProperty("locators", otherLocators);
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                try {
                    File logFile = new File(this.testName + "-locator" + locatorPort + ".log");
                    InetAddress bindAddr = null;
                    try {
                        bindAddr = InetAddress.getByName(DistributedTestCase.getServerHostName(vm.getHost()));
                    }
                    catch (UnknownHostException uhe) {
                        DistributedTestCase.fail("While resolving bind address ", uhe);
                    }
                    Locator locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, (InetAddress)bindAddr, (Properties)props);
                    remoteObjects.put(LocatorTestBase.LOCATOR_KEY, locator);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + locatorPort, ex);
                }
            }
        });
    }

    protected void stopLocatorInVM(VM vm) {
        vm.invoke(new SerializableRunnable("Stop Locator"){

            @Override
            public void run() {
                Locator locator = (Locator)remoteObjects.remove(LocatorTestBase.LOCATOR_KEY);
                locator.stop();
            }
        });
    }

    protected int startBridgeServerInVM(VM vm, String[] groups, String locators) {
        return this.startBridgeServerInVM(vm, groups, locators, new String[]{REGION_NAME});
    }

    protected int addBridgeServerInVM(VM vm, final String[] groups) {
        SerializableCallable connect = new SerializableCallable("Add Bridge server"){

            public Object call() throws Exception {
                Cache cache = (Cache)remoteObjects.get(LocatorTestBase.CACHE_KEY);
                BridgeServer server = cache.addBridgeServer();
                int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(serverPort);
                server.setGroups(groups);
                server.start();
                return new Integer(serverPort);
            }
        };
        Integer port = (Integer)vm.invoke(connect);
        return port;
    }

    protected int startBridgeServerInVM(VM vm, String[] groups, String locators, String[] regions) {
        return this.startBridgeServerInVM(vm, groups, locators, regions, BridgeServer.DEFAULT_LOAD_PROBE);
    }

    protected int startBridgeServerInVM(VM vm, final String[] groups, final String locators, final String[] regions, final ServerLoadProbe probe) {
        SerializableCallable connect = new SerializableCallable("Start bridge server"){

            public Object call() throws IOException {
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(0));
                props.setProperty("locators", locators);
                InternalDistributedSystem ds = LocatorTestBase.this.getSystem(props);
                Cache cache = CacheFactory.create((DistributedSystem)ds);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEnableBridgeConflation(true);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attrs = factory.create();
                for (int i = 0; i < regions.length; ++i) {
                    cache.createRegion(regions[i], attrs);
                }
                BridgeServer server = cache.addBridgeServer();
                int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(serverPort);
                server.setGroups(groups);
                server.setLoadProbe(probe);
                server.start();
                remoteObjects.put(LocatorTestBase.CACHE_KEY, cache);
                return new Integer(serverPort);
            }
        };
        Integer port = (Integer)vm.invoke(connect);
        return port;
    }

    protected int startBridgeServerWithEmbeddedLocator(VM vm, final String[] groups, final String locators, final String[] regions, final ServerLoadProbe probe) {
        SerializableCallable connect = new SerializableCallable("Start bridge server"){

            public Object call() throws IOException {
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(0));
                props.setProperty("start-locator", locators);
                props.setProperty("locators", locators);
                InternalDistributedSystem ds = LocatorTestBase.this.getSystem(props);
                Cache cache = CacheFactory.create((DistributedSystem)ds);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEnableBridgeConflation(true);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attrs = factory.create();
                for (int i = 0; i < regions.length; ++i) {
                    cache.createRegion(regions[i], attrs);
                }
                BridgeServer server = cache.addBridgeServer();
                server.setGroups(groups);
                server.setLoadProbe(probe);
                int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(serverPort);
                server.start();
                remoteObjects.put(LocatorTestBase.CACHE_KEY, cache);
                return new Integer(serverPort);
            }
        };
        Integer port = (Integer)vm.invoke(connect);
        return port;
    }

    protected void startBridgeClientInVM(VM vm, String group, String host, int port) {
        this.startBridgeClientInVM(vm, group, host, port, new String[]{REGION_NAME});
    }

    protected void startBridgeClientInVM(VM vm, String group, String host, int port, String[] regions) {
        PoolFactoryImpl pf = new PoolFactoryImpl(null);
        pf.addLocator(host, port).setServerGroup(group).setPingInterval(200L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1);
        this.startBridgeClientInVM(vm, (Pool)pf.getPoolAttributes(), regions);
    }

    protected void startBridgeClientInVM(VM vm, final Pool pool, final String[] regions) {
        SerializableRunnable connect = new SerializableRunnable("Start bridge client"){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(0));
                props.setProperty("locators", "");
                InternalDistributedSystem ds = LocatorTestBase.this.getSystem(props);
                Cache cache = CacheFactory.create((DistributedSystem)ds);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setPoolName(LocatorTestBase.POOL_NAME);
                PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
                pf.init(pool);
                MyLocatorCallback locatorCallback = new MyLocatorCallback();
                remoteObjects.put(CALLBACK_KEY, locatorCallback);
                pf.setLocatorDiscoveryCallback((LocatorDiscoveryCallback)locatorCallback);
                pf.create(LocatorTestBase.POOL_NAME);
                RegionAttributes attrs = factory.create();
                for (int i = 0; i < regions.length; ++i) {
                    cache.createRegion(regions[i], attrs);
                }
                remoteObjects.put(LocatorTestBase.CACHE_KEY, cache);
            }
        };
        if (vm == null) {
            connect.run();
        } else {
            vm.invoke(connect);
        }
    }

    protected void stopBridgeMemberVM(VM vm) {
        vm.invoke(new SerializableRunnable("Stop bridge member"){

            @Override
            public void run() {
                Cache cache = (Cache)remoteObjects.remove(LocatorTestBase.CACHE_KEY);
                cache.close();
                DistributedTestCase.disconnectFromDS();
            }
        });
    }

    public String getLocatorString(Host host, int locatorPort) {
        return this.getLocatorString(host, new int[]{locatorPort});
    }

    public String getLocatorString(Host host, int[] locatorPorts) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < locatorPorts.length; ++i) {
            str.append(LocatorTestBase.getServerHostName(host)).append("[").append(locatorPorts[i]).append("]");
            if (i >= locatorPorts.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    protected static class MyLocatorCallback
    extends LocatorDiscoveryCallbackAdapter {
        private final Set discoveredLocators = new HashSet();
        private final Set removedLocators = new HashSet();

        protected MyLocatorCallback() {
        }

        public synchronized void locatorsDiscovered(List locators) {
            this.discoveredLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void locatorsRemoved(List locators) {
            this.removedLocators.addAll(locators);
            ((Object)((Object)this)).notifyAll();
        }

        public boolean waitForDiscovery(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.discoveredLocators, locator, time);
        }

        public boolean waitForRemove(InetSocketAddress locator, long time) throws InterruptedException {
            return this.waitFor(this.removedLocators, locator, time);
        }

        private synchronized boolean waitFor(Set set, InetSocketAddress locator, long time) throws InterruptedException {
            long remaining = time;
            long endTime = System.currentTimeMillis() + time;
            while (!set.contains(locator) && remaining >= 0L) {
                ((Object)((Object)this)).wait(remaining);
                remaining = endTime - System.currentTimeMillis();
            }
            return set.contains(locator);
        }

        public synchronized Set getDiscovered() {
            return new HashSet(this.discoveredLocators);
        }
    }
}

