/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.internal.AutoConnectionSourceDUnitTest;
import com.gemstone.gemfire.cache.client.internal.LocatorTestBase;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import junit.framework.Assert;

public class AutoConnectionSourceWithUDPDUnitTest
extends AutoConnectionSourceDUnitTest {
    protected int mCastPort;

    public AutoConnectionSourceWithUDPDUnitTest(String name) {
        super(name);
    }

    public void testStartLocatorLater() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.startBridgeServerInVM(vm1, null, null);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        this.startBridgeClientInVM(vm2, null, AutoConnectionSourceWithUDPDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm1, (Serializable)((Object)"key")));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mCastPort = AvailablePort.getRandomAvailablePort((int)1);
    }

    @Override
    protected int startBridgeServerInVM(final VM vm, final String[] groups, String locators, final String[] regions) {
        SerializableCallable connect = new SerializableCallable("Start bridge server"){

            public Object call() throws IOException {
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(AutoConnectionSourceWithUDPDUnitTest.this.mCastPort));
                props.setProperty("mcast-address", DistributionConfig.DEFAULT_MCAST_ADDRESS.getHostAddress());
                props.setProperty("locators", "");
                props.setProperty("bind-address", DistributedTestCase.getServerHostName(vm.getHost()));
                InternalDistributedSystem ds = AutoConnectionSourceWithUDPDUnitTest.this.getSystem(props);
                Cache cache = CacheFactory.create((DistributedSystem)ds);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEnableBridgeConflation(true);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                RegionAttributes attrs = factory.create();
                for (int i = 0; i < regions.length; ++i) {
                    cache.createRegion(regions[i], attrs);
                }
                BridgeServer server = cache.addBridgeServer();
                int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(serverPort);
                server.setGroups(groups);
                server.start();
                LocatorTestBase.remoteObjects.put("CACHE", cache);
                return new Integer(serverPort);
            }
        };
        Integer port = (Integer)vm.invoke(connect);
        return port;
    }

    @Override
    public void startLocatorInVM(final VM vm, final int locatorPort, String otherLocators) {
        vm.invoke(new SerializableRunnable("Create Locator"){
            final String testName;
            {
                super(name);
                this.testName = AutoConnectionSourceWithUDPDUnitTest.this.getUniqueName();
            }

            @Override
            public void run() {
                DistributedTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("mcast-port", String.valueOf(AutoConnectionSourceWithUDPDUnitTest.this.mCastPort));
                props.setProperty("mcast-address", DistributionConfig.DEFAULT_MCAST_ADDRESS.getHostAddress());
                props.setProperty("locators", "");
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                InetAddress bindAddr = null;
                try {
                    bindAddr = InetAddress.getByName(DistributedTestCase.getServerHostName(vm.getHost()));
                }
                catch (UnknownHostException uhe) {
                    DistributedTestCase.fail("While resolving bind address ", uhe);
                }
                try {
                    File logFile = new File(this.testName + "-locator" + locatorPort + ".log");
                    Locator locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, (InetAddress)bindAddr, (Properties)props, (boolean)false, (boolean)true, null);
                    LocatorTestBase.remoteObjects.put("LOCATOR", locator);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + locatorPort, ex);
                }
            }
        });
    }
}

