/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.NoAvailableServersException;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.LocatorTestBase;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeMembership;
import com.gemstone.gemfire.cache.util.BridgeMembershipEvent;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.cache.util.BridgeMembershipListenerAdapter;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AutoConnectionSourceDUnitTest
extends LocatorTestBase {
    protected static final Object BRIDGE_LISTENER = "BRIDGE_LISTENER";
    private static final long MAX_WAIT = 60000L;

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public AutoConnectionSourceDUnitTest(String name) {
        super(name);
    }

    public void testDiscoverBridgeServers() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()) + "[" + locatorPort + "]";
        this.startBridgeServerInVM(vm1, null, locators);
        this.startBridgeClientInVM(vm2, null, AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm1, (Serializable)((Object)"key")));
    }

    public void testNoLocators() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        try {
            this.startBridgeClientInVM(vm0, null, AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0));
            this.putInVM(vm0, (Serializable)((Object)"key"), (Serializable)((Object)"value"));
            AutoConnectionSourceDUnitTest.fail((String)"Client cache should not have been able to start");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNoBridgeServer() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        try {
            this.startBridgeClientInVM(vm1, null, AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
            this.putInVM(vm0, (Serializable)((Object)"key"), (Serializable)((Object)"value"));
            AutoConnectionSourceDUnitTest.fail((String)"Client cache should not have been able to start");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDynamicallyFindBridgeServer() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()) + "[" + locatorPort + "]";
        this.startBridgeServerInVM(vm1, null, locators);
        this.startBridgeClientInVM(vm2, null, AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key"), (Serializable)((Object)"value"));
        this.startBridgeServerInVM(vm3, null, locators);
        this.stopBridgeMemberVM(vm1);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key2"), (Serializable)((Object)"value2"));
        Assert.assertEquals((Object)"value2", (Object)this.getInVM(vm3, (Serializable)((Object)"key2")));
    }

    public void testDynamicallyFindLocators() throws Exception {
        Host host = Host.getHost(0);
        String hostName = AutoConnectionSourceDUnitTest.getServerHostName(host);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int locatorPort0 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        int locatorPort1 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm1);
        int locatorPort3 = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm3);
        String locators = this.getLocatorString(host, new int[]{locatorPort0, locatorPort1, locatorPort3});
        this.startLocatorInVM(vm0, locatorPort0, locators);
        this.startLocatorInVM(vm1, locatorPort1, locators);
        this.startBridgeClientInVM(vm2, null, AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort0);
        InetSocketAddress locatorToWaitFor = new InetSocketAddress(hostName, locatorPort1);
        this.waitForLocatorDiscovery(vm2, locatorToWaitFor);
        this.stopLocatorInVM(vm0);
        this.startBridgeServerInVM(vm0, null, locators);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm0, (Serializable)((Object)"key")));
        this.startLocatorInVM(vm3, locatorPort3, locators);
        this.stopBridgeMemberVM(vm0);
        locatorToWaitFor = new InetSocketAddress(hostName, locatorPort3);
        this.waitForLocatorDiscovery(vm2, locatorToWaitFor);
        this.stopLocatorInVM(vm1);
        this.startBridgeServerInVM(vm1, null, locators);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key2"), (Serializable)((Object)"value2"));
        Assert.assertEquals((Object)"value2", (Object)this.getInVM(vm1, (Serializable)((Object)"key2")));
    }

    public void testEmbeddedLocator() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        String locators = AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()) + "[" + locatorPort + "]";
        this.startBridgeServerWithEmbeddedLocator(vm0, null, locators, new String[]{"A_REGION"}, CacheServer.DEFAULT_LOAD_PROBE);
        this.startBridgeClientInVM(vm2, null, AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
        this.putAndWaitForSuccess(vm2, "A_REGION", (Serializable)((Object)"key"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm2, (Serializable)((Object)"key")));
    }

    private void waitForLocatorDiscovery(VM vm, final InetSocketAddress locatorToWaitFor) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws InterruptedException {
                LocatorTestBase.MyLocatorCallback callback = (LocatorTestBase.MyLocatorCallback)((Object)LocatorTestBase.remoteObjects.get(LocatorTestBase.CALLBACK_KEY));
                boolean discovered = callback.waitForDiscovery(locatorToWaitFor, 60000L);
                Assert.assertTrue((String)("Waited 60000 for " + locatorToWaitFor + " to be discovered on client. List is now: " + callback.getDiscovered()), (boolean)discovered);
                return null;
            }
        });
    }

    public void testServerGroups() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()) + "[" + locatorPort + "]";
        this.startBridgeServerInVM(vm1, new String[]{"group1", "group2"}, locators, new String[]{"A", "B"});
        this.startBridgeServerInVM(vm2, new String[]{"group2", "group3"}, locators, new String[]{"B", "C"});
        this.startBridgeClientInVM(vm3, "group1", AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort, new String[]{"A", "B", "C"});
        this.putAndWaitForSuccess(vm3, "A", (Serializable)((Object)"key"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm1, "A", (Serializable)((Object)"key")));
        try {
            this.putInVM(vm3, "C", (Serializable)((Object)"key2"), (Serializable)((Object)"value2"));
            AutoConnectionSourceDUnitTest.fail((String)"Should not have been able to find Region C on the server");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopBridgeMemberVM(vm3);
        this.startBridgeClientInVM(vm3, "group3", AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort, new String[]{"A", "B", "C"});
        try {
            this.putInVM(vm3, "A", (Serializable)((Object)"key3"), (Serializable)((Object)"value"));
            AutoConnectionSourceDUnitTest.fail((String)"Should not have been able to find Region A on the server");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.putInVM(vm3, "C", (Serializable)((Object)"key4"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm2, "C", (Serializable)((Object)"key4")));
        this.stopBridgeMemberVM(vm3);
        this.startBridgeClientInVM(vm3, "group2", AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort, new String[]{"A", "B", "C"});
        this.putInVM(vm3, "B", (Serializable)((Object)"key5"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm1, "B", (Serializable)((Object)"key5")));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm2, "B", (Serializable)((Object)"key5")));
        this.stopBridgeMemberVM(vm1);
        this.putInVM(vm3, "B", (Serializable)((Object)"key6"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm2, "B", (Serializable)((Object)"key6")));
        this.startBridgeServerInVM(vm1, new String[]{"group1", "group2"}, locators, new String[]{"A", "B"});
        this.stopBridgeMemberVM(vm2);
        this.putInVM(vm3, "B", (Serializable)((Object)"key7"), (Serializable)((Object)"value"));
        Assert.assertEquals((Object)"value", (Object)this.getInVM(vm1, "B", (Serializable)((Object)"key7")));
    }

    public void testTwoServersInSameVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        this.startLocatorInVM(vm0, locatorPort, "");
        String locators = AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()) + "[" + locatorPort + "]";
        int serverPort1 = this.startBridgeServerInVM(vm1, new String[]{"group1"}, locators);
        int serverPort2 = this.addBridgeServerInVM(vm1, new String[]{"group2"});
        this.startBridgeClientInVM(vm2, "group2", AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
        this.checkEndpoints(vm2, new int[]{serverPort2});
        this.stopBridgeMemberVM(vm2);
        this.startBridgeClientInVM(vm2, "group1", AutoConnectionSourceDUnitTest.getServerHostName(vm0.getHost()), locatorPort);
        this.checkEndpoints(vm2, new int[]{serverPort1});
    }

    public void testBridgeMembershipListener() throws Exception {
        Host host = Host.getHost(0);
        VM locatorVM = host.getVM(0);
        VM bridge1VM = host.getVM(1);
        VM bridge2VM = host.getVM(2);
        VM clientVM = host.getVM(3);
        int locatorPort = AvailablePortHelper.getRandomAvailableTCPPortOnVM(locatorVM);
        this.startLocatorInVM(locatorVM, locatorPort, "");
        String locators = AutoConnectionSourceDUnitTest.getServerHostName(locatorVM.getHost()) + "[" + locatorPort + "]";
        this.addBridgeListener(bridge1VM);
        int serverPort1 = this.startBridgeServerInVM(bridge1VM, null, locators);
        this.addBridgeListener(clientVM);
        this.startBridgeClientInVM(clientVM, null, AutoConnectionSourceDUnitTest.getServerHostName(locatorVM.getHost()), locatorPort);
        this.checkEndpoints(clientVM, new int[]{serverPort1});
        this.waitForJoin(bridge1VM);
        MyListener serverListener = this.getBridgeListener(bridge1VM);
        Assert.assertEquals((int)0, (int)serverListener.getCrashes());
        Assert.assertEquals((int)0, (int)serverListener.getDepartures());
        Assert.assertEquals((int)1, (int)serverListener.getJoins());
        this.resetBridgeListener(bridge1VM);
        this.waitForJoin(clientVM);
        MyListener clientListener = this.getBridgeListener(clientVM);
        Assert.assertEquals((int)0, (int)clientListener.getCrashes());
        Assert.assertEquals((int)0, (int)clientListener.getDepartures());
        Assert.assertEquals((int)1, (int)clientListener.getJoins());
        this.resetBridgeListener(clientVM);
        this.checkEndpoints(clientVM, new int[]{serverPort1});
        int serverPort2 = this.startBridgeServerInVM(bridge2VM, null, locators);
        this.checkEndpoints(clientVM, new int[]{serverPort1, serverPort2});
        serverListener = this.getBridgeListener(bridge1VM);
        Assert.assertEquals((int)0, (int)serverListener.getCrashes());
        Assert.assertEquals((int)0, (int)serverListener.getDepartures());
        Assert.assertEquals((int)0, (int)serverListener.getJoins());
        this.resetBridgeListener(bridge1VM);
        this.waitForJoin(clientVM);
        clientListener = this.getBridgeListener(clientVM);
        Assert.assertEquals((int)0, (int)clientListener.getCrashes());
        Assert.assertEquals((int)0, (int)clientListener.getDepartures());
        Assert.assertEquals((int)1, (int)clientListener.getJoins());
        this.resetBridgeListener(clientVM);
        this.stopBridgeMemberVM(bridge2VM);
        this.checkEndpoints(clientVM, new int[]{serverPort1});
        serverListener = this.getBridgeListener(bridge1VM);
        Assert.assertEquals((int)0, (int)serverListener.getCrashes());
        Assert.assertEquals((int)0, (int)serverListener.getDepartures());
        Assert.assertEquals((int)0, (int)serverListener.getJoins());
        this.resetBridgeListener(bridge1VM);
        this.waitForCrash(clientVM);
        clientListener = this.getBridgeListener(clientVM);
        Assert.assertEquals((int)1, (int)clientListener.getCrashes());
        Assert.assertEquals((int)0, (int)clientListener.getDepartures());
        Assert.assertEquals((int)0, (int)clientListener.getJoins());
        this.resetBridgeListener(clientVM);
        this.stopBridgeMemberVM(clientVM);
        this.waitForDeparture(bridge1VM);
        serverListener = this.getBridgeListener(bridge1VM);
        Assert.assertEquals((int)0, (int)serverListener.getCrashes());
        Assert.assertEquals((int)1, (int)serverListener.getDepartures());
        Assert.assertEquals((int)0, (int)serverListener.getJoins());
    }

    protected Object getInVM(VM vm, Serializable key) {
        return this.getInVM(vm, "A_REGION", key);
    }

    protected Object getInVM(VM vm, final String regionName, final Serializable key) {
        return vm.invoke(new SerializableCallable("Get in VM"){

            public Object call() throws Exception {
                Cache cache = (Cache)LocatorTestBase.remoteObjects.get("CACHE");
                Region region = cache.getRegion(regionName);
                return region.get((Object)key);
            }
        });
    }

    protected void putAndWaitForSuccess(VM vm, String regionName, Serializable key, Serializable value) throws InterruptedException {
        long endTime = System.currentTimeMillis() + 60000L;
        long remaining = 60000L;
        int i = 0;
        while (true) {
            try {
                System.err.println("Attempt: " + i++);
                this.putInVM(vm, regionName, key, value);
            }
            catch (RMIException e) {
                if (!(e.getCause() instanceof NoAvailableServersException)) {
                    throw e;
                }
                if (remaining <= 0L) {
                    throw e;
                }
                AutoConnectionSourceDUnitTest.pause(100);
                remaining = endTime - System.currentTimeMillis();
                continue;
            }
            break;
        }
    }

    protected void putInVM(VM vm, Serializable key, Serializable value) {
        this.putInVM(vm, "A_REGION", key, value);
    }

    protected void putInVM(VM vm, final String regionName, final Serializable key, final Serializable value) {
        vm.invoke(new SerializableCallable("Put in VM"){

            public Object call() throws Exception {
                Cache cache = (Cache)LocatorTestBase.remoteObjects.get("CACHE");
                Region region = cache.getRegion(regionName);
                return region.put((Object)key, (Object)value);
            }
        });
    }

    protected void checkEndpoints(VM vm, final int[] expectedPorts) {
        vm.invoke(new SerializableRunnable("Check endpoint"){

            @Override
            public void run() {
                HashSet<Integer> actualEndpointPorts;
                PoolImpl pool = (PoolImpl)PoolManager.find((String)"daPool");
                int retryCount = 50;
                HashSet<Integer> expectedEndpointPorts = new HashSet<Integer>();
                for (int i = 0; i < expectedPorts.length; ++i) {
                    expectedEndpointPorts.add(new Integer(expectedPorts[i]));
                }
                do {
                    List endpoints = pool.getCurrentServers();
                    actualEndpointPorts = new HashSet<Integer>();
                    for (ServerLocation sl : endpoints) {
                        actualEndpointPorts.add(new Integer(sl.getPort()));
                    }
                    if (expectedEndpointPorts.size() == actualEndpointPorts.size()) break;
                    DistributedTestCase.pause(100);
                } while (retryCount-- > 0);
                Assert.assertEquals(expectedEndpointPorts, actualEndpointPorts);
            }
        });
    }

    protected void addBridgeListener(VM vm) {
        vm.invoke(new SerializableRunnable("Add membership listener"){

            @Override
            public void run() {
                MyListener listener = new MyListener();
                BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listener);
                LocatorTestBase.remoteObjects.put(BRIDGE_LISTENER, listener);
            }
        });
    }

    protected void resetBridgeListener(VM vm) {
        vm.invoke(new SerializableRunnable("Add membership listener"){

            @Override
            public void run() {
                MyListener listener = (MyListener)LocatorTestBase.remoteObjects.get(BRIDGE_LISTENER);
                listener.reset();
            }
        });
    }

    private MyListener getBridgeListener(VM vm) {
        return (MyListener)vm.invoke(new SerializableCallable("Add membership listener"){

            public Object call() {
                return LocatorTestBase.remoteObjects.get(BRIDGE_LISTENER);
            }
        });
    }

    private void waitForJoin(VM vm) {
        vm.invoke(new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MyListener listener;
                MyListener myListener = listener = (MyListener)LocatorTestBase.remoteObjects.get(BRIDGE_LISTENER);
                synchronized (myListener) {
                    long end = System.currentTimeMillis() + 10000L;
                    while (listener.joins == 0) {
                        try {
                            long remaining = end - System.currentTimeMillis();
                            if (remaining < 0L) break;
                            listener.wait(remaining);
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
            }
        });
    }

    private void waitForCrash(VM vm) {
        vm.invoke(new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MyListener listener;
                MyListener myListener = listener = (MyListener)LocatorTestBase.remoteObjects.get(BRIDGE_LISTENER);
                synchronized (myListener) {
                    long end = System.currentTimeMillis() + 10000L;
                    while (listener.crashes == 0) {
                        try {
                            long remaining = end - System.currentTimeMillis();
                            if (remaining <= 0L) break;
                            DistributedTestCase.getLogWriter().info("waiting for crash for " + remaining + "ms");
                            listener.wait(remaining);
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
            }
        });
    }

    private void waitForDeparture(VM vm) {
        vm.invoke(new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MyListener listener;
                MyListener myListener = listener = (MyListener)LocatorTestBase.remoteObjects.get(BRIDGE_LISTENER);
                synchronized (myListener) {
                    long end = System.currentTimeMillis() + 10000L;
                    while (listener.departures == 0) {
                        try {
                            long remaining = end - System.currentTimeMillis();
                            if (remaining <= 0L) break;
                            DistributedTestCase.getLogWriter().info("waiting for departure for " + remaining + "ms");
                            listener.wait(remaining);
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
            }
        });
    }

    public static class MyListener
    extends BridgeMembershipListenerAdapter
    implements Serializable {
        protected int crashes = 0;
        protected int joins = 0;
        protected int departures = 0;

        public synchronized void memberCrashed(BridgeMembershipEvent event) {
            ++this.crashes;
            this.notifyAll();
        }

        public synchronized void reset() {
            this.crashes = 0;
            this.joins = 0;
            this.departures = 0;
        }

        public synchronized void memberJoined(BridgeMembershipEvent event) {
            ++this.joins;
            this.notifyAll();
        }

        public synchronized void memberLeft(BridgeMembershipEvent event) {
            ++this.departures;
            this.notifyAll();
        }

        public synchronized int getCrashes() {
            return this.crashes;
        }

        public synchronized int getJoins() {
            return this.joins;
        }

        public synchronized int getDepartures() {
            return this.departures;
        }
    }
}

