/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class CacheRegionClearStatsDUnitTest
extends DistributedTestCase {
    private static GemFireCacheImpl cache = null;
    private static VM server1 = null;
    private static VM client1 = null;
    private static final String REGION_NAME = "CacheRegionClearStatsDUnitTest_Region";
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String client_k1 = "client-k1";
    private static final String client_k2 = "client-k2";
    private static final int clearOp = 2;

    public CacheRegionClearStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        client1 = host.getVM(1);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        CacheRegionClearStatsDUnitTest.assertNotNull((Object)ds);
        cache = (GemFireCacheImpl)CacheFactory.create((DistributedSystem)ds);
        CacheRegionClearStatsDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        new CacheRegionClearStatsDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new CacheRegionClearStatsDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(false).setThreadLocalConnections(true).setMinConnections(1).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).create("CacheRegionClearStatsDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCacheDisk() throws Exception {
        return CacheRegionClearStatsDUnitTest.createCache(DataPolicy.PERSISTENT_REPLICATE);
    }

    private static Integer createCache(DataPolicy dataPolicy) throws Exception {
        new CacheRegionClearStatsDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(dataPolicy);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        CacheServer server1 = cache.addCacheServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public static Integer createServerCache() throws Exception {
        return CacheRegionClearStatsDUnitTest.createCache(DataPolicy.REPLICATE);
    }

    public static void createClientCacheDisk(String host, Integer port1) throws Exception {
        new CacheRegionClearStatsDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new CacheRegionClearStatsDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(false).setThreadLocalConnections(true).setMinConnections(1).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).create("CacheRegionClearStatsDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
    }

    public void testClearStatsWithNormalRegion() {
        Integer port1 = (Integer)server1.invoke(CacheRegionClearStatsDUnitTest.class, "createServerCache");
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "createClientCache", new Object[]{CacheRegionClearStatsDUnitTest.getServerHostName(server1.getHost()), port1});
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "put");
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "validationClearStat");
        server1.invoke(CacheRegionClearStatsDUnitTest.class, "validationClearStat");
    }

    public void testClearStatsWithDiskRegion() {
        Integer port1 = (Integer)server1.invoke(CacheRegionClearStatsDUnitTest.class, "createServerCacheDisk");
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "createClientCacheDisk", new Object[]{CacheRegionClearStatsDUnitTest.getServerHostName(server1.getHost()), port1});
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "put");
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "validationClearStat");
        server1.invoke(CacheRegionClearStatsDUnitTest.class, "validationClearStat");
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(CacheRegionClearStatsDUnitTest.class, "closeCache");
        server1.invoke(CacheRegionClearStatsDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void put() {
        try {
            Region r1 = cache.getRegion("/CacheRegionClearStatsDUnitTest_Region");
            CacheRegionClearStatsDUnitTest.assertNotNull((Object)r1);
            r1.put((Object)k1, (Object)client_k1);
            CacheRegionClearStatsDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
            r1.put((Object)k2, (Object)client_k2);
            CacheRegionClearStatsDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            r1.clear();
            r1.put((Object)k1, (Object)client_k1);
            CacheRegionClearStatsDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
            r1.put((Object)k2, (Object)client_k2);
            CacheRegionClearStatsDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            r1.clear();
        }
        catch (Exception ex) {
            CacheRegionClearStatsDUnitTest.fail("failed while put", ex);
        }
    }

    public static void validationClearStat() {
        CacheRegionClearStatsDUnitTest.assertEquals((int)cache.getCachePerfStats().getClearCount(), (int)2);
    }
}

