/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.stats;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class GemFireMemberandVMStatsDUnitTest
extends AdminDUnitTestCase {
    public GemFireMemberandVMStatsDUnitTest(String name) {
        super(name);
    }

    protected SystemMember getMember() throws Exception {
        GemFireMemberandVMStatsDUnitTest.getLogWriter().info("[getMember]");
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberandVMStatsDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                props.setProperty("enable-time-statistics", "true");
                props.setProperty("statistic-sampling-enabled", "true");
                GemFireMemberandVMStatsDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberandVMStatsDUnitTest.getLogWriter().info("Test: Created DS");
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)GemFireMemberandVMStatsDUnitTest.this.getSystem());
            }
        });
        GemFireMemberandVMStatsDUnitTest.getLogWriter().info("Test: Created Cache");
        Thread.sleep(2000L);
        SystemMember[] members = this.tcSystem.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            GemFireMemberandVMStatsDUnitTest.fail((String)sb.toString());
        }
        GemFireMemberandVMStatsDUnitTest.getLogWriter().info("Test: Created Member");
        return members[0];
    }

    protected long getCpu() {
        StatisticsType type = this.getSystem().findType("VMStats");
        GemFireMemberandVMStatsDUnitTest.assertNotNull((Object)type);
        Statistics[] stats = this.getSystem().findStatisticsByType(type);
        assert (stats.length != 0);
        Statistics vmStats = stats[0];
        return vmStats.getLong("processCpuTime");
    }

    public void testDummy() {
    }

    public void _testProcessCPUTime() throws Exception {
        GemFireMemberandVMStatsDUnitTest.getLogWriter().info("[testProcessCPUTime]");
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        this.getMember();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                final InternalDistributedSystem s = GemFireMemberandVMStatsDUnitTest.this.getSystem();
                final long startTime = GemFireMemberandVMStatsDUnitTest.this.getCpu();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        if (GemFireMemberandVMStatsDUnitTest.this.getCpu() != startTime) {
                            return true;
                        }
                        s.getLogWriter().info("please ignore");
                        long fac = 1L;
                        for (int i = 0; i < 100; ++i) {
                            fac = fac * (long)i + (long)s.toString().length();
                        }
                        return false;
                    }

                    @Override
                    public String description() {
                        return "cpu time did not change (is this an intelligent JIT?)";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 200L, true);
            }
        });
    }
}

