/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.statalerts;

import com.gemstone.gemfire.admin.statalerts.StatAlertDefinitionDUnitTest;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.statalerts.DummyStatisticInfoImpl;
import com.gemstone.gemfire.internal.admin.statalerts.StatisticInfo;
import javax.management.MBeanServer;

public class StatAlertDefinitionJMXOperationsDUnitTest
extends StatAlertDefinitionDUnitTest {
    private static StatAlertDefinition definition = null;
    private static String name = "def1";
    private static StatisticInfo[] statInfo = new StatisticInfo[]{new DummyStatisticInfoImpl("CachePerfStats", "cachePerfStats", "puts")};
    private static Integer threshold = new Integer(10);

    public StatAlertDefinitionJMXOperationsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        definition = this.prepareStatAlertDefinition(name, statInfo, false, (short)-1, null, threshold);
    }

    public void testStatAlertDefinitionRegistration() throws Exception {
        StatAlertDefinitionJMXOperationsDUnitTest.registerStatAlertDefinition(definition);
        StatAlertDefinitionJMXOperationsDUnitTest.getLogWriter().info("Successfully registered statalert definition.");
        boolean result = StatAlertDefinitionJMXOperationsDUnitTest.isStatAlertDefinitionCreated(definition);
        StatAlertDefinitionJMXOperationsDUnitTest.assertTrue((boolean)result);
    }

    public void testStatAlertDefinitionUpdation() throws Exception {
        MBeanServer mbs = this.agent.getMBeanServer();
        StatAlertDefinitionJMXOperationsDUnitTest.assertNotNull((Object)mbs);
        Integer newThreshold = new Integer(2 * threshold);
        definition = this.prepareStatAlertDefinition(name, statInfo, false, (short)-1, null, newThreshold);
        StatAlertDefinitionJMXOperationsDUnitTest.registerStatAlertDefinition(definition);
        StatAlertDefinition[] defs = StatAlertDefinitionJMXOperationsDUnitTest.getAllStatAlertDefinitions();
        StatAlertDefinitionJMXOperationsDUnitTest.assertNotNull((Object)defs);
        StatAlertDefinitionJMXOperationsDUnitTest.assertTrue((defs.length == 1 ? 1 : 0) != 0);
        StatAlertDefinitionJMXOperationsDUnitTest.assertEquals((Object)definition, (Object)defs[0]);
    }

    public void testStatAlertDefinitionRemoval() throws Exception {
        MBeanServer mbs = this.agent.getMBeanServer();
        StatAlertDefinitionJMXOperationsDUnitTest.assertNotNull((Object)mbs);
        StatAlertDefinitionJMXOperationsDUnitTest.removeStatAlertDefinition(definition);
        StatAlertDefinition[] defs = StatAlertDefinitionJMXOperationsDUnitTest.getAllStatAlertDefinitions();
        StatAlertDefinitionJMXOperationsDUnitTest.assertNotNull((Object)defs);
        StatAlertDefinitionJMXOperationsDUnitTest.assertTrue((defs.length == 0 ? 1 : 0) != 0);
    }
}

