/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.memberstatus;

import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.RegionStatus;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import java.util.Random;

public class GemFireMemberRegionStatusDUnitTest
extends AdminDUnitTestCase {
    public static final int MEM_VM = 0;
    private final int noOfEntity = 10;

    public GemFireMemberRegionStatusDUnitTest(String name) {
        super(name);
    }

    protected VM getMemberVM() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    protected SystemMemberCache getMemberCache() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String testName = this.getName();
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = GemFireMemberRegionStatusDUnitTest.this.getDistributedSystemProperties();
                props.setProperty("name", testName);
                GemFireMemberRegionStatusDUnitTest.this.getSystem(props);
            }
        });
        GemFireMemberRegionStatusDUnitTest.pause(2000);
        GemFireMemberRegionStatusDUnitTest.getLogWriter().info("Test: Created DS");
        AdminDistributedSystem system = this.tcSystem;
        SystemMember[] members = system.getSystemMemberApplications();
        if (members.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("Expected 1 member, got " + members.length + ": ");
            for (int i = 0; i < members.length; ++i) {
                SystemMember member = members[i];
                sb.append(member.getName());
                sb.append(" ");
            }
            GemFireMemberRegionStatusDUnitTest.fail((String)sb.toString());
        }
        GemFireMemberRegionStatusDUnitTest.getLogWriter().info("Test: Created Member");
        SystemMemberCache cache = members[0].getCache();
        GemFireMemberRegionStatusDUnitTest.assertNull((Object)cache);
        vm.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                CacheFactory.create((DistributedSystem)GemFireMemberRegionStatusDUnitTest.this.getSystem());
            }
        });
        GemFireMemberRegionStatusDUnitTest.getLogWriter().info("Test: Created Cache");
        cache = members[0].getCache();
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)cache);
        return cache;
    }

    public void testStatusSerialization() throws Exception {
        SystemMemberCache cache = this.getMemberCache();
        GemFireMemberStatus status = ((SystemMemberCacheImpl)cache).getSnapshot();
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)status.getRegionStatuses());
    }

    public void testStatusSerializationForRootRegion() throws Exception {
        SystemMemberCache cache = this.getMemberCache();
        VM vm1 = this.getMemberVM();
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                AttributesFactory factory = new AttributesFactory();
                MembershipAttributes membershipAttributes = new MembershipAttributes(new String[]{"A"}, LossAction.FULL_ACCESS, ResumptionAction.NONE);
                factory.setMembershipAttributes(membershipAttributes);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion("RegionTest", attrs);
                Random generator = new Random();
                for (int i = 0; i < 10; ++i) {
                    int temp = generator.nextInt(200);
                    region.put((Object)String.valueOf(i), (Object)new Integer(temp));
                }
                DistributedTestCase.getLogWriter().info("Created a Region " + region.getFullPath());
            }
        });
        GemFireMemberStatus status = ((SystemMemberCacheImpl)cache).getSnapshot();
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)status);
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)status.getRegionStatuses());
        RegionStatus regionStatus = (RegionStatus)status.getRegionStatus("/RegionTest");
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)regionStatus);
        GemFireMemberRegionStatusDUnitTest.assertEquals((int)10, (int)regionStatus.getNumberOfEntries());
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)regionStatus.toString());
    }

    public void testStatusSerializationForSubRegions() throws Exception {
        SystemMemberCache cache = this.getMemberCache();
        VM vm1 = this.getMemberVM();
        vm1.invoke(new CacheSerializableRunnable("Create cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                AttributesFactory factory = new AttributesFactory();
                MembershipAttributes membershipAttributes = new MembershipAttributes(new String[]{"A"}, LossAction.FULL_ACCESS, ResumptionAction.NONE);
                factory.setMembershipAttributes(membershipAttributes);
                RegionAttributes attrs = factory.create();
                Region region = cache.createRegion("RegionTest", attrs);
                Region subregion = region.createSubregion("SubRegionTest", attrs);
                Random generator = new Random();
                for (int i = 0; i < 10; ++i) {
                    int temp = generator.nextInt(200);
                    subregion.put((Object)String.valueOf(i), (Object)new Integer(temp));
                }
                DistributedTestCase.getLogWriter().info("Created a Region " + region.getFullPath());
                DistributedTestCase.getLogWriter().info("Created a SubRegion " + subregion.getFullPath());
            }
        });
        GemFireMemberStatus status = ((SystemMemberCacheImpl)cache).getSnapshot();
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)status);
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)status.getRegionStatuses());
        RegionStatus regionStatus = (RegionStatus)status.getRegionStatus("/RegionTest/SubRegionTest");
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)regionStatus);
        GemFireMemberRegionStatusDUnitTest.assertEquals((int)10, (int)regionStatus.getNumberOfEntries());
        GemFireMemberRegionStatusDUnitTest.assertNotNull((Object)regionStatus.toString());
    }
}

