/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.SystemMemberBridgeServer;
import com.gemstone.gemfire.admin.SystemMemberCacheServer;
import com.gemstone.gemfire.admin.jmx.JMXAdminImpl;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.internal.Assert;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class JMXSystemMemberBridgeServer
extends JMXAdminImpl
implements SystemMemberCacheServer,
SystemMemberBridgeServer {
    JMXSystemMemberBridgeServer(MBeanServerConnection mbs, ObjectName objectName) {
        super(mbs, objectName);
        Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
    }

    private RuntimeException handleException(Exception ex) {
        String s = "While accessing cache server MBean";
        return new InternalGemFireException(s, (Throwable)ex);
    }

    private AdminException handleAdminException(Exception ex) {
        return new AdminException((Throwable)ex);
    }

    public int getPort() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "port");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setPort(int port) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("port", new Integer(port)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public void start() throws AdminException {
        try {
            this.mbs.invoke(this.objectName, "start", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public boolean isRunning() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "running");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void stop() throws AdminException {
        try {
            this.mbs.invoke(this.objectName, "stop", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public void refresh() {
        try {
            this.mbs.invoke(this.objectName, "refresh", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getBindAddress() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "bindAddress");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setBindAddress(String address) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("bindAddress", address));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public String getHostnameForClients() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "hostnameForClients");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setHostnameForClients(String name) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("hostnameForClients", name));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public void setNotifyBySubscription(boolean b) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("notifyBySubscription", new Boolean(b)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public boolean getNotifyBySubscription() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Boolean)this.mbs.getAttribute(this.objectName, "notifyBySubscription");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setSocketBufferSize(int v) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("socketBufferSize", new Integer(v)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public int getSocketBufferSize() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "socketBufferSize");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setMaximumTimeBetweenPings(int v) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("maximumTimeBetweenPings", new Integer(v)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public int getMaximumTimeBetweenPings() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "maximumTimeBetweenPings");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public int getMaxConnections() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "maxConnections");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setMaxConnections(int v) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("maxConnections", new Integer(v)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public int getMaxThreads() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "maxThreads");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setMaxThreads(int v) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("maxThreads", new Integer(v)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public int getMaximumMessageCount() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "maximumMessageCount");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setMaximumMessageCount(int v) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("maximumMessageCount", new Integer(v)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public int getMessageTimeToLive() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Integer)this.mbs.getAttribute(this.objectName, "messageTimeToLive");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setMessageTimeToLive(int v) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("messageTimeToLive", new Integer(v)));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public void setGroups(String[] groups) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("groups", groups));
        }
        catch (Exception ex) {
            throw this.handleAdminException(ex);
        }
    }

    public String[] getGroups() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String[])this.mbs.getAttribute(this.objectName, "groups");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public long getLoadPollInterval() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (Long)this.mbs.getAttribute(this.objectName, "loadPollInterval");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setLoadPollInterval(long loadPollInterval) throws AdminException {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            this.mbs.setAttribute(this.objectName, new Attribute("loadPollInterval", new Long(loadPollInterval)));
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public String getLoadProbe() {
        try {
            Assert.assertTrue((this.objectName != null ? 1 : 0) != 0);
            return (String)this.mbs.getAttribute(this.objectName, "loadProbe");
        }
        catch (Exception ex) {
            throw this.handleException(ex);
        }
    }

    public void setLoadProbe(ServerLoadProbe loadProbe) throws AdminException {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

