/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.internal.AbstractHealthEvaluator;
import com.gemstone.gemfire.admin.internal.GemFireHealthConfigImpl;
import com.gemstone.gemfire.admin.internal.HealthEvaluatorTestCase;
import com.gemstone.gemfire.admin.internal.MemberHealthEvaluator;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.ProcessStats;
import com.gemstone.gemfire.internal.PureJavaMode;
import java.util.ArrayList;

public class MemberHealthEvaluatorTest
extends HealthEvaluatorTestCase {
    public MemberHealthEvaluatorTest(String name) {
        super(name);
    }

    public void testCheckVMProcessSize() throws InterruptedException {
        if (PureJavaMode.osStatsAreAvailable()) {
            GemFireStatSampler sampler = this.system.getStatSampler();
            MemberHealthEvaluatorTest.assertNotNull((Object)sampler);
            sampler.waitForInitialization(10000L);
            ProcessStats stats = sampler.getProcessStats();
            MemberHealthEvaluatorTest.assertNotNull((Object)stats);
            ArrayList status = new ArrayList();
            long threshold = stats.getProcessSize() * 2L;
            if (threshold <= 0L) {
                return;
            }
            GemFireHealthConfigImpl config = new GemFireHealthConfigImpl(null);
            config.setMaxVMProcessSize(threshold);
            MemberHealthEvaluator eval = new MemberHealthEvaluator((GemFireHealthConfig)config, this.system.getDistributionManager());
            eval.evaluate(status);
            MemberHealthEvaluatorTest.assertTrue((boolean)status.isEmpty());
            status = new ArrayList();
            long processSize = stats.getProcessSize();
            threshold = processSize / 2L;
            MemberHealthEvaluatorTest.assertTrue((String)("Threshold (" + threshold + ") is > 0.  Process size is " + processSize), (threshold > 0L ? 1 : 0) != 0);
            config = new GemFireHealthConfigImpl(null);
            config.setMaxVMProcessSize(threshold);
            eval = new MemberHealthEvaluator((GemFireHealthConfig)config, this.system.getDistributionManager());
            eval.evaluate(status);
            MemberHealthEvaluatorTest.assertEquals((int)1, (int)status.size());
            AbstractHealthEvaluator.HealthStatus ill = (AbstractHealthEvaluator.HealthStatus)status.get(0);
            MemberHealthEvaluatorTest.assertEquals((Object)GemFireHealth.OKAY_HEALTH, (Object)ill.getHealthCode());
            MemberHealthEvaluatorTest.assertTrue((ill.getDiagnosis().indexOf("The size of this VM") != -1 ? 1 : 0) != 0);
        }
    }
}

