/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemDUnitTest;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class SystemMemberDUnitTest
extends AdminDUnitTestCase {
    public SystemMemberDUnitTest(String name) {
        super(name);
    }

    public void testHostInformation() throws Exception {
        Host host = Host.getHost(0);
        String hostName = SystemMemberDUnitTest.getServerHostName(host);
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        final String testName = this.getName();
        SystemMemberDUnitTest.assertFalse((boolean)this.isConnectedToDS());
        final AdminDistributedSystem system = this.tcSystem;
        final int vmCount = host.getVMCount();
        for (int i = 0; i < vmCount; ++i) {
            VM vm = host.getVM(i);
            final int pid = vm.getPid();
            vm.invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                    Properties props = SystemMemberDUnitTest.this.getDistributedSystemProperties();
                    String name = testName + "_" + pid;
                    props.setProperty("name", name);
                    SystemMemberDUnitTest.this.getSystem(props);
                }
            });
        }
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return system.getSystemMemberApplications().length >= vmCount;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications never reached " + vmCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        SystemMember[] apps = system.getSystemMemberApplications();
        SystemMemberDUnitTest.assertEquals((int)host.getVMCount(), (int)apps.length);
        for (int i = 0; i < apps.length; ++i) {
            SystemMember app = apps[i];
            SystemMemberDUnitTest.assertTrue((boolean)app.getType().isApplication());
            String appName = app.getName();
            if (appName.indexOf(testName) == -1) {
                String s = "Expected app name \"" + appName + "\" to contain \"" + testName + "\"";
                SystemMemberDUnitTest.fail((String)s);
            }
            String expected = InetAddress.getByName(hostName).getCanonicalHostName();
            String actual = app.getHostAddress().getCanonicalHostName();
            if (!actual.startsWith(expected)) {
                String s = "Expected \"" + expected + "\" got \"" + actual + "\"";
                SystemMemberDUnitTest.fail((String)s);
            }
            InetAddress address = app.getHostAddress();
            boolean foundAddress = false;
            for (int j = 0; j < addresses.length; ++j) {
                if (!addresses[j].equals(address)) continue;
                foundAddress = true;
                break;
            }
            SystemMemberDUnitTest.assertTrue((boolean)foundAddress);
        }
    }

    public void testStringsAndThings() throws Exception {
        AdminDistributedSystem system = this.tcSystem;
        ArrayList<SystemMember> members = new ArrayList<SystemMember>();
        members.addAll(Arrays.asList(system.getSystemMemberApplications()));
        for (SystemMember member : members) {
            SystemMemberDUnitTest.assertNotNull((Object)member.getId());
            SystemMemberDUnitTest.assertNotNull((Object)member.getLog());
            SystemMemberDUnitTest.assertNotNull((Object)member.getVersion());
        }
    }

    public void testNameIsId() throws Exception {
        Host host = Host.getHost(0);
        SystemMemberDUnitTest.assertFalse((boolean)this.isConnectedToDS());
        final AdminDistributedSystem system = this.tcSystem;
        final int vmCount = host.getVMCount();
        for (int i = 0; i < vmCount; ++i) {
            VM vm = host.getVM(i);
            vm.invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                    Properties props = SystemMemberDUnitTest.this.getDistributedSystemProperties();
                    String name = "";
                    props.setProperty("name", name);
                    SystemMemberDUnitTest.this.getSystem(props);
                }
            });
        }
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return system.getSystemMemberApplications().length >= vmCount;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected  failure", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications never reached " + vmCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
        SystemMember[] apps = system.getSystemMemberApplications();
        SystemMemberDUnitTest.assertEquals((int)host.getVMCount(), (int)apps.length);
        for (int i = 0; i < apps.length; ++i) {
            SystemMember app = apps[i];
            SystemMemberDUnitTest.assertEquals((String)app.getId(), (String)app.getName());
        }
    }

    public void testRolesAndDistributedMember() throws Exception {
        final String[] vmRoles = new String[]{"VM_A", "VM_B", "VM_C", "VM_D"};
        SystemMemberDUnitTest.assertFalse((boolean)this.isConnectedToDS());
        final AdminDistributedSystem system = this.tcSystem;
        final int vmCount = Host.getHost(0).getVMCount();
        int i = 0;
        while (i < vmCount) {
            final int vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                    Properties props = SystemMemberDUnitTest.this.getDistributedSystemProperties();
                    props.setProperty("name", String.valueOf(vm));
                    props.setProperty("roles", vmRoles[vm]);
                    SystemMemberDUnitTest.this.getSystem(props);
                }
            });
        }
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return system.getSystemMemberApplications().length >= vmCount;
                }
                catch (AdminException e) {
                    DistributedTestCase.fail("unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return "system member applications never reached " + vmCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        SystemMember[] apps = system.getSystemMemberApplications();
        SystemMemberDUnitTest.assertEquals((int)vmCount, (int)apps.length);
        for (int i2 = 0; i2 < apps.length; ++i2) {
            SystemMember app = apps[i2];
            String[] roles = app.getRoles();
            DistributedMember distMember = app.getDistributedMember();
            SystemMemberDUnitTest.assertEquals((int)1, (int)roles.length);
            String name = app.getName();
            int whichVm = new Integer(name);
            SystemMemberDUnitTest.assertEquals((String)vmRoles[whichVm], (String)roles[0]);
            SystemMemberDUnitTest.assertNotNull((Object)distMember);
            DistributedMember vmMember = (DistributedMember)Host.getHost(0).getVM(whichVm).invoke(DistributedSystemDUnitTest.class, "getDistributedMember", new Object[0]);
            SystemMemberDUnitTest.assertNotNull((Object)vmMember);
            SystemMemberDUnitTest.assertEquals((Object)vmMember, (Object)distMember);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        if (this.isJMX() && this.agent != null) {
            LogWriter logger = this.agent.getLogWriter();
            logger.info("<ExpectedException action=add>" + RuntimeAdminException.class.getName() + "</ExpectedException>");
            logger.info("<ExpectedException action=add>" + DistributedSystemDisconnectedException.class.getName() + "</ExpectedException>");
            logger.info("<ExpectedException action=add>" + InterruptedException.class.getName() + "</ExpectedException>");
        }
        super.tearDown2();
    }
}

