/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminDUnitTestCase;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.CacheServerConfig;
import com.gemstone.gemfire.admin.ConfigurationParameter;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributedSystemFactoryTest;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.admin.DistributionLocatorConfig;
import com.gemstone.gemfire.admin.StatisticResource;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberType;
import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.admin.internal.ManagedEntityConfigXmlGenerator;
import com.gemstone.gemfire.admin.internal.ManagedEntityConfigXmlParser;
import com.gemstone.gemfire.admin.internal.ManagedEntityControllerFactory;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.i18n.StringIdImpl;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.ManagerLogWriter;
import com.gemstone.gemfire.internal.PureLogWriter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.StopWatch;
import com.gemstone.org.jgroups.util.StringId;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.HostHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class DistributedSystemDUnitTest
extends AdminDUnitTestCase {
    public DistributedSystemDUnitTest(String name) {
        super(name);
    }

    public static void assertEquals(DistributedSystemConfig config1, DistributedSystemConfig config2) {
        DistributedSystemDUnitTest.assertEquals((String)config1.getSystemId(), (String)config2.getSystemId());
        DistributedSystemDUnitTest.assertEquals((String)config1.getSystemName(), (String)config2.getSystemName());
        DistributedSystemDUnitTest.assertEquals((String)config1.getMcastAddress(), (String)config2.getMcastAddress());
        DistributedSystemDUnitTest.assertEquals((int)config1.getMcastPort(), (int)config2.getMcastPort());
        DistributedSystemDUnitTest.assertEquals((String)config1.getLocators(), (String)config2.getLocators());
        DistributedSystemDUnitTest.assertEquals((String)config1.getRemoteCommand(), (String)config2.getRemoteCommand());
        DistributedSystemDUnitTest.assertEquals(config1.getDistributionLocatorConfigs(), config2.getDistributionLocatorConfigs());
        DistributedSystemDUnitTest.assertEquals((boolean)config1.isSSLEnabled(), (boolean)config2.isSSLEnabled());
        DistributedSystemDUnitTest.assertEquals((String)config1.getSSLProtocols(), (String)config2.getSSLProtocols());
        DistributedSystemDUnitTest.assertEquals((String)config1.getSSLCiphers(), (String)config2.getSSLCiphers());
        DistributedSystemDUnitTest.assertEquals((boolean)config1.isSSLAuthenticationRequired(), (boolean)config2.isSSLAuthenticationRequired());
        DistributedSystemDUnitTest.assertEquals((Object)config1.getSSLProperties(), (Object)config2.getSSLProperties());
    }

    public static void assertEquals(DistributionLocatorConfig[] array1, DistributionLocatorConfig[] array2) {
        DistributedSystemDUnitTest.assertEquals((int)array1.length, (int)array2.length);
        for (int i = 0; i < array1.length; ++i) {
            DistributedSystemDUnitTest.assertEquals(array1[i], array2[i]);
        }
    }

    public static void assertEquals(DistributionLocatorConfig l1, DistributionLocatorConfig l2) {
        DistributedSystemDUnitTest.assertEquals((String)l1.getHost(), (String)l2.getHost());
        DistributedSystemDUnitTest.assertEquals((int)l1.getPort(), (int)l2.getPort());
        DistributedSystemDUnitTest.assertEquals((String)l1.getBindAddress(), (String)l2.getBindAddress());
        DistributedSystemDUnitTest.assertEquals((String)l1.getWorkingDirectory(), (String)l2.getWorkingDirectory());
        DistributedSystemDUnitTest.assertEquals((String)l1.getProductDirectory(), (String)l2.getProductDirectory());
        DistributedSystemDUnitTest.assertEquals((String)l1.getRemoteCommand(), (String)l2.getRemoteCommand());
    }

    public void testDefaultRemoteCommand() {
        DistributedSystemDUnitTest.assertNotNull((Object)this.tcSystem);
        AdminDistributedSystem adminSystem = this.tcSystem;
        DistributedSystemDUnitTest.assertEquals((String)"rsh -n {HOST} {CMD}", (String)adminSystem.getRemoteCommand());
        DistributedSystemDUnitTest.assertEquals((String)"rsh -n {HOST} {CMD}", (String)"rsh -n {HOST} {CMD}");
    }

    public void testNullRemoteCommand() throws Exception {
        DistributedSystemDUnitTest.assertNotNull((Object)this.tcSystem);
        String command = null;
        AdminDistributedSystem adminSystem = this.tcSystem;
        adminSystem.setRemoteCommand(command);
        DistributedSystemDUnitTest.assertEquals(command, (String)adminSystem.getRemoteCommand());
    }

    public void testEmptyRemoteCommand() throws Exception {
        DistributedSystemDUnitTest.assertNotNull((Object)this.tcSystem);
        String command = "";
        AdminDistributedSystem adminSystem = this.tcSystem;
        adminSystem.setRemoteCommand("");
        DistributedSystemDUnitTest.assertEquals((String)"", (String)adminSystem.getRemoteCommand());
    }

    public void testValidRemoteCommands() throws Exception {
        DistributedSystemDUnitTest.assertNotNull((Object)this.tcSystem);
        this.validateRemoteCommandIsValid("rsh -n {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -l klund {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -n -d {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -PN {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -P0 {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -l klund -n -d {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -n -l klund -d {host} {cmd}");
        this.validateRemoteCommandIsValid("rsh -n -d -l klund {host} {cmd}");
        this.validateRemoteCommandIsValid("/usr/kerberos/bin/rsh -n {host} {cmd}");
        this.validateRemoteCommandIsValid("C:\\somepath\\rsh.exe -n {host} {cmd}");
        this.validateRemoteCommandIsValid("C:/somepath/rsh.exe -n {host} {cmd}");
        this.validateRemoteCommandIsValid("ssh klund@{host} {cmd}");
        this.validateRemoteCommandIsValid("ssh -l klund {host} {cmd}");
        this.validateRemoteCommandIsValid("ssh -1246AaCfgkMNnqsTtVvXxY klund@{host} {cmd}");
        this.validateRemoteCommandIsValid("ssh -b 127.0.0.1 klund@{host} {cmd}");
        this.validateRemoteCommandIsValid("ssh -b 0:0:0:0:0:0:0:1 {host} {cmd}");
        this.validateRemoteCommandIsValid("ssh -b ::1 klund@{host} {cmd}");
        this.validateRemoteCommandIsValid("ssh -D 127.0.0.1:9999 klund@{host} {cmd}");
    }

    private void validateRemoteCommandIsValid(String command) {
        AdminDistributedSystem adminSystem = this.tcSystem;
        adminSystem.setRemoteCommand(command);
        DistributedSystemDUnitTest.assertEquals((String)command, (String)adminSystem.getRemoteCommand());
    }

    public void testInvalidRemoteCommands() throws Exception {
        DistributedSystemDUnitTest.assertNotNull((Object)this.tcSystem);
        this.validateRemoteCommandIsInvalid("invalid");
        this.validateRemoteCommandIsInvalid("ssh d");
        this.validateRemoteCommandIsInvalid("ssh {host}");
        this.validateRemoteCommandIsInvalid("ssh {host} /bin/ls");
        this.validateRemoteCommandIsInvalid("\"C:/some path/rsh.exe\" -n {host} {cmd}");
        this.validateRemoteCommandIsInvalid("C:/some path/rsh.exe -n {host} {cmd}");
        this.validateRemoteCommandIsInvalid("rsh.bin -n {host} {cmd}");
        this.validateRemoteCommandIsInvalid("{host} {cmd}");
    }

    private void validateRemoteCommandIsInvalid(String command) {
        AdminDistributedSystem adminSystem;
        block4: {
            adminSystem = this.tcSystem;
            try {
                adminSystem.setRemoteCommand(command);
                DistributedSystemDUnitTest.fail((String)"invalid remote command should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InternalGemFireException expected) {
                Throwable cause = expected.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof IllegalArgumentException) break block4;
                throw expected;
            }
        }
        DistributedSystemDUnitTest.assertFalse((boolean)command.equals(adminSystem.getRemoteCommand()));
    }

    protected int getSystemMemberApplicationCount() {
        int vmCount = 0;
        Host host = Host.getHost(0);
        for (int i = 0; i < host.getVMCount(); ++i) {
            if (this.isJMX() && i == 3) continue;
            ++vmCount;
        }
        if (this.isConnectedToDS()) {
            ++vmCount;
        }
        return vmCount;
    }

    public void testGetSystemMemberApplications() throws Throwable {
        VM vm;
        int j;
        int i;
        DistributedSystemDUnitTest.assertTrue((boolean)this.tcSystem.isConnected());
        if (!this.isJMX()) {
            DistributedSystemFactoryTest.checkEnableAdministrationOnly((boolean)true, (boolean)true);
            DistributedSystemFactoryTest.checkEnableAdministrationOnly((boolean)false, (boolean)true);
        }
        for (i = 0; i < Host.getHostCount(); ++i) {
            j = 0;
            while (j < Host.getHost(i).getVMCount()) {
                vm = Host.getHost(i).getVM(j);
                final int v = j++;
                vm.invoke(new SerializableRunnable("disconnect from distributed system"){

                    @Override
                    public void run() {
                        if (DistributedSystemDUnitTest.this.isJMX() && v == 3) {
                            return;
                        }
                        CacheTestCase.disconnectFromDS();
                    }
                });
            }
        }
        for (i = 0; i < Host.getHostCount(); ++i) {
            j = 0;
            while (j < Host.getHost(i).getVMCount()) {
                vm = Host.getHost(i).getVM(j);
                final int h = i;
                final int v = j++;
                vm.invoke(new SerializableRunnable("Connect to distributed system"){

                    @Override
                    public void run() {
                        if (DistributedSystemDUnitTest.this.isJMX() && v == 3) {
                            return;
                        }
                        Properties props = new Properties();
                        String className = DistributedSystemDUnitTest.this.getClass().getName();
                        String name = className.substring(className.lastIndexOf(".") + 1) + "_Host" + h + "_VM" + v;
                        String roles = "VM" + v;
                        props.setProperty("name", name);
                        props.setProperty("roles", roles);
                        DistributedSystemDUnitTest.this.getSystem(props);
                        TestCase.assertEquals((String)name, (String)DistributedSystemDUnitTest.this.getSystem().getName());
                        DistributedSystemDUnitTest.this.getCache();
                    }
                });
            }
        }
        DistributedSystemDUnitTest.getLogWriter().info("finished connecting VMs");
        DistributedSystemDUnitTest.assertFalse((String)"We're connected to the DS?", (boolean)this.isConnectedToDS());
        DistributedSystemDUnitTest.assertTrue((boolean)this.tcSystem.isConnected());
        int retries = 20;
        for (int attempts = 0; attempts <= retries; ++attempts) {
            if (attempts > 0) {
                DistributedSystemDUnitTest.getLogWriter().info("attempt #" + attempts);
            }
            if (!this.tcSystem.isConnected() || !this.tcSystem.isRunning()) {
                DistributedSystemDUnitTest.getLogWriter().info("attempt #" + attempts + ": !connected or !running");
                DistributedSystemDUnitTest.pause(2000);
                continue;
            }
            SystemMember[] members = this.tcSystem.getSystemMemberApplications();
            int count = this.getSystemMemberApplicationCount();
            if (count != members.length) {
                DistributedSystemDUnitTest.getLogWriter().info("attempt #" + attempts + ": appcount = " + count + "; members = " + members.length);
                DistributedSystemDUnitTest.pause(2000);
                continue;
            }
            for (int i2 = 0; i2 < members.length; ++i2) {
                this.checkSystemMember(members[i2]);
            }
            break;
        }
        DistributedSystemDUnitTest.assertTrue((boolean)this.tcSystem.isConnected());
        DistributedSystemDUnitTest.assertTrue((boolean)this.tcSystem.isRunning());
        SystemMember[] apps = this.tcSystem.getSystemMemberApplications();
        if (this.getSystemMemberApplicationCount() != apps.length) {
            for (int i3 = 0; i3 < apps.length; ++i3) {
                DistributedSystemDUnitTest.getLogWriter().info("app" + i3 + ": " + apps[i3]);
            }
        }
        DistributedSystemDUnitTest.assertEquals((int)this.getSystemMemberApplicationCount(), (int)apps.length);
        this.subTestGetSystemMemberApplications();
    }

    protected void subTestGetSystemMemberApplications() throws Exception {
    }

    public void testLookupSystemMember() throws Throwable {
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedSystemDUnitTest.this.getSystem();
            }
        });
        DistributedMember distMember = (DistributedMember)Host.getHost(0).getVM(0).invoke(DistributedSystemDUnitTest.class, "getDistributedMember", new Object[0]);
        DistributedSystemDUnitTest.assertFalse((String)"We're connected to the DS?", (boolean)this.isConnectedToDS());
        int retries = 20;
        SystemMember member = null;
        for (int attempts = 0; attempts <= retries; ++attempts) {
            if (attempts > 0) {
                DistributedSystemDUnitTest.getLogWriter().info("attempt #" + attempts);
            }
            if (!this.tcSystem.isConnected() || !this.tcSystem.isRunning()) {
                DistributedSystemDUnitTest.pause(2000);
                continue;
            }
            member = this.tcSystem.lookupSystemMember(distMember);
            if (member == null) {
                DistributedSystemDUnitTest.pause(2000);
                continue;
            }
            this.checkSystemMember(member);
            break;
        }
        Assert.assertTrue((member != null ? 1 : 0) != 0, (Object)("Member " + distMember + " never appeared"));
        DistributedSystemDUnitTest.assertTrue((boolean)this.tcSystem.isConnected());
        DistributedSystemDUnitTest.assertTrue((boolean)this.tcSystem.isRunning());
        DistributedSystemDUnitTest.assertNotNull((Object)this.tcSystem.lookupSystemMember(distMember));
    }

    public void checkSystemMember(SystemMember mbr) throws Exception {
        DistributedSystemDUnitTest.assertEquals((Object)SystemMemberType.APPLICATION, (Object)mbr.getType());
        DistributedSystemDUnitTest.assertNotNull((Object)mbr.getId());
        DistributedSystemDUnitTest.assertNotNull((Object)mbr.getName());
        DistributedSystemDUnitTest.assertNotNull((Object)mbr.getHost());
        DistributedSystemDUnitTest.assertNotNull((Object)mbr.getHostAddress());
        DistributedSystemDUnitTest.assertNotNull((Object)mbr.getLog());
        DistributedSystemDUnitTest.assertNotNull((Object)mbr.getVersion());
        try {
            ConfigurationParameter[] config = mbr.getConfiguration();
            DistributedSystemDUnitTest.assertTrue((config.length > 0 ? 1 : 0) != 0);
        }
        catch (UnsupportedOperationException e) {
            DistributedSystemDUnitTest.getLogWriter().info("getConfiguration not supported in this test");
        }
        StatisticResource[] statResources = mbr.getStats();
        DistributedSystemDUnitTest.assertTrue((statResources.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < statResources.length; ++i) {
            StatisticResource statResource = statResources[i];
            DistributedSystemDUnitTest.assertNotNull((Object)statResource.getName());
            DistributedSystemDUnitTest.assertNotNull((Object)statResource.getDescription());
            DistributedSystemDUnitTest.assertNotNull((Object)statResource.getType());
            DistributedSystemDUnitTest.assertNotNull((Object)statResource.getOwner());
            DistributedSystemDUnitTest.assertNotNull((Object)statResource.getStatistics());
            statResource.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlerts() throws Exception {
        int[] arg = new int[]{1, 2, 5, 10};
        StringId messageId = LocalizedStrings.TESTING_THIS_MESSAGE_HAS_0_MEMBERS;
        LogWriter logger = DistributedSystemDUnitTest.getLogWriter();
        try {
            ArrayList<Locale> localeList = new ArrayList<Locale>();
            localeList.add(Locale.US);
            localeList.add(Locale.JAPAN);
            block5: for (int index = 0; index < localeList.size(); ++index) {
                Locale testLocale = (Locale)localeList.get(index);
                logger.info("Testing Alerts with Locale = " + testLocale);
                StringIdImpl.setLocale((Locale)testLocale);
                for (int i = 0; i < arg.length; ++i) {
                    try {
                        this.doTestAlerts(arg[i], messageId.toLocalizedString(new Object[]{1}));
                        continue block5;
                    }
                    catch (AssertionFailedError e) {
                        if (i != arg.length) continue;
                        throw e;
                    }
                }
            }
        }
        finally {
            logger.finer("Test complete, Restoring locale to US English");
            StringIdImpl.setLocale((Locale)Locale.US);
        }
    }

    private void doTestAlerts(final int waitMultiplier, final String message) throws Exception {
        DistributedSystemDUnitTest.getLogWriter().info("[doTestAlerts] testing with waitMultiplier " + waitMultiplier);
        String connectionName = "TestAlerts";
        if (!this.tcSystem.isConnected()) {
            this.reconnectToSystem();
        }
        this.tcSystem.setAlertLevel(AlertLevel.SEVERE);
        TestAlertListener listener = new TestAlertListener(){

            @Override
            public void alert2(Alert alert) {
                DistributedTestCase.getLogWriter().info("DEBUG: alert=" + alert);
                TestCase.assertEquals((Object)AlertLevel.SEVERE, (Object)alert.getLevel());
                TestCase.assertTrue((String)alert.getMessage(), (alert.getMessage().indexOf(message) != -1 ? 1 : 0) != 0);
                TestCase.assertEquals((String)"TestAlerts", (String)alert.getConnectionName());
                if (!DistributedSystemDUnitTest.this.isJMX()) {
                    TestCase.assertNotNull((Object)alert.getSystemMember());
                }
                long now = System.currentTimeMillis();
                long then = alert.getDate().getTime();
                TestCase.assertTrue((String)(now + " - " + then + " >= 1000"), (now - then < 1000L ? 1 : 0) != 0);
            }
        };
        this.tcSystem.addAlertListener((AlertListener)listener);
        DistributedSystemDUnitTest.assertEquals((Object)AlertLevel.SEVERE, (Object)this.tcSystem.getAlertLevel());
        VM vm = Host.getHost(0).getVM(0);
        vm.invoke(new SerializableRunnable("Reconnect to distributed system"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                Properties props = new Properties();
                props.setProperty("name", "TestAlerts");
                LogWriter logger = DistributedSystemDUnitTest.this.getSystem(props).getLogWriter();
                TestCase.assertEquals((String)"TestAlerts", (String)DistributedSystemDUnitTest.this.getSystem().getName());
                TestCase.assertEquals((String)"TestAlerts", (String)((PureLogWriter)logger).getConnectionName());
                DistributedTestCase.pause(1000 * waitMultiplier);
                logger.severe(message);
            }
        });
        DistributedSystemDUnitTest.assertTrue((boolean)listener.waitForInvoked(1000 * waitMultiplier));
        String latest = this.tcSystem.getLatestAlert();
        DistributedSystemDUnitTest.assertNotNull((Object)latest);
        DistributedSystemDUnitTest.assertTrue((String)("Latest message was: \"" + latest + "\""), (latest.indexOf(message) != -1 ? 1 : 0) != 0);
        vm.invoke(new SerializableRunnable("Send low-level alert"){

            @Override
            public void run() {
                LogWriter logger = DistributedSystemDUnitTest.this.getSystem().getLogWriter();
                TestCase.assertEquals((String)"TestAlerts", (String)DistributedSystemDUnitTest.this.getSystem().getName());
                logger.config("No alert should be issued");
            }
        });
        DistributedSystemDUnitTest.pause(1000 * waitMultiplier);
        DistributedSystemDUnitTest.assertFalse((String)"Lowering of log level failed", (boolean)listener.wasInvoked());
        latest = this.tcSystem.getLatestAlert();
        DistributedSystemDUnitTest.assertNotNull((Object)latest);
        DistributedSystemDUnitTest.assertTrue((String)("Latest message was: " + latest), (latest.indexOf(message) != -1 ? 1 : 0) != 0);
        this.tcSystem.removeAlertListener((AlertListener)listener);
        vm.invoke(new SerializableRunnable("Send severe-level alert"){

            @Override
            public void run() {
                LogWriter logger = DistributedSystemDUnitTest.this.getSystem().getLogWriter();
                TestCase.assertEquals((String)"TestAlerts", (String)DistributedSystemDUnitTest.this.getSystem().getName());
                logger.severe(message);
            }
        });
        DistributedSystemDUnitTest.pause(1000 * waitMultiplier);
        DistributedSystemDUnitTest.assertFalse((String)"Removal of AlertListener failed. See bug 34687.", (boolean)listener.wasInvoked());
        DistributedTestCase.getLogWriter().info("Changing alert level to " + AlertLevel.WARNING);
        this.tcSystem.setAlertLevel(AlertLevel.WARNING);
        listener = new TestAlertListener(){

            @Override
            public void alert2(Alert alert) {
                TestCase.assertTrue((AlertLevel.WARNING.getSeverity() <= alert.getLevel().getSeverity() ? 1 : 0) != 0);
                if (alert.getMessage().indexOf(message) == -1) {
                    return;
                }
                if (!DistributedSystemDUnitTest.this.isJMX()) {
                    TestCase.assertNotNull((Object)alert.getSystemMember());
                }
                long now = System.currentTimeMillis();
                long then = alert.getDate().getTime();
                TestCase.assertTrue((String)(now + " - " + then + " >= 1000"), (now - then < 1000L ? 1 : 0) != 0);
            }
        };
        this.tcSystem.addAlertListener((AlertListener)listener);
        DistributedSystemDUnitTest.pause(1000 * waitMultiplier);
        vm.invoke(new SerializableRunnable("Send warning level alert"){

            @Override
            public void run() {
                LogWriter logger = DistributedSystemDUnitTest.this.getSystem().getLogWriter();
                TestCase.assertEquals((String)"TestAlerts", (String)DistributedSystemDUnitTest.this.getSystem().getName());
                logger.warning(message);
            }
        });
        DistributedSystemDUnitTest.assertTrue((boolean)listener.waitForInvoked(1000 * waitMultiplier));
        String latest2 = this.tcSystem.getLatestAlert();
        DistributedSystemDUnitTest.assertNotNull((Object)latest2);
        DistributedSystemDUnitTest.assertTrue((!latest.equals(latest2) ? 1 : 0) != 0);
        this.tcSystem.removeAlertListener((AlertListener)listener);
        DistributedTestCase.getLogWriter().info("Changing alert level to " + AlertLevel.ERROR);
        this.tcSystem.setAlertLevel(AlertLevel.ERROR);
        listener = new TestAlertListener(){

            @Override
            public void alert2(Alert alert) {
                TestCase.assertTrue((AlertLevel.ERROR.getSeverity() <= alert.getLevel().getSeverity() ? 1 : 0) != 0);
                if (alert.getMessage().indexOf(message) == -1) {
                    return;
                }
                if (!DistributedSystemDUnitTest.this.isJMX()) {
                    TestCase.assertNotNull((Object)alert.getSystemMember());
                }
                long now = System.currentTimeMillis();
                long then = alert.getDate().getTime();
                TestCase.assertTrue((String)(now + " - " + then + " >= 1000"), (now - then < 1000L ? 1 : 0) != 0);
            }
        };
        this.tcSystem.addAlertListener((AlertListener)listener);
        DistributedSystemDUnitTest.pause(1000 * waitMultiplier);
        vm.invoke(new SerializableRunnable("Send error level alert"){

            @Override
            public void run() {
                LogWriter logger = DistributedSystemDUnitTest.this.getSystem().getLogWriter();
                TestCase.assertEquals((String)"TestAlerts", (String)DistributedSystemDUnitTest.this.getSystem().getName());
                int maxAttempts = 100;
                boolean found = false;
                for (int i = 0; i < maxAttempts && !(found = ((ManagerLogWriter)logger).hasAlertListener()); ++i) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertTrue((String)"did not find an alert listener in 10 seconds, or was interrupted", (boolean)found);
                logger.error(message);
            }
        });
        DistributedSystemDUnitTest.assertTrue((boolean)listener.waitForInvoked(1000 * waitMultiplier));
        String latest3 = this.tcSystem.getLatestAlert();
        DistributedSystemDUnitTest.assertNotNull((Object)latest3);
        DistributedSystemDUnitTest.assertTrue((!latest.equals(latest3) ? 1 : 0) != 0);
    }

    public void testMembershipEvents() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        vm1.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        final String[] id = new String[1];
        TestSystemMembershipListener listener = new TestSystemMembershipListener(){

            @Override
            public void memberJoined2(SystemMembershipEvent event) {
                id[0] = event.getMemberId();
            }
        };
        if (!this.tcSystem.isConnected()) {
            this.reconnectToSystem();
        }
        this.tcSystem.addMembershipListener((SystemMembershipListener)listener);
        vm0.invoke(new SerializableRunnable("Connect to DS"){

            @Override
            public void run() {
                DistributedSystemDUnitTest.this.getSystem();
            }
        });
        int maxAttempts = 20;
        for (i = 0; i <= maxAttempts; ++i) {
            DistributedSystemDUnitTest.pause(50);
            try {
                DistributedSystemDUnitTest.assertTrue((boolean)listener.wasInvoked());
                break;
            }
            catch (AssertionFailedError e) {
                if (i < maxAttempts) continue;
                vm0.invoke(new SerializableRunnable("Disconnect from DS"){

                    @Override
                    public void run() {
                        CacheTestCase.disconnectFromDS();
                    }
                });
                throw e;
            }
        }
        vm0.invoke(new SerializableRunnable("Check id"){

            @Override
            public void run() {
                String myId = DistributedSystemDUnitTest.this.getSystem().getMemberId();
                TestCase.assertEquals((String)id[0], (String)myId);
            }
        });
        vm1.invoke(new SerializableRunnable("Connect to DS"){

            @Override
            public void run() {
                DistributedSystemDUnitTest.this.getSystem();
            }
        });
        maxAttempts = 20;
        for (i = 0; i <= maxAttempts; ++i) {
            DistributedSystemDUnitTest.pause(50);
            try {
                DistributedSystemDUnitTest.assertTrue((boolean)listener.wasInvoked());
                break;
            }
            catch (AssertionFailedError e) {
                if (i < maxAttempts) continue;
                throw e;
            }
        }
        vm1.invoke(new SerializableRunnable("Check id"){

            @Override
            public void run() {
                String myId = DistributedSystemDUnitTest.this.getSystem().getMemberId();
                TestCase.assertEquals((String)id[0], (String)myId);
            }
        });
        this.tcSystem.removeMembershipListener((SystemMembershipListener)listener);
        vm1.invoke(new SerializableRunnable("Reconnect to DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributedSystemDUnitTest.this.getSystem();
            }
        });
        DistributedSystemDUnitTest.pause(250);
        DistributedSystemDUnitTest.assertFalse((String)"Removal of MembershipListener failed. See bug 34687.", (boolean)listener.wasInvoked());
        listener = new TestSystemMembershipListener(){

            @Override
            public void memberLeft2(SystemMembershipEvent event) {
                id[0] = event.getMemberId();
            }
        };
        this.tcSystem.addMembershipListener((SystemMembershipListener)listener);
        vm0.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        maxAttempts = 20;
        for (i = 0; i <= maxAttempts; ++i) {
            DistributedSystemDUnitTest.pause(50);
            try {
                DistributedSystemDUnitTest.assertTrue((boolean)listener.wasInvoked());
                break;
            }
            catch (AssertionFailedError e) {
                if (i < maxAttempts) continue;
                throw e;
            }
        }
        vm1.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        maxAttempts = 20;
        for (i = 0; i <= maxAttempts; ++i) {
            DistributedSystemDUnitTest.pause(50);
            try {
                DistributedSystemDUnitTest.assertTrue((boolean)listener.wasInvoked());
                break;
            }
            catch (AssertionFailedError e) {
                if (i < maxAttempts) continue;
                throw e;
            }
        }
    }

    public void testReadOnlyDistributedSystemConfig() {
        if (this.isJMX()) {
            return;
        }
        if (!this.tcSystem.isConnected()) {
            this.reconnectToSystem();
        }
        DistributedSystemConfig config = this.tcSystem.getConfig();
        try {
            config.setLocators("frank[12345]");
            DistributedSystemDUnitTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            config.setMcastPort(44444);
            DistributedSystemDUnitTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCloneDistributedSystemConfig() throws Exception {
        if (this.isJMX()) {
            return;
        }
        DistributedSystemConfig config = this.tcSystem.getConfig();
        DistributedSystemConfig config2 = (DistributedSystemConfig)config.clone();
        DistributedSystemDUnitTest.assertEquals(config, config2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManageDistributionLocators() throws Exception {
        if (!ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            return;
        }
        if (HostHelper.isWindows()) {
            return;
        }
        VM vm = Host.getHost(0).getVM(0);
        String hostName = DistributedSystemDUnitTest.getServerHostName(Host.getHost(0));
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPortsForDUnitSite(2);
        int port1 = freeTCPPorts[0];
        int port2 = freeTCPPorts[1];
        AdminDistributedSystem admin = this.tcSystem;
        admin.disconnect();
        DistributedSystemDUnitTest.disconnectFromDS();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem();
        config.setMcastAddress(DistributedSystemConfig.DEFAULT_MCAST_ADDRESS);
        config.setMcastPort(0);
        config.setLocators("");
        String bindAddress = DistributedTestCase.getIPLiteral();
        config.setBindAddress(bindAddress);
        boolean ipv6 = false;
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            if (addr instanceof Inet6Address) {
                ipv6 = true;
            }
        }
        catch (UnknownHostException e) {
            DistributedSystemDUnitTest.getLogWriter().severe("exception looking up " + hostName, (Throwable)e);
        }
        if (ipv6) {
            config.setRemoteCommand("ssh -6");
        } else {
            config.setRemoteCommand("rsh -n {HOST} {CMD}");
        }
        admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        String locatorsString = hostName + "[" + port1 + "]," + hostName + "[" + port2 + "]";
        DistributionLocator locator1 = admin.addDistributionLocator();
        locator1.getConfig().setPort(port1);
        File dir1 = new File(this.getUniqueName() + "_locator1");
        dir1.mkdirs();
        locator1.getConfig().setHost(hostName);
        locator1.getConfig().setWorkingDirectory(dir1.getAbsolutePath());
        locator1.getConfig().getDistributedSystemProperties().setProperty("locators", locatorsString);
        locator1.getConfig().getDistributedSystemProperties().setProperty("bind-address", hostName);
        locator1.getConfig().getDistributedSystemProperties().setProperty("log-level", DistributedSystemDUnitTest.getDUnitLogLevel());
        DistributedSystemDUnitTest.getLogWriter().info("Starting Locator 1 on port " + port1);
        locator1.start();
        DistributedSystemDUnitTest.assertTrue((String)("Locator1 did not start on " + locator1.getConfig().getHost()), (boolean)locator1.waitToStart(60000L));
        DistributionLocator locator2 = admin.addDistributionLocator();
        locator2.getConfig().setPort(port2);
        File dir2 = new File(this.getUniqueName() + "_locator2");
        dir2.mkdirs();
        locator2.getConfig().setHost(hostName);
        locator2.getConfig().setWorkingDirectory(dir2.getAbsolutePath());
        locator2.getConfig().getDistributedSystemProperties().setProperty("locators", locatorsString);
        locator2.getConfig().getDistributedSystemProperties().setProperty("bind-address", hostName);
        locator2.getConfig().getDistributedSystemProperties().setProperty("log-level", DistributedSystemDUnitTest.getDUnitLogLevel());
        DistributedSystemDUnitTest.getLogWriter().info("Starting Locator 2 on port " + port2);
        locator2.start();
        DistributedSystemDUnitTest.assertTrue((String)("Locator2 did not start on " + locator2.getConfig().getHost()), (boolean)locator2.waitToStart(120000L));
        DistributionLocatorConfig config1 = locator1.getConfig();
        DistributionLocatorConfig config2 = locator2.getConfig();
        String locatorString = config1.getHost() + "[" + config1.getPort() + "]," + config2.getHost() + "[" + config2.getPort() + "]";
        String vmName = this.getUniqueName() + "-vm";
        final Properties props = new Properties();
        props.setProperty("name", vmName);
        props.setProperty("locators", locatorString);
        props.setProperty("mcast-port", "0");
        props.setProperty("log-file", vmName + ".log");
        props.setProperty("log-level", DistributedSystemDUnitTest.getDUnitLogLevel());
        vm.invoke(new SerializableRunnable("Connect to new DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributedSystem.connect((Properties)props);
            }
        });
        boolean wasDedicated = DistributionManager.isDedicatedAdminVM;
        DistributionManager.isDedicatedAdminVM = true;
        try {
            DistributedSystemDUnitTest.getLogWriter().info("Administering DS with locators " + admin.getConfig().getLocators());
            admin.getConfig().setSystemName(this.getUniqueName() + "-admin");
            admin.getConfig().setSystemId(this.getUniqueName() + "-admin");
            admin.connect();
            DistributedSystemDUnitTest.assertTrue((String)"Couldn't administer DS", (boolean)admin.waitToBeConnected(60000L));
            DistributionLocator[] locs = admin.getDistributionLocators();
            DistributedSystemDUnitTest.assertEquals((int)2, (int)locs.length);
            final DistributionLocator finalLoc1 = locator1;
            final DistributionLocator finalLoc2 = locator2;
            DistributedTestCase.WaitCriterion wc1 = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return finalLoc1.isRunning();
                }

                @Override
                public String description() {
                    return "locator1 started";
                }
            };
            DistributedSystemDUnitTest.waitForCriterion(wc1, 2000L, 10L, true);
            DistributedTestCase.WaitCriterion wc2 = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return finalLoc2.isRunning();
                }

                @Override
                public String description() {
                    return "locator2 started";
                }
            };
            DistributedSystemDUnitTest.waitForCriterion(wc2, 2000L, 10L, true);
            SystemMember[] members = admin.getSystemMemberApplications();
            StringBuffer sb = new StringBuffer();
            if (members.length > 0) {
                sb.append(members.length);
                sb.append(" members: ");
                for (int i = 0; i < members.length; ++i) {
                    SystemMember member = members[i];
                    sb.append(member.getName());
                    sb.append(" (");
                    sb.append(member.getId());
                    sb.append(") ");
                }
            }
            if (members.length == 1) {
                DistributedSystemDUnitTest.assertEquals((String)vmName, (String)members[0].getName());
            }
            vm.invoke(new SerializableRunnable("Disconnect from new DS"){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                    DistributedSystem.connect((Properties)props).disconnect();
                }
            });
            DistributedSystemDUnitTest.assertLog(locator1.getLog(), 5);
            DistributedSystemDUnitTest.assertLog(locator2.getLog(), 5);
            locator1.stop();
            locator2.stop();
            DistributedSystemDUnitTest.assertTrue((boolean)locator1.waitToStop(60000L));
            DistributedSystemDUnitTest.assertTrue((boolean)locator2.waitToStop(60000L));
            DistributedSystemDUnitTest.assertFalse((boolean)locator1.isRunning());
            DistributedSystemDUnitTest.assertFalse((boolean)locator2.isRunning());
            admin.disconnect();
            DistributedSystemDUnitTest.pause(5000);
            DistributedSystemDUnitTest.assertEquals((String)sb.toString(), (int)1, (int)members.length);
        }
        finally {
            DistributionManager.isDedicatedAdminVM = wasDedicated;
        }
        this.reconnectToSystem();
    }

    public void testXmlConfig() throws Exception {
        if (!ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            return;
        }
        Random random = new Random();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem();
        AdminDistributedSystem adminSystem = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        config.setMcastPort(0);
        config.setLocators("");
        String id = this.getUniqueName();
        config.setSystemId(id);
        String remoteCommand = "ssh {HOST} {CMD}";
        config.setRemoteCommand("ssh {HOST} {CMD}");
        boolean sslEnabled = true;
        config.setSSLEnabled(true);
        String protocols = "FRED/JOE/BOB";
        config.setSSLProtocols("FRED/JOE/BOB");
        String ciphers = "BOB/JOE/FRED";
        config.setSSLCiphers("BOB/JOE/FRED");
        boolean sslAuthenticationRequired = random.nextBoolean();
        config.setSSLAuthenticationRequired(sslAuthenticationRequired);
        Properties sslProps = new Properties();
        sslProps.setProperty("ONE", "1");
        sslProps.setProperty("TWO", "2");
        config.setSSLProperties(sslProps);
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int port1 = freeTCPPorts[0];
        int port2 = freeTCPPorts[1];
        String locatorsString = DistributedSystemDUnitTest.getServerHostName(Host.getHost(0)) + "[" + port1 + "]," + DistributedSystemDUnitTest.getServerHostName(Host.getHost(0)) + "[" + port2 + "]";
        DistributionLocator locator1 = adminSystem.addDistributionLocator();
        locator1.getConfig().setPort(port1);
        locator1.getConfig().getDistributedSystemProperties().setProperty("locators", locatorsString);
        DistributionLocator locator2 = adminSystem.addDistributionLocator();
        locator2.getConfig().setPort(port2);
        locator2.getConfig().getDistributedSystemProperties().setProperty("locators", locatorsString);
        CacheServerConfig server1 = adminSystem.addCacheServer().getConfig();
        String classpath = "/usr/local/guillermo";
        server1.setClassPath("/usr/local/guillermo");
        String productDirectory = "c:\\GemFire\\stuff";
        server1.setProductDirectory("c:\\GemFire\\stuff");
        CacheServerConfig server2 = adminSystem.addCacheServer().getConfig();
        server2.setRemoteCommand("ssh {HOST} {CMD}");
        String workingDirectory = System.getProperty("user.dir");
        server2.setWorkingDirectory(workingDirectory);
        File file = new File(this.getUniqueName() + ".xml");
        PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
        ManagedEntityConfigXmlGenerator.generate((AdminDistributedSystem)adminSystem, (PrintWriter)pw);
        pw.flush();
        config = AdminDistributedSystemFactory.defineDistributedSystem();
        FileInputStream fis = new FileInputStream(file);
        ManagedEntityConfigXmlParser.parse((InputStream)fis, (DistributedSystemConfig)config);
        DistributedSystemDUnitTest.assertEquals((String)id, (String)config.getSystemId());
        DistributedSystemDUnitTest.assertEquals((String)"ssh {HOST} {CMD}", (String)config.getRemoteCommand());
        DistributedSystemDUnitTest.assertEquals((boolean)true, (boolean)config.isSSLEnabled());
        DistributedSystemDUnitTest.assertEquals((String)"FRED/JOE/BOB", (String)config.getSSLProtocols());
        DistributedSystemDUnitTest.assertEquals((String)"BOB/JOE/FRED", (String)config.getSSLCiphers());
        DistributedSystemDUnitTest.assertEquals((boolean)sslAuthenticationRequired, (boolean)config.isSSLAuthenticationRequired());
        DistributedSystemDUnitTest.assertEquals((Object)sslProps, (Object)config.getSSLProperties());
        DistributionLocatorConfig[] locators = config.getDistributionLocatorConfigs();
        DistributedSystemDUnitTest.assertEquals((int)2, (int)locators.length);
        boolean found1 = false;
        boolean found2 = false;
        for (int i = 0; i < locators.length; ++i) {
            DistributionLocatorConfig locator = locators[i];
            if (locator.getPort() == port1) {
                found1 = true;
                continue;
            }
            if (locator.getPort() == port2) {
                found2 = true;
                continue;
            }
            DistributedSystemDUnitTest.fail((String)("Locator with unknown port " + locator.getPort()));
        }
        DistributedSystemDUnitTest.assertTrue((boolean)found1);
        DistributedSystemDUnitTest.assertTrue((boolean)found2);
        CacheServerConfig[] servers = config.getCacheServerConfigs();
        DistributedSystemDUnitTest.assertEquals((int)2, (int)servers.length);
        for (int i = 0; i < servers.length; ++i) {
            CacheServerConfig server = servers[i];
            if ("/usr/local/guillermo".equals(server.getClassPath())) {
                DistributedSystemDUnitTest.assertEquals((String)"c:\\GemFire\\stuff", (String)server.getProductDirectory());
                continue;
            }
            DistributedSystemDUnitTest.assertEquals((String)"ssh {HOST} {CMD}", (String)server.getRemoteCommand());
            DistributedSystemDUnitTest.assertEquals((String)workingDirectory, (String)server.getWorkingDirectory());
        }
    }

    public void testExistingLocator() throws Exception {
        AdminDistributedSystem system = this.tcSystem;
        DistributionLocator[] locators = system.getDistributionLocators();
        DistributedSystemDUnitTest.assertEquals((int)1, (int)locators.length);
        DistributionLocatorConfig config = locators[0].getConfig();
        DistributedSystemDUnitTest.assertTrue((config.getPort() > 0 ? 1 : 0) != 0);
        InetAddress host2 = InetAddress.getByName(config.getHost());
        DistributedSystemDUnitTest.assertNotNull((Object)config.getWorkingDirectory());
        new File(config.getProductDirectory());
    }

    public void xxtestManyNewMcastMembers() throws Exception {
        DistributedSystemDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int expectedCount = 4;
        int cpuLoadTime = 10000;
        final long startTryingTime = System.currentTimeMillis() + 5000L;
        SerializableRunnable consumeCPU = new SerializableRunnable("consumeCPU"){

            @Override
            public void run() {
                DistributedSystemDUnitTest.this.waitForStartTime(startTryingTime);
                if (Thread.interrupted()) {
                    return;
                }
                long endTime = System.currentTimeMillis() + 10000L;
                while (System.currentTimeMillis() < endTime) {
                    for (int i = 0; i < 100000; ++i) {
                        double u = 3.018622140684698;
                        u = u * u * u / 3.1415926;
                    }
                    DistributedTestCase.pause(100);
                }
            }
        };
        SerializableRunnable testMcast = new SerializableRunnable("manyNewMcastMembers"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Properties env = new Properties();
                env.setProperty("mcast-port", "" + mcastPort);
                env.setProperty("locators", "");
                env.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                env.setProperty("disable-tcp", "true");
                env.setProperty("statistic-sampling-enabled", "true");
                env.setProperty("statistic-archive-file", "manyNewMcastmembers.gfs");
                JGroupMembershipManager.DEBUG_JAVAGROUPS = true;
                try {
                    DistributedSystemDUnitTest.this.waitForStartTime(startTryingTime);
                    if (Thread.interrupted()) {
                        return;
                    }
                    DistributedSystem sys = DistributedSystem.connect((Properties)env);
                    int numClients = ((InternalDistributedSystem)sys).getDistributionManager().getNormalDistributionManagerIds().size();
                    try {
                        if (numClients != 4) {
                            DistributedTestCase.getLogWriter().error("Expected 4 members but found " + numClients);
                        }
                        sys.disconnect();
                        TestCase.assertTrue((numClients == 4 ? 1 : 0) != 0);
                    }
                    catch (Throwable throwable) {
                        TestCase.assertTrue((numClients == 4 ? 1 : 0) != 0);
                        throw throwable;
                    }
                }
                finally {
                    JGroupMembershipManager.DEBUG_JAVAGROUPS = false;
                }
            }
        };
        Thread[] asyncs = new AsyncInvocation[]{vm0.invokeAsync(testMcast), vm1.invokeAsync(testMcast), vm2.invokeAsync(testMcast), vm3.invokeAsync(testMcast)};
        long endWait = System.currentTimeMillis() + 10000L + 60000L;
        while (System.currentTimeMillis() < endWait && this.anyThreadsAlive(asyncs)) {
            DistributedSystemDUnitTest.pause(1000);
        }
        if (this.anyThreadsAlive(asyncs)) {
            throw new RuntimeException("testManyNewMcastMembers failed to wait long enough for async tasks to finish");
        }
        for (int i = 0; i < asyncs.length; ++i) {
            if (((AsyncInvocation)asyncs[i]).getException() == null) continue;
            throw new RuntimeException("testManyNewMcastMembers failed", ((AsyncInvocation)asyncs[i]).getException());
        }
    }

    public void xxxtestManyNewLocatorMembers() throws Exception {
        DistributedSystemDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int expectedCount = 4;
        int cpuLoadTime = 10000;
        final long startTryingTime = System.currentTimeMillis() + 5000L;
        SerializableRunnable consumeCPU = new SerializableRunnable("consumeCPU"){

            @Override
            public void run() {
                DistributedSystemDUnitTest.this.waitForStartTime(startTryingTime);
                if (Thread.interrupted()) {
                    return;
                }
                long endTime = System.currentTimeMillis() + 10000L;
                while (System.currentTimeMillis() < endTime) {
                    for (int i = 0; i < 100000; ++i) {
                        double u = 3.018622140684698;
                        u = u * u * u / 3.1415926;
                    }
                    DistributedTestCase.pause(100);
                }
            }
        };
        SerializableRunnable testLocators = new SerializableRunnable("manyNewMembers with locators"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DistributedSystemDUnitTest.this.waitForStartTime(startTryingTime);
                if (Thread.interrupted()) {
                    return;
                }
                Properties env = new Properties();
                env.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                DistributedSystem sys = DistributedSystem.connect((Properties)env);
                int numClients = ((InternalDistributedSystem)sys).getDistributionManager().getNormalDistributionManagerIds().size();
                try {
                    sys.disconnect();
                    TestCase.assertTrue((numClients == 4 ? 1 : 0) != 0);
                }
                catch (Throwable throwable) {
                    TestCase.assertTrue((numClients == 4 ? 1 : 0) != 0);
                    throw throwable;
                }
            }
        };
        Thread[] asyncs = new AsyncInvocation[]{vm0.invokeAsync(testLocators), vm1.invokeAsync(testLocators), vm2.invokeAsync(testLocators), vm3.invokeAsync(testLocators)};
        long endWait = System.currentTimeMillis() + 10000L + 60000L;
        while (System.currentTimeMillis() < endWait && this.anyThreadsAlive(asyncs)) {
            DistributedSystemDUnitTest.pause(1000);
        }
        if (this.anyThreadsAlive(asyncs)) {
            throw new RuntimeException("testManyNewLocatorMembers failed to wait long enough for async tasks to finish");
        }
        for (int i = 0; i < asyncs.length; ++i) {
            if (((AsyncInvocation)asyncs[i]).getException() == null) continue;
            throw new RuntimeException("testManyNewLocatorMembers failed", ((AsyncInvocation)asyncs[i]).getException());
        }
    }

    private boolean anyThreadsAlive(Thread[] threads) {
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    protected void waitForStartTime(long startTime) {
        long timeLeft = startTime - System.currentTimeMillis();
        DistributedSystemDUnitTest.assertTrue((timeLeft >= 0L ? 1 : 0) != 0);
        while ((timeLeft = startTime - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException e) {
                DistributedSystemDUnitTest.fail("interrupted", e);
            }
        }
    }

    public static abstract class TestSystemMembershipListener
    implements SystemMembershipListener {
        boolean invoked = false;
        protected Throwable callbackError = null;

        public boolean wasInvoked() {
            this.checkForError();
            boolean value = this.invoked;
            this.invoked = false;
            return value;
        }

        public final void memberJoined(SystemMembershipEvent event) {
            this.invoked = true;
            try {
                this.memberJoined2(event);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                this.callbackError = t;
            }
        }

        public void memberJoined2(SystemMembershipEvent event) {
            String s = "Unexpected join; member = " + event.getDistributedMember() + "; id = " + event.getMemberId();
            throw new UnsupportedOperationException(s);
        }

        public final void memberLeft(SystemMembershipEvent event) {
            this.invoked = true;
            try {
                this.memberLeft2(event);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                this.callbackError = t;
            }
        }

        public void memberLeft2(SystemMembershipEvent event) {
            String s = "Unexpected left: " + event;
            throw new UnsupportedOperationException(s);
        }

        public final void memberCrashed(SystemMembershipEvent event) {
            this.invoked = true;
            try {
                this.memberCrashed2(event);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                this.callbackError = t;
            }
        }

        public void memberCrashed2(SystemMembershipEvent event) {
            String s = "Unexpected crash: " + event;
            throw new UnsupportedOperationException(s);
        }

        public final void memberInfo(SystemMembershipEvent event) {
            this.invoked = true;
            try {
                this.memberInfo2(event);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                this.callbackError = t;
            }
        }

        public void memberInfo2(SystemMembershipEvent event) {
            String s = "Unexpected crash: " + event;
            throw new UnsupportedOperationException(s);
        }

        private void checkForError() {
            if (this.callbackError != null) {
                throw new Error("Exception occurred in callback", this.callbackError);
            }
        }
    }

    public static abstract class TestAlertListener
    implements AlertListener {
        boolean invoked = false;
        protected Throwable callbackError = null;
        private final Object syncMe = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wasInvoked() {
            Object object = this.syncMe;
            synchronized (object) {
                this.checkForError();
                boolean value = this.invoked;
                this.invoked = false;
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForInvoked(long timeout) throws InterruptedException {
            Object object = this.syncMe;
            synchronized (object) {
                StopWatch timer = new StopWatch(true);
                long timeLeft = timeout - timer.elapsedTimeMillis();
                while (!this.invoked && timeLeft > 0L) {
                    this.syncMe.wait(timeLeft);
                }
                return this.wasInvoked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void alert(Alert alert) {
            Object object = this.syncMe;
            synchronized (object) {
                this.invoked = true;
                try {
                    this.alert2(alert);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable t) {
                    this.callbackError = t;
                }
                finally {
                    this.syncMe.notifyAll();
                }
            }
        }

        public abstract void alert2(Alert var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForError() {
            Object object = this.syncMe;
            synchronized (object) {
                if (this.callbackError != null) {
                    throw new Error("Exception occurred in callback", this.callbackError);
                }
            }
        }
    }
}

