/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributedSystemFactoryTest;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import junit.framework.TestCase;

public class AdminOnDsDUnitTest
extends DistributedTestCase {
    public AdminOnDsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAdminOnNormalDs() throws Exception {
        AdminOnDsDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm = host.getVM(1);
        String hostAddr = SocketCreator.getLocalHost().getHostAddress();
        final InetAddress hostInetAddr = InetAddress.getByName(hostAddr);
        final int port = AvailablePort.getRandomAvailablePort((int)0, (InetAddress)hostInetAddr);
        String locators = hostAddr + "[" + port + "]";
        DistributedSystem myDS = null;
        AdminDistributedSystem adminDS = null;
        final Properties p = new Properties();
        if (Boolean.getBoolean("java.net.preferIPv6Addresses")) {
            p.setProperty("bind-address", hostAddr);
        }
        p.setProperty("mcast-port", "0");
        p.setProperty("log-level", AdminOnDsDUnitTest.getDUnitLogLevel());
        p.setProperty("locators", locators);
        vm.invoke(new SerializableRunnable("Start locator on " + port){

            @Override
            public void run() {
                File logFile = new File(AdminOnDsDUnitTest.this.getUniqueName() + "-locator" + port + ".log");
                try {
                    Locator.startLocatorAndDS((int)port, (File)logFile, (InetAddress)hostInetAddr, (Properties)p);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port, ex);
                }
            }
        });
        try {
            try {
                myDS = DistributedSystem.connect((Properties)p);
                DistributedSystemFactoryTest.checkEnableAdministrationOnly((boolean)true, (boolean)true);
                DistributedSystemFactoryTest.checkEnableAdministrationOnly((boolean)false, (boolean)true);
                DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)myDS, null);
                adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                adminDS.connect();
                adminDS.waitToBeConnected(5000L);
                boolean connected = adminDS.isConnected();
                AdminOnDsDUnitTest.assertTrue((boolean)connected);
                DistributionLocator[] distLocs = adminDS.getDistributionLocators();
                AdminOnDsDUnitTest.assertEquals((int)1, (int)distLocs.length);
                final DistributionLocator locator = distLocs[0];
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return locator.isRunning();
                    }

                    @Override
                    public String description() {
                        return "locator started";
                    }
                };
                AdminOnDsDUnitTest.waitForCriterion(wc, 5000L, 10L, true);
            }
            catch (Throwable throwable) {
                SerializableRunnable stop = new SerializableRunnable("Stop locators "){

                    @Override
                    public void run() {
                        TestCase.assertTrue((boolean)Locator.hasLocator());
                        Locator.getLocator().stop();
                        TestCase.assertFalse((boolean)Locator.hasLocator());
                    }
                };
                vm.invoke(stop);
                DistributionLocator[] distLocs = adminDS.getDistributionLocators();
                AdminOnDsDUnitTest.assertEquals((int)1, (int)distLocs.length);
                DistributionLocator locator = distLocs[0];
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(locator){
                    final /* synthetic */ DistributionLocator val$locator;
                    {
                        this.val$locator = distributionLocator;
                    }

                    @Override
                    public boolean done() {
                        return !this.val$locator.isRunning();
                    }

                    @Override
                    public String description() {
                        return "locator stopped";
                    }
                };
                AdminOnDsDUnitTest.waitForCriterion(wc, 5000L, 10L, true);
                throw throwable;
            }
            SerializableRunnable stop = new /* invalid duplicate definition of identical inner class */;
            vm.invoke(stop);
            DistributionLocator[] distLocs = adminDS.getDistributionLocators();
            AdminOnDsDUnitTest.assertEquals((int)1, (int)distLocs.length);
            DistributionLocator locator = distLocs[0];
            DistributedTestCase.WaitCriterion wc = new /* invalid duplicate definition of identical inner class */;
            AdminOnDsDUnitTest.waitForCriterion(wc, 5000L, 10L, true);
        }
        finally {
            if (adminDS != null) {
                adminDS.disconnect();
            }
            if (myDS != null) {
                myDS.disconnect();
            }
        }
    }
}

