/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConPrms;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.lru.LRUAlgorithm;
import com.gemstone.gemfire.internal.cache.lru.MemLRUCapacityController;
import com.gemstone.gemfire.internal.size.WellKnownClassSizer;
import hydra.ClientDescription;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import memscale.OffHeapHelper;
import util.TestException;

public class MemLRUParameters
implements Serializable {
    public static int UNKNOWN = -1;
    public static final int MEGABYTE = 0x100000;
    public static final int OFF_HEAP_OVERHEAD = 8;
    protected int byteArraySize = UNKNOWN;
    protected int maximumMegabytes = UNKNOWN;
    protected long minEvictionBytes = UNKNOWN;
    protected long allowableExcessBytes = UNKNOWN;
    protected long totalAllowableBytes;
    protected int keyLength;
    protected long regionByteLimit = UNKNOWN;
    protected int bytesPerKey = UNKNOWN;
    protected int perEntryOverhead = UNKNOWN;
    protected int totalBytesPerEntry = UNKNOWN;

    public MemLRUParameters(int keyLength, int maxMegabytes, Region aRegion) {
        this.init(keyLength, maxMegabytes, aRegion);
        Log.getLogWriter().info("Created MemLRUParameters " + this);
    }

    private void init(int keyLength, int maximumMegabytesArg, Region aRegion) {
        if (aRegion == null) {
            this.perEntryOverhead = UNKNOWN;
        } else {
            LRUAlgorithm algor = ((LocalRegion)aRegion).getEvictionController();
            if (algor == null) {
                this.perEntryOverhead = UNKNOWN;
            } else {
                MemLRUCapacityController capCon = (MemLRUCapacityController)algor;
                this.perEntryOverhead = capCon.getPerEntryOverhead();
            }
        }
        this.keyLength = keyLength;
        this.byteArraySize = TestConfig.tab().intAt(CapConPrms.byteArraySize, UNKNOWN);
        this.maximumMegabytes = maximumMegabytesArg;
        this.regionByteLimit = this.maximumMegabytes * 0x100000;
        if (keyLength != UNKNOWN) {
            this.bytesPerKey = WellKnownClassSizer.sizeof((Object)new String(new char[keyLength]));
        }
        if (this.perEntryOverhead == UNKNOWN) {
            this.totalBytesPerEntry = UNKNOWN;
            this.byteArraySize = UNKNOWN;
        } else {
            int byteArrayOverhead = 16;
            this.totalBytesPerEntry = this.bytesPerKey + this.byteArraySize + byteArrayOverhead + this.perEntryOverhead;
            if (OffHeapHelper.isOffHeapMemoryConfigured()) {
                this.totalBytesPerEntry = this.byteArraySize + 8;
                if (this.totalBytesPerEntry % 8 != 0) {
                    int nextMultiple = this.totalBytesPerEntry / 8 + 1;
                    this.totalBytesPerEntry = nextMultiple * 8;
                }
            }
        }
        this.setAllowableExcessBytes();
        this.setMinEvictionBytes();
        if (this.allowableExcessBytes != (long)UNKNOWN) {
            this.totalAllowableBytes = this.regionByteLimit + this.allowableExcessBytes;
        }
        StringBuffer aStr = new StringBuffer();
        if (this.maximumMegabytes == UNKNOWN) {
            aStr.append("maximumMegabytes is " + this.maximumMegabytes + "\n");
        }
        if (this.regionByteLimit == (long)UNKNOWN) {
            aStr.append("regionByteLimit is " + this.regionByteLimit + "\n");
        }
        if (this.bytesPerKey == UNKNOWN) {
            aStr.append("bytesPerKey is " + this.bytesPerKey + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    public int getByteArraySize() {
        return this.byteArraySize;
    }

    public int getMaximumMegabytes() {
        if (this.maximumMegabytes == UNKNOWN) {
            throw new TestException("maximumMegabytes " + this.maximumMegabytes + " is unknown");
        }
        return this.maximumMegabytes;
    }

    public long getMinEvictionBytes() {
        return this.minEvictionBytes;
    }

    public int getKeyLength() {
        if (this.keyLength == UNKNOWN) {
            throw new TestException("keyLength " + this.keyLength + " is unknown");
        }
        return this.keyLength;
    }

    public long getRegionByteLimit() {
        if (this.regionByteLimit == (long)UNKNOWN) {
            throw new TestException("regionByteLimit " + this.regionByteLimit + " is unknown");
        }
        return this.regionByteLimit;
    }

    public long getTotalBytesPerEntry() {
        if (this.totalBytesPerEntry == UNKNOWN) {
            throw new TestException("totalBytesPerEntry " + this.totalBytesPerEntry + " is unknown");
        }
        return this.totalBytesPerEntry;
    }

    public long getAllowableExcessBytes() {
        if (this.allowableExcessBytes == (long)UNKNOWN) {
            throw new TestException("allowableExcessBytes " + this.allowableExcessBytes + " is unknown");
        }
        return this.allowableExcessBytes;
    }

    public long getTotalAllowableBytes() {
        if (this.totalAllowableBytes == (long)UNKNOWN) {
            throw new TestException("totalAllowableBytes " + this.totalAllowableBytes + " is unknown");
        }
        return this.totalAllowableBytes;
    }

    public int getMaxEntries() {
        int maxEntries = (int)(this.regionByteLimit / (long)this.totalBytesPerEntry);
        return maxEntries;
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(super.toString() + "\n");
        aStr.append("   Object overhead values:\n");
        aStr.append("      keyLength: " + this.keyLength + "\n");
        aStr.append("      bytesPerKey: " + this.bytesPerKey + "\n");
        aStr.append("      byteArraySize: " + this.byteArraySize + "\n");
        aStr.append("      perEntryOverhead: " + this.perEntryOverhead + "\n");
        aStr.append("      totalBytesPerEntry: " + this.totalBytesPerEntry + "\n");
        aStr.append("   Memory eviction settings:\n");
        aStr.append("      maximumMegabytes: " + this.maximumMegabytes + "\n");
        aStr.append("   Region limits:\n");
        aStr.append("      regionByteLimit: " + this.regionByteLimit + "\n");
        aStr.append("      minEvictionBytes: " + this.minEvictionBytes + "\n");
        aStr.append("      allowableExcessBytes: " + this.allowableExcessBytes + "\n");
        aStr.append("      totalAllowableBytes: " + this.totalAllowableBytes + "\n");
        return aStr.toString();
    }

    private void setAllowableExcessBytes() {
        try {
            int upperLimitDelta = TestConfig.tab().intAt(CapConPrms.upperLimitDelta);
            this.allowableExcessBytes = upperLimitDelta;
            Log.getLogWriter().info("   Set allowableExcessBytes to " + this.allowableExcessBytes + "(upperLimitDelta is " + upperLimitDelta + ", regionByteLimit is " + this.regionByteLimit + ")");
        }
        catch (HydraConfigException e) {
            if (this.totalBytesPerEntry == UNKNOWN) {
                throw new TestException("Error in hydra configuration, key/value sizes are not always equal throughout test, and upperLimitDelta was not specified");
            }
            String clientName = System.getProperty("clientName");
            ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
            int numThreads = cd.getVmThreads();
            int delta = this.totalBytesPerEntry * (numThreads * 2);
            if (OffHeapHelper.isOffHeapMemoryConfigured()) {
                delta = this.totalBytesPerEntry * (numThreads * 3 + 1);
            }
            this.allowableExcessBytes = delta;
            Log.getLogWriter().info("   Set allowableExcessBytes to " + this.allowableExcessBytes + ", based on numThreads in this VM " + numThreads + " (+ some extra allowance),  and totalBytesPerEntry " + this.totalBytesPerEntry + ", delta is " + delta);
            return;
        }
    }

    private void setMinEvictionBytes() {
        try {
            int lowerLimitDelta = TestConfig.tab().intAt(CapConPrms.lowerLimitDelta);
            this.minEvictionBytes = this.regionByteLimit - (long)lowerLimitDelta;
            Log.getLogWriter().info("   Set minEvictionBytes to " + this.minEvictionBytes + "(lowerLimitDelta is " + lowerLimitDelta + ", regionByteLimit is " + this.regionByteLimit + ")");
        }
        catch (HydraConfigException e) {
            if (this.totalBytesPerEntry == UNKNOWN) {
                throw new TestException("Error in hydra configuration, key/value sizes are not always equal throughout test, and lowerLimitDelta was not specified");
            }
            String clientName = System.getProperty("clientName");
            ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
            int numThreads = cd.getVmThreads();
            int delta = this.totalBytesPerEntry * numThreads;
            this.minEvictionBytes = this.regionByteLimit - (long)delta;
            Log.getLogWriter().info("   Set minEvictionBytes to " + this.minEvictionBytes + ", based on numThreads in this VM is " + numThreads + " and totalBytesPerEntry " + this.totalBytesPerEntry + ", delta is " + delta);
            return;
        }
    }
}

