/*
 * Decompiled with CFR 0.152.
 */
package capCon;

import capCon.CapConBB;
import capCon.CapConTest;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import util.AbstractListener;
import util.EventCountersBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class EvictListener
extends AbstractListener
implements CacheListener {
    private SharedCounters counters = CapConBB.getBB().getSharedCounters();

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        this.incrementAfterCreateCounters(event, (Blackboard)EventCountersBB.getBB());
        try {
            this.doAfterCreate(event);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure((Error)err);
            throw err;
        }
        catch (Throwable aThrowable) {
            SystemFailure.checkFailure();
            String errStr = aThrowable.toString() + TestHelper.getStackTrace(aThrowable);
            CapConBB.getBB().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, errStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.incrementAfterDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
        Log.getLogWriter().info("Beginning afterDestroy event: " + this.evictedCountersToString());
        try {
            this.doAfterDestroy(event);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure((Error)err);
            throw err;
        }
        catch (Throwable aThrowable) {
            SystemFailure.checkFailure();
            String errStr = aThrowable.toString() + TestHelper.getStackTrace(aThrowable);
            CapConBB.getBB().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, errStr);
        }
        finally {
            Log.getLogWriter().info("Done in EvictListener.afterDestroy, " + this.evictedCountersToString());
        }
    }

    public void afterInvalidate(EntryEvent event) {
        this.incrementAfterInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.incrementAfterUpdateCounters(event, (Blackboard)EventCountersBB.getBB());
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        this.incrementAfterRegionDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.incrementAfterRegionInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
        this.incrementCloseCounter(EventCountersBB.getBB());
    }

    private void doAfterCreate(EntryEvent event) throws CacheException {
        Region aRegion = event.getRegion();
        int numKeys = aRegion.keys().size();
        Log.getLogWriter().info("In EvictListener.doAfterCreate: region " + TestHelper.regionToString(aRegion, false) + " num keys is " + numKeys);
    }

    private synchronized void doAfterDestroy(EntryEvent event) {
        Region aRegion = event.getRegion();
        int numKeys = aRegion.keys().size();
        Log.getLogWriter().info("In EvictListener.doAfterDestroy: region " + TestHelper.regionToString(aRegion, false) + " num keys is " + numKeys);
        long highestEvictedNameID = this.getHighestEvictedNameID();
        long highestSeqEvictedNameID = this.counters.read(CapConBB.HIGHEST_SEQ_NAME_ID);
        Object key = event.getKey();
        long currNameID = NameFactory.getCounterForName(key);
        if (currNameID <= highestSeqEvictedNameID) {
            String aStr = "Destroying an object that was previously evicted: " + key + " " + this.evictedCountersToString();
            Log.getLogWriter().info(aStr);
            throw new TestException(aStr);
        }
        long diff = Math.abs(highestEvictedNameID - currNameID);
        this.counters.setIfLarger(CapConBB.MAX_LRU_DIFF, diff);
        Log.getLogWriter().info("highestEvictedNameID is " + highestEvictedNameID + ", currNameID is " + currNameID + ", diff is " + diff);
        if (diff > (long)CapConTest.testInstance.LRUAllowance) {
            String errStr = "Evicted object is outside of LRUAllowance " + CapConTest.testInstance.LRUAllowance + ", difference between this object and the highest evicted object: " + diff + " " + this.evictedCountersToString();
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
        if (currNameID == highestSeqEvictedNameID + 1L) {
            Log.getLogWriter().info("currNameID " + currNameID + " is next in line to seq counter");
            highestSeqEvictedNameID = this.counters.incrementAndRead(CapConBB.HIGHEST_SEQ_NAME_ID);
            Log.getLogWriter().info("highestSeqEvictedNameID is now  " + highestSeqEvictedNameID);
            SharedMap aMap = CapConBB.getBB().getSharedMap();
            Set aSet = (Set)aMap.get(CapConBB.OUT_OF_ORDER_SET);
            aSet.remove(key);
            Iterator it = aSet.iterator();
            ArrayList removeList = new ArrayList();
            while (it.hasNext()) {
                Object name = it.next();
                long nameID = NameFactory.getCounterForName(name);
                if (nameID != highestSeqEvictedNameID + 1L) continue;
                highestSeqEvictedNameID = this.counters.incrementAndRead(CapConBB.HIGHEST_SEQ_NAME_ID);
                Log.getLogWriter().info("Found another sequential name in the out-of-order set " + name + " highestSeqEvictedNameID is now  " + highestSeqEvictedNameID);
                removeList.add(name);
                it = aSet.iterator();
            }
            for (int i = 0; i < removeList.size(); ++i) {
                Object name = removeList.get(i);
                Log.getLogWriter().info("Removing " + name + " from the out-of-order set");
                aSet.remove(name);
            }
            aMap.put(CapConBB.OUT_OF_ORDER_SET, aSet);
        } else {
            Log.getLogWriter().info("Adding " + key + " to the out-of-order set");
            SharedMap aMap = CapConBB.getBB().getSharedMap();
            Set aSet = (Set)aMap.get(CapConBB.OUT_OF_ORDER_SET);
            aSet.add(key);
            aMap.put(CapConBB.OUT_OF_ORDER_SET, aSet);
            if (aSet.size() > CapConTest.testInstance.LRUAllowance) {
                throw new TestException("Number of elements that are out of order " + aSet.size() + " is more than the LRUAllowance of " + CapConTest.testInstance.LRUAllowance);
            }
        }
    }

    private String evictedCountersToString() {
        StringBuffer aStr = new StringBuffer();
        long highestSeqNameID = this.counters.read(CapConBB.HIGHEST_SEQ_NAME_ID);
        long highestNameID = this.getHighestEvictedNameID();
        aStr.append("Highest sequentially evicted nameID: " + highestSeqNameID + "\n");
        aStr.append("Highest evicted nameID: " + highestNameID + "\n");
        SharedMap aMap = CapConBB.getBB().getSharedMap();
        Set aSet = (Set)aMap.get(CapConBB.OUT_OF_ORDER_SET);
        Iterator it = aSet.iterator();
        while (it.hasNext()) {
            aStr.append("   Out of order: " + it.next() + "\n");
        }
        return aStr.toString();
    }

    private long getHighestEvictedNameID() {
        long highest = this.counters.read(CapConBB.HIGHEST_SEQ_NAME_ID);
        SharedMap aMap = CapConBB.getBB().getSharedMap();
        Set aSet = (Set)aMap.get(CapConBB.OUT_OF_ORDER_SET);
        Iterator it = aSet.iterator();
        while (it.hasNext()) {
            long nameID = NameFactory.getCounterForName(it.next());
            highest = Math.max(highest, nameID);
        }
        return highest;
    }
}

