/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.poc.useCase3_2;

import cacheperf.poc.useCase3_2.TaskSyncBlackboard;
import cacheperf.poc.useCase3_2.UseCase3Client;
import cacheperf.poc.useCase3_2.UseCase3Prms;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;

public class Terminators {
    private static long totalTaskTimeMs = (long)TestConfig.tab().intAt(Prms.totalTaskTimeSec) * 1000L;

    public static boolean terminateOnBatchSeconds(UseCase3Client c) {
        if (c.batchSeconds == -1) {
            String s = BasePrms.nameForKey(UseCase3Prms.batchSeconds) + " is not set";
            throw new HydraConfigException(s);
        }
        return System.currentTimeMillis() >= c.batchStartTime + (long)(c.batchSeconds * 1000);
    }

    public static boolean terminateOnTotalTaskTimeSec(UseCase3Client c) {
        if (c.workloadStartTime == -1L) {
            String s = "UseCase3Client.workloadStartTime is not set";
            throw new HydraConfigException(s);
        }
        return System.currentTimeMillis() >= c.workloadStartTime + totalTaskTimeMs;
    }

    public static boolean terminateOnMaxKey(UseCase3Client c) {
        if (c.currentKey >= c.maxKeys) {
            Log.getLogWriter().info("Completed " + c.currentKey + " keys, surpasses max key");
            return true;
        }
        return false;
    }

    public static boolean terminateOnSignal(UseCase3Client c) {
        return TaskSyncBlackboard.getInstance().getSharedCounters().read(TaskSyncBlackboard.signal) != 0L;
    }
}

