/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.poc.useCase14;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import cacheperf.poc.useCase14.UseCase14Prms;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Region;
import distcache.gemfire.GemFireCachePrms;
import hydra.BasePrms;
import hydra.ConfigPrms;
import hydra.EdgeHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import java.util.List;
import objects.ObjectHelper;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;

public class UseCase14Client
extends CachePerfClient {
    private static HydraThreadLocal localcurrentpushkey = new HydraThreadLocal();
    private static HydraThreadLocal localcurrentpullkey = new HydraThreadLocal();
    public int currentPushKey;
    public int currentPullKey;

    public static synchronized void addRegionTask() {
        UseCase14Client c = new UseCase14Client();
        c.initHydraThreadLocals();
        c.addRegion();
        c.updateHydraThreadLocals();
    }

    private void addRegion() {
        String regionName = GemFireCachePrms.getRegionName();
        String regionConfig = ConfigPrms.getRegionConfig();
        if (RegionHelper.getRegion(regionName) == null) {
            RegionHelper.createRegion(regionName, regionConfig);
        }
        Region region = RegionHelper.getRegion(regionName);
        EdgeHelper.addThreadLocalConnection(region);
    }

    public static void feedDataTask() {
        UseCase14Client c = new UseCase14Client();
        c.initialize(1);
        c.feedData();
    }

    private void feedData() {
        if (this.maxKeys % 100 != 0) {
            String s = "Need " + BasePrms.nameForKey(CachePerfPrms.maxKeys) + " to be a multiple of 100 for cacheperf.poc.useCase14.UseCase14Prms.feedDataTask";
            throw new HydraConfigException(s);
        }
        Region pushRegion = RegionHelper.getRegion("PushRegion");
        Region pullRegion = RegionHelper.getRegion("PullRegion");
        int pushChunkSize = UseCase14Prms.getPushPercentage();
        int pullChunkSize = 100 - pushChunkSize;
        boolean batchDone = false;
        this.executeTaskTerminator();
        this.executeWarmupTerminator();
        do {
            int i;
            for (i = 0; i < pushChunkSize; ++i) {
                this.feed(pushRegion, this.currentPushKey);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                this.currentPushKey += this.numThreads;
                this.currentKey = this.currentPushKey;
            }
            for (i = 0; i < pullChunkSize; ++i) {
                this.feed(pullRegion, this.currentPullKey);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                this.currentPullKey += this.numThreads;
                this.currentKey = this.currentPullKey;
            }
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void feed(Region region, int i) {
        long start = this.statistics.startCreate();
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        try {
            region.create(key, val);
        }
        catch (EntryExistsException e) {
            throw new HydraRuntimeException("Key already exists: " + key);
        }
        this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
    }

    public static void createTxDataTask() {
        UseCase14Client c = new UseCase14Client();
        c.initialize();
        c.createTxData();
    }

    private void createTxData() {
        Region region = RegionHelper.getRegion("TxRegion");
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.createTx(region, key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void createTx(Region region, int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startCreate();
        try {
            region.create(key, val);
        }
        catch (EntryExistsException e) {
            throw new HydraRuntimeException("Key already exists: " + key);
        }
        this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
    }

    public static void putTxDataTask() {
        UseCase14Client c = new UseCase14Client();
        c.initialize(3);
        c.putTxData();
    }

    private void putTxData() {
        Region region = RegionHelper.getRegion("TxRegion");
        boolean batchDone = false;
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.putTx(region, key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void putTx(Region region, int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startPut();
        boolean committed = false;
        while (!committed) {
            this.tm.begin();
            region.put(key, val);
            try {
                this.tm.commit();
                committed = true;
            }
            catch (ConflictException e) {
                UseCase14Client.log().info("CONFLICT");
            }
        }
        this.statistics.endPut(start, this.isMainWorkload, this.histogram);
    }

    public static void sleepTask() {
        int ms = CachePerfPrms.getSleepMs();
        UseCase14Client.log().info("Sleeping " + ms + " ms");
        MasterController.sleepForMs(ms);
    }

    public static void validateMessagesFailedQueuedTask() {
        UseCase14Client c = new UseCase14Client();
        c.validateMessagesFailedQueued();
    }

    private void validateMessagesFailedQueued() {
        String type = "CacheClientProxyStatistics";
        String stat = "messagesFailedQueued";
        long failures = this.getStatTotalCount(type, stat);
        String s = type + "." + stat + " = " + failures;
        if (failures != 0L) {
            throw new HydraRuntimeException(s);
        }
        UseCase14Client.log().info(s);
    }

    private long getStatTotalCount(String type, String stat) {
        String spec = "* " + type + " * " + stat + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + "max";
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            Log.getLogWriter().warning("No stats found for " + spec);
            return 0L;
        }
        double failures = 0.0;
        for (int i = 0; i < psvs.size(); ++i) {
            PerfStatValue psv = (PerfStatValue)psvs.get(i);
            failures += psv.getMax();
        }
        return (long)failures;
    }

    protected int getCurrentPushKey() {
        Integer n = (Integer)localcurrentpushkey.get();
        if (n == null) {
            n = new Integer(this.ttgid());
            localcurrentpushkey.set(n);
        }
        return n;
    }

    protected void setCurrentPushKey(int n) {
        localcurrentpushkey.set(new Integer(n));
    }

    protected int getCurrentPullKey() {
        Integer n = (Integer)localcurrentpullkey.get();
        if (n == null) {
            n = new Integer(this.ttgid());
            localcurrentpullkey.set(n);
        }
        return n;
    }

    protected void setCurrentPullKey(int n) {
        localcurrentpullkey.set(new Integer(n));
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.currentPushKey = this.getCurrentPushKey();
        this.currentPullKey = this.getCurrentPullKey();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setCurrentPushKey(this.currentPushKey);
        this.setCurrentPullKey(this.currentPullKey);
    }
}

