/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.memory;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import perffmwk.PerformanceStatistics;

public class CacheSizeStats
extends PerformanceStatistics {
    private static final int SCOPE = 1;
    public static final String CACHE_SIZE = "cacheSize";
    public static final String CACHE_MEM_SIZE = "cacheMemSize";
    public static final String EMPTY_CACHE_MEM_SIZE = "emptyCacheMemSize";
    public static final String WARMED_UP_CACHE_MEM_SIZE = "warmedUpCacheMemSize";
    public static final String OBJECT_SIZE = "objectSize";
    public static final String PER_ENTRY_OVERHEAD = "perEntryOverhead";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{CacheSizeStats.factory().createIntGauge(CACHE_SIZE, "Final entry count in the cache.", "operations", largerIsBetter), CacheSizeStats.factory().createLongGauge(WARMED_UP_CACHE_MEM_SIZE, "memory size of the cache after the trim interval has passed", "bytes", !largerIsBetter), CacheSizeStats.factory().createLongGauge(CACHE_MEM_SIZE, "Final memory size of the cache.", "bytes", !largerIsBetter), CacheSizeStats.factory().createLongGauge(EMPTY_CACHE_MEM_SIZE, "Memory Size of the cache before the cache was populated", "bytes", !largerIsBetter), CacheSizeStats.factory().createLongGauge(OBJECT_SIZE, "The size of our test object", "bytes", !largerIsBetter), CacheSizeStats.factory().createLongGauge(PER_ENTRY_OVERHEAD, "The change in cache size divided by the number of entries, minus the size of the data", "bytes", !largerIsBetter)};
    }

    public static CacheSizeStats getInstance(String name) {
        return (CacheSizeStats)CacheSizeStats.getInstance(CacheSizeStats.class, 1, name);
    }

    public CacheSizeStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    protected void setEmptyCacheMemSize(long memSize) {
        this.statistics().setLong(EMPTY_CACHE_MEM_SIZE, memSize);
    }

    protected void setObjectSize(int objectSize) {
        this.statistics().setLong(OBJECT_SIZE, (long)objectSize);
    }

    public void setWarmedUpCacheMemSize(long memSize) {
        this.statistics().setLong(WARMED_UP_CACHE_MEM_SIZE, memSize);
    }

    public void setCacheSize(int cacheSize) {
        this.statistics().setInt(CACHE_SIZE, cacheSize);
    }

    public void setCacheMemSize(long cacheMemSize) {
        this.statistics().setLong(CACHE_MEM_SIZE, cacheMemSize);
    }

    public void setPerEntryOverhead(long perEntryOverhead) {
        this.statistics().setLong(PER_ENTRY_OVERHEAD, perEntryOverhead);
    }
}

