/*
 * Decompiled with CFR 0.152.
 */
package cacheServer.wan;

import com.gemstone.gemfire.cache.Cache;
import hydra.CacheHelper;
import hydra.CacheServerHelper;
import hydra.ConfigPrms;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import wan.CacheClientPrms;
import wan.CacheServerPrms;

public class WANClient
extends wan.WANClient {
    protected static Cache xmlCache;
    static String gatewayXmlFilename;
    private static final String cacheServerStr = "cacheserver";

    public static synchronized void initPeerGateway() {
        if (xmlCache == null) {
            String gatewayHubConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayHubConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayHubConfig, null));
            String cacheConfig = TestConfig.tasktab().stringAt(CacheClientPrms.cacheConfig, TestConfig.tab().stringAt(CacheClientPrms.cacheConfig, null));
            int myVmid = RemoteTestModule.getMyVmid();
            String clientName = RemoteTestModule.getMyClientName();
            gatewayXmlFilename = "vm_" + myVmid + "_" + clientName + ".xml";
            xmlCache = CacheHelper.startCacheXmlGenerationForGateway(cacheConfig, null, gatewayHubConfig, gatewayXmlFilename);
        }
    }

    public static synchronized void startPeerGateway() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            block3: {
                String gatewayHubConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayHubConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayHubConfig, null));
                String cacheConfig = TestConfig.tasktab().stringAt(CacheClientPrms.cacheConfig, TestConfig.tab().stringAt(CacheClientPrms.cacheConfig, null));
                String gatewayConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayConfig, null));
                String regionConfig = TestConfig.tasktab().stringAt(CacheClientPrms.regionConfig, TestConfig.tab().stringAt(CacheClientPrms.regionConfig, null));
                String diskStoreConfig = ConfigPrms.getDiskStoreConfig();
                try {
                    CacheHelper.finishCacheXmlGenerationForGateway(xmlCache, cacheConfig, gatewayHubConfig, gatewayConfig, regionConfig, null, null, null, diskStoreConfig, null, gatewayXmlFilename);
                }
                catch (HydraRuntimeException e) {
                    String errStr = e.toString();
                    if (errStr.indexOf("Cache XML file was already created") >= 0) break block3;
                    throw e;
                }
            }
            CacheHelper.createCacheFromXml(gatewayXmlFilename);
        }
    }

    public static synchronized void initServerGateway() {
        if (xmlCache == null) {
            String gatewayHubConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayHubConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayHubConfig, null));
            String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, TestConfig.tab().stringAt(CacheServerPrms.cacheConfig, null));
            int myVmid = RemoteTestModule.getMyVmid();
            String clientName = RemoteTestModule.getMyClientName();
            gatewayXmlFilename = "vm_" + myVmid + "_" + clientName + ".xml";
            xmlCache = CacheHelper.startCacheXmlGenerationForGateway(cacheConfig, null, gatewayHubConfig, gatewayXmlFilename);
        }
    }

    public static synchronized void startServerGateway() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            block3: {
                String gatewayHubConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayHubConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayHubConfig, null));
                String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, TestConfig.tab().stringAt(CacheServerPrms.cacheConfig, null));
                String gatewayConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayConfig, null));
                String regionConfig = TestConfig.tasktab().stringAt(CacheServerPrms.regionConfig, TestConfig.tab().stringAt(CacheServerPrms.regionConfig, null));
                String bridgeConfig = TestConfig.tasktab().stringAt(CacheServerPrms.bridgeConfig, TestConfig.tab().stringAt(CacheServerPrms.bridgeConfig, null));
                String diskStoreConfig = ConfigPrms.getDiskStoreConfig();
                try {
                    CacheHelper.finishCacheXmlGenerationForGateway(xmlCache, cacheConfig, gatewayHubConfig, gatewayConfig, regionConfig, null, bridgeConfig, null, diskStoreConfig, null, gatewayXmlFilename);
                }
                catch (HydraRuntimeException e) {
                    String errStr = e.toString();
                    if (errStr.indexOf("Cache XML file was already created") >= 0) break block3;
                    throw e;
                }
            }
            CacheHelper.createCacheFromXml(gatewayXmlFilename);
            Log.getLogWriter().info("Starting up Gateway with cache.xml file " + gatewayXmlFilename);
        }
    }

    public static synchronized void startServerGatewayWithCacheServer() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            block3: {
                String gatewayHubConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayHubConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayHubConfig, null));
                String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, TestConfig.tab().stringAt(CacheServerPrms.cacheConfig, null));
                String gatewayConfig = TestConfig.tasktab().stringAt(CacheServerPrms.gatewayConfig, TestConfig.tab().stringAt(CacheServerPrms.gatewayConfig, null));
                String regionConfig = TestConfig.tasktab().stringAt(CacheServerPrms.regionConfig, TestConfig.tab().stringAt(CacheServerPrms.regionConfig, null));
                String bridgeConfig = TestConfig.tasktab().stringAt(CacheServerPrms.bridgeConfig, TestConfig.tab().stringAt(CacheServerPrms.bridgeConfig, null));
                String diskStoreConfig = ConfigPrms.getDiskStoreConfig();
                try {
                    CacheHelper.finishCacheXmlGenerationForGateway(xmlCache, cacheConfig, gatewayHubConfig, gatewayConfig, regionConfig, null, bridgeConfig, null, diskStoreConfig, null, gatewayXmlFilename);
                }
                catch (HydraRuntimeException e) {
                    String errStr = e.toString();
                    if (errStr.indexOf("Cache XML file was already created") >= 0) break block3;
                    throw e;
                }
            }
            WANClient.startCacheServer();
        }
    }

    public static void startCacheServer() {
        int myVmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
        Log.getLogWriter().info("Starting up Gateway CacheServer " + serverName + " with cache.xml file " + gatewayXmlFilename);
        GemFireDescription gfd = TestConfig.getInstance().getClientDescription(clientName).getGemFireDescription();
        String offHeapMemorySize = gfd.getOffHeapMemorySize();
        String[] extraArgs = null;
        extraArgs = offHeapMemorySize != null ? new String[]{" off-heap-memory-size=" + offHeapMemorySize} : new String[]{};
        CacheServerHelper.startCacheServer(serverName, gatewayXmlFilename, extraArgs);
    }

    public static void stopCacheServer() {
        int myVmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
        CacheServerHelper.stopCacheServer(serverName);
    }
}

