/*
 * Decompiled with CFR 0.152.
 */
package cacheServer.wan;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterProxyIF;
import hydra.ProcessMgr;
import hydra.RmiRegistryHelper;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import wan.WANBlackboard;

public class QueueMonitor
extends CacheListenerAdapter
implements CacheListener,
Declarable {
    public static MasterProxyIF Master = null;
    protected static LogWriter log = null;
    protected static String logName;

    public void init(Properties prop) {
    }

    static {
        try {
            Log.getLogWriter();
        }
        catch (HydraRuntimeException e) {
            logName = "cacheserver_" + ProcessMgr.getProcessId();
            log = Log.createLogWriter(logName, "info");
        }
        String cacheServerDir = System.getProperty("user.dir");
        String testDir = FileUtil.pathFor(cacheServerDir);
        System.setProperty("test.dir", testDir);
        if (Master == null) {
            Master = RmiRegistryHelper.lookupMaster();
        }
        final String key = "EVENT_QUEUE_SIZE:" + logName;
        Log.getLogWriter().info("Started event queue monitor with key: " + key);
        final SharedMap bb = WANBlackboard.getInstance().getSharedMap();
        Thread queueMonitor = new Thread(new Runnable(){

            @Override
            public void run() {
                DistributedSystem statFactory = null;
                Statistics[] gStats = null;
                while (true) {
                    if (statFactory == null) {
                        statFactory = CacheFactory.getAnyInstance().getDistributedSystem();
                    }
                    if (gStats == null) {
                        gStats = statFactory.findStatisticsByType(statFactory.findType("GatewayStatistics"));
                    }
                    SystemFailure.checkFailure();
                    long qSize = 0L;
                    for (int i = 0; i < gStats.length; ++i) {
                        long gQSize = gStats[i].getInt(GatewayStats.getEventQueueSizeId());
                        qSize += gQSize;
                    }
                    try {
                        bb.put(key, new Long(qSize));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }

            protected void finalize() throws Throwable {
                Object o = bb.remove(key);
                Log.getLogWriter().severe("REMOVING [" + key + "] from Blackboard, value was:" + o);
                super.finalize();
            }
        });
        queueMonitor.setDaemon(true);
        queueMonitor.start();
    }
}

