/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.smoke;

import cacheLoader.smoke.BB;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import hydra.BasePrms;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import java.text.DecimalFormat;
import perffmwk.PerfStatMgr;
import util.CacheBB;
import util.CachePrms;

public class TestParms
extends BasePrms {
    public static final String DEFAULT_EXPIRATION_ACTION = "INVALIDATE";
    public static Long defineCacheLoader;
    public static Long searchTimeout;
    public static Long lockTimeout;
    public static Long readIterations;
    public static Long logDetails;
    private static final DecimalFormat format;

    protected static boolean getDefineCacheLoader() {
        Long key = defineCacheLoader;
        return TestParms.tasktab().booleanAt(key, TestParms.tab().booleanAt(key, false));
    }

    protected static int getSearchTimeout() {
        Long key = searchTimeout;
        return TestParms.tasktab().intAt(key, TestParms.tab().intAt(key, GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT));
    }

    protected static int getLockTimeout() {
        Long key = lockTimeout;
        return TestParms.tasktab().intAt(key, TestParms.tab().intAt(key, GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT));
    }

    protected static int getReadIterations() {
        Long key = readIterations;
        return TestParms.tasktab().intAt(key, TestParms.tab().intAt(key, 1));
    }

    protected static boolean getLogDetails() {
        Long key = logDetails;
        return TestParms.tasktab().booleanAt(key, TestParms.tab().booleanAt(key, false));
    }

    protected static int getEntryTTLSec() {
        Long key = CachePrms.entryTTLSec;
        return TestParms.tasktab().intAt(key, TestParms.tab().intAt(key, 0));
    }

    protected static String getEntryTTLActionString() {
        Long key = CachePrms.entryTTLAction;
        return TestParms.tasktab().stringAt(key, TestParms.tab().stringAt(key, DEFAULT_EXPIRATION_ACTION));
    }

    protected static int getEntryIdleTimeoutSec() {
        Long key = CachePrms.entryIdleTimeoutSec;
        return TestParms.tasktab().intAt(key, TestParms.tab().intAt(key, 0));
    }

    protected static String getEntryIdleTimeoutActionString() {
        Long key = CachePrms.entryIdleTimeoutAction;
        return TestParms.tasktab().stringAt(key, TestParms.tab().stringAt(key, DEFAULT_EXPIRATION_ACTION));
    }

    public static void logParms() {
        Log.getLogWriter().info("\n    Scope: " + CacheBB.getBB().getScopeAttribute() + "\n    MirrorRegion: " + CacheBB.getBB().getMirrorAttribute() + "\n    TTL: " + TestParms.getEntryTTLSec() + "\n    TTLExpirAction: " + TestParms.getEntryTTLActionString() + "\n    IdleTimeout: " + TestParms.getEntryIdleTimeoutSec() + "\n    IdleTimeoutExpirAction: " + TestParms.getEntryIdleTimeoutActionString() + "\n    searchTimeout: " + TestParms.getSearchTimeout() + "\n    lockTimeout: " + TestParms.getLockTimeout());
    }

    public static boolean writePerfResultsTask() {
        SharedCounters counters = BB.getInstance().getSharedCounters();
        PerfStatMgr report = PerfStatMgr.getInstance();
        long timedReads = counters.read(BB.NUM_TIMED_READ_CALLS);
        long readTime = counters.read(BB.TIME_READ_CALLS);
        if (timedReads > 0L) {
            Log.getLogWriter().info(TestParms.noteTiming(timedReads, "read calls", 0L, readTime, "milliseconds"));
        }
        long timedPuts = counters.read(BB.NUM_TIMED_PUT_CALLS);
        long putTime = counters.read(BB.TIME_PUT_CALLS);
        if (timedPuts > 0L) {
            Log.getLogWriter().info(TestParms.noteTiming(timedPuts, "put calls", 0L, putTime, "milliseconds"));
        }
        return true;
    }

    public static String noteTiming(long operations, String operationUnit, long beginTime, long endTime, String timeUnit) {
        long delta = endTime - beginTime;
        StringBuffer sb = new StringBuffer();
        sb.append("  Performed ");
        sb.append(operations);
        sb.append(" ");
        sb.append(operationUnit);
        sb.append(" in ");
        sb.append(delta);
        sb.append(" ");
        sb.append(timeUnit);
        sb.append("\n");
        double ratio = (double)operations / (double)delta;
        sb.append("    ");
        sb.append(format.format(ratio));
        sb.append(" ");
        sb.append(operationUnit);
        sb.append(" per ");
        sb.append(timeUnit);
        sb.append("\n");
        ratio = (double)delta / (double)operations;
        sb.append("    ");
        sb.append(format.format(ratio));
        sb.append(" ");
        sb.append(timeUnit);
        sb.append(" per ");
        sb.append(operationUnit);
        sb.append("\n");
        return sb.toString();
    }

    static {
        BasePrms.setValues(TestParms.class);
        format = new DecimalFormat("###.###");
    }
}

