/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLReport {
    private static final String DIVIDER = "--------------------";
    private static final char SLASH = '/';
    private static final char DOT = '.';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReport(String testName, String testProps, String localConf, String testDir, String btFile) throws IOException, NumberFormatException {
        String xmlDir = "xml-reports";
        if (!FileUtil.exists(xmlDir)) {
            FileUtil.mkdir(xmlDir);
        }
        String testNameTmp = testName.replace('/', '.').substring(0, testName.lastIndexOf("."));
        String fn = "xml-reports/TEST-" + testNameTmp + ".xml";
        boolean isNewReport = !FileUtil.exists(fn);
        String err = XMLReport.getFirstError(testDir);
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            if (isNewReport) {
                doc = builder.newDocument();
                Element suite = doc.createElement("testsuite");
                suite.setAttribute("failures", "0");
                suite.setAttribute("errors", "0");
                suite.setAttribute("hostname", HostHelper.getLocalHost());
                suite.setAttribute("name", FileUtil.filenameFor(btFile));
                suite.setAttribute("tests", "0");
                suite.appendChild(doc.createElement("properties"));
                doc.appendChild(suite);
            } else {
                doc = builder.parse(new File(fn));
            }
            NodeList suites = doc.getElementsByTagName("testsuite");
            Element suite = (Element)suites.item(0);
            XMLReport.incrementAttribute(suite, "tests");
            Element testcase = doc.createElement("testcase");
            suite.appendChild(testcase);
            testcase.setAttribute("name", testName + " " + testProps);
            if (err != null) {
                XMLReport.incrementAttribute(suite, "errors");
                Element error = doc.createElement("error");
                testcase.appendChild(error);
                error.setAttribute("type", "");
                error.setAttribute("message", "");
                String message = "RESULT DIR " + FileUtil.filenameFor(testDir) + "\n" + err + "    ";
                error.setTextContent(message);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fn));){
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new HydraRuntimeException("Unable to write to file: " + fn, e);
        }
        catch (TransformerException e) {
            throw new HydraRuntimeException("Unable to write to file: " + fn, e);
        }
        catch (ParserConfigurationException e) {
            throw new HydraRuntimeException("Unable to write to file: " + fn, e);
        }
        catch (SAXException e) {
            throw new HydraRuntimeException("Unable to write to file: " + fn, e);
        }
    }

    private static void incrementAttribute(Element suite, String name) {
        Attr attribute = suite.getAttributeNode(name);
        String text = attribute.getValue();
        int current = Integer.parseInt(text);
        suite.setAttribute(name, Integer.toString(current + 1));
    }

    private static String getFirstError(String testDir) throws IOException {
        String fn = testDir + File.separator + "errors.txt";
        if (FileUtil.exists(fn)) {
            String line;
            StringBuffer buf = new StringBuffer();
            BufferedReader br = new BufferedReader(new FileReader(fn));
            int count = 0;
            while ((line = br.readLine()) != null && !line.startsWith(DIVIDER)) {
                if (count == 20) {
                    buf.append("&lt;snip&gt;\n");
                    break;
                }
                if ((line = line.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;")).length() > 200) {
                    buf.append(line.substring(0, 200)).append("&lt;snip&gt;\n");
                } else {
                    buf.append(line).append("\n");
                }
                ++count;
            }
            br.close();
            return buf.toString();
        }
        return null;
    }
}

