/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class RecreateBTFile {
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: batterytest.RecreateBTFile (dir)+");
        err.println("  dir     Directory containing battery test run");
        err.println("");
        err.println("Re-creates a .bt file based on the configutation information found in a directory containing a test run.  The generated .bt is printed to standard out.");
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            dirs.add(new File(args[i]));
        }
        if (dirs.isEmpty()) {
            RecreateBTFile.usage("Missing directory");
        }
        for (File dir : dirs) {
            File latest;
            if (!dir.isDirectory()) {
                RecreateBTFile.usage("File " + dir + " is not a directory");
            }
            if (!(latest = new File(dir, "latest.prop")).exists()) {
                RecreateBTFile.usage("Directory " + dir + " does not contain a test run");
            }
            Properties props = new Properties();
            props.load(new FileInputStream(latest));
            String testName = props.getProperty("TestName");
            if (testName == null) {
                err.println("No \"TestName\" property in " + latest);
                continue;
            }
            out.print(testName);
            out.print(" ");
            out.flush();
            Enumeration<?> theEnum = props.propertyNames();
            while (theEnum.hasMoreElements()) {
                String search;
                String key = (String)theEnum.nextElement();
                if (!key.startsWith(search = "hydra.SystemProperties-")) continue;
                out.print(key.substring(search.length()));
                out.print("=");
                out.print(props.getProperty(key));
                out.print(" ");
                out.flush();
            }
            out.println("");
        }
    }
}

