/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import batterytest.BatteryTestConfig;
import hydra.ConfigLexer;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.MasterDescription;
import hydra.TestConfig;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class ConfigParser {
    private static final String INCLUDE = "include";
    private static final String NEWLINE = "\n";
    private static final String COMMA = ",";
    private static int ComparisonKey = 0;

    public static Vector parseFile(String fn) throws FileNotFoundException {
        return ConfigParser.parseFile(fn, false);
    }

    public static Vector parseFile(String fn, boolean verbose) throws FileNotFoundException {
        ConfigParser parser = new ConfigParser();
        String text = parser.getText(fn);
        ConfigLexer lex = new ConfigLexer();
        Vector tokens = ConfigLexer.tokenize(text);
        if (tokens.size() == 0) {
            System.out.println("Batterytest input file " + fn + " is empty");
            System.exit(0);
        }
        if (verbose) {
            System.out.println("\nTokens...");
            Iterator i = tokens.iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        }
        Vector finalTests = parser.parse(tokens, verbose);
        ConfigParser.printTestFile("batterytest.bt", finalTests);
        return finalTests;
    }

    private Vector parse(Vector tokens, boolean verbose) {
        if (verbose) {
            System.out.println("\n================\nSTARTING PARSE\n" + tokens + "\n================\n");
        }
        Vector<BatteryTestConfig> tests = new Vector<BatteryTestConfig>();
        int index = -1;
        ListIterator i = tokens.listIterator();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (verbose) {
                System.out.println("TOKEN: " + token);
            }
            if (i.hasNext()) {
                String nextToken = (String)i.next();
                if (verbose) {
                    System.out.println("NEXT TOKEN: " + nextToken);
                }
                if (token.equalsIgnoreCase(INCLUDE)) {
                    try {
                        TestConfig tc;
                        try {
                            tc = TestConfig.create();
                        }
                        catch (HydraRuntimeException e) {
                            tc = TestConfig.getInstance();
                        }
                        MasterDescription.configure(tc);
                        String fn = EnvHelper.expandEnvVars(nextToken, tc.getMasterDescription().getVmDescription().getHostDescription());
                        Vector includedTests = ConfigParser.parseFile(fn, verbose);
                        for (BatteryTestConfig includedTest : includedTests) {
                            tests.add(++index, includedTest);
                        }
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new HydraConfigException("Include file not found: " + nextToken, e);
                    }
                }
                if (nextToken.equals("=")) {
                    String s;
                    if (index == -1) {
                        s = "No test specified for system property: " + token;
                        throw new HydraConfigException(s);
                    }
                    if (this.containsWhiteSpace(token)) {
                        s = "System property cannot include whitespace: " + token;
                        throw new HydraConfigException(s);
                    }
                    if (verbose) {
                        System.out.println("PARSING SYSPROP VALUE");
                    }
                    this.parseSysPropValue(i, tests, index, token, verbose);
                    continue;
                }
                if (verbose && index > -1) {
                    System.out.println(index + ":" + tests.elementAt(index));
                }
                if (!this.isTest(token)) continue;
                tests.add(++index, new BatteryTestConfig(token));
                i.previous();
                continue;
            }
            if (verbose && index > -1) {
                System.out.println(index + ":" + tests.elementAt(index));
            }
            if (!this.isTest(token)) continue;
            tests.add(++index, new BatteryTestConfig(token));
        }
        return this.postprocess(tests, verbose);
    }

    private void parseSysPropValue(ListIterator i, Vector tests, int index, String sysprop, boolean verbose) {
        BatteryTestConfig btc;
        HydraVector values;
        if (i.hasNext()) {
            values = this.parseUnterminatedCommaIdentifierList(i, verbose);
            if (verbose) {
                System.out.println("SYSPROP VALUES: " + values);
            }
            btc = (BatteryTestConfig)tests.get(index);
            if (verbose) {
                System.out.println("ADDING PROPERTY " + sysprop);
            }
        } else {
            String s = "Expected value for system property " + sysprop;
            throw new HydraConfigException(s);
        }
        btc.addProperty(sysprop, values);
    }

    private HydraVector parseUnterminatedCommaIdentifierList(ListIterator i, boolean verbose) {
        HydraVector list = new HydraVector();
        String identifier = this.parseValue(i);
        if (verbose) {
            System.out.println("COMMALIST TOKEN: " + identifier);
        }
        if (identifier.equals(COMMA)) {
            throw new HydraConfigException("Found comma instead of identifier");
        }
        list.add(identifier);
        while (i.hasNext()) {
            identifier = this.parseValue(i);
            if (verbose) {
                System.out.println("COMMALIST TOKEN: " + identifier);
            }
            if (identifier.equals(COMMA)) {
                identifier = this.parseValue(i);
                if (verbose) {
                    System.out.println("COMMALIST TOKEN: " + identifier);
                }
                if (identifier.equals(COMMA)) {
                    throw new HydraConfigException("Extra comma");
                }
                list.add(identifier);
                continue;
            }
            i.previous();
            break;
        }
        return list;
    }

    private String parseValue(ListIterator i) {
        String token = (String)i.next();
        if (this.containsWhiteSpace(token)) {
            String s = "System property cannot include whitespace: " + token;
            throw new HydraConfigException(s);
        }
        return token;
    }

    private boolean isTest(String token) {
        if (token.indexOf(".conf") == -1 && token.indexOf(".pl") == -1 && token.indexOf(".xml") == -1) {
            throw new HydraConfigException("Expected .conf or .xml or .pl file, found: " + token);
        }
        return true;
    }

    private boolean containsWhiteSpace(String token) {
        return token.indexOf(32) > -1 || token.indexOf(9) > -1 || token.indexOf(10) > -1 || token.indexOf(13) > -1 || token.indexOf(12) > -1;
    }

    private String getText(String fn) throws FileNotFoundException {
        StringBuffer buf = new StringBuffer(1000);
        BufferedReader br = new BufferedReader(new FileReader(fn));
        try {
            String s;
            while ((s = br.readLine()) != null) {
                buf.append(s);
                buf.append(NEWLINE);
            }
            br.close();
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Error reading hydra configuration file " + fn, e);
        }
        return buf.toString();
    }

    private Vector postprocess(Vector tests, boolean verbose) {
        Vector<BatteryTestConfig> newTests = new Vector<BatteryTestConfig>();
        for (BatteryTestConfig btc : tests) {
            Vector btcp = btc.getProperties();
            if (btc.postprocessed() || btcp == null) {
                newTests.add(btc);
                continue;
            }
            Vector properties = ConfigParser.multiply(btcp.iterator());
            if (verbose) {
                System.out.println("MULTIPLIER RESULT: " + properties);
            }
            String name = btc.getName();
            Iterator j = properties.iterator();
            while (j.hasNext()) {
                String onlyOnPlatforms;
                String key;
                BatteryTestConfig.Property p;
                BatteryTestConfig b = new BatteryTestConfig(name);
                b.setProperties((Vector)j.next());
                if (verbose) {
                    System.out.println("CREATING TEST WITH PROPERTIES: " + b.getProperties());
                }
                if ((p = b.getProperty(key = "perffmwk.comparisonKey")) != null) {
                    if (((String)p.getVal()).equalsIgnoreCase("autogenerate")) {
                        b.resetProperty(key, String.valueOf(ComparisonKey));
                        if (verbose) {
                            System.out.println("RESET " + b.getProperty(key));
                        }
                        ++ComparisonKey;
                    } else {
                        String val = (String)p.getVal();
                        if (val.toLowerCase().startsWith("fromprops")) {
                            b.resetProperty(key, b.getPropertyKeyString(val));
                            if (verbose) {
                                System.out.println("RESET " + b.getProperty(key));
                            }
                        }
                    }
                }
                if (HostHelper.shouldRun(onlyOnPlatforms = (String)b.getPropertyVal("onlyOnPlatforms"))) {
                    b.postprocess();
                    newTests.add(b);
                    continue;
                }
                if (!verbose) continue;
                System.out.println("Skipping " + b + " because it is only run on " + onlyOnPlatforms + " and this platform is " + (Object)((Object)HostHelper.getLocalHostOS()));
            }
        }
        if (verbose) {
            System.out.println("Generated " + newTests.size() + " tests from:\n" + tests + ":\n" + newTests);
        }
        return newTests;
    }

    private static Vector multiply(Vector properties) {
        return ConfigParser.multiply(properties.iterator());
    }

    private static Vector multiply(Iterator properties) {
        BatteryTestConfig.Property property = (BatteryTestConfig.Property)properties.next();
        String key = property.getKey();
        if (properties.hasNext()) {
            Vector bodies = new Vector();
            Vector tails = ConfigParser.multiply(properties);
            for (String head : (Vector)property.getVal()) {
                for (Vector tail : tails) {
                    Vector<BatteryTestConfig.Property> body = new Vector<BatteryTestConfig.Property>();
                    body.add(new BatteryTestConfig.Property(key, head));
                    for (BatteryTestConfig.Property p : tail) {
                        body.add(p.copy());
                    }
                    bodies.add(body);
                }
            }
            return bodies;
        }
        Vector bodies = new Vector();
        for (String head : (Vector)property.getVal()) {
            Vector<BatteryTestConfig.Property> body = new Vector<BatteryTestConfig.Property>();
            body.add(new BatteryTestConfig.Property(key, head));
            bodies.add(body);
        }
        return bodies;
    }

    private static void printTestFile(String fn, Vector tests) {
        if (tests == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (BatteryTestConfig btc : tests) {
            buf.append(btc.toTestString());
        }
        FileUtil.writeToFile(fn, buf.toString());
    }

    public static void main(String[] args) {
        String fn = args[0];
        try {
            Vector tests = ConfigParser.parseFile(fn, true);
            System.out.println("\n================================================================================\n");
            System.out.println("FINAL LIST");
            System.out.println("\n================================================================================\n");
            for (BatteryTestConfig btc : tests) {
                System.out.println(btc);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Batterytest input file " + fn + " not found.");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

