/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import hydra.FileUtil;
import hydra.HydraConfigException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class BatteryTestConfig {
    private String name;
    private Vector<Property> properties;
    private boolean postprocessed = false;

    public BatteryTestConfig(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected Vector getProperties() {
        return this.properties;
    }

    public SortedMap getSortedProperties() {
        if (this.properties == null) {
            return null;
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Property p : this.properties) {
            map.put(p.getKey(), p.getVal());
        }
        return map;
    }

    protected void setProperties(Vector properties) {
        this.properties = properties;
    }

    protected String getPropertyKeyString(String val) {
        if (val.substring(9).length() == 0) {
            if (this.properties == null) {
                return "none";
            }
            return this.getPropertyKeyString();
        }
        if (this.properties == null) {
            String s = "No properties available to compute " + val;
            throw new HydraConfigException(s);
        }
        return this.getPropertyKeyStringFrom(val);
    }

    private String getPropertyKeyString() {
        StringBuffer buf = new StringBuffer();
        for (Property p : this.properties) {
            if (p.getKey().equals("perffmwk.comparisonKey")) continue;
            if (buf.length() > 0) {
                buf.append("_");
            }
            buf.append(p.getVal());
        }
        return buf.toString();
    }

    private String getPropertyKeyStringFrom(String propspec) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(propspec.substring(9), ":", false);
        boolean skipNextUnderscore = false;
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String val = (String)this.getPropertyVal(key);
            if (val == null) {
                val = key;
            }
            if (val.equals("x")) {
                skipNextUnderscore = true;
            } else if (skipNextUnderscore) {
                skipNextUnderscore = false;
            } else if (buf.length() > 0) {
                buf.append("_");
            }
            buf.append(val);
        }
        return buf.toString();
    }

    protected String getPropertyString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" ");
        if (this.properties != null) {
            for (Property property : this.properties) {
                buf.append("-D" + property.getKey() + "=" + property.getVal() + " ");
            }
        }
        return buf.toString();
    }

    protected Property getProperty(String key) {
        if (this.properties != null) {
            for (Property p : this.properties) {
                if (!p.getKey().equals(key)) continue;
                return p;
            }
        }
        return null;
    }

    protected Object getPropertyVal(String key) {
        if (this.properties == null) {
            return null;
        }
        Property property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        return property.getVal();
    }

    protected void resetProperty(String key, Object val) {
        boolean reset = false;
        for (Property p : this.properties) {
            if (!p.getKey().equals(key)) continue;
            int index = this.properties.indexOf(p);
            p.setVal(val);
            reset = true;
        }
        if (!reset) {
            this.properties.add(new Property(key, val));
        }
    }

    protected void addProperty(String key, Object val) {
        Property p;
        if (this.properties == null) {
            this.properties = new Vector();
        }
        if ((p = this.getProperty(key)) != null) {
            throw new HydraConfigException("Property " + p.getKey() + " has already been set to " + p.getVal() + ", cannot be reset to " + val);
        }
        Property property = new Property(key, val);
        this.properties.add(property);
    }

    protected boolean postprocessed() {
        return this.postprocessed;
    }

    protected void postprocess() {
        this.postprocessed = true;
    }

    public void fillInWithDefaultsFrom(String fn) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(fn);
        }
        catch (FileNotFoundException e) {
            return;
        }
        Properties p = new Properties();
        try {
            p.load(fis);
        }
        catch (IOException e) {
            throw new HydraConfigException("Unable to load test properties from " + fn);
        }
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (this.getProperty(name) != null) continue;
            this.addProperty(name, p.getProperty(name));
        }
    }

    protected void writePropertiesToFile(String fn) {
        StringBuffer buf = new StringBuffer();
        SortedMap map = this.getSortedProperties();
        if (map != null) {
            buf.append("testName=" + this.getName() + "\n");
            for (String key : map.keySet()) {
                buf.append(key + "=" + map.get(key) + "\n");
            }
            FileUtil.writeToFile(fn, buf.toString());
        }
    }

    protected String toTestString() {
        return this.toTestSpec() + "\n";
    }

    protected String toTestSpec() {
        if (this.properties == null) {
            return this.name;
        }
        return this.name + " " + this.toTestProps();
    }

    protected String toTestProps() {
        StringBuffer buf = new StringBuffer();
        if (this.properties != null) {
            for (Property property : this.properties) {
                buf.append(" " + property.getKey() + "=" + property.getVal());
            }
        }
        return buf.toString().trim();
    }

    public String toString() {
        String s = this.name;
        if (this.properties != null) {
            s = s + " " + this.properties;
        }
        return s;
    }

    public static class Property {
        String key;
        Object val;

        public Property(String key, Object val) {
            this.key = key;
            this.val = val;
        }

        public String getKey() {
            return this.key;
        }

        public Object getVal() {
            return this.val;
        }

        protected void setVal(Object val) {
            this.val = val;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        public Property copy() {
            return new Property(this.key, this.val);
        }
    }
}

