/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.AdminBB;
import admin.AdminPrms;
import admin.AdminTestDistributedSystemFactory;
import admin.AdminTestException;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.RegionNotFoundException;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberCacheListener;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import hydra.AgentHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.log.LogPrms;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import util.CacheUtil;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class AdminTest {
    public static AdminTest testInstance;
    protected static final boolean adminInDsVm;
    protected static final String logLevel;
    protected static int[] GfManagerOperations;
    protected static final int getProductDirectoryOp = 0;
    protected static final int firstGfManagerOperation = 0;
    protected static final int lastGfManagerOperation = 0;
    protected static int[] SystemMemberOperations;
    protected static final int accessAllRegions = 100;
    protected static final int dispCacheAttrs = 101;
    protected static final int modifyCacheAttrs = 102;
    protected static final int dispRegionAttrs = 103;
    protected static final int firstSystemMemberOperation = 100;
    protected static final int lastSystemMemberOperation = 103;
    protected static int[] GfHealthOperations;
    protected static final int setHealthEvalIntervalOp = 200;
    protected static final int firstGfHealthOperation = 200;
    protected static final int lastGfHealthOperation = 200;
    public AdminDistributedSystem ds = null;

    protected String opToString(int op) {
        switch (op) {
            case 0: {
                return "getProductDirectory";
            }
            case 100: {
                return "accessAllRegions";
            }
            case 101: {
                return "dispCacheAttrs";
            }
            case 102: {
                return "modifyCacheAttrs";
            }
            case 103: {
                return "dispRegionAttrs";
            }
            case 200: {
                return "setHealthEvalInterval";
            }
        }
        throw new TestException("Unknown operation " + op);
    }

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static void startAgentTask() {
        String agentConfig = ConfigPrms.getAgentConfig();
        AgentHelper.createAgent(agentConfig);
        AgentHelper.startAgent();
    }

    public static synchronized void createRegionHierarchyTask() {
        Cache c = CacheUtil.createCache();
        if (c.rootRegions().size() <= 0) {
            testInstance.createRegionHierarchy();
        }
    }

    protected void createRegionHierarchy() {
        Cache c = CacheUtil.createCache();
        int numRoots = TestConfig.tab().intAt(AdminPrms.numRootRegions);
        int breadth = TestConfig.tab().intAt(AdminPrms.numSubRegions);
        int depth = TestConfig.tab().intAt(AdminPrms.regionDepth);
        Region r2 = null;
        c.setLockTimeout(TestConfig.tab().intAt(AdminPrms.lockTimeout));
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        for (int i = 0; i < numRoots; ++i) {
            String rootName = "root" + (i + 1);
            r2 = regDef.createRootRegion(c, rootName, null, null, null);
            Log.getLogWriter().info("Created root region " + TestHelper.regionToString(r2, true));
            AdminTest.createSubRegions(r2, breadth, depth, "Region", regDef);
        }
        Set croots = c.rootRegions();
        for (Region aRegion : croots) {
            Set subRegions = aRegion.subregions(true);
            String mapKey = new String(aRegion.getName() + "_RegionCount");
            Log.getLogWriter().fine(" putting ( " + mapKey + ", " + subRegions.size() + ") into sharedMap");
            AdminBB.getInstance().getSharedMap().put(mapKey, new Integer(subRegions.size()));
        }
        croots = c.rootRegions();
        if (croots.size() != numRoots) {
            Log.getLogWriter().info("ERROR: wrong number of roots: " + c.rootRegions().size());
        }
        for (Region r2 : croots) {
            Set subs = r2.subregions(true);
            Iterator sit = subs.iterator();
            while (sit.hasNext()) {
                Log.getLogWriter().fine("  " + ((Region)sit.next()).getName());
            }
            Log.getLogWriter().fine("===");
        }
    }

    public static void createSubRegions(Region r, int numChildren, int levelsLeft, String parentName, RegionDefinition regDef) {
        for (int i = 1; i <= numChildren; ++i) {
            String currentName = parentName + "-" + i;
            Region child = null;
            try {
                child = r.createSubregion(currentName, regDef.getRegionAttributes(null, null, null));
                Log.getLogWriter().fine("Created subregion " + TestHelper.regionToString(child, true));
            }
            catch (RegionExistsException e) {
                child = r.getSubregion(currentName);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (levelsLeft <= 1) continue;
            AdminTest.createSubRegions(child, numChildren, levelsLeft - 1, currentName, regDef);
        }
    }

    public static void dispRegions() {
        Set croots = CacheUtil.getCache().rootRegions();
        for (Region r : croots) {
            Log.getLogWriter().fine(r.getName());
            Set subs = r.subregions(true);
            Iterator sit = subs.iterator();
            while (sit.hasNext()) {
                Log.getLogWriter().fine("  " + ((Region)sit.next()).getName());
            }
            Log.getLogWriter().fine("===");
        }
    }

    public static synchronized void initializeTask() {
        if (testInstance == null) {
            testInstance = new AdminTest();
            testInstance.initialize();
        }
    }

    public static synchronized void initializeForCacheTask() {
        if (testInstance == null) {
            testInstance = new AdminTest();
            CacheUtil.createCache();
        }
    }

    public static synchronized void initializeForSameVmTask() {
        if (testInstance == null) {
            testInstance = new AdminTest();
            CacheUtil.createCache();
            testInstance.initialize();
        }
    }

    protected void initialize() {
        SystemMemberCacheListener systemMemberCacheListener;
        SystemMembershipListener systemMembershipListener;
        DistributedSystemConfig dsConfig;
        Cache cache;
        Log.getLogWriter().info("Creating an admin DistributedSystem...");
        if (!adminInDsVm) {
            cache = CacheUtil.createCache();
            cache.getDistributedSystem().disconnect();
            AdminDistributedSystemFactory.setEnableAdministrationOnly((boolean)true);
            String gemfireName = System.getProperty("gemfireName");
            GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
            Integer mcastPort = gfd.getMcastPort();
            String mcastAddress = gfd.getMcastAddress();
            Boolean disableTcp = gfd.getDisableTcp();
            Properties p = gfd.getDistributedSystemProperties();
            String locatorPortString = p.getProperty("locators");
            Log.getLogWriter().info("locatorPortString = " + locatorPortString);
            dsConfig = AdminDistributedSystemFactory.defineDistributedSystem();
            dsConfig.setLocators(locatorPortString);
            if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
                String addr = HostHelper.getHostAddress();
                dsConfig.setBindAddress(addr);
            }
            dsConfig.setMcastPort(mcastPort.intValue());
            dsConfig.setMcastAddress(mcastAddress);
            dsConfig.setDisableTcp(disableTcp.booleanValue());
        } else {
            cache = CacheUtil.getCache();
            DistributedSystem thisVmDs = cache.getDistributedSystem();
            try {
                dsConfig = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)thisVmDs, null);
            }
            catch (AdminException ae) {
                String s = "Problem getting config for ds to which VM is currently connected";
                throw new AdminTestException(s, (Exception)((Object)ae));
            }
        }
        try {
            this.ds = AdminTestDistributedSystemFactory.getDistributedSystem(dsConfig);
            Log.getLogWriter().fine("getDistributedSystem returned " + this.ds.toString());
        }
        catch (AdminTestException ae) {
            throw new HydraRuntimeException("Could not getDistributedSystem", (Exception)((Object)ae));
        }
        if (AdminPrms.getAdminInterface() == 0 && (systemMembershipListener = AdminPrms.getSystemMembershipListener()) != null) {
            this.ds.addMembershipListener(systemMembershipListener);
        }
        if (AdminPrms.getAdminInterface() == 0 && (systemMemberCacheListener = AdminPrms.getSystemMemberCacheListener()) != null) {
            this.ds.addCacheListener(systemMemberCacheListener);
        }
        Log.getLogWriter().info("Connecting to the AdminDistributedSystem " + this.ds);
        if (this.ds instanceof AdminDistributedSystemImpl) {
            ((AdminDistributedSystemImpl)this.ds).connect(Log.getLogWriter().convertToLogWriterI18n());
        } else {
            this.ds.connect();
        }
        long timeout = 30000L;
        try {
            if (!this.ds.waitToBeConnected(timeout)) {
                String s = "Could not connect after " + timeout + "ms";
                throw new TestException(s);
            }
        }
        catch (InterruptedException ex) {
            String s = "Interrupted while waiting to be connected";
            throw new HydraRuntimeException(s, ex);
        }
        dsConfig = this.ds.getConfig();
        while (!this.ds.isRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Log.getLogWriter().warning("Interrupted while sleeping", (Throwable)ex);
            }
        }
        Log.getLogWriter().fine("getConfig returns " + dsConfig.toString());
        String runningStatus = new String(this.ds.isRunning() ? " is " : " is not ");
        Log.getLogWriter().info("DistributedSystem " + this.ds.getName() + ":" + this.ds.getId() + runningStatus + "running");
        Log.getLogWriter().info("Exiting initialize()");
    }

    public static void GFHealthOpsTask() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doGFHealthOps(minTaskGranularityMS);
    }

    protected void doGFHealthOps(long msToRun) {
        GemFireHealth health = this.ds.getGemFireHealth();
        String hostName = HostHelper.getIPAddress().getCanonicalHostName();
        Log.getLogWriter().info("hostName is " + hostName);
        Log.getLogWriter().info("Doing operations on GemFireHealth " + health + " for " + msToRun + " ms");
        long startTime = System.currentTimeMillis();
        do {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, GfHealthOperations.length - 1);
            int whichOp = GfHealthOperations[randInt];
            Log.getLogWriter().fine("Doing GemFireHealth operation " + this.opToString(whichOp) + " on " + health);
            GemFireHealthConfig healthConfig = null;
            boolean configIsDefault = false;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().fine("Getting default GemFireHealthConfig...");
                configIsDefault = true;
                healthConfig = health.getDefaultGemFireHealthConfig();
            } else {
                Log.getLogWriter().fine("Getting GemFireHealthConfig for host " + hostName + "...");
                configIsDefault = false;
                healthConfig = health.getGemFireHealthConfig(hostName);
            }
            switch (whichOp) {
                case 200: {
                    int newInterval = TestConfig.tab().getRandGen().nextInt(1, 10);
                    Log.getLogWriter().fine("Setting new healthEvaluationInterval to " + newInterval);
                    healthConfig.setHealthEvaluationInterval(newInterval);
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + this.opToString(whichOp));
                }
            }
            if (configIsDefault) {
                health.setDefaultGemFireHealthConfig(healthConfig);
            } else {
                health.setGemFireHealthConfig(hostName, healthConfig);
            }
            GemFireHealth.Health currentHealth = health.getHealth();
            Log.getLogWriter().fine("Current health is " + currentHealth + ", diagnosis is " + health.getDiagnosis());
        } while (System.currentTimeMillis() - startTime < msToRun);
        Log.getLogWriter().fine("Done doing operations on GemFireManager for " + msToRun + " ms");
    }

    public static void SystemMemberOpsTask() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        try {
            testInstance.doSystemMemberOps(minTaskGranularityMS);
        }
        catch (RuntimeException ex) {
            Log.getLogWriter().severe("During doSystemMemberOps", (Throwable)ex);
            throw ex;
        }
    }

    protected void doSystemMemberOps(long msToRun) {
        SystemMember[] systemMembers = null;
        TestHelper.checkForEventError(AdminBB.getInstance());
        try {
            systemMembers = this.ds.getSystemMemberApplications();
        }
        catch (AdminException ae) {
            throw new HydraRuntimeException("Could not get SystemMemberApplications");
        }
        if (systemMembers.length == 0) {
            Log.getLogWriter().info("Cannot do operations on SystemMembers, there are no SystemMembers");
            return;
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("Discovered " + systemMembers.length + " SystemMembers\n");
        for (int i = 0; i < systemMembers.length; ++i) {
            aStr.append("   SystemMembers[" + i + "] = " + systemMembers[i].toString() + "\n");
        }
        Log.getLogWriter().fine(aStr.toString());
        Log.getLogWriter().info("Doing operations on SystemMembers for " + msToRun + " ms");
        long startTime = System.currentTimeMillis();
        block26: do {
            SystemMemberCache cache;
            int randInt = TestConfig.tab().getRandGen().nextInt(0, systemMembers.length - 1);
            SystemMember sm = systemMembers[randInt];
            randInt = TestConfig.tab().getRandGen().nextInt(0, SystemMemberOperations.length - 1);
            int whichOp = SystemMemberOperations[randInt];
            Log.getLogWriter().fine("Doing SystemMember operation " + this.opToString(whichOp) + " on " + sm);
            try {
                cache = sm.getCache();
            }
            catch (AdminException e) {
                String s = "During accessAllRegions";
                throw new TestException(s, e);
            }
            catch (OperationCancelledException e) {
                Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                continue;
            }
            if (cache == null) {
                Log.getLogWriter().fine("Member " + sm + " has no cache");
                continue;
            }
            switch (whichOp) {
                case 100: {
                    try {
                        this.accessAllRegions(cache);
                    }
                    catch (CancelException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                    }
                    catch (OperationCancelledException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                    }
                    continue block26;
                }
                case 102: {
                    try {
                        this.modifyCacheAttrs(cache);
                        break;
                    }
                    catch (AdminException e) {
                        String s = "During modifyCacheAttrs on " + sm.getName() + " " + sm.getId();
                        throw new TestException(s, e);
                    }
                    catch (CancelException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                        break;
                    }
                    catch (OperationCancelledException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                        break;
                    }
                }
                case 101: {
                    try {
                        this.dispCacheAttrs(cache);
                    }
                    catch (CancelException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                    }
                    catch (OperationCancelledException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                    }
                    continue block26;
                }
                case 103: {
                    try {
                        this.dispRegionAttrs(cache);
                        break;
                    }
                    catch (AdminException e) {
                        String s = "During dispRegionAttrs on " + sm.getName() + " " + sm.getId();
                        throw new TestException(s, e);
                    }
                    catch (CancelException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                        break;
                    }
                    catch (OperationCancelledException e) {
                        Log.getLogWriter().fine("Ignoring exception " + (Object)((Object)e));
                        break;
                    }
                }
                default: {
                    throw new TestException("Unknown operation " + this.opToString(whichOp));
                }
            }
        } while (System.currentTimeMillis() - startTime < msToRun);
        Log.getLogWriter().fine("Done doing operations on GemFireManager for " + msToRun + " ms");
    }

    protected void accessAllRegions(SystemMemberCache smCache) {
        Log.getLogWriter().fine("SystemMemberCache = " + smCache.toString());
        Set rootRegions = smCache.getRootRegionNames();
        Log.getLogWriter().fine(" root regions = " + rootRegions);
        ArrayList aList = this.getAllRegionNames(smCache);
        StringBuffer displayList = new StringBuffer();
        for (int i = 0; i < aList.size(); ++i) {
            displayList.append(aList.get(i) + " \n");
        }
        Log.getLogWriter().fine("accessAllRegions regionList = \n" + displayList.toString());
    }

    protected void dispCacheAttrs(SystemMemberCache smCache) {
        Log.getLogWriter().fine("dispCacheAttrs: SystemMemberCache = " + smCache.toString());
        StringBuffer aStr = new StringBuffer("dispCacheAttrs values:\n");
        try {
            smCache.refresh();
            aStr.append("LockLease = " + smCache.getLockLease() + "\n");
            aStr.append("LockTimeout = " + smCache.getLockTimeout() + "\n");
            aStr.append("SearchTimeout = " + smCache.getSearchTimeout() + "\n");
        }
        catch (RegionNotFoundException ex) {
            Log.getLogWriter().fine("dispCacheAttrs caught " + (Object)((Object)ex));
        }
        Log.getLogWriter().fine(aStr.toString());
    }

    protected void modifyCacheAttrs(SystemMemberCache smCache) throws AdminException {
        Log.getLogWriter().fine("modifyCacheAttrs: SystemMemberCache = " + smCache.toString());
        int lockLease = smCache.getLockLease();
        int lockTimeout = smCache.getLockTimeout();
        int searchTimeout = smCache.getSearchTimeout();
        StringBuffer aStr = new StringBuffer("modifyCacheAttrs original values:\n");
        aStr.append("lockLease = " + lockLease + "\n");
        aStr.append("lockTimeout = " + lockTimeout + "\n");
        aStr.append("searchTimeout = " + searchTimeout + "\n");
        Log.getLogWriter().fine(aStr.toString());
        smCache.setLockLease(lockLease + 10);
        smCache.setLockTimeout(lockTimeout + 10);
        smCache.setSearchTimeout(searchTimeout + 10);
        smCache.refresh();
        aStr = new StringBuffer("modifyCacheAttrs updated values: \n");
        aStr.append("lockLease = " + smCache.getLockLease() + "\n");
        aStr.append("lockTimeout = " + smCache.getLockTimeout() + "\n");
        aStr.append("searchTimeout = " + smCache.getSearchTimeout() + "\n");
        Log.getLogWriter().fine(aStr.toString());
    }

    protected void dispRegionAttrs(SystemMemberCache smCache) throws AdminException {
        Log.getLogWriter().fine("dispRegionAttrs: SystemMemberCache = " + smCache.toString());
        smCache.refresh();
        String regionName = this.getRandomRegion(smCache);
        if (regionName == null) {
            return;
        }
        SystemMemberRegion smRegion = null;
        try {
            smRegion = smCache.getRegion(regionName);
        }
        catch (AdminException ae) {
            throw new AdminTestException(" could not getRegion " + regionName, (Exception)((Object)ae));
        }
        catch (RegionNotFoundException ex) {
            Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + regionName);
            return;
        }
        catch (RegionDestroyedException de) {
            Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + regionName);
            return;
        }
        if (smRegion == null) {
            Log.getLogWriter().fine("dispRegionAttrs : getRegion returned null for " + regionName);
            return;
        }
        try {
            smRegion.refresh();
        }
        catch (RegionNotFoundException ex) {
            Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + regionName + " during refresh");
            return;
        }
        catch (RegionDestroyedException de) {
            Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + regionName + " during refresh");
            return;
        }
        StringBuffer aStr = new StringBuffer("dispRegionAttrs: \n");
        try {
            int entryTTL = smRegion.getEntryTimeToLiveTimeLimit();
            int entryIdleTime = smRegion.getEntryIdleTimeoutTimeLimit();
            int regionTTL = smRegion.getRegionTimeToLiveTimeLimit();
            int regionIdleTime = smRegion.getRegionIdleTimeoutTimeLimit();
            int entryCount = smRegion.getEntryCount();
            long lastModifiedTime = smRegion.getLastModifiedTime();
            long lastAccessedTime = smRegion.getLastAccessedTime();
            long hitCount = smRegion.getHitCount();
            long missCount = smRegion.getMissCount();
            Set subregionNames = smRegion.getSubregionNames();
            aStr.append("Region = " + regionName + "\n");
            aStr.append("entryTTL = " + entryTTL + "\n");
            aStr.append("entryIdleTime = " + entryIdleTime + "\n");
            aStr.append("regionTTL = " + regionTTL + "\n");
            aStr.append("regionIdleTime = " + regionIdleTime + "\n");
            aStr.append("entryCount = " + entryCount + "\n");
            aStr.append("lastModifiedTime = " + lastModifiedTime + "\n");
            aStr.append("lastAccessedTime = " + lastAccessedTime + "\n");
            aStr.append("hitCount = " + hitCount + "\n");
            aStr.append("missCount = " + missCount + "\n");
            aStr.append("subregionNames = " + subregionNames + "\n");
        }
        catch (RegionNotFoundException ex) {
            Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + regionName + " getAttributes()");
            return;
        }
        catch (RegionDestroyedException de) {
            Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + regionName + "getAttributes()");
            return;
        }
        Log.getLogWriter().fine(aStr.toString());
    }

    protected String getRandomRegion(SystemMemberCache smCache) throws AdminException {
        ArrayList regionList = this.getAllRegionNames(smCache);
        for (int i = 0; i < 20 && regionList.isEmpty(); ++i) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new TestException("Interrupted while sleeping", ex);
            }
            smCache.refresh();
            regionList = this.getAllRegionNames(smCache);
        }
        if (regionList.isEmpty()) {
            String s = "Member Cache " + smCache + " has no regions";
            Log.getLogWriter().fine(s);
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, regionList.size() - 1);
        String regionName = (String)regionList.get(randInt);
        Log.getLogWriter().fine("getRandomRegion returning " + regionName);
        return regionName;
    }

    protected ArrayList getAllRegionNames(SystemMemberCache smCache) {
        ArrayList regionList = new ArrayList();
        SystemMemberRegion smRegion = null;
        smCache.refresh();
        Set rootRegions = smCache.getRootRegionNames();
        regionList.addAll(rootRegions);
        Iterator it = rootRegions.iterator();
        while (it.hasNext()) {
            String regionName = null;
            try {
                regionName = (String)it.next();
                smRegion = smCache.getRegion(regionName);
            }
            catch (AdminException ae) {
                throw new AdminTestException(" could not getRegion " + regionName, (Exception)((Object)ae));
            }
            catch (RegionNotFoundException ex) {
                Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + regionName);
                continue;
            }
            catch (RegionDestroyedException de) {
                Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + regionName);
                continue;
            }
            regionList.addAll(this.getRegionNames(smCache, smRegion));
        }
        return regionList;
    }

    protected ArrayList getRegionNames(SystemMemberCache smCache, SystemMemberRegion smRegion) {
        ArrayList<String> aList = new ArrayList<String>();
        String subregionName = null;
        Set subRegions = null;
        String parentRegionName = null;
        try {
            smRegion.refresh();
            parentRegionName = smRegion.getFullPath();
            subRegions = smRegion.getSubregionNames();
        }
        catch (Exception e) {
            Log.getLogWriter().fine("getRegionNames caught " + e);
            return aList;
        }
        Iterator it = subRegions.iterator();
        while (it.hasNext()) {
            subregionName = new String(parentRegionName + "/" + (String)it.next());
            aList.add(subregionName);
            SystemMemberRegion aRegion = null;
            try {
                aRegion = smCache.getRegion(subregionName);
            }
            catch (AdminException ae) {
                throw new AdminTestException(" Could not get subregion given subregionName " + subregionName, (Exception)((Object)ae));
            }
            catch (RegionNotFoundException ex) {
                Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + subregionName);
                continue;
            }
            catch (RegionDestroyedException dx) {
                Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + subregionName);
                continue;
            }
            if (aRegion == null) {
                if (AdminPrms.areRegionsDestroyed()) continue;
                String s = "Could not find subregion \"" + subregionName + "\"";
                throw new TestException(s);
            }
            aList.addAll(this.getRegionNames(smCache, aRegion));
        }
        return aList;
    }

    public static void validateTest() {
        Log.getLogWriter().info("Entered validateTest()");
        if (AdminPrms.getAdminInterface() == 0) {
            AdminBB.getInstance().printSharedCounters();
            SharedCounters sc = AdminBB.getInstance().getSharedCounters();
            long recycleRequests = sc.read(AdminBB.recycleRequests);
            long joinedNotifications = sc.read(AdminBB.joinedNotifications);
            long departedNotifications = sc.read(AdminBB.departedNotifications);
            if (recycleRequests == 0L) {
                throw new AdminTestException("ValidationFailed: No recycling of Connections completed");
            }
            if (departedNotifications == 0L || joinedNotifications == 0L) {
                throw new AdminTestException("ValidationFailed:  Expected non-zero values , but found joined:" + joinedNotifications + " departed: " + departedNotifications);
            }
        }
    }

    public static void anyAdminOpsTask() {
        testInstance.doAnyAdminOps();
    }

    protected void doAnyAdminOps() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Doing admin operations for " + minTaskGranularityMS + " ms");
        long startTime = System.currentTimeMillis();
        do {
            this.doGFHealthOps(0L);
            this.doSystemMemberOps(0L);
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        Log.getLogWriter().fine("Done doing admin operations for " + minTaskGranularityMS + " ms");
    }

    public static synchronized void waitForSystemMembersTask() {
        testInstance.waitForSystemMembers();
    }

    /*
     * Unable to fully structure code
     */
    protected void waitForSystemMembers() {
        block9: {
            expectedNumSystemMembers = TestHelper.getNumVMs();
            if (!AdminTest.adminInDsVm) {
                --expectedNumSystemMembers;
            }
            agents = AgentHelper.getEndpoints();
            Log.getLogWriter().info("Waiting for " + (expectedNumSystemMembers -= agents.size()) + " system members");
            numSystemMembers = 0;
            lastLogTime = 0L;
            logInterval = 5000L;
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    Assert.assertTrue((boolean)(this.ds != null));
                    numSystemMembers = this.ds.getSystemMemberApplications().length;
                    if (numSystemMembers == expectedNumSystemMembers) break block9;
                    if (numSystemMembers > expectedNumSystemMembers) {
                        systemMembers = this.ds.getSystemMemberApplications();
                        aStr = new StringBuffer();
                        aStr.append("Discovered " + systemMembers.length + " SystemMembers\n");
                        for (i = 0; i < systemMembers.length; ++i) {
                            aStr.append("   SystemMembers[" + i + "] = " + systemMembers[i].getId() + "\n");
                        }
                        Log.getLogWriter().fine(aStr.toString());
                        throw new AdminTestException("Number of system members exceeds number expected.  Expected: " + expectedNumSystemMembers + " but found: " + numSystemMembers);
                    }
                    if (System.currentTimeMillis() - lastLogTime >= logInterval) {
                        Log.getLogWriter().fine("Waiting for " + expectedNumSystemMembers + " system members, current number of system members: " + numSystemMembers);
                        lastLogTime = System.currentTimeMillis();
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    break;
                }
            }
            catch (AdminException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            {
                ** while (true)
            }
        }
        Log.getLogWriter().fine("Done waiting for system members, found " + numSystemMembers);
    }

    public static void healthMonitorTask() {
        testInstance.doHealthMonitor();
    }

    protected void doHealthMonitor() {
        GemFireHealth health = this.ds.getGemFireHealth();
        GemFireHealthConfig healthConfig = health.getDefaultGemFireHealthConfig();
        int newInterval = 1;
        Log.getLogWriter().fine("Setting new healthEvaluationInterval to " + newInterval);
        healthConfig.setHealthEvaluationInterval(newInterval);
        health.setDefaultGemFireHealthConfig(healthConfig);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Monitoring health for " + minTaskGranularityMS + " ms");
        long startTime = System.currentTimeMillis();
        do {
            GemFireHealth.Health currentHealth = health.getHealth();
            String diagnosis = health.getDiagnosis();
            String aStr = "Current health is " + currentHealth + ", diagnosis is " + diagnosis;
            Log.getLogWriter().fine(aStr);
            if (currentHealth.readResolve().equals(GemFireHealth.OKAY_HEALTH) || currentHealth.readResolve().equals(GemFireHealth.POOR_HEALTH)) {
                throw new TestException(aStr);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        Log.getLogWriter().fine("Done monitoring health for " + minTaskGranularityMS + " ms");
    }

    static {
        int i;
        testInstance = null;
        adminInDsVm = AdminPrms.adminInDsVm();
        logLevel = TestConfig.tab().stringAt(LogPrms.file_logLevel);
        GfManagerOperations = null;
        SystemMemberOperations = null;
        GfHealthOperations = null;
        GfManagerOperations = new int[1];
        for (i = 0; i <= 0; ++i) {
            AdminTest.GfManagerOperations[i - 0] = i;
        }
        SystemMemberOperations = new int[4];
        for (i = 100; i <= 103; ++i) {
            AdminTest.SystemMemberOperations[i - 100] = i;
        }
        GfHealthOperations = new int[1];
        for (i = 200; i <= 200; ++i) {
            AdminTest.GfHealthOperations[i - 200] = i;
        }
    }
}

