/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package regions.validate;

/**
 * This <code>Value</code> indicates that a region entry has been
 * {@linkplain com.gemstone.gemfire.cache.Region#invalidate
 * invalidated}. 
 *
 * @author David Whitlock
 * @since 3.5
 */
public class InvalidValue extends Value {

  /**
   * Creates a new <code>InvalidValue</code>
   */
  public InvalidValue() {
    super();
  }

  //////////////////////  Instance Methods  //////////////////////

  /**
   * An <code>InvalidValue</code> is only equal to another
   * <code>InvalidValue</code>. 
   */
  public boolean equals(Object o) {
    return o instanceof InvalidValue;
  }

  public String toString() {
    return "Invalid at " + this.formatTimestamp();
  }

}
