/*
 * Decompiled with CFR 0.152.
 */
package wan.query;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.newedge.account.domain.BackOfficeAccount;
import com.newedge.account.domain.BackOfficeAccountCollection;
import com.newedge.staticdata.domain.Product;
import diskRecovery.RecoveryPrms;
import diskRecovery.RecoveryTest;
import diskRecovery.StartupShutdownTest;
import hydra.CacheHelper;
import hydra.ConfigHashtable;
import hydra.GsRandom;
import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import query.QueryPrms;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelperPrms;
import util.ValueHolder;
import wan.CacheClientPrms;
import wan.WANClient;

public class WANQueryClient
extends RecoveryTest {
    static final int UPDATE_OPERATION = 1;
    static final int QUERY_OPERATION = 2;
    static ConfigHashtable conftab = TestConfig.tab();

    public static void HydraTask_createGatewayHub() {
        WANClientInner client = new WANQueryClient().new WANClientInner();
        client.createGatewayHub();
    }

    public static void HydraTask_sleepForSometime() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void closeServerCacheTask() throws Exception {
        CacheHelper.closeCache();
    }

    public static void closeEdgeClientCacheTask() throws Exception {
        CacheHelper.closeCache();
    }

    public static void HydraTask_updateRegions() {
        Serializable value;
        int numToLoad = RecoveryPrms.getNumToLoad();
        int CHUNK_SIZE = 50;
        RandomValues rv = new RandomValues();
        Set regionSet = CacheHelper.getCache().rootRegions();
        long maxKey = 1L * NameFactory.getPositiveNameCounter();
        Log.getLogWriter().info("MAX KEY :: " + maxKey);
        int PUT_ALL_SIZE = 50;
        GsRandom rand = TestConfig.tab().getRandGen();
        HashMap<String, Serializable> putAllMap = new HashMap<String, Serializable>();
        for (int i = 1; i <= PUT_ALL_SIZE; ++i) {
            long randInt = rand.nextLong(1L, maxKey);
            String key = NameFactory.getObjectNameForCounter(randInt);
            ValueHolder value2 = new ValueHolder(key, rv);
            putAllMap.put(key, value2);
        }
        Log.getLogWriter().info("Created putAll map of size " + putAllMap.size() + ", updating all regions with putAll...);");
        for (Region aRegion : regionSet) {
            String regName = aRegion.getName();
            if (regName.equals("product") || regName.equals("backOfficeAccount") || regName.equals("backOfficeAccountCollection")) continue;
            Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
            aRegion.putAll(putAllMap);
        }
        Region aRegion = CacheHelper.getCache().getRegion("product");
        for (Object key : putAllMap.keySet()) {
            value = new Product();
            value.productCode = (String)key;
            value.instrumentId = (String)key;
            putAllMap.put((String)key, value);
        }
        Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
        aRegion.putAll(putAllMap);
        aRegion = CacheHelper.getCache().getRegion("backOfficeAccount");
        for (Object key : putAllMap.keySet()) {
            value = new BackOfficeAccount();
            ((BackOfficeAccount)value).account = (String)key;
            putAllMap.put((String)key, value);
        }
        Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
        aRegion.putAll(putAllMap);
        aRegion = CacheHelper.getCache().getRegion("backOfficeAccountCollection");
        for (Object key : putAllMap.keySet()) {
            value = new BackOfficeAccountCollection();
            putAllMap.put((String)key, value);
        }
        Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
        aRegion.putAll(putAllMap);
        Log.getLogWriter().info("Printing current region hierarchy with sizes");
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
    }

    public static void HydraTask_doEntryAndQueryOperations() {
        long startTime = System.currentTimeMillis();
        long minTaskGranularityMS = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec) * 1000L;
        do {
            int whichOp = WANQueryClient.getOp(QueryPrms.entryAndQueryOperations);
            switch (whichOp) {
                case 2: {
                    StartupShutdownTest.HydraTask_doQueries();
                    break;
                }
                case 1: {
                    WANQueryClient.HydraTask_updateRegions();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected static int getOp(Long whichPrm) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("update")) {
            op = 1;
        } else if (operation.equals("query")) {
            op = 2;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        if (System.currentTimeMillis() - startTime > limit) {
            throw new TestException("Could not find an operation in " + limit + " check that the operations list has allowable choices");
        }
        return op;
    }

    class WANClientInner
    extends WANClient {
        @Override
        public Cache createCache(String cacheConfig) {
            return super.createCache(cacheConfig);
        }

        @Override
        public Region createRegion(String regionName, String regionConfig) {
            return super.createRegion(regionName, regionConfig);
        }

        public void initPdxDiskStore_1() {
            WANClientInner.initPdxDiskStore();
        }

        @Override
        public CacheServer startBridgeServer(String bridgeConfig) {
            return super.startBridgeServer(bridgeConfig);
        }

        @Override
        public void createGatewayHub() {
            super.createGatewayHub();
        }

        public void registerInterest(Region region) {
            InterestResultPolicy interestPolicy = CacheClientPrms.getInterestPolicy();
            LocalRegion localRegion = (LocalRegion)region;
            String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
            if (!VmDurableId.equals("")) {
                Log.getLogWriter().info("Doing durable register interest");
                localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy, true);
            } else {
                localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy);
            }
            Log.getLogWriter().info("Initialized region " + region + "\nRegistered interest in ALL_KEYS with InterestResultPolicy = " + interestPolicy);
        }
    }
}

