/*
 * Decompiled with CFR 0.152.
 */
package wan.ml;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import wan.ml.MarketLoader;
import wan.ml.MarketUpdate;

public class GemFireQuoteFeeder
extends MarketLoader {
    Region marketDataCache = null;
    QuoteFeederThread feederThread = null;

    public static void main(String[] args) {
        Cache c = CacheFactory.getAnyInstance();
        Properties p = new Properties();
        try {
            p.put("quotes_to_process", args[0]);
            p.put("quotes_per_second", args[1]);
            p.put("quotes_file_location", args[2]);
        }
        catch (Exception e) {
            c.getLogger().severe("Error Extracting Startup Arguments", (Throwable)e);
            return;
        }
        GemFireQuoteFeeder app = new GemFireQuoteFeeder();
        try {
            app.marketDataCache = c.getRegion("QUOTES");
            c.getLogger().info("Retrieved Bridge Region QUOTES");
            c.getLogger().info("QUOTES Region Attributes: " + app.marketDataCache.getAttributes().toString());
        }
        catch (Exception e) {
            c.getLogger().severe("Could not create QUOTES region", (Throwable)e);
        }
        app.init(p);
        try {
            app.waitForNotification();
        }
        catch (InterruptedException e) {
            c.getLogger().severe("Quote feeder interrupted waiting for notification", (Throwable)e);
            return;
        }
    }

    public void init(Properties p) {
        this.initTestParams(p);
        this.initLog("MarketLoader_LOG.txt");
        this.feederThread = new QuoteFeederThread(this);
        this.feederThread.start();
    }

    public void initTestParams(Properties p) {
        try {
            file_name = p.getProperty("quotes_file_location");
            RATE_PER_SECOND = Integer.parseInt(p.getProperty("quotes_per_second"));
            TOTAL_QUOTES = Integer.parseInt(p.getProperty("quotes_to_process"));
        }
        catch (Exception e) {
            System.out.println("Error getting trade pumping parameters, using defaults: " + e);
            e.printStackTrace();
            RATE_PER_SECOND = 1;
        }
    }

    public void initLog(String logFileName) {
        try {
            fh = new FileHandler(logFileName);
            logger.addHandler(fh);
            logger.setLevel(Level.ALL);
        }
        catch (Exception e) {
            System.out.println("Could not open log file handle! Exiting . . . ");
            System.exit(0);
        }
    }

    @Override
    protected void vendorInit(String[] args) throws Throwable {
    }

    @Override
    protected void vendorPublishingAPI(String xml) throws Throwable {
        MarketUpdate update = new MarketUpdate(xml, false);
        this.marketDataCache.put((Object)update.ccy, (Object)update);
    }

    public class QuoteFeederThread
    extends Thread {
        GemFireQuoteFeeder loader;

        public QuoteFeederThread(GemFireQuoteFeeder loader) {
            this.loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.loader.easyPumpMarketChanges();
                Object object = GemFireQuoteFeeder.this.completeNotification;
                synchronized (object) {
                    GemFireQuoteFeeder.this.completeNotification.notify();
                }
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable e) {
                System.out.println("Thowable Error caught from easyPumpMarketChanges: " + e);
                e.printStackTrace();
            }
        }
    }
}

