/*
 * Decompiled with CFR 0.152.
 */
package vsphere.vijava;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.ExecuteCQ61;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.RegisterInterest61;
import com.gemstone.gemfire.internal.cache.vmotion.VMotionObserver;
import com.gemstone.gemfire.internal.cache.vmotion.VMotionObserverAdapter;
import com.gemstone.gemfire.internal.cache.vmotion.VMotionObserverHolder;
import cq.CQUtilBB;
import hct.BridgeNotifyBB;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.Collection;
import java.util.Set;
import vsphere.vijava.VIJavaUtil;
import vsphere.vijava.VMotionBB;

public class VMotionTestBase {
    public static final String VMOTION_TRIGGERRED = "vMotionTriggerred";

    public static void setvMotionDuringCQRegistartion() {
        ExecuteCQ61.VMOTION_DURING_CQ_REGISTRATION_FLAG = true;
        VMotionObserverHolder.setInstance((VMotionObserver)new VMotionObserverAdapter(){

            public synchronized void vMotionBeforeCQRegistration() {
                try {
                    SharedMap sm = CQUtilBB.getBB().getSharedMap();
                    Boolean value = (Boolean)sm.get(VMotionTestBase.VMOTION_TRIGGERRED);
                    if (value == null || value != null && !value.booleanValue()) {
                        sm.put(VMotionTestBase.VMOTION_TRIGGERRED, Boolean.TRUE);
                        VIJavaUtil.HydraTask_migrateVM();
                    }
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Exception while migrating VM", (Throwable)e);
                }
                finally {
                    ExecuteCQ61.VMOTION_DURING_CQ_REGISTRATION_FLAG = false;
                }
            }
        });
    }

    public static void setvMotionDuringRegisterInterest() {
        RegisterInterest61.VMOTION_DURING_REGISTER_INTEREST_FLAG = true;
        VMotionObserverHolder.setInstance((VMotionObserver)new VMotionObserverAdapter(){

            public synchronized void vMotionBeforeRegisterInterest() {
                try {
                    SharedMap sm = BridgeNotifyBB.getBB().getSharedMap();
                    Boolean value = (Boolean)sm.get(VMotionTestBase.VMOTION_TRIGGERRED);
                    if (value == null || value != null && !value.booleanValue()) {
                        sm.put(VMotionTestBase.VMOTION_TRIGGERRED, Boolean.TRUE);
                        VIJavaUtil.HydraTask_migrateVM();
                    }
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Exception while migrating VM", (Throwable)e);
                }
                finally {
                    RegisterInterest61.VMOTION_DURING_REGISTER_INTEREST_FLAG = false;
                }
            }
        });
    }

    public static synchronized void updateBBWithServerVMNames() {
        int myVMid = RemoteTestModule.getMyVmid();
        ClientVmInfo myInfo = new ClientVmInfo(new Integer(myVMid), RemoteTestModule.getMyClientName(), null);
        Collection coll = CacheClientNotifier.getInstance().getClientProxies();
        if (coll.size() > 0) {
            VMotionBB.getBB().getSharedMap().put(myInfo.getClientName(), myInfo);
            Log.getLogWriter().info("server vm name is ::" + myInfo.getClientName());
        }
    }

    public static void setFailoverFlag() {
        VIJavaUtil.STOP_START_SERVER = true;
    }

    public static void setvMotionDuringGII() {
        InitialImageOperation.VMOTION_DURING_GII = true;
        VMotionObserverHolder.setInstance((VMotionObserver)new VMotionObserverAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void vMotionDuringGII(Set recipients, LocalRegion region) {
                try {
                    if (region.isUsedForMetaRegion() || region.isInternalRegion()) {
                        return;
                    }
                    SharedMap sm = BridgeNotifyBB.getBB().getSharedMap();
                    Integer num = (Integer)sm.get(VMotionTestBase.VMOTION_TRIGGERRED);
                    num = num == null ? 0 : num;
                    if (num == 0) {
                        num = num + 1;
                        sm.put(VMotionTestBase.VMOTION_TRIGGERRED, (int)num);
                        InternalDistributedMember idm = recipients.iterator().hasNext() ? recipients.iterator().next() : null;
                        final String vmName = idm.getHost().substring(0, 14);
                        Thread task = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    VIJavaUtil.migrateVMToTargetHost(vmName);
                                }
                                catch (Exception e) {
                                    Log.getLogWriter().info("Exception while migrating VM", (Throwable)e);
                                }
                            }
                        });
                        task.start();
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException ie) {
                    Log.getLogWriter().info((Throwable)ie);
                }
                finally {
                    InitialImageOperation.VMOTION_DURING_GII = false;
                }
            }
        });
    }

    public static void resetvMotionFlag() {
        ExecuteCQ61.VMOTION_DURING_CQ_REGISTRATION_FLAG = false;
        RegisterInterest61.VMOTION_DURING_REGISTER_INTEREST_FLAG = false;
        InitialImageOperation.VMOTION_DURING_GII = false;
        VMotionObserverHolder.setInstance((VMotionObserver)VMotionObserverHolder.NO_OBSERVER);
    }

    public static void resetFailoverFlag() {
        VIJavaUtil.STOP_START_SERVER = false;
    }
}

